<?php

namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

class AccountTitle extends Model
{
    /**
     * [submitAccount 提交科目操作]
     * @param  [type] $user_info  [用户信息]
     * @param  [type] $type       [类型：1借，汇入；2贷，汇出]
     * @param  [type] $money      [金额，乘以100]
     * @param  [type] $acti_id    [科目id]
     * @param  [type] $apply_time [汇款时间]
     * @return [type]             [description]
     */
    public static function submitAccount(
    	$user_info,
    	$type,
    	$money,
    	$acti_id,
    	$apply_time
    ) {
        //判断是否有此科目
        $find_acti_data = DB::table('account_title')
                    ->where('acti_id', $acti_id)
                    ->first(['acti_course_title', 'acti_subject_code', 'acti_initial_count', 'acti_closing_account',
                    	'acti_lend', 'acti_loan']);
        if (empty($find_acti_data)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'当前科目不存在'];
        }

        $apply_time_arr = explode('-', $apply_time);//汇款时间
        $year = $apply_time_arr[0];//年
        $month = $apply_time_arr[1];//月
        $now_time = date('Y-m-d H:i:s');//当前时间
        // 科目查询表，查询汇款时间的那个月的科目数据
        $find_acse_data = DB::table('account_select')
                        ->where('acse_year', $year)
                        ->where('acse_month', $month)
                        ->where('acse_acti_id', $acti_id)
                        ->first(['acse_id', 'acse_initial_count',  'acse_initial_count', 'acse_lend', 'acse_loan']);
        $last_month = $month -1;//上个月
        //如果上个月是一月份
        if($last_month == 0){
            $last_month = 12;
            $last_year = $year - 1;
        }else{
            $last_year = $year;
        }

        //科目查询的期末余额
        if(empty($find_acse_data)){
            // 如果没有当月的科目查询数据，说明是当月第一天添加科目金额，当月的期初金额就是上个月的期末金额
            //获取上个月期末余额
            $closing_account = DB::table('account_select')
                        ->where('acse_acti_id', $acti_id)
                        ->where('acse_year', $last_year)
                        ->where('acse_month', $last_month)
                        ->value('acse_closing_account');

            $acse_data['acse_acti_id'] = $acti_id;//科目id
            $acse_data['acti_adm_cid'] = $user_info->adm_cid;//公司id
            $acse_data['acti_shop_id'] = $user_info->adm_shop_id;//门店id
            $acse_data['acse_year'] = $year;//年份
            $acse_data['acse_month'] = $month;//月份
            $acse_data['acse_subject_code'] = $find_acti_data->acti_subject_code;//科目代码
            $acse_data['acse_course_title'] = $find_acti_data->acti_course_title;//科目名称
            $acse_data['acse_initial_count'] = $closing_account ? $closing_account : 0;//期初余额
            // 借（汇入）金额
            if ($type == 1) {
                $acse_data['acse_lend'] = $money;//借
                $acse_data['acse_loan'] = 0;//贷
                $acse_closing_account = $closing_account + $money;//期末余额
            // 贷（汇出）金额
            }else{
                $acse_data['acse_lend'] = 0;//借
                $acse_data['acse_loan'] = $money;//贷
                // 如果第一次操作，之前没有余额，贷出金额，金额就为负数，数据库里的金额是不能为负数的，这种情况需要在考虑一下
                $acse_closing_account = $closing_account - $money;//期末余额
                if ($acse_closing_account < 0) {
                	$acse_closing_account = 0;
                }
            }
            $acse_data['acse_closing_account'] = $acse_closing_account;//期末余额
            $acse_data['acse_create_time'] = $apply_time;//申请时间
            $acse_data['acse_update_time'] = $now_time;//更新时间
            $acse_res = DB::table('account_select')->insert($acse_data);
        }else{
            // 当月科目数据已存在，科目查询的期末余额
            if ($type == 1) {
                $closing_account = $find_acse_data->acse_initial_count + $find_acse_data->acse_lend + $money - $find_acse_data->acse_loan;
                $acse_data['acse_lend'] = $find_acse_data->acse_lend + $money;//借（汇入）金额增加
                $acse_data['acse_closing_account'] = $closing_account;//期末余额
            }else{
                $closing_account = $find_acse_data->acse_initial_count + $find_acse_data->acse_lend - $money - $find_acse_data->acse_loan;
                $acse_data['acse_loan'] = $find_acse_data->acse_loan + $money;//贷（汇出）金额增加
            }
            $acse_data['acse_closing_account'] = $closing_account;//期末余额
            $acse_data['acse_update_time'] = $now_time;
            $acse_res = DB::table('account_select')
                        ->where('acse_id', $find_acse_data->acse_id)
                        ->update($acse_data);
        }
        if (empty($acse_res)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'科目金额操作失败'];
        }

        // 科目管理表
        if ($type == 1) {
            $acti_closing_account = $find_acti_data->acti_initial_count + $find_acti_data->acti_lend + $money - $find_acti_data->acti_loan;
            $acti_data['acti_lend'] = $find_acti_data->acti_lend + $money;//借（汇入）金额增加
        }else{
            $acti_closing_account = $find_acti_data->acti_initial_count + $find_acti_data->acti_lend - $money - $find_acti_data->acti_loan;
            $acti_data['acti_loan'] = $find_acti_data->acti_loan + $money;//贷（汇出）金额增加
        }
        $acti_data['acti_closing_account'] = $acti_closing_account;//期末余额
        $acti_data['acti_update_time'] = $now_time;
        $acti_res = DB::table('account_title')
                    ->where('acti_id', $acti_id)
                    ->update($acti_data);
        if(empty($acti_res)){
            return ['code'=>500, 'msg'=>'error', 'data'=>'科目金额操作失败'];
        }else{
            return ['code'=>200, 'msg'=>'success', 'data'=>'科目金额操作成功'];
        }
    }
}
