<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\WeChatApplet\User\WeixinUserService;
use App\Services\Shop\VipCardService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Services\Point\PointService;
use App\Services\CommonService;
use App\Services\Business\WashOrderService;


// 微信用户信息
class WeixinUserController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new WeixinUserService();
        $this->bootWithService($service);
    }

    // 客户登录
    public function login(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->loginValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'login';
		logFileRecord($log_record, 'wash/WeixinUser', 2);
        
        // 登录
        DB::beginTransaction();
        $return_data = WeixinUserService::login($request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
        } else {
            DB::commit();
        }
        return response()->json($return_data);
    }

    // 客户授权手机号登录pc
    public function pcLogin(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->pcLoginValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'pcLogin';
        logFileRecord($log_record, 'wash/WeixinUser', 2);
        
        // 登录
        DB::beginTransaction();
        $return_data = WeixinUserService::pcLogin($request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
        } else {
            DB::commit();
        }
        return response()->json($return_data);
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 详情
        $return_data = WeixinUserService::info($request->all());
        return response()->json($return_data);
    }

    // 修改个人信息
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WeixinUserService::edit($user_info,$request->all());
        return response()->json($return_data);
    }

    // 我的会员卡
    public function myvip(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        // 查询字段
        $field_columns = ['myvi_id', 'myvi_adm_id', 'myvi_num', 'myvi_create_adm_id', 'myvi_create_time', 'myvi_surplus_times', 'myvi_all_times', 'myvi_effective_date', 'myvi_state', 'myvi_carnum', 'myvi_name', 'myvi_sepr_id', 'myvi_sepr_name', 'myvi_long_term', 'myvi_end_time'];
        $search_data = $request;
        $search_data['adm_id'] = $user_info->ussh_user_id;
        DB::beginTransaction();
        $return_data = VipCardService::vipCardIndex($user_info, $search_data, 10, $field_columns);
        if ($return_data['code'] == 500) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 我的会员卡
    public function myVipInfo(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $request['adm_id'] = $user_info->ussh_user_id;
        $return_data = VipCardService::myVipInfo($user_info, $request);
        if ($return_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'暂无数据', 'data'=>'暂无数据']);
        }
    }

    // 生成会员卡二维码
    public function vipQrcode(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->vipQrcodeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $return_data = WeixinUserService::vipQrcode($user_info, $request);
        if ($return_data['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($return_data);
    }

    // 获取会员卡二维码
    public function getVipQrcode(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->vipQrcodeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WeixinUserService::getVipQrcode($user_info, $request);
        return response()->json($return_data);
    }

    // 我的会员卡使用明细
    public function myvipDetail(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        // 查询字段
        // $field_columns = ['vcre_id', 'vcre_myvi_id', 'vcre_user_id', 'vcre_ord_num', 'vcre_ord_id', 'vcre_create_time', 'vcre_car_adm_name', 'vcre_car_adm_phone', 'vcre_myvi_num', 'myvi_name', 'vcre_log', 'vcre_num_change', 'orcl_car_num', 'myvi_surplus_times'];
        $field_columns = ['vcre_id', 'vcre_myvi_id', 'vcre_user_id', 'vcre_ord_num', 'vcre_ord_id', 'vcre_create_time', 'vcre_car_adm_name', 'vcre_car_adm_phone', 'vcre_myvi_num', 'myvi_name', 'vcre_log', 'vcre_num_change', 'orcl_car_num','vcrd_num', 'myvid_data_name','myvid_surplus_times', 'myvid_data_id','myvid_type','vcrd_description'];
        $search_data = $request->all();
        $search_data['mem_id'] = $user_info->ussh_user_id;
        $return_data = VipCardService::detailIndex($user_info, $search_data, 10, $field_columns);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    /**
     * 我的积分
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-18
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function myPoints(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $search_data = $request->all();
        $search_data['mem_id'] = $user_info->ussh_user_id;
        $return_data = WeixinUserService::myPoints($user_info, $search_data, 10);
        return response()->json($return_data);
    }

    /**
     * 我的积分详情
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-18
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function myPointsInfo(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $search_data = $request->all();
        $search_data['mem_id'] = $user_info->ussh_user_id;
        $return_data = WeixinUserService::myPointsInfo($user_info, $search_data, 10);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    /**
     * 我的签到数据
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-18
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getSigninData(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $search_data = $request->all();
        $search_data['mem_id'] = $user_info->ussh_user_id;
        $return_data = PointService::getSigninData($user_info, $search_data, 10);
        return response()->json($return_data);
    }

    /**
     * 签到
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function sign(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $return_data = PointService::sign($user_info);
        return response()->json($return_data);
    }

    /**
     * 签到规则
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function signRule(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $search_data = $request->all();
        $search_data['mem_id'] = $user_info->ussh_user_id;
        $find_data = DB::table('sign_config')
            ->where('sico_shop_id', $user_info->adm_shop_id)
            ->select('sico_id', 'sico_state', 'sico_type', 'sico_day_type', 'sico_day_num')
            ->first();
        $find_data = CommonService::dataToArray($find_data);
        $day_data = DB::table('sign_day_config')
            ->where('sidco_scid', $find_data['sico_id'])
            ->where('sidco_type', '<=' ,$find_data['sico_day_num'])
            ->select('sidco_type', 'sidco_points')
            ->get();
        $day_data = CommonService::dataToArray($day_data);
        $find_data['day_data'] = PointService::getSigninType($find_data['sico_day_type'], $day_data);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
    }

    /**
     * 签到礼品列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function signGoods(Request $request) {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $res = WeixinUserService::signGoods($user_info, $request);
        if ($res) {
            return response()->json(['code'=>200, 'msg'=>'success','data'=>$res]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'暂无数据','data'=>$res]);
        }
    }

    /**
     * 活动送积分
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function activities(Request $request) {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $res = WeixinUserService::activities($user_info, $request);
        if ($res) {
            return response()->json(['code'=>200, 'msg'=>'success','data'=>$res]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'暂无数据','data'=>$res]);
        }
    }

    /**
     * 领取积分
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function claimPoints(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->claimPointsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $res = WeixinUserService::claimPoints($user_info, $request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 领取签到礼品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function claimSignGoods(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->claimSignGoodsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = WeixinUserService::claimSignGoods($user_info, $request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 今天是否签到
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function todaySign(Request $request) {
        if (empty($request['weus_id'])) {
            $data['state'] = 2;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $res = WeixinUserService::todaySign($user_info, $request);
        return response()->json($res);
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取主页操作按钮
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/3/29 17:35
     * |---------------------------------------------------------------------------------
    */
    public function getActionList ( Request $request ){
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $res = WeixinUserService::getActionList($user_info, $request);
        return response()->json($res);
    }
    /**
     * 余额明细
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function banlance(Request $request) {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $request['mem_id']= $user_info->ussh_user_id;
        $res = WashOrderService::reclog($user_info, $request);
        return response()->json(['code'=>200, 'msg'=>'success','data'=>$res]);
    }

    /*
     * @name 用户的登录过的门店列表
     * @retrun array
     * @author Ma 2023/10/17 16:41
     *
    */
    public function shopList(Request $request){
        $user_info = LoginUserService::getUser();
        $res = WeixinUserService::shopList($user_info, $request);
        return response()->json($res);
    }

    /**
     * 绑定分享人
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-27
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function shareBind(Request $request) {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        if (empty($user_info->ussh_user_id)) {
            return response()->json(['code'=>300,'msg'=>'请授权登录','data'=>'']);
        }
        $request['mem_id'] = $user_info->ussh_user_id;
        $res = WeixinUserService::shareBind($user_info, $request);
        return response()->json($res);
    }

    /**
     * 通过手机号绑定分享人
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-27
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function phoneBind(Request $request) {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $request['mem_id'] = $user_info->ussh_user_id;
        $res = WeixinUserService::phoneBind($user_info, $request);
        return response()->json($res);
    }

    /**
     * 我的邀请记录
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-30
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function invitation(Request $request) {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $request['mem_id'] = $user_info->ussh_user_id;
        $res = WeixinUserService::invitation($user_info, $request);
        return response()->json($res);
    }

    /**
     * 分享的二维码
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-31
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function shareQrCode(Request $request) {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $request['mem_id'] = $user_info->ussh_user_id;
        $res = WeixinUserService::shareQrCode($user_info, $request);
        return response()->json(['code'=>200, 'msg'=>'success','data'=>$res]);
    }

    /**
     * 登录获取验证码
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getCode(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getCodeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $request['ip'] = getRealIp($request);
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = WeixinUserService::getCode($user_info, $request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 登录获取手机号
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getlist(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $request['ip'] = getRealIp($request);
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = WeixinUserService::getlist($user_info, $request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 解绑手机号
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function delPhone(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $request['ip'] = getRealIp($request);
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = WeixinUserService::delPhone($user_info, $request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 切换门店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-24
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function changeShop(Request $request) {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $request['ip'] = getRealIp($request);
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = WeixinUserService::changeShop($user_info, $request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }
}
