<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Business\WashOrderService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\CashierDesk;

// 洗美-微信用户列表
class WashOrderController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new WashOrderService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (empty($request['weus_id'])) {
            return response()->json(['code'=>300, 'msg'=>'请登录', 'data'=>[]]);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexWashValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'index';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('ord_type', 1);//买家类型1会员零售
        request()->offsetSet('ord_client_id', $request['weus_id']);//用户id，买家id
        request()->offsetSet('ord_classify', 2);//订单分类：1蓄电池2洗美店3易损件,用户小程序是洗美店订单

        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchClientPage((object) $user_info, $request->all(), 10);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 预约单列表
    public function reindex(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexWashValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'reindex';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        request()->offsetSet('reli_client_type', 1);//买家类型1会员零售

        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->reindex((object) $user_info, $request->all(), 10);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 预约单详情
    public function reinfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->reinfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'reinfo';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::reinfo($user_info, $request->all());
        return response()->json($return_data);
    }


    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoWashValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'info';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::washInfo($user_info, $request->all());
        return response()->json($return_data);
    }

    // 签字图片提交
    public function signatureSubmit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->signatureSubmitValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'signatureSubmit';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $return_data = WashOrderService::signatureSubmit($user_info, $request->all());
        if ($return_data['code'] == 200) {
            DB::commit();
            // OperationLog::addLog($user_info, getRealIp($request), '订单列表', '客户签字', '客户签字成功');
            return $this->success('客户签字成功');
        } else {
            DB::rollBack();
            return response()->json($return_data);
        }
    }
    
    // 转售后
    public function afterSale(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = $this->dataService->afterSale($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '申请售后', '申请售后：'.$return_data['data']['afsl_after_number'].'成功');
            return $this->success('申请售后成功');
        }
    }

    // 订单历史
    public function getOrderHistory(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getOrderHistoryValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getOrderHistory';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = $this->dataService->getOrderHistory($user_info, $request->all());
        return response()->json($return_data);
    }

    // 客户取消订单
    public function cancel(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->remarkValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'cancel';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $user_info->adm_id = 0;
        DB::beginTransaction();
        // 取消订单
        $return_data = WashOrderService::cancel($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } 
        // else {
        //     DB::commit();
        //     OperationLog::addLog($user_info, getRealIp($request), '订单列表', '取消订单', '取消订单' . $return_data['data']['ord_order_number'] . '成功');
        //     return $this->success('取消订单成功');
        // }

        // 生成操作记录
        $orlo_res = orderLog($user_info, $request['ord_id'], 0, '客户取消订单');

        if ($request['remark']) {
            // 添加备注
            $orre_res = orderRemark($user_info, $request['ord_id'], '', $request['remark'], '订单列表');
        } else {
            $orre_res = true;
        }
        if ($orlo_res && $orre_res) {
            $adm_data = DB::table('admin_shop_role')
                ->where('shop_id', $user_info->adm_shop_id)
                ->where('adm_shop_leave', 1)
                ->select('adm_id')
                ->first();
            $wechat_msg['pushtype'] = 6;//取消订单
            $wechat_msg['ord_id'] = $request['ord_id']; //订单id
            $wechat_msg['adm_id'] = $adm_data->adm_id; //推送人
            $wechat_msg['ord_number'] = $return_data['data']['ord_order_number']; //订单号
            $wechat_msg['character_string1'] = $return_data['data']['ord_order_number'];//订单号
            $wechat_msg['thing4'] =  $return_data['data']['orcl_name'];//取消客户
            $wechat_msg['time3'] = date('Y-m-d H:i:s');//取消时间
            // $wechat_msg['const2'] = '其它原因';//取消原因
            $CashierDesk = new CashierDesk;
            $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '取消订单', '取消订单' . $return_data['data']['ord_order_number'] . '成功');
            return $this->success('取消订单成功');
        } else {
            DB::rollBack();
            return $this->error('取消订单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 验车结果
    public function validateCarData(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoWashValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'validateCarData';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::validateCarData($user_info, $request->all());
        return response()->json($return_data);
    }

    // 订单作品-列表
    public function OrderWorks(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->OrderWorksindexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'OrderWorks';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        $return_data = $this->dataService->OrderWorksindex($user_info, $request->all());
        if (empty($return_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            // 获取当前列表下的按钮
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 订单作品-详情
    public function OrderWorksinfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->OrderWorksinfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // request()->offsetSet('rt', 'wechatWash');//微信用户信息
        // // 获取用户信息
        // $user_info = LoginUserService::getUser();
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'OrderWorksinfo';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        $user_info = [];
        $return_data = $this->dataService->OrderWorksinfo($user_info, $request->all());
        if (empty($return_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 客户小程序-兑换积分商品
    public function addPointOrder(Request $request)
    {
        if (empty($request['weus_id'])) {
            return $this->error('请授权登录', 300);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->addPointOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addPointOrder';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        // 获取用户信息
        DB::beginTransaction();
        // 购买商品-新增预约单
        request()->offsetSet('ip', getRealIp($request));
        // 调用添加订单方法
        $return_data = WashOrderService::addPointOrder($user_info,$request->all(), 3);
        
        if (!empty($request['car_num'])) {
            $request['meca_car_num'] = $request['car_num'];
            $request['meca_car_brand_series'] = $request['car_brand_series'];
            $request['meca_car_frame'] = $request['car_vin'];
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                // 调用增加会员车辆接口
                $return_car_data = MemberCarService::add($request->all());
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        // 查询
        if ($return_data['code'] != 200 || $return_car_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            return response()->json($return_data);
        }
    }

    /**
     * 客户领取状态
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-23
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function recOrder(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::recOrder($user_info, $request);
        return response()->json($return_data);
    }
}
