<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\WeChatApplet\User\UserSearchService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

// 用户小程序-搜索
class UserSearchController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new UserSearchService();
        $this->bootWithService($service);
    }

    /**
     * 用户的搜索历史记录列表
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'index';
        logFileRecord($log_record, 'wash/UserSearch', 2);

        // $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 热门搜索
    public function searchHot(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->searchServiceValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'searchHot';
        logFileRecord($log_record, 'wash/UserSearch', 2);

        $list_items = DB::table('user_search_history')
            ->select(DB::raw('count(ussh_id) as num, ussh_search_content as name'))
            ->groupBy('ussh_search_content')
            ->orderBy('num', 'desc')
            ->limit(5)
            ->get()->toArray();
        $data['current_page'] = 1;  //当前页面页码
        $data['last_page'] = 1;        //表示最后一页的页码
        $data['total'] = 10;               //总数据个数
        $data['current_number'] = 10;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 搜索服务
    public function searchService(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->searchServiceValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'searchService';
        logFileRecord($log_record, 'wash/UserSearch', 2);

        // 按技师类型查询
        $fields = ['sepr_id', 'sepr_name', 'sepr_img', 'sepr_shop_id', 'shop_store_name'];
        
        request()->offsetSet('sepr_state', 1);//状态1启用2停用
        $return_data = $this->dataService->searchService($request->all(), 9, $fields, 'desc');
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 搜索商品
    public function searchGooods(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->searchServiceValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'searchService';
        logFileRecord($log_record, 'wash/searchGooods', 2);

        // 获取用户信息
        // $user_info = LoginUserService::getUser();
        // 按技师类型查询
        $return_data = $this->dataService->searchGooods($request->all());
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }
    
    // 清空历史搜索记录
    public function clearRecord(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'searchService';
        logFileRecord($log_record, 'wash/searchGooods', 2);
        
        // 获取用户信息
        // $user_info = LoginUserService::getUser();
        // 按技师类型查询
        $return_data = $this->dataService->clearRecord($request->all());
        return response()->json($return_data);
    }
}
