<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\WeChatApplet\User\UserAddressService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

class UserAddressController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new UserAddressService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 地址搜索记录
    public function searchRecord(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->searchRecordValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        // $user_info = LoginUserService::getUser();
        // 按技师类型查询
        $return_data = $this->dataService->searchRecord($request->all());
        if ($return_data) {
            return response()->json(['code'=>200, 'msg'=>'记录成功', 'data'=>'']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'记录失败', 'data'=>'']);
        }
    }

    // 清空历史搜索记录
    public function clearRecord(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        // $user_info = LoginUserService::getUser();
        // 按技师类型查询
        $return_data = $this->dataService->clearRecord($request->all());
        return response()->json($return_data);
    }
}
