<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Business\ReservationService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Services\WeChatApplet\User\MemberCarService;
use App\Services\Business\WashOrderService;
use App\Services\Shop\VipCardService;

// 客户小程序预约单
class ReservationController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new ReservationService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($user_info, $request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 客户小程序-新增预约下单
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'add';
        logFileRecord($log_record, 'wash/Reservation', 2);

        // 获取用户信息
        // $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        // 新增预约单
        request()->offsetSet('ip', getRealIp($request));
        $return_data = ReservationService::add($request->all(), 3);
        if (!empty($request['car_num'])) {
            $request['meca_car_num'] = $request['car_num'];
            $request['meca_car_brand_series'] = $request['car_brand_series'];
            $request['meca_car_frame'] = $request['car_vin'];
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                $return_car_data = MemberCarService::add($request->all());
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        // 查询
        if ($return_data['code'] != 200 || $return_car_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            return $this->success('预约下单成功');
        }
    }

    // 客户小程序-购买套餐下单
    public function addOrder(Request $request)
    {
        if (empty($request['weus_id'])) {
            return $this->error('请授权登录', 300);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->addOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addOrder';
        logFileRecord($log_record, 'wash/Reservation', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        // 获取用户信息
        DB::beginTransaction();
        // 购买商品-新增预约单
        request()->offsetSet('ip', getRealIp($request));
        // 调用添加订单方法
        $return_data = WashOrderService::addOrder($user_info,$request->all(), 3);
        if (!empty($request['car_num'])) {
            $request['meca_car_num'] = $request['car_num'];
            $request['meca_car_brand_series'] = $request['car_brand_series'];
            $request['meca_car_frame'] = $request['car_vin'];
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                // 调用增加会员车辆接口
                $return_car_data = MemberCarService::add($request->all());
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        // 查询
        if ($return_data['code'] != 200 || $return_car_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            
            DB::commit();
            return response()->json($return_data);
        }
    }

    // 查询可用会员卡
    public function getmyVip(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getmyVipValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getmyVip';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechatWash');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $res = WashOrderService::getmyVip($user_info, $request->all());
        return response()->json($res);
    }

    // 客户小程序-购买纯商品下单
    public function addGoodsOrder(Request $request)
    {
        if (empty($request['weus_id'])) {
            return $this->error('请授权登录', 300);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->addGoodsOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addGoodsOrder';
        logFileRecord($log_record, 'wash/Reservation', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        // 获取用户信息
        DB::beginTransaction();
        // 购买商品-新增预约单
        request()->offsetSet('ip', getRealIp($request));
        $return_data = WashOrderService::addGoodsOrder($user_info,$request->all(), 3);
        // 查询
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            return response()->json($return_data);
        }
    }

    // 客户小程序-购买会员卡
    public function addVipCard(Request $request)
    {
        if (empty($request['weus_id'])) {
            return $this->error('请授权登录', 300);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->addVipCardValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addVipCard';
        logFileRecord($log_record, 'wash/Reservation', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        request()->offsetSet('adm_id', $user_info->ussh_user_id);//会员id
        // 获取用户信息
        DB::beginTransaction();
        // 购买商品-会员卡
        request()->offsetSet('ip', getRealIp($request));
        $return_data = VipCardService::addvipcard($user_info, $request->all(), 2);
        if ($return_data['code'] == 200) {
            DB::commit();
            return response()->json($return_data);
        } else {
            DB::rollBack();
            return response()->json($return_data);
        }
    }
    
    // 获取此用户的此门店的最后一个预约单
    public function getlastReli(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getlastReliValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $find_reli_data = DB::table('wash_reservation_list as reli')
            ->leftJoin('wash_reservation_client as recl', 'reli.reli_id', '=', 'recl.recl_reli_id')
            ->where('reli_shop_id', $user_info->adm_shop_id)
            ->where('reli_client_id', $user_info->ussh_user_id)
            ->select('reli_id', 'recl_name', 'recl_phone', 'recl_car_num', 'recl_car_brand_series', 'recl_car_vin')
            ->orderBy('reli_id', 'desc')
            ->first();
        if (empty($find_reli_data)) {
            $find_reli_data = DB::table('member as m')
                ->leftJoin('user_shop as u', 'u.ussh_user_id', '=', 'm.mem_id')
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->where('ussh_user_id', $user_info->ussh_user_id)
                ->select('mem_name as recl_name', 'mem_phone as recl_phone', 'mem_car_series as recl_car_brand_series', 'mem_car_num as recl_car_num')
                ->first();
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_reli_data]);
    }

    // 撤回
    public function withdraw(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->remarkValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'withdraw';
        logFileRecord($log_record, 'wash/Reservation', 2);

        // 获取用户信息
        // $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        // 取消预约单
        $return_data = ReservationService::withdraw($request->all(), 4);
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            return $this->success('撤回成功');
        }
    }
}
