<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use App\Services\WeChatApplet\User\MemberLevelService;
use BlueCity\Core\Inc\ErrorInc;

class MemberLevelController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new MemberLevelService();
        $this->bootWithService($service);
    }

    // 详情
    public function info(Request $request)
    {

        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'info';
		logFileRecord($log_record, 'wash/MemberLevel', 2);

        // 查询
        $return_data = MemberLevelService::info($request->all());
        return response()->json($return_data);
    }
    
    // 列表
    public function list(Request $request)
    {

        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'list';
		logFileRecord($log_record, 'wash/MemberLevel', 2);

        // 查询
        $return_data = MemberLevelService::list($request->all());
        return response()->json($return_data);
    }

    // 黑钻页面
    public function blackInfo(Request $request)
    {

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'blackInfo';
        logFileRecord($log_record, 'wash/MemberLevel', 2);

        // 查询
        $return_data = MemberLevelService::blackInfo($request->all());
        return response()->json($return_data);
    }

    // 礼品列表
    public function goodsList(Request $request)
    {

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'list';
        logFileRecord($log_record, 'wash/MemberLevel', 2);

        // 查询
        $return_data = MemberLevelService::goodsList($request->all());
        return response()->json($return_data);
    }

    // 使用礼品
    public function useLevelGoods(Request $request)
    {

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'list';
        logFileRecord($log_record, 'wash/MemberLevel', 2);

        // 查询
        $return_data = MemberLevelService::useLevelGoods($request->all());
        return response()->json($return_data);
    }

    // 购买黑钻
    public function buyBlack(Request $request)
    {

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'list';
        logFileRecord($log_record, 'wash/MemberLevel', 2);

        // 查询
        $return_data = MemberLevelService::buyBlack($request->all());
        return response()->json($return_data);
    }

    // 下单
    public function addOrder(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'list';
        logFileRecord($log_record, 'wash/MemberLevel', 2);

        // 查询
        $return_data = MemberLevelService::addOrder($request->all());
        return response()->json($return_data);
    }

    // 取消下单
    public function cancelOrder(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'list';
        logFileRecord($log_record, 'wash/MemberLevel', 2);

        // 查询
        $return_data = MemberLevelService::cancelOrder($request->all());
        return response()->json($return_data);
    }
}
