<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\WeChatApplet\User\MemberCarService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

class MemberCarController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new MemberCarService();
        $this->bootWithService($service);
    }

    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'index';
		logFileRecord($log_record, 'wash/MemberCar', 2);

        // $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'info';
		logFileRecord($log_record, 'wash/MemberCar', 2);

        // 查询
        $return_data = MemberCarService::info($request->all());
        return response()->json($return_data);
    }
    
    // 新增
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'add';
		logFileRecord($log_record, 'wash/MemberCar', 2);

        $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
        if ($exist) {
            return $this->error('车牌号已经存在', ErrorInc::DATA_EXIST);
        }

        // 查询
        $return_data = MemberCarService::add($request->all());
        return response()->json($return_data);
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'edit';
		logFileRecord($log_record, 'wash/MemberCar', 2);

        $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['meca_id']);
        if ($exist) {
            return $this->error('车牌号已经存在', ErrorInc::DATA_EXIST);
        }

        // 编辑
        $return_data = MemberCarService::edit($request->all());
        return response()->json($return_data);
    }

    // 设置默认
    public function carDefault(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->carDefaultValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'carDefault';
        logFileRecord($log_record, 'wash/MemberCar', 2);

        // 编辑
        $return_data = MemberCarService::carDefault($request->all());
        return response()->json($return_data);
    }
}
