<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\WeChatApplet\Technician\WeixinTechnicianService;
use App\Services\Shop\VipCardService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginTechnicianService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

// 微信用户信息
class WeixinTechnicianController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new WeixinTechnicianService();
        $this->bootWithService($service);
    }

    // 技师登录
    public function login(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->loginValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'login';
		logFileRecord($log_record, 'wash/WeixinTechnician', 2);
        
        // 登录
        DB::beginTransaction();
        $return_data = WeixinTechnicianService::login($request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
        } else {
            DB::commit();
        }
        return response()->json($return_data);
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 详情
        $return_data = WeixinTechnicianService::info($request->all());
        return response()->json($return_data);
    }

    // 修改个人信息
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $return_data = WeixinTechnicianService::edit($request->all());
        return response()->json($return_data);
    }

    // 我的会员卡
    public function myvip(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $Technician_info = LoginTechnicianService::getTechnician();
        // 查询字段
        $field_columns = ['myvi_id', 'myvi_adm_id', 'myvi_num', 'myvi_create_adm_id', 'myvi_create_time', 'myvi_surplus_times', 'myvi_all_times', 'myvi_effective_date', 'myvi_state', 'myvi_carnum', 'myvi_name', 'myvi_sepr_id', 'myvi_sepr_name', 'myvi_long_term', 'myvi_end_time'];
        $search_data = $request;
        $search_data['adm_id'] = $Technician_info->ussh_Technician_id;
        DB::beginTransaction();
        $return_data = VipCardService::vipCardIndex($Technician_info, $search_data, 10, $field_columns);
        if ($return_data['code'] == 500) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 我的会员卡
    public function myVipInfo(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $Technician_info = LoginTechnicianService::getTechnician();
        $request['adm_id'] = $Technician_info->ussh_Technician_id;
        $return_data = VipCardService::myVipInfo($Technician_info, $request);
        if ($return_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'暂无数据', 'data'=>'暂无数据']);
        }
    }

    // 生成会员卡二维码
    public function vipQrcode(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->vipQrcodeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $Technician_info = LoginTechnicianService::getTechnician();
        DB::beginTransaction();
        $return_data = WeixinTechnicianService::vipQrcode($Technician_info, $request);
        if ($return_data['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($return_data);
    }

    // 获取会员卡二维码
    public function getVipQrcode(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->vipQrcodeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $Technician_info = LoginTechnicianService::getTechnician();
        $return_data = WeixinTechnicianService::getVipQrcode($Technician_info, $request);
        return response()->json($return_data);
    }

    // 我的会员卡使用明细
    public function myvipDetail(Request $request)
    {
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $Technician_info = LoginTechnicianService::getTechnician();
        // 查询字段
        $field_columns = ['vcre_id', 'vcre_myvi_id', 'vcre_Technician_id', 'vcre_ord_num', 'vcre_ord_id', 'vcre_create_time', 'vcre_car_adm_name', 'vcre_car_adm_phone', 'vcre_myvi_num', 'myvi_name'];
        $search_data = $request->all();
        $search_data['mem_id'] = $Technician_info->ussh_Technician_id;
        $return_data = VipCardService::detailIndex($Technician_info, $search_data, 10, $field_columns);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }
}
