<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Business\WashWorkService;
use App\Services\Business\WashWorkBasicService;
use App\Services\Business\WashOrderBasicService;
use App\Services\Business\WashOrderService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Services\CommonService;

// 技师小程序工单信息
class WashWorkController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new WashWorkService();
        $this->orderdataService = $orderservice = new WashOrderService();
        $this->bootWithService($service);
        // $this->bootWithService($orderservice);
    }

    // 首页-预约信息列表
    public function home(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->homeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'home';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->homePage($user_info, $request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 首页-预约汇总、排行榜
    public function homeCollect(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->homeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'homeCollect';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->homeCollect($user_info, $request->all());

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 首页-预约时间
    public function homeAppointTime(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->homeValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'homeAppointTime';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->homeAppointTime($user_info, $request->all());

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 首页-预约时间
    public function planAppointTime(Request $request)
    {
        // // 验证参数
        // $error_message = $this->dataService->mainValidator->planAppointTimeValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        // }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'planAppointTime';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        // 获取那些日期有排班的日期数据
        $search_data = $this->dataService->planAppointTime($user_info, $request->all());

        // 获取那些日期里有设置预约数量的日期
        $reserve_data = $this->dataService->planAppointNum($user_info, $request->all());

        if (empty($search_data) && empty($reserve_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data,'reserve_data'=>$reserve_data]);
        }
    }

    // 排班计划列表
    public function planappIndex(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->planappIndexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'planappIndex';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->planappIndex($user_info, $request->all(), 50);
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        $set_num = false;
        foreach ($list_button as $key => $value) {
            if ($value['pri_id'] == 22 && $value['have_pri'] == 1) {
                $set_num = true;
            }
        }
        if (isset($request['add_num']) && $request['add_num'] == 1) {
            $find_most = DB::table('moudle_statistics')
                ->where('most_shop_id', $user_info->adm_shop_id)
                ->where('most_adm_id', $user_info->adm_id)
                ->where('most_moudle_id', 3)
                ->first();
            $update_data['most_nums'] = $find_most->most_nums + 1;
            $update_data['most_update_time'] = date('Y-m-d H:i:s');
            if ($update_data['most_nums'] >= 3) {
                $update_data['most_remind'] = 2;
            }
            $update_res = DB::table('moudle_statistics')
                ->where('most_id', $find_most->most_id)
                ->update($update_data);
        }
        if (empty($search_data['data'])) {
            return response()->json(['code'=>200, 'msg'=>'未找到数据', 'data'=>$search_data, 'set_num'=>$set_num]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'set_num'=>$set_num]);
        }
    }

    /**
     * 排班计划显示字段
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2025-03-27
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function planTitle(Request $request) {
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $find_data = DB::table('shop_showset')
            ->where('shst_shop_id', $user_info->adm_shop_id)
            ->where('shst_type', 'plan')
            ->where('shst_state', 1)
            ->first();
        if (empty($find_data)) {
            $shst_state = 1;
            $all_data['work_data'] = [['name'=>'订单单号','field'=>'ord_order_number', 'select'=>true],['name'=>'工单单号','field'=>'wor_number', 'select'=>true],['name'=>'施工门店','field'=>'wopl_address', 'select'=>true],['name'=>'预约时间','field'=>'wopl_date', 'select'=>true],['name'=>'销售人员','field'=>'wopl_sale_name', 'select'=>true],['name'=>'施工说明','field'=>'wopl_explain', 'select'=>true],['name'=>'施工人员','field'=>'service_adm_name', 'select'=>true]];

            $all_data['goods_data'] = [['name'=>'商品名称','field'=>'orgo_goo_name', 'select'=>true],['name'=>'商品数量','field'=>'orgo_goo_quantity', 'select'=>true],['name'=>'商品单位','field'=>'orgo_goo_unit', 'select'=>true]];
            $all_data['mem_data'] = [['name'=>'姓名/电话','field'=>'mem_name', 'select'=>true],['name'=>'车牌号','field'=>'orcl_car_num', 'select'=>true],['name'=>'品牌系列','field'=>'orcl_car_brand_series', 'select'=>true]];
            // $find_data['shst_data'] = $all_data;
            // ,['name'=>'车辆颜色','field'=>'mem_car_color', 'select'=>false],['name'=>'客户来源','field'=>'mem_source', 'select'=>false],['name'=>'会员标签','field'=>'mem_label_name', 'select'=>false],['name'=>'会员等级','field'=>'mem_level', 'select'=>false],['name'=>'业务员','field'=>'mem_salesman_id', 'select'=>false]
        } else {
            $shst_state = 1;
            // $all_data['shst_data'] = json_decode(json_encode($find_data->shst_data, true), true);
            $all_data = json_decode($find_data->shst_data,true);
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$all_data, 'shst_state'=>$shst_state]);
    }

    // 设置预约数量 孔圣寅
    public function planappSetnum(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'planappSetnum';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();

        $return_data = $this->dataService->planappSetnum($user_info, $request->all());

        if ($return_data['code'] != 200) {
            Db::rollBack();
            return response()->json($return_data);
        }
        OperationLog::addLog($user_info, getRealIp($request), '排班计划', '设置预约数量', $return_data['res']);
        DB::commit();
        return response()->json($return_data);
    }

    /**
     * 获取订单
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-29
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getOrderType(Request $request) {
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $request['orty_state'] = 1;
        $return_data = WashOrderService::orderType($user_info,$request);
        return response()->json($return_data);
    }

    // 根据预约排班时间获取当日可以预约数量和已预约数量
    public function appoinTimeJudge(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'appoinTimeJudge';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        $return_data = $this->dataService->appoinTimeJudge($user_info, $request->all());

        return response()->json($return_data);
    }

    // 工单列表
    public function index(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'index';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        $search_data = $this->dataService->indexPage($user_info, $request->all(), 10);
        // 获取当前列表下的按钮
        $list_items = $search_data['data'];
        if (!empty($list_items)) {
            foreach ($list_items as $key => $value) {
                $buttonData = [];
                if (!empty($value->wocl_client_id)) {
                    $buttonData[] = 'assign';
                }
                if(in_array($value->wor_state, [7,8,10]) && $value->wocl_check_car_state == 1){
                    $buttonData[] = 'validateCarInfo';
                }
                if($value->wor_state < 7){
                    $buttonData[] = 'cancelOrder';
                }
                if(in_array($value->wor_state, [8,9,10])){
                    $buttonData[] = 'completionInfo';
                }
                if(in_array($value->wor_state, [10])){
                    $buttonData[] = 'returnItemInfo';
                }
                if(in_array($value->wor_state, [8])){
                    $buttonData[] = 'auditWork';
                }
                if(in_array($value->wor_state, [9])){
                    $buttonData[] = 'returnWork';
                    
                }
                // if(in_array($value->wor_state, [7]) && $value->wocl_check_car_state == 1 && $user_info->adm_id == $value->wor_service_adm_id){
                //     $buttonData[] = 'addCheckCar';
                // }
                $wotp_service_adm_id = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value->wor_id)
                    ->where('wotp_work_type', 1)
                    ->value('wotp_service_adm_id');
                if(in_array($value->wor_state, [4,5,6]) && $value->wocl_check_car_state == 2 && $user_info->adm_id == $wotp_service_adm_id){
                    $buttonData[] = 'checkCar';
                }
                $wotp_service_adm_id2 = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value->wor_id)
                    ->where('wotp_work_type', 2)
                    ->value('wotp_service_adm_id');
                if(in_array($value->wocl_check_car_state, [1,5]) && in_array($value->wor_state, [7]) && $user_info->adm_id == $wotp_service_adm_id2){
                    $buttonData[] = 'completion';
                }
                $wotp_service_adm_id3 = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value->wor_id)
                    ->where('wotp_work_type', 3)
                    ->value('wotp_service_adm_id');
                if(in_array($value->wor_state, [9]) && $user_info->adm_id == $wotp_service_adm_id3){
                    $buttonData[] = 'returnItem';
                }
                $button = CommonService::getAppletListButton($buttonData,$list_button);
                $list_items[$key]->button_one = $button['button_one']??[];
                $list_items[$key]->button_two = $button['button_two']??[];
                // $list_items[$key]->button_three = $button['button_three']??[];
            }
            $search_data['data'] = $list_items;
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        // if (empty($list_items)) {
        //     return $this->error('未找到数据', 200);
        // } else {
        // }
    }

    // 派单
    /**
     * 派单
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-07
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function dispatchList(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'dispatchList';
        logFileRecord($log_record, 'wash/WashWork', 2);
        // 验证参数
        $error_message = $this->dataService->mainValidator->dispatchListValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->dispatchList($user_info, $request->all());
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            $list_data = $search_data['data'];
            if (!empty($list_data)) {
                $pri_operate_method = array_column($list_button, 'pri_operate_method');
                foreach ($list_data as $key => $value) {
                    $buttonData = [];
                    if(in_array($value->ord_wor_state, [7])){
                        $buttonData[] = 'receivingOrder';
                        if($value->ord_type!=3) {
                            $buttonData[] = 'setService';
                        }
                        if($value->ord_source==5) {
                            $buttonData[] = 'refuseOrder';
                        }
                    }
                    if(in_array($value->ord_wor_state, [1])){
                        if($value->ord_type!=3) {
                            $buttonData[] = 'setService';
                        }
                        $buttonData[] = 'newCreateWork';
                    }
                    if(!in_array('phone', $pri_operate_method) && $value->ord_wor_state != 7){
                        $list_data[$key]->orcl_phone = substr($value->orcl_phone,0,3).'****'.substr($value->orcl_phone,-4);
                        $list_data[$key]->orcl_name = mb_substr($value->orcl_name,0,1,'utf-8').str_repeat("*",(strlen($value->orcl_name)/3-1));
                    }
                    $button = CommonService::getAppletListButton($buttonData,$list_button);
                    $list_data[$key]->button_one = $button['button_one']??[];
                    $list_data[$key]->button_two = $button['button_two']??[];
                    $list_data[$key]->button_three = $button['button_three']??[];
                }
            }
            $search_data['data'] = $list_data;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    public function orderInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->orderInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'orderInfo';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::orderInfo($user_info, $request->all());
        $info = $return_data['data']['order_data'];
        // 获取当前列表下的按钮
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        $pri_operate_method = array_column($list_button, 'pri_operate_method');
        $buttonData = [];
        if(in_array($info->ord_wor_state, [7])){
            $buttonData[] = 'receivingOrder';
            $buttonData[] = 'refuseOrder';
        }
        $work_order = DB::table('work_order')
            ->where('wor_order_id',$request['ord_id'])
            ->select('wor_state','wor_id')
            ->first();
        $work_order = CommonService::dataToArray($work_order);
        if(in_array($info->ord_state, [1]) && (!$work_order || $work_order['wor_state']<=5) && in_array($info->ord_type, [0,1])){
            $buttonData[] = 'editOrderMember';
        }
//        if ($info->orcl_sales_adm_id == $user_info->adm_id) {
            $buttonData[] = 'editOrderExplain';
//        }
        if(in_array($info->ord_wor_state, [1])){
            $buttonData[] = 'newCreateWork';
        }
        if (($info->ord_wor_state == 1 || $info->ord_wor_state == 7) && $info->ord_source != 5 && $info->ord_add_type == 1) {
            $buttonData[] = 'cancelOrder';
        }
        if(!in_array('phone', $pri_operate_method) && $info->ord_wor_state != 7){
            $info->orcl_phone = substr($info->orcl_phone,0,3).'****'.substr($info->orcl_phone,-4);
            $info->orcl_name = mb_substr($info->orcl_name,0,1,'utf-8').str_repeat("*",(strlen($info->orcl_name)/3-1));
        }
        $info->buttonData = $buttonData;
        $button = CommonService::getAppletListButton($buttonData,$list_button);
        $info->button_one = $button['button_one']??[];
        $info->button_two = $button['button_two']??[];
        $return_data['data']['order_data'] = $info;
        return response()->json($return_data);
    }

    // 获取各个模块未读数量
    public function getmodelnum(Request $request)
    {

    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'info';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::info($user_info, $request->all());
        if (isset($return_data['data']['work_data'])) {
            $info = $return_data['data']['work_data'];
        } else {
            return response()->json($return_data);
        }
        $is_team = DB::table('wash_work_technician_part')
            ->where('wotp_wor_id', $info->wor_id)
            ->where('wotp_service_adm_id', $user_info->adm_id)
            ->exists();
        // 获取当前列表下的按钮
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        $orcl_sales_adm_id = DB::table('order_client')
            ->where('orcl_ord_id',$info->wor_order_id)->value('orcl_sales_adm_id');
        $buttonData = [];
        if(isset($request['searchPage']) && $request['searchPage']=='validateCar'){
            if (in_array($info->wor_state, [4, 5, 6]) && $info->wocl_check_car_state == 2 && $user_info->adm_id == $info->wor_service_adm_id && $info->ord_type!=3) {
                $buttonData[] = 'setService';
            }
        }else {
            $wotp_service_adm_id = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $info->wor_id)
                    ->where('wotp_work_type', 1)
                    ->value('wotp_service_adm_id');
            if (in_array($info->wor_state, [4, 5, 6]) && $info->wocl_check_car_state == 2 && $user_info->adm_id == $wotp_service_adm_id) {
               $buttonData[] = 'checkCar';
               $buttonData[] = 'cancelOrder';
            }
            $buttonData[] = 'editOrderExplain';
            if (in_array($info->wor_state, [4, 5, 6]) && $info->wocl_check_car_state == 2 && $info->ord_type!=3) {
                $buttonData[] = 'setService';
            }
            $wotp_service_adm_id2 = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $info->wor_id)
                ->where('wotp_work_type', 2)
                ->value('wotp_service_adm_id');
            if (in_array($info->wocl_check_car_state, [1, 5]) && in_array($info->wor_state, [7]) && $user_info->adm_id == $wotp_service_adm_id2) {
               $buttonData[] = 'completion';
            }

            if (!empty($info->wocl_client_id)) {
               $buttonData[] = 'assign';
            }
            if (in_array($info->wor_state, [7, 8, 10]) && $info->wocl_check_car_state == 1) {
               $buttonData[] = 'validateCarInfo';
            }
            if (in_array($info->ord_state, [1]) && $info->wor_state<6 && in_array($info->wor_type, [0,1])) {
                $buttonData[] = 'editOrderMember';
            }
            if (in_array($info->wor_state, [8, 10,12])) {
               $buttonData[] = 'completionInfo';
            }
            $wotp_service_adm_id3 = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $info->wor_id)
                ->where('wotp_work_type', 3)
                ->value('wotp_service_adm_id');
            if(in_array($info->wor_state, [9]) && $user_info->adm_id == $wotp_service_adm_id3){
                $buttonData[] = 'returnItem';
            }
        }
        $button = CommonService::getAppletListButton($buttonData,$list_button);
        $info->button_one = $button['button_one']??[];
        $info->button_two = $button['button_two']??[];
        $return_data['data']['work_data'] = $info;
        return response()->json($return_data);
    }

    // 拒单
    public function refuse(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'refuse';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = WashWorkService::refuse($user_info, $request->all());
        if ($return_data['code'] != 200) {
            return response()->json($return_data);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '技师拒单');
        if ($request['remark']) {
            // 添加备注
            $orre_res = orderRemark($user_info, 0, $request['wor_id'], $request['remark'], '技师拒单');
        } else {
            $orre_res = true;
        }
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number', 'wocl_car_num', 'wor_type', 'wor_number')
            ->first();
        if ($orlo_res && $orre_res) {
            DB::commit();
            $log_data = [
                'oplo_module'=>'工单列表小程序',
                'oplo_action'=>'技师拒单',
                'oplo_content'=>$return_data['data']['wor_number'] . '拒单成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$find_wor_data->ord_order_number,
                'work_number'=>$find_wor_data->wor_number,
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $log_data);
        } else {
            DB::rollBack();
        }
        return response()->json($return_data);
    }

    // 验车
    public function validateCar(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->validateCarValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'validateCar';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        if ($request['type'] == '1' || $request['type'] == '3'|| $request['type'] == '4') {
            // 查看验车结果
            $return_data = WashWorkService::validateCar($user_info, $request->all());
            if ($return_data['code'] != 200) {
                DB::rollBack();
            } else {
                DB::commit();
            }
            return response()->json($return_data);
        }

        // 提交验车数据
        $return_data = WashWorkService::validateCar($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, $return_data['data']['wor_order_id'], $request['wor_id'], '技师验车');
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number', 'wocl_car_num', 'wor_type', 'wor_number')
            ->first();
        if ($find_wor_data->wor_type == 1) {
            // 客户小程序-微信用户id
            $weus_id = DB::table('user_shop')
                ->where('ussh_shop_id', $find_wor_data->wor_shop_id)
                ->where('ussh_user_id', $find_wor_data->wocl_client_id)
                ->value('ussh_weus_id');
        } else {
            $weus_id = DB::table('business_account')
                ->where('buac_shop_id', $find_wor_data->wor_shop_id)
                ->where('buac_id', $find_wor_data->wocl_client_id)
                ->value('buac_id');
        }
        // if ($weus_id) {
        //     // 添加客户消息
        //     $add_data['weus_id'] = $weus_id;
        //     $add_data['shop_id'] = $find_wor_data->wor_shop_id;
        //     $add_data['primary_id'] = $find_wor_data->wor_order_id;//单据的主键id
        //     $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
        //     $add_data['adm_type'] = $find_wor_data->wor_type;//1门店2合作商
        //     $add_data['read_state'] = 1;//阅读状态：1未读2已读
        //     $add_data['title'] = '验车确认通知';//消息标题
        //     if ($find_wor_data->wor_type == 1) {
        //         $add_data['content'] = '您的爱车（'.$find_wor_data->wocl_car_num.'）已完成验车，请您签字确认';//操作内容
        //     } else {
        //         $add_data['content'] = '您有订单已完成验车，请签字确认';//操作内容
        //     }
        //     $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
        //     $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
        //     $addUserMessage_res = addUserMessage($add_data);
        //     unset($add_data);
        // } else {
        //     $addUserMessage_res['code'] = 200;
        // }
        if ($orlo_res) {
            DB::commit();
            $data = [
                'oplo_module'=>'工单列表',
                'oplo_action'=>'技师验件',
                'oplo_content'=>'技师验件', $return_data['data']['wor_number'] . '验件成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$find_wor_data->ord_order_number,
                'work_number'=>$find_wor_data->wor_number,
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $data);
            return response()->json($return_data);
        } else {
            DB::rollBack();
            return $this->error('验车失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 验车
    public function checkCar(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->checkCarValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'checkCar';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 提交订单编辑数据
        $return_data = WashWorkService::checkCar($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 补充验车
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-24
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function addCheckCar(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addCheckCarValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addCheckCar';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 提交订单编辑数据
        $return_data = WashWorkService::addCheckCar($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 验车取消选择
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function cancelSelect(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelSelectValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'cancelSelect';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 提交订单编辑数据
        $return_data = WashWorkService::cancelSelect($user_info, $request->all());
        return response()->json($return_data);
    }

    // 施工-开始施工
    public function construction(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'construction';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = WashWorkService::construction($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number', 'wor_number')
            ->first();
        // // 客户小程序-微信用户id
        // $weus_id = DB::table('user_shop')
        //     ->where('ussh_shop_id', $find_wor_data->wor_shop_id)
        //     ->where('ussh_user_id', $find_wor_data->wocl_client_id)
        //     ->value('ussh_weus_id');

        // if ($weus_id) {
        //     // 添加客户消息
        //     $add_data['weus_id'] = $weus_id;
        //     $add_data['shop_id'] = $find_wor_data->wor_shop_id;
        //     $add_data['primary_id'] = $find_wor_data->wor_order_id;//单据的主键id
        //     $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
        //     $add_data['read_state'] = 1;//阅读状态：1未读2已读
        //     $add_data['content'] = '您的订单：'.$find_wor_data->ord_order_number.'工单开始施工,操作人：'.$user_info->adm_name;//操作内容
        //     $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
        //     $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
        //     $addUserMessage_res = addUserMessage($add_data);
        //     unset($add_data);
        // } else {
        //     $addUserMessage_res['code'] = 200;
        // }
        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '开始施工');
        if ($orlo_res/* && $addUserMessage_res['code'] == 200*/) {
            DB::commit();
            $data = [
                'oplo_module'=>'工单列表',
                'oplo_action'=>'开始施工',
                'oplo_content'=>$find_wor_data->wor_number . '开始施工成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$find_wor_data->ord_order_number,
                'work_number'=>$find_wor_data->wor_number,
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $data);
            return $this->success('开始施工成功');
        } else {
            DB::rollBack();
            return $this->error('开始施工失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 施工-施工单信息
    public function constructionInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'constructionInfo';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        $return_data = WashWorkService::constructionInfo($user_info, $request->all());
        return response()->json($return_data);
    }

    // 施工-施工单信息
    public function conInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'constructionInfo';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        $return_data = WashWorkService::conInfo($user_info, $request->all());
        return response()->json($return_data);
    }

    // 施工-完成提交工单
    public function accomplish(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $goo_data = DB::table('work_good as wogo')
                ->leftJoin('goods as g', 'g.goo_id', '=', 'wogo.wogo_goo_id')
                ->where('wogo_wor_id', $request['wor_id'])
                ->where('wogo_goo_type', 1)
                ->select('wogo_goo_unit', 'wogo_goo_unta_id', 'wogo_goo_amount', 'goo_unit_conversion', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_type', 'wogo_orgo_id', 'wogo_id', 'wogo_wago_id', 'wogo_goo_price', 'wogo_goo_goods_encode', 'wogo_is_recycle', 'wogo_recycle_quantity', 'wogo_is_waste', 'wogo_goo_waste_number')
                ->get()->toArray();
            if ($goo_data) {
                foreach ($goo_data as $key => $value) {
                    $goo_data[$key]->wogo_goo_amounts = $value->wogo_goo_amount.$value->wogo_goo_unit;
                    $goo_data[$key]->wogo_goo_amount = $value->wogo_goo_amount;
                }
            }
            $find_ware = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->select('wor_ware_id', 'wor_is_recycle')
                ->first();
            
            $data['find_ware'] = $find_ware->wor_ware_id;
            $data['wor_is_recycle'] = $find_ware->wor_is_recycle;
            $data['goo_data'] = $goo_data;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->accomplishValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'accomplish';
        logFileRecord($log_record, 'wash/WashWork', 2);
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number', 'wor_type', 'wor_number', 'wor_service_adm_id', 'wor_work_type')
            ->first();
        $find_worker = DB::table('wash_work_technician_part as w')
            ->leftJoin('admin', 'w.wotp_service_adm_id', '=', 'adm_id')
            ->where('wotp_wor_id', $request['wor_id'])
            ->where(function ($query) use ($request) { //技师id
                if (!empty($request['adm_id'])) {
                    $query->where('wotp_service_adm_id', $request['adm_id']);
                }
            })
            ->where('wotp_work_type', 2)
            ->select('wotp_service_adm_id', 'adm_name')
            ->get()->toArray();
        if (count($find_worker) == 1) {
            foreach ($find_worker as $key => $value) {
                $completion_info = DB::table('completion_info')
                    ->where('coin_wor_id', $request['wor_id'])
                    ->where('coin_adm_id', $value->wotp_service_adm_id)
                    // ->where('coin_must', 1)
                    ->select('coin_data_id', 'coin_type', 'coin_id', 'coin_data', 'coin_name', 'coin_must')
                    ->get()->toArray();
                
                foreach ($completion_info as $key4 => $value4) {
                    if ($value4->coin_type == 1) {
                        $label[] = $value4->coin_data;
                    }
                    if ($value4->coin_type == 2 || ($value4->coin_type == 3 && $value4->coin_data)) {
                        $image_data[] = $value4->coin_data;
                    }
                }
                
                if (empty($image_data)) {
                    return response()->json(['code'=>500, 'msg'=>'请上传'.$value->adm_name.'的施工图片1', 'data'=>'']);
                }
            }
        } else {
            foreach ($find_worker as $key => $value) {
                $completion_info = DB::table('completion_info')
                    ->where('coin_wor_id', $request['wor_id'])
                    ->where('coin_adm_id', $value->wotp_service_adm_id)
                    // ->where('coin_must', 1)
                    ->select('coin_data_id', 'coin_type', 'coin_id', 'coin_data', 'coin_name', 'coin_must')
                    ->get()->toArray();
                $j = 0;
                $image_data = [];
                $label = [];
                foreach ($completion_info as $key4 => $value4) {
                    if ($value4->coin_type == 1) {
                        $label[] = $value4->coin_data;
                    }
                    if ($value4->coin_type == 2 || ($value4->coin_type == 3 && $value4->coin_data)) {
                        $image_data[] = $value4->coin_data;
                    }
                }
                if (empty($image_data) || empty($label)) {
                    return response()->json(['code'=>500, 'msg'=>'请上传'.$value->adm_name.'的施工部位和施工图片', 'data'=>'']);
                }
            }
        }
        DB::beginTransaction();
        $return_data = WashWorkService::accomplish($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        

        if ($find_wor_data->wor_type == 1) {
            // 客户小程序-微信用户id
            $weus_id = DB::table('user_shop')
                ->where('ussh_shop_id', $find_wor_data->wor_shop_id)
                ->where('ussh_user_id', $find_wor_data->wocl_client_id)
                ->value('ussh_weus_id');
        } else {
            $weus_id = DB::table('business_account')
                ->where('buac_shop_id', $find_wor_data->wor_shop_id)
                ->where('buac_id', $find_wor_data->wocl_client_id)
                ->value('buac_id');
        }
        if ($weus_id) {
            // 添加客户消息
            $add_data['weus_id'] = $weus_id;
            $add_data['shop_id'] = $find_wor_data->wor_shop_id;
            $add_data['primary_id'] = $find_wor_data->wor_order_id;//单据的主键id
            $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
            $add_data['adm_type'] = $find_wor_data->wor_type;//客户类型1门店2合作商
            $add_data['title'] = '施工完成通知';//单据类型：1订单2工单3预约单4售后单
            $add_data['read_state'] = 1;//阅读状态：1未读2已读
            if ($find_wor_data->wor_type == 1) {
                if ($return_data['data']['wocl_car_num']) {
                    $add_data['content'] = '您的爱车（'.$return_data['data']['wocl_car_num'].'）已服务完成，请您为我们的服务做出评价';//操作内容
                } else {
                    $add_data['content'] = '您的爱车已服务完成，请您为我们的服务做出评价';//操作内容
                }
            } else {
                $add_data['content'] = '您有订单已施工完成，请查看';//操作内容
            }
            // $add_data['content'] = '您的订单：'.$find_wor_data->ord_order_number.'工单审核成功,审核人：'.$user_info->adm_name;//操作内容
            $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
            $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
            $addUserMessage_res = addUserMessage($add_data);
            unset($add_data);
        } else {
            $addUserMessage_res['code'] = 200;
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '完成提交');
        if ($orlo_res) {
            DB::commit();
            $log_data = [
                'oplo_module'=>'工单列表',
                'oplo_action'=>'完成提交',
                'oplo_content'=>$return_data['data']['wor_number'] . '完成提交成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$find_wor_data->ord_order_number,
                'work_number'=>$find_wor_data->wor_number,
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $log_data);
            return $this->success('完成提交成功');
        } else {
            DB::rollBack();
            return $this->error('完成提交失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 提交施工
    public function submitConstruction(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'submitConstruction';
        $file_name = date('Ymd', strtotime('this week Monday', time()));
        logFileRecord($log_record, 'wash/WashWork'.$file_name, 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        // 查询工单数据
        if ($request['type'] == 1) {
            $find_data = DB::table('wash_work_check_history')
                ->where('woch_adm_id', $user_info->adm_id)
                ->where('woch_wor_id', $request['wor_id'])
                ->where('woch_check_res', 3)
                ->select('woch_part_data', 'woch_check_res', 'woch_check', 'woch_wor_id', 'woch_adm_id')
                ->orderBy('woch_create_time', 'desc')
                ->first();
            $wor_service_adm_id = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->value('wor_service_adm_id');
            if ($wor_service_adm_id == $user_info->adm_id) {
                $find_data = DB::table('wash_work_check_history')
                    ->where('woch_adm_id', $user_info->adm_id)
                    ->where('woch_wor_id', $request['wor_id'])
                    ->where('woch_check_res', 2)
                    ->select('woch_part_data', 'woch_check_res', 'woch_check', 'woch_wor_id', 'woch_adm_id')
                    ->orderBy('woch_create_time', 'desc')
                    ->first();
            }
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
        }

        // 提交工单
        // 验证参数
        $error_message = $this->dataService->mainValidator->submitConstructionValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        DB::beginTransaction();
        // 判断门店版本
        if ($user_info->shop_versions == 1) {
            // 基础版提交流程
            $return_data = WashWorkBasicService::submitConstruction($user_info, $request->all());
        } else {
            $return_data = WashWorkService::submitConstruction($user_info, $request->all());
        }
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number', 'wor_type', 'wor_number')
            ->first();
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '提交施工');
        if ($orlo_res) {
            DB::commit();
            $log_data = [
                'oplo_module'=>'工单列表',
                'oplo_action'=>'提交施工',
                'oplo_content'=>'提交施工'.$request['wor_number'] . '提交施工成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$find_wor_data->ord_order_number,
                'work_number'=>$find_wor_data->wor_number,
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $log_data);
            return $this->success('提交施工成功');
        } else {
            DB::rollBack();
            return $this->error('提交施工失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 质检
    public function qualityTesting(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->qualityTestingValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'qualityTesting';
        $file_name = date('Ymd', strtotime('this week Monday', time()));
        logFileRecord($log_record, 'wash/WashWork'.$file_name, 2);
        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        sqlLog();
        DB::beginTransaction();
        $return_data = WashWorkService::qualityTesting($user_info, $request->all());
        if ($request['type'] == 1 || $request['type'] == 3) {
            return response()->json($return_data);
        }
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number', 'wor_type', 'wor_number')
            ->first();
        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '质检');
        if ($orlo_res) {
            DB::commit();
            $log_data = [
                'oplo_module'=>'工单列表',
                'oplo_action'=>'质检',
                'oplo_content'=>$find_wor_data->wor_number . '质检成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$find_wor_data->ord_order_number,
                'work_number'=>$find_wor_data->wor_number,
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $log_data);
            return $this->success('质检成功');
        } else {
            DB::rollBack();
            return $this->error('质检失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 生成工单
    public function createWork(Request $request)
    {
        // 验证参数
        $error_message = $this->orderdataService->mainValidator->editShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'createWork';
        logFileRecord($log_record, 'wash/WashWork', 2);
        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 获取生成订单数据
        if ($request['type'] == 1) {
            $return_data = WashOrderService::editShow($user_info, $request->all());
            return response()->json($return_data);
        }

        DB::beginTransaction();
        request()->offsetSet('ord_service_type', 1);
        request()->offsetSet('ip', getRealIp($request));
        $request['goods_data'] = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_id', 'orgo_goo_id as goo_id', 'orgo_goo_name as goo_name', 'orgo_state as goo_state', 'orgo_goo_price as goo_price', 'orgo_goo_quantity as goo_quantity', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'orgo_goo_type as goo_type', 'orgo_goo_goods_encode as goo_goods_encode', 'orgo_wago_id as wago_id')
            ->get()->toArray();
        
        $order_data = WashOrderService::createWork($user_info, $request->all());
        if ($order_data['code'] != 200) {
            DB::rollBack();
            return response()->json($order_data);
        }

        $find_wor_data = DB::table('order')
            ->leftJoin('work_order', 'ord_id', '=', 'wor_order_id')
            ->where('ord_id', $request['ord_id'])
            ->select('wor_service_adm_id', 'wor_number', 'wor_order_number', 'ord_order_number', 'wor_id')
            ->first();
        if (!empty($request['service_adm_data'])) {
            // 添加技师消息
            $add_data['adm_id'] = $request['service_adm_id'];
            $add_data['shop_id'] = $user_info->adm_shop_id;
            $add_data['primary_id'] =$find_wor_data->wor_id; //单据的主键id
            $add_data['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
            $add_data['message_type'] = 1;
            // $add_data['message_type'] = $data['message_type'];
            $add_data['title'] = '派单通知'; //操作内容
            $add_data['content'] = '您有新的工单，请及时处理'; //操作内容
            $add_data['read_state'] = 1; //阅读状态：1未读2已读
            $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
            $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
            $addAdminMessage_res = addAdminMessage($add_data);
        } else {
            $addAdminMessage_res['code'] = 200;
        }
        if ($addAdminMessage_res['code'] != 200) {
            DB::rollBack();
            return response()->json($addAdminMessage_res);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, $request['ord_id'], 0, '生成工单');
        if ($orlo_res) {
            DB::commit();
            $data = [
                'oplo_module'=>'派单',
                'oplo_action'=>'派单',
                'oplo_content'=>'派单'.$find_wor_data->ord_order_number . '成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$find_wor_data->ord_order_number,
                'work_number'=>isset($find_wor_data->wor_number) ? $find_wor_data->wor_number : '',
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $data);
            return $this->success('派单成功');
        } else {
            DB::rollBack();
            return $this->error('派单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 工单-重新派单
    public function assign(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->assignShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'assign';
        logFileRecord($log_record, 'wash/WashWork', 2);
        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $find_work = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->leftjoin('order as o', 'o.ord_id', '=', 'wor.wor_order_id')
                ->where('wor_id', $request['wor_id'])
                ->where('wor_shop_id', $user_info->adm_shop_id)
                ->select('wor_number', 'wor_explain', 'wor_appoint_time', 'wor_address', 'wor_address_id', 'wor_address_type', 'ord_id')
                ->first();
            $ord_Explainpic = [];
            $Explainpic = self::getExplainpic($user_info, $find_work->ord_id);
            if (!empty($Explainpic['data'])) {
                $ord_Explainpic = $Explainpic['data'];
            }
            $find_work->ord_explain_pic = $ord_Explainpic;
            
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_work]);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->assignValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        DB::beginTransaction();
        request()->offsetSet('wor_service_adm_id', $request['service_adm_id']);
        // 提交重新派单数据
        $return_data = WashWorkService::assign($user_info, $request->all());
        if ($return_data['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($return_data);
    }

    // 接单提交
    public function receiveSubmit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->receiveSubmitValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'receiveSubmit';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = WashWorkService::receiveSubmit($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '接单');
        if ($orlo_res) {
            DB::commit();
            $data = [
                'oplo_module'=>'工单列表',
                'oplo_action'=>'接单',
                'oplo_content'=>$return_data['data']['wor_number'] . '接单成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$return_data['data']['order_number'],
                'work_number'=>$return_data['data']['wor_number'],
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $data);
            // OperationLog::addLog($user_info, getRealIp($request), '工单列表', '接单', $return_data['data']['wor_number'] . '接单成功');
            return $this->success('接单成功');
        } else {
            DB::rollBack();
            return $this->error('接单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 预约时间设置
    public function appointmentSet(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->appointmentSetValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'appointmentSet';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = $this->dataService->appointmentSet($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, $return_data['data']['wor_order_id'], $request['wor_id'], '技师预约');
        // 预约备注内容
        $remark_data = '预约时间：' . $request['appoint_time'];
        if (isset($request['appoint_remark']) && !empty($request['appoint_remark'])) {
            $remark_data .= ' ' . $request['appoint_remark'];
        }
        $orre_res = orderRemark($user_info, $return_data['data']['wor_order_id'], $request['wor_id'], $remark_data, '工单列表-技师预约');
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number')
            ->first();
        // 客户小程序-微信用户id
        $weus_id = DB::table('user_shop')
            ->where('ussh_shop_id', $find_wor_data->wor_shop_id)
            ->where('ussh_user_id', $find_wor_data->wocl_client_id)
            ->value('ussh_weus_id');

        // if ($weus_id) {
        //     // 添加客户消息
        //     $add_data['weus_id'] = $weus_id;
        //     $add_data['shop_id'] = $find_wor_data->wor_shop_id;
        //     $add_data['primary_id'] = $find_wor_data->wor_order_id;//单据的主键id
        //     $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
        //     $add_data['read_state'] = 1;//阅读状态：1未读2已读
        //     $add_data['content'] = '您的订单：'.$find_wor_data->ord_order_number.'工单预约成功,操作人：'.$user_info->adm_name;//操作内容
        //     $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
        //     $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
        //     $addUserMessage_res = addUserMessage($add_data);
        //     unset($add_data);
        // } else {
        //     $addUserMessage_res['code'] = 200;
        // }

        if ($orlo_res && $orre_res/* && $addUserMessage_res['code'] == 200*/) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '预约', $return_data['data']['wor_number'] . '预约成功');
            return $this->success('预约成功');
        } else {
            DB::rollBack();
            return $this->error('预约失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 待派订单修改预约时间
    public function appointmentOrderSet(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->appointmentOrderSetValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'appointmentOrderSet';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = $this->dataService->appointmentOrderSet($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, $request['ord_id'], 0, '订单修改预约时间');
        // 预约备注内容
        $remark_data = '预约时间：' . $request['appoint_time'];
        if (isset($request['appoint_remark']) && !empty($request['appoint_remark'])) {
            $remark_data .= ' ' . $request['appoint_remark'];
        }
        $orre_res = orderRemark($user_info, $request['ord_id'], 0, $remark_data, '订单列表-修改预约时间');
        // 订单单信息
        $find_order_data = DB::table('order as o')
            ->leftJoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->where('ord_id', $request['ord_id'])
            ->select('orcl_client_id', 'ord_shop_id', 'ord_id', 'ord_order_number')
            ->first();
        // 客户小程序-微信用户id
        $weus_id = DB::table('user_shop')
            ->where('ussh_shop_id', $find_order_data->ord_shop_id)
            ->where('ussh_user_id', $find_order_data->orcl_client_id)
            ->value('ussh_weus_id');

        // if ($weus_id) {
        //     // 添加客户消息
        //     $add_data['weus_id'] = $weus_id;
        //     $add_data['shop_id'] = $find_order_data->ord_shop_id;
        //     $add_data['primary_id'] = $find_order_data->ord_id;//单据的主键id
        //     $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
        //     $add_data['read_state'] = 1;//阅读状态：1未读2已读
        //     $add_data['content'] = '您的订单：'.$find_order_data->ord_order_number.'订单预约时间修改成功,操作人：'.$user_info->adm_name;//操作内容
        //     $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
        //     $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
        //     $addUserMessage_res = addUserMessage($add_data);
        //     unset($add_data);
        // } else {
        //     $addUserMessage_res['code'] = 200;
        // }

        if ($orlo_res && $orre_res/* && $addUserMessage_res['code'] == 200*/) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '预约', $find_order_data->ord_order_number . '预约修改成功');
            return $this->success('预约修改成功');
        } else {
            DB::rollBack();
            return $this->error('预约修改失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 工单历史
    public function getWorkHistory(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getWorkHistoryValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getWorkHistory';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::getWorkHistory($user_info, $request->all());
        return response()->json($return_data);
    }

    // 编辑技师
    public function editTechnician(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editTechnicianValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'editTechnician';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $return_data = WashWorkService::editTechnician($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '修改技师');
        if ($orlo_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '修改技师', '修改技师成功');
            return $this->success('修改技师成功');
        } else {
            DB::rollBack();
            return $this->error('修改技师失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 获取工单状态数量
    public function getMessage(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getMessage';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::getMessage($user_info, $request->all());
        return response()->json($return_data);
    }

    // 获取智配工单驳回数量
    public function rejectCount(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::rejectCount($user_info);
        return response()->json($return_data);
    }

    // 智配驳回订单列表
    public function rejectList(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('wor_other_audit', 3);//智配审核结果：1未审核2通过3驳回
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->indexPage($user_info, $request->all(), 10);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 智配驳回订单重新提交
    public function resubmit(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if (empty($request['wor_id']) || !in_array($request['type'], [1,2])) {
            return response()->json(['code'=>500, 'msg'=>'参数错误', 'data'=>'参数错误']);
        }
        if ($request['type'] == 1) {
            $return_data = WashWorkService::findResubmit($user_info, $request->all());
        } else {
            $return_data = WashWorkService::resubmit($user_info, $request->all());
        }
        return response()->json($return_data);
    }

    /**
     * 完工左侧列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getLeft(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getLeftValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getLeft';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 提交数据
        $return_data = WashWorkService::getLeft($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 完工添加数据
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function completion(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->completionValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'completion';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 提交数据
        $return_data = WashWorkService::completion($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 完工删除数据
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function cancelCom(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelComValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'cancelCom';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 提交订单编辑数据
        $return_data = WashWorkService::cancelCom($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 完工数据查询
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function completionInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->completionInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'completionInfo';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 完工信息
        $return_data = WashWorkService::completionInfo($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 质检数据查询
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function qualityInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->completionInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'qualityInfo';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 提交订单编辑数据
        $return_data = WashWorkService::qualityInfo($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 质检添加数据
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-15
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function quality(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->qualityValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'quality';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 质检数据提交
        $return_data = WashWorkService::quality($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 质检删除数据
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-17
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function cancelQuality(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelQualityValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'cancelQuality';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 提交订单编辑数据
        $return_data = WashWorkService::cancelQuality($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 余料废料实时存储
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-08-17
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function materials(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->materialsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'materials';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 质检数据提交
        $return_data = WashWorkService::materials($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 同步图片或取消同步
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-24
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function userPicState(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->userPicStateValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'userPicState';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 同步图片或取消同步
        $return_data = WashWorkService::userPicState($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 取消订单
     */
    public function cancelOrder(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'cancelOrder';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 取消订单
        DB::beginTransaction();
        $return_data = WashWorkService::cancelOrder($user_info, $request->all());
        if ($return_data['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($return_data);
    }

    /**
     * 还件-工单返工
     */
    public function returnWork(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'returnWork';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 工单返工
        $return_data = WashWorkService::returnWork($user_info, $request->all());
        return response()->json($return_data);
    }

    /**
     * 还件
     */
    public function returnItem(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'returnItem';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 工单返工
        $return_data = WashWorkService::returnItem($user_info, $request->all());
        OperationLog::addLog($user_info, getRealIp($request), '技师工单列表', '还件', '还件成功');
        return response()->json($return_data);
    }

    /**
     * 审核施工信息
     */
    public function auditWork(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'auditWork';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $find_work_remark = DB::table('completion_info')
                ->where('coin_wor_id', $request['wor_id'])
                ->where('coin_type', 4)
                // ->where('coin_must', 1)
                ->select('coin_wor_id', 'coin_type', 'coin_data')
                ->first();
            $find_com_img = DB::table('completion_info')
                ->where('coin_wor_id', $request['wor_id'])
                ->where('coin_type', 3)
                // ->where('coin_must', 1)
                ->select('coin_wor_id', 'coin_type', 'coin_data')
                ->get()->toArray();
            $data['work_image'] = $find_com_img;
            $data['work_remark'] = $find_work_remark ? $find_work_remark->coin_data:'无';
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
        $res = WashWorkService::auditWork($user_info,$request);
        return response()->json($res);
    }

    public function returnItemInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->completionInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'returnItemInfo';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        // 完工信息
        $return_data = WashWorkService::returnItemInfo($user_info, $request->all());
        return response()->json($return_data);
    }
}
