<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use App\Http\Models\Api\Common;
use App\Services\WeChatApplet\Technician\MemberService;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use App\Services\Business\WashOrderService;
use App\Services\Business\WashOrderBasicService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Services\PublicSearch;
use App\Services\Business\ReservationService;
use App\Http\Requests\Validators\Business\WashOrderBasicValidator;
use Pinyin;
use App\Services\CommonService;
use App\Http\Controllers\Api\Verify\ProductManage\VerifyServiceProjectController;
use App\Http\Controllers\Api\Verify\ProductManage\VerifyBrandListController;
use App\Http\Controllers\Api\Verify\ProductManage\VerifyCategoryListController;
use App\Http\Controllers\Api\Verify\ProductManage\VerifyBrandSerieController;
use App\Http\Controllers\WeChatApplet\Technician\WashStockakeController;
use App\Http\Controllers\Api\ProductManage\GoodsListController;
use App\Services\Business\WashMyWarehouseService;
use App\Services\Shop\GoodsService;
class WashOrderController extends Controller
{
    public $dataService = null;
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataService = $service = new WashOrderService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'index';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $data_re = $request->all();
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        $data_re['search_all'] = 2;
        foreach ($list_button as $key => $value) {
            if ($value['pri_operate_method'] == 'searchAll' && $value['have_pri'] == 1) {
                $data_re['search_all'] = 1;
            }
        }
        $search_data = $this->dataService->searchPage($user_info, $data_re, 10, 2);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            $list_data = $search_data['data'];
            //--------------全部退货不显示退货按钮，不是全部，显示--start----------
            $goods_data = $search_data['order_goods'];
            foreach ($goods_data as $good_key => $good_value){
                //订单商品是否已经全部退货
                $all_order_return[$good_value->orgo_ord_id] = false;//默认不可以退货
                if($good_value->orgo_goo_type == 1){//商品类型 1商品2服务3套餐商品4会员卡5充值卡
                    $all_return_goods[$good_value->orgo_ord_id][$good_value->orgo_goo_id] = $good_value->orgo_goo_quantity - $good_value->orgo_goo_return_quantity;//订单商品数量 - 退货数量
                }
            }
            if(isset($all_return_goods)){
                foreach ($all_return_goods as $re_key => $re_value) {
                    foreach ($re_value as $r_key => $r_value){
                        if($r_value > 0){
                            $all_order_return[$re_key] = true;//还有商品，可以退货
                        }
                    }
                }
            }
            //--------------全部退货不显示退货按钮，不是全部，显示-end-----------
            if (!empty($list_data)) {
                $pri_operate_method = array_column($list_button, 'pri_operate_method');
                foreach ($list_data as $key => $value) {
                    $buttonData = [];
                    $tuihuo = false;
                    //已结算或者已经发货
                    $wor_number = DB::table('work_order')
                        ->where('wor_order_id', $value->ord_id)
                        ->value('wor_number');
                    $dispatch_data = 1;//类型：1未出库2已出库
                    if($wor_number){
                        $dispatch_data = DB::table('dispatch_bill')
                            ->where('dego_cid', $user_info->adm_cid)
                            ->where('dego_superior_shop_id', $user_info->adm_shop_id)
                            ->where('dego_type', '<>', 3)
                            ->where('dego_original_number', $wor_number)
                            ->value('dego_type');
                    }else{
                        $dispatch_data = DB::table('dispatch_bill')
                            ->where('dego_cid', $user_info->adm_cid)
                            ->where('dego_superior_shop_id', $user_info->adm_shop_id)
                            ->where('dego_type', '<>', 3)
                            ->where('dego_original_number', $value->ord_order_number)
                            ->value('dego_type');
                    }
                    //有未处理退货不能申请
                    $return_status = true;
                    $refund_statuss = true;
                    $is_return_good = true;//默认没有申请退货，true 展示取消按钮
                    $return_good_status = DB::table('return_goods')
                        ->where('retgo_order_number', $value->ord_order_number)
                        ->where('retgo_status', 1)
                        ->orderBy('retgo_id','desc')
                        ->value('retgo_return_status');//退货进度：1未回收2部分回收3已回收4供货商回收
                    if($return_good_status){
                        if(in_array($return_good_status, [0,3,4])){
                            $return_status = true;
                        }else{
                            $return_status = false;
                            $is_return_good = false;//有退货未完成，false 不展示取消按钮
                        }
                    }
                    $refund_status = DB::table('refund')
                        ->where('ref_order_number', $value->ord_order_number)
                        ->where('ref_cancel', 1)
                        ->orderBy('ref_id','desc')
                        ->value('ref_status');//状态：1待审核2通过3驳回
                    if($refund_status){
                        if(in_array($refund_status, [2,3])){
                            $refund_statuss = true;
                        }else{
                            $refund_statuss = false;
                            $is_return_good = false;//有退款未完成，false 不展示取消按钮
                        }
                    }
                    if($dispatch_data == 2 && $return_status && $refund_statuss && isset($all_order_return[$value->ord_id]) && $all_order_return[$value->ord_id]){//已发货，退货退款都处理完成，就可以申请退款
                        $tuihuo = true;
                    }
                    if(isset($wor_number) && $value->ord_wor_state >= 20){
                        $tuihuo = false;
                    }
                    if($tuihuo && $value->ord_add_type == 1 && $value->ord_payment_way != 5){
                        $buttonData[] = 'add';
                    }
                    if(in_array($value->ord_wor_state, [1]) || ($value->ord_service_type == 2 && in_array($value->ord_wor_state, [1,2]) )){
                        $buttonData[] = 'cancel';
                    }
                    if (in_array($value->ord_wor_state, [1]) && $value->ord_service_type == 2) {
                        $buttonData[] = 'receiveOrder';
                    }
                    if(($value->ord_state ==1 || $value->ord_state ==3) && $value->ord_source != 5 && $value->ord_wor_state != 11) {
                        $buttonData[] = 'settlement';
                    }
                    if($value->ord_wor_state != 11 && $value->ord_source != 5) {
                        $buttonData[] = 'uploadOrdPic';
                    }
                    //换货
                    if(in_array($value->ord_wor_state, [7,1,2]) && !in_array($value->ord_payment_way, [10,11,12]) ){
                        $buttonData[] = 'exchangeGoods';
                    }
                    if(!in_array('orderPhone', $pri_operate_method) && $value->ord_wor_state != 7){
                        $list_data[$key]->orcl_phone = substr($value->orcl_phone,0,3).'****'.substr($value->orcl_phone,-4);
                        $list_data[$key]->orcl_name = mb_substr($value->orcl_name,0,1,'utf-8').str_repeat("*",(strlen($value->orcl_name)/3-1));
                    }
                    $buttonData[] = 'addRemark';//orderExplain
                    $button = CommonService::getAppletListButton($buttonData,$list_button);
                    $list_data[$key]->button_one = $button['button_one']??[];
                    $list_data[$key]->button_two = $button['button_two']??[];
                    $list_data[$key]->button_three = $button['button_three']??[];
                }
            }
            $search_data['data'] = $list_data;
            $search_data['list_button'] = $list_button;
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $search_data]);
        }
    }

    // 新增
    public function add(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 判断门店版本
        if ($user_info->shop_versions == 1) {
            // 基础版验证
            $error_message = (new WashOrderBasicValidator())->addValidator($request->all());
        } else {
            // 基础版验证
            $error_message = (new WashOrderBasicValidator())->addValidator($request->all());
            // $error_message = $this->dataService->mainValidator->addValidator($request->all());
        }
        // 验证参数
        $error_message = json_decode(json_encode($error_message, true), true);
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'add';
        $file_name = $user_info->shop_versions.'_'.date('Ymd', strtotime('this week Monday', time()));
        logFileRecord($log_record, 'wash/WashOrder'.$file_name, 2);
        
        request()->offsetSet('orcl_carowner_name', $request['orcl_name']);
        request()->offsetSet('orcl_carowner_phone', $request['orcl_phone']);
        request()->offsetSet('ip', getRealIp($request));
        
        DB::beginTransaction();
        
        // 其他版本功能逻辑
        if (!isset($request['ware_id'])) {
            request()->offsetSet('ware_id', 1);
        }
        request()->offsetSet('ord_service_type', 1);
        request()->offsetSet('orcl_shipment_party', 1);

        $request['client_ip'] = getRealIp($request);
        // $order_data = WashOrderService::add($user_info, $request->all());
        $order_data = WashOrderBasicService::add($user_info, $request->all());
        // 生成订单历史记录
        if ($order_data['code'] == 200) {
            $log_data = [
                'oplo_module'=>'快速开单',
                'oplo_action'=>'开单',
                'oplo_content'=>'技师开单',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>$order_data['data']['ord_order_number'],
                'work_number'=>'',
                'data_source'=>2,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $log_data);

            $data['wohi_primary_id'] = $order_data['data']['ord_id'];
            $data['wohi_state_name'] = '已创建';
            $data['wohi_state'] = 1;
            $data['wohi_type'] = 1;
            addHistory($data);
            unset($data);

            $post_data['most_moudle_id'] = 1;
            addMoudleNum($user_info, $post_data);

            DB::commit();
            return $this->success('生成订单成功');
        } else {
            DB::rollBack();
            return response()->json($order_data);
        }
    }

    // 工作台-搜索企业客户
    public function searchBusiness(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $shop_id = $user_info->adm_shop_id;

        $search_data = $request->all();
        $shop = DB::table('shop')
            ->where('shop_id', $shop_id)
            ->where('shop_cid', $user_info->adm_cid)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('shop_store_name', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->select('shop_id as bucl_id', 'shop_store_name as bucl_name')
            ->get()->toArray();
        $list = DB::table('business_client as bucl')
            ->where([
                'bucl_cid' => $user_info->adm_cid,
                'bucl_shop_id' => $shop_id
            ])
            ->where('bucl_del', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('bucl_name', 'like', '%' . $search_data['search_data'] . '%')
                        ->orwhere('bucl_user_phone', 'like', '%' . $search_data['search_data'] . '%')
                        ->orwhere('bucl_user_name', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->select('bucl_id', 'bucl_name')
            ->get()->toArray();
        if ($shop) {
            $shop[0]->address_type = 1;
            $shop[0]->bucl_name = $shop[0]->bucl_name . '(本店)';
        }
        foreach ($list as $key => $value) {
            $list[$key]->address_type = 2;
        }
        $shop = json_decode(json_encode($shop, true), true);
        $list = json_decode(json_encode($list, true), true);
        $new_list = array_merge($shop, $list);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $new_list]);
    }

    // 技师小程序-合作商新增预约下单
    public function addReservation(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addReservationValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'business');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addReservation';
        logFileRecord($log_record, 'wash/Reservation', 2);
        DB::beginTransaction();
        // 新增预约单
        request()->offsetSet('ip', getRealIp($request));
        $return_data = WashOrderService::addReservation($user_info, $request->all(), 3);
        // if (!empty($request['car_num'])) {
        //     $request['meca_car_num'] = $request['car_num'];
        //     $request['meca_car_brand_series'] = $request['car_brand_series'];
        //     $request['meca_car_frame'] = $request['car_vin'];
        //     $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
        //     if (!$exist) {
        //         $return_car_data = MemberCarService::add($request->all());
        //     } else {
        //         $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        //     }
        // } else {
        //     $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        // }
        // 查询
        if ($return_data['code'] != 200/* || $return_car_data['code'] != 200*/) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            return $this->success('预约下单成功');
        }
    }

    //图片获取车牌号
    public function pictoplace(Request $request)
    {
        $url = 'http://sudianwang.com/OcrWeb/servlet/OcrServlet'; //生产环境
        //$url='http://weixin.sudianwang.com/index.php/Addscoret/ceshi';//生产环境
        //$url='http://b6cf6458.ngrok.io/Api';
        $filedata = strstr($request['filedata'], ',');
        $ParArray = array("filedata" => $filedata, "pid" => "6");
        //$ParArray = json_encode($ParArray);
        $resp = $this->https_post($url, $ParArray);
        $obj = json_decode($resp, true);
        if ($obj['ErrorCode'] == 0) {
            return response()->json(['code' => 200, 'msg' => '识别成功', 'data' => $obj]);
        } else {
            return response()->json(['code' => 500, 'msg' => '识别失败', 'data' => '']);
        }
    }

    function https_post($url, $data)
    {
        //$curl = curl_init();
        //curl_setopt($curl, CURLOPT_URL, $url);
        //curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        //curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        //curl_setopt($curl, CURLOPT_POST, 1);
        //curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        //curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        //$output = curl_exec($curl);
        //curl_close($curl);
        //return $output;
        $postdata = http_build_query($data);
        $options = array('http' => array('method' => 'POST', 'header' => 'Content-type:application/x-www-form-urlencoded', 'content' => $postdata, 'timeout' => 15 * 60));
        $context = stream_context_create($options);
        $result = file_get_contents($url, false, $context);
        return $result;
    }

    // 详情
    public function BusOrderinfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'business');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::BusOrderinfo($user_info, $request->all());
        return response()->json($return_data);
    }

    // 取消订单
    public function cancel(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        // 取消订单
        $return_data = WashOrderService::cancel($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        //取消应收应付
        $find_rece = DB::table('receivable_pay')
            ->where('recpay_original_id', $request['ord_id'])
            ->first();
        if($find_rece){
            $update_qrres = DB::table('receivable_pay')
                ->where('recpay_original_id', $request['ord_id'])
                ->update(['recpay_order_state'=>3]);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, $request['ord_id'], 0, '取消订单');
        if ($request['remark']) {
            // 添加备注
            $orre_res = orderRemark($user_info, $request['ord_id'], '', $request['remark'], '订单列表');
        } else {
            $orre_res = true;
        }
        if ($orlo_res && $orre_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '取消订单', '取消订单' . $return_data['data']['ord_order_number'] . '成功');
            return $this->success('取消订单成功');
        } else {
            DB::rollBack();
            return $this->error('取消订单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 备注
    public function remark(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->remarkValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::remarkSearch($user_info, $request->all());
        $orre_res = orderRemark($user_info, $request['ord_id'], $return_data['wor_id'], $request['remark'], '订单列表');
        if ($orre_res) {
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '备注', '订单 ' . $return_data['ord_order_number'] . ' 添加备注 :' . $request['remark']);
            return $this->success('备注成功');
        } else {
            return $this->error('备注失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 预约设置
    public function appointmentSet(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->appointmentSetValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'appointmentSet';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        DB::beginTransaction();
        $return_data = $this->dataService->appointmentSet($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '预约设置', '预约设置：' . $return_data['data']['ord_order_number'] . '成功');
            return $this->success('预约设置成功');
        }
    }

    // 转售后
    public function afterSale(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = $this->dataService->afterSale($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '申请售后', '申请售后：' . $return_data['data']['afsl_after_number'] . '成功');
            return $this->success('申请售后成功');
        }
    }

    // 订单作品-新增
    public function addOrderWorks(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addOrderWorksValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = $this->dataService->addOrderWorks($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '添加作品', '添加作品成功');
            return $this->success('添加作品成功');
        }
    }

    // 订单作品-列表
    public function OrderWorksindex(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->OrderWorksindexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'business');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $return_data = $this->dataService->OrderWorksindex($user_info, $request->all());
        if (empty($return_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $return_data]);
        }
    }

    // 订单作品-详情
    public function OrderWorksinfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->OrderWorksinfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'business');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $return_data = $this->dataService->OrderWorksinfo($user_info, $request->all());
        if (empty($return_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $return_data]);
        }
    }

    // 订单作品-编辑
    public function OrderWorksedit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->OrderWorksinfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $return_data = $this->dataService->OrderWorksinfo($user_info, $request->all());
            if (empty($return_data)) {
                return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
            } else {
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $return_data]);
            }
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->OrderWorkseditValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $return_data = $this->dataService->OrderWorksedit($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '编辑作品', '编辑作品成功');
            return $this->success('编辑作品成功');
        }
    }

    // 订单作品-删除
    public function OrderWorksdel(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->OrderWorksdelValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $return_data = $this->dataService->OrderWorksdel($user_info, $request->all());
        if ($return_data) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '删除作品', '删除作品成功');
            return $this->success('删除作品成功');
        }
    }

    // 订单审核
    public function auditOrder(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->auditOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'auditOrder';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('orit_service_price', $request['ord_actual_price']);
        $return_data = $this->dataService->auditOrder($user_info, $request->all());
        if ($return_data['code'] == 500) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '修改价格', '修改价格成功');
            return response()->json($return_data);
        }
    }

    // 根据车牌查询会员信息
    public function getMembershipByLicensePlate(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getMembershipByLicensePlateValidator($request->all());
        if (!empty($error_message)) {
            return response()->json(['code' => 500, 'msg' => $error_message->first(), 'data' => $error_message]);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();

        // 根据车牌查会员
        $member_data = DB::table('member')
            ->where('mem_shop_id', $user_info->adm_shop_id)
            ->where('mem_car_num', $request['licence_plate'])
            ->select('mem_id', 'mem_name', 'mem_phone', 'mem_car_series', 'mem_car_model', 'mem_car_num')
            ->first();
        $vip_data = [];
        if ($member_data && !empty($request['myvi_sepr_id'])) {
            // 查询会员卡信息
            $now_time = date('Y-m-d H:i:s');
            $vip_data = DB::table('myvip')
                ->where('myvi_adm_id', $member_data->mem_id)
                ->where('myvi_sepr_id', $request['myvi_sepr_id'])
                ->where('myvi_state', 1)
                ->where('myvi_end_time', '>', $now_time)
                ->select('myvi_id', 'myvi_end_time', 'myvi_long_term', 'myvi_sepr_id', 'myvi_sepr_name', 'myvi_surplus_times')
                ->get()->toArray();
        }
        $return_data['member_data'] = $member_data;
        $return_data['vip_data'] = $vip_data;
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $return_data]);
    }

    // 工作台-搜索会员-车辆信息
    public function searchMember(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();
        $shop_id = $user_info->adm_shop_id;
        $post['string'] = 'meml_';
        $post['user_info'] = $user_info;
        $post['shop_id'] = $shop_id;
        $type = 1;
        $where_data = whereFunction($post,$type);
        $level_data = DB::table('member_level')
            ->whereIn($where_data['string'], $where_data['shop_id'])
            ->where('meml_show', 2)
            ->get()->toArray();
        if($level_data){
            foreach ($level_data as $lkey => $lvalue){
                $meml_discount[$lvalue->meml_level] = $lvalue->meml_discount;
            }
        }
        $search_data = $request->all();
        $post['string'] = 'mem_';
        $type = 1;
        $where_data = whereFunction($post,$type);
        $params['mem_cid'] = $user_info->adm_cid;
        $params[$where_data['string']."_searchin"] = $where_data['shop_id'];
        $params['mem_state'] = 1;
        if (!empty($search_data['search_data'])) {
            $search_data_searchor['mem_name_like'] = $search_data['search_data'];
            $search_data_searchor['mem_phone_like'] = $search_data['search_data'];
            $search_data_searchor['meca_car_num_like'] = $search_data['search_data'];
            $params['search_data_searchor'] = $search_data_searchor;
        }
        if (!empty($search_data['mem_id'])) {
            $params['mem_id'] = $search_data['mem_id'];
        }
        $where = CommonService::jointWhere($params);
        $list_data = DB::table('member as m')
            ->leftJoin('user_shop as ussh', 'ussh.ussh_user_id', '=', 'm.mem_id')
            ->leftJoin('weixin_user as wx', 'ussh.ussh_weus_id', '=', 'wx.weus_id')
            ->leftJoin('member_car as mc', 'mc.meca_mem_id', '=', 'm.mem_id')
            ->whereRaw($where)
            ->select('mem_id', 'mem_name', 'mem_phone', 'mem_province', 'mem_city', 'mem_county', 'mem_address', 'mem_bership', 'mem_car_series', 'mem_source', 'weus_headimgurl', 'mem_sex', 'mem_car_color', 'mem_rec_banlance', 'mem_gift_banlance', 'meca_car_num', 'mem_level','mem_initial')
            ->groupBy('mem_id');
            if(empty($search_data['page'])){
                $list = $list_data
                    ->get()->toArray();
            }else {
                $list_data = $list_data->orderBy('mem_initial', 'asc')
                    ->paginate(10);
                $list = $list_data->items();
            }
        $mem_id = array_column($list, 'mem_id');
        if ($mem_id) {
            foreach ($list as $key => $value) {
                $list[$key]->mem_car_num = $value->meca_car_num;
                if(empty($search_data['page'])){
                    $rest = mb_substr($value->mem_name, 0, 1, 'utf-8');
                    if ($rest) {
                        $mb = mb_strlen($rest, 'utf-8');
                        $st = strlen($rest);
                        if ($st == $mb) { //英文
                            $list[$key]->firstLetter = strtoupper($rest);
                        } else { //汉字
                            $list[$key]->firstLetter = substr(strtoupper(Pinyin::abbr($value->mem_name)), 0, 1);
                        }
                    } else {
                        $list[$key]->firstLetter = '';
                    }
                }else {
                    $list[$key]->firstLetter = $value->mem_initial;
                }
//
                //折扣
                $list[$key]->discount = '';
                if(isset($meml_discount[$value->mem_level])){
                    $list[$key]->discount = intval($meml_discount[$value->mem_level]) / 10;
                }
            }
        }
        if(empty($search_data['page'])){
            $data = $list;
        }else {
            $data['list'] = $list;
            $data['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['total'] = $list_data->total();               //总数据个数
        }
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
    }

    // 工作台-搜索企业客户-账户
    public function searchBusinessacc(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();
        if ($user_info->shop_superior_id) {
            // 总店id
            $shop_id = $user_info->shop_superior_id;
        } else {
            $shop_id = $user_info->adm_shop_id;
        }

        $search_data = $request->all();
        $params['bucl_cid'] = $user_info->adm_cid;
        $params['bucl_shop_id'] = $shop_id;
        $params['buac_del'] = 1;
        $params['bucl_del'] = 1;
        $params['bucl_state'] = 1;
        if (!empty($search_data['search_data'])) {
            $search_data_searchor['bucl_name_like'] = $search_data['search_data'];
            $search_data_searchor['buac_name_like'] = $search_data['search_data'];
            $search_data_searchor['buac_phone_like'] = $search_data['search_data'];
            $params['search_data_searchor'] = $search_data_searchor;
        }
        if (!empty($search_data['bucl_id'])) {
            $params['bucl_id'] = $search_data['bucl_id'];
        }
        if (!empty($search_data['buac_id'])) {
            $params['buac_id'] = $search_data['buac_id'];
        }
        $where = CommonService::jointWhere($params);
        $list_data = DB::table('business_client as bucl')
            ->leftjoin('business_account as buac', 'buac.buac_bucl_id', '=', 'bucl_id')
            ->whereRaw($where)
            ->select('buac_id', 'buac_name', 'buac_phone', 'bucl_name', 'bucl_id', 'bucl_rec_banlance', 'bucl_gift_banlance');
        if(empty($search_data['page'])){
            $list = $list_data
                ->get()->toArray();
        }else{
            $list_data = $list_data
                ->paginate(100000);
            $list = $list_data->items();
        }

        if ($list) {
            foreach ($list as $key => $value) {
                $rest = mb_substr($value->buac_name, 0, 1, 'utf-8');
                if ($rest) {
                    $mb = mb_strlen($rest, 'utf-8');
                    $st = strlen($rest);
                    if ($st == $mb) { //英文 转成大写
                        $list[$key]->firstLetter = strtoupper($rest);
                    } else { //汉字
                        $list[$key]->firstLetter = substr(strtoupper(Pinyin::abbr($value->buac_name)), 0, 1);
                    }
                } else {
                    $list[$key]->firstLetter = '';
                }
            }
        }
        if(empty($search_data['page'])){
            $data = $list;
        }else {
            $data['list'] = $list;
            $data['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['total'] = $list_data->total();               //总数据个数
        }      //总数据个数
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
    }

    // 搜索勾选过的仓库 以及该总店下所有的移动仓
    public function searchAllWarehouse(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 获取到该账号下勾选的仓库id
        $ware_id = DB::table('admin_set')
            ->where('adms_adm_id', $user_info->adm_id)
            ->where('adms_shop_id', $user_info->adm_shop_id)
            ->value('adms_ware_id');
        if (empty($ware_id)) {
            $ware_id = [];
        } else {
            $ware_id = explode(',', $ware_id);
        }
        $search_data = $request->all();

        if ($request['ware_type'] == 1) {
            // 只搜索被设置的固定仓
            $data = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_superior_shop_id', $shop_id)
                ->whereIn('ware_id', $ware_id)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['search_data'])) {
                        $query->where('ware_name', 'like', '%' . $search_data['search_data'] . '%');
                    }
                })
                ->get(['ware_id', 'ware_default', 'ware_name']);
        } else {
            // 搜索被设置的固定仓、移动仓,搜索启用的仓库
            $data = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_superior_shop_id', $shop_id)
                ->where('ware_state', 1)
                ->where('ware_type', '<>', 2)
                ->whereIn('ware_id', $ware_id)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['search_data'])) {
                        $query->where('ware_name', 'like', '%' . $search_data['search_data'] . '%');
                    }
                })
                ->get(['ware_id', 'ware_default', 'ware_name']);
        }

        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
    }

    // 获取商品库存信息
    public function getGoodsStock(Request $request)
    {
        if (!isset($request['pri_id'])) {
            request()->offsetSet('pri_id', 17);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->searchGoodsValidator($request->all());
        if (!empty($error_message)) {
            $error_message = $error_message->all();
            return $this->error($error_message[0], ErrorInc::INVALID_PARAM, $error_message);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 判断是否选择仓库
        if (empty($request['ware_id'])) {
            // 没有选择仓库，查询所有商品
            $return_data = WashOrderBasicService::getGoods($user_info, $request->all(), $this->show_count);
            if (isset($request['add_num']) && $request['add_num'] == 1) {
                $find_most = DB::table('moudle_statistics')
                    ->where('most_shop_id', $user_info->adm_shop_id)
                    ->where('most_adm_id', $user_info->adm_id)
                    ->where('most_moudle_id', 2)
                    ->first();
                $update_data['most_nums'] = $find_most->most_nums + 1;
                $update_data['most_update_time'] = date('Y-m-d H:i:s');
                if ($update_data['most_nums'] >= 3) {
                    $update_data['most_remind'] = 2;
                }
                $update_res = DB::table('moudle_statistics')
                    ->where('most_id', $find_most->most_id)
                    ->update($update_data);
            }
            return response()->json($return_data);
        }
        
        // 判断是否传仓库id
        if ($request['ware_id']) {
            $ware_id[] = $request['ware_id'];
        } else {
            // 获取到该账号下勾选的服务门店id
            $ware_id = DB::table('admin_set')
                ->where('adms_adm_id', $user_info->adm_id)
                ->where('adms_shop_id', $user_info->adm_shop_id)
                ->value('adms_ware_id');
            if (empty($ware_id)) {
                $ware_id = [];
            } else {
                $ware_id = explode(',', $ware_id);
            }
        }

        $shop_state = true;
        if (in_array($shop_id, config('apisystem.NO_SHOPID'))) {
            $shop_state = false;
        }
        $post['string'] = 'goo_';
        $post['user_info'] = $user_info;
        $type = 3;
        $where_data = whereFunction($post,$type);
        $search_data = $request->all();
        $list_data = DB::table('goods as g')
            ->join('warehouse_goods as wg', 'wg.wago_goo_id', '=', 'g.goo_id')
            ->join('warehouse as w', 'w.ware_id', '=', 'wg.wago_ware_id')
            ->leftJoin('brand_serie as brse', 'brse.brse_id', '=', 'g.goo_brse_id')
            ->where(function ($query) use ($user_info, $shop_state) {
                if ($shop_state) {
                    $query->where('goo_cid', 0)
                        ->orwhere('goo_cid', $user_info->adm_cid);
                } else {
                    $query->where('goo_cid', $user_info->adm_cid);
                }
            })
            ->where(function ($query) use ($user_info, $where_data) {
                // if ($shop_state) {
                //     $query->where('goo_shop_id', 0)
                //         ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                // } else {
                // }
                $query->whereIn($where_data['string'], $where_data['shop_id']);
            })
            ->where('wago_stock_number', '>', 0)
            ->where('goo_state', 1)
            ->where('ware_state', 1)
            ->whereIn('wago_ware_id', $ware_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['goo_name'] . '%')
                        ->orwhere('goo_goods_encode', 'like', '%' . $search_data['goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['waon_class'])) {
                    $query->where('wago_class', $search_data['waon_class']);
                }
            }) //仓库类别
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_type'])) {
                    $query->where('goo_type', $search_data['goo_type']);
                } else {
                    $query->where('goo_type', 1);
                }
            }) //商品类型
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            }) //品牌
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            }) //品类
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_brse_id'])) {
                    $query->where('goo_brse_id', $search_data['goo_brse_id']);
                }
            }) //品牌系列id
            ->select('goo_class', 'goo_id', 'goo_name', 'goo_type', 'goo_goods_encode', 'goo_wholesale_price as goo_price', 'goo_ampere_hour', 'goo_brse_id', 'goo_bra_name', 'goo_unta_id', 'goo_unit', 'goo_unit_conversion', 'goo_cate_name', 'brse_name', 'wago_id', 'goo_pic', 'wago_stock_number', 'goo_level', 'goo_fid')
            ->orderBy('goo_goods_encode', 'asc')
            ->groupBy('goo_id')
            ->paginate($this->show_count);
        // dump($list_data);die;
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $goods_data = $list_data->items();
        $data_info['goods_data'] = $goods_data;
        if ($data_info['goods_data']) {
            $goo_id = array_column($goods_data, 'goo_id');
            // 查询客户单位设置的商品价格
            $channel_goo_data = DB::table('channel_unit_goods_correlation')
                ->where('cugc_shop_id', $shop_id)
                ->where('cugc_chun_id', $request['chun_id'])
                ->whereIn('cugc_goo_id', $goo_id)
                ->pluck('cugc_set_goo_price', 'cugc_goo_id')
                ->toArray();


            foreach ($goods_data as $k => $v) {
                $goods_data[$k]->new_goo_unit = $v->goo_unit;
                if (empty($v->goo_pic)) {
                   $goods_data[$k]->goo_pic = config('apisystem.server_name_https').'/image/artificerImg/default_goo_img.png';
                }
                if ($v->goo_level == 1 || ($v->goo_level ==2 && $v->goo_fid)) {
                    $goods_data[$k]->goo_change = 1;
                } else {
                    $goods_data[$k]->goo_change = 2;
                }
            }

            // 判断是否传仓库id
            if ($request['ware_id']) {
                $ware_id[] = $request['ware_id'];
            } else {
                // 获取到该账号下勾选的服务门店id
                $ware_id = DB::table('admin_set')
                    ->where('adms_adm_id', $user_info->adm_id)
                    ->where('adms_shop_id', $user_info->adm_shop_id)
                    ->value('adms_ware_id');
                if (empty($ware_id)) {
                    $ware_id = [];
                } else {
                    $ware_id = explode(',', $ware_id);
                }
            }
        } else {
            $data_info['stock_data'] = '';
        }
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        $pri_operate_method = array_column($list_button, 'pri_operate_method');
        if (!empty($list_button)) {
            foreach ($list_button as $key => $value) {
                if ($value['pri_operate_method'] == 'addGoods' && $value['have_pri'] == 1) {
                    $data_info['addGoods'] = true;
                    break;
                } else {
                    $data_info['addGoods'] = false;
                }
            }
        } else {
            $data_info['addGoods'] = false;
        }
        if (!empty($goods_data)) {
            foreach ($goods_data as $key => $value) {
                $buttonData = [];
                foreach ($list_button as $k => $v) {
                    if ($v['pri_operate_method'] == 'goToOrder' && $v['have_pri'] == 1) {
                        $buttonData[] = 'goToOrder';
                    }
                    if ($v['pri_operate_method'] == 'stock' && $v['have_pri'] == 1) {
                        $buttonData[] = 'stock';
                    }
                }
                $button = CommonService::getAppletListButton($buttonData,$list_button);
                $goods_data[$key]->button_one = $button['button_one']??[];
                $goods_data[$key]->button_two = $button['button_two']??[];
                $goods_data[$key]->button_three = $button['button_three']??[];
            }
            $data_info['goods_data'] = $goods_data;
            if (isset($request['add_num']) && $request['add_num'] == 1) {
                $find_most = DB::table('moudle_statistics')
                    ->where('most_shop_id', $user_info->adm_shop_id)
                    ->where('most_adm_id', $user_info->adm_id)
                    ->where('most_moudle_id', 2)
                    ->first();
                $update_data['most_nums'] = $find_most->most_nums + 1;
                $update_data['most_update_time'] = date('Y-m-d H:i:s');
                if ($update_data['most_nums'] >= 3) {
                    $update_data['most_remind'] = 2;
                }
                $update_res = DB::table('moudle_statistics')
                    ->where('most_id', $find_most->most_id)
                    ->update($update_data);
            }
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code' => 200, 'msg' => '暂无数据', 'data' => $data_info, 'list_button'=>$list_button]);
        }
    }

    // 获取商品库存信息
    public function getGoodsStockInfo(Request $request)
    {
        if (!isset($request['pri_id'])) {
            request()->offsetSet('pri_id', 17);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->getGoodsStockInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $return_data = WashOrderBasicService::getGoodsInfo($user_info, $request->all(), $this->show_count);

        return response()->json($return_data);
    }

    // 获取品类数据
    public function getCategory(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();

        $select_field = "cate_id, cate_name";
        $public_search = new PublicSearch;
        $list_data = $public_search->searchCategory($user_info, $request->all(), $select_field);
        return response()->json(['code' => 200, 'msg' => 'success', 'data_info' => $list_data['data_info']]);
    }

    // 获取品牌数据
    public function getBrand(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();

        $select_field = "bra_id, bra_name";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchBrand($user_info, $request->all(), $select_field);
        return response()->json(['code' => 200, 'msg' => 'success', 'data_info' => $list_data['data_info']]);
    }

    // 获取品牌系列数据
    public function getBrandSerie(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();

        $select_field = "brse_id, brse_name";

        $public_search = new PublicSearch;
        $list_data = $public_search->searchBrandSerie($user_info, $request->all(), $select_field);
        return response()->json(['code' => 200, 'msg' => 'success', 'data_info' => $list_data['data_info']]);
    }

    // 生成订单的唯一标识
    public function searchUniqueString(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();

        // 获取唯一字符串标识
        $ord_unique_string = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        $data = ['ord_unique_string' => $ord_unique_string];
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
    }

    // 合作商订单列表
    public function BusOrder(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'BusOrder';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'business');
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->BusOrder($user_info, $request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $search_data]);
        }
    }

    // 客户取消订单
    public function buscancel(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->buscancelValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'buscancel';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'business'); //微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        // 取消订单
        $return_data = WashOrderService::cancel($user_info, $request->all());
        if ($return_data['code'] == 200) {
            DB::commit();
            return $this->success('取消订单成功');
        } else {
            DB::rollBack();
            return $this->error('取消订单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 验车结果
    public function validateCarData(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoBusValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'validateCarData';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'business'); //微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::validateCarData($user_info, $request->all());
        return response()->json($return_data);
    }

    // 签字图片提交
    public function signatureSubmit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->busSignatureSubmitValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'signatureSubmit';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'business'); //微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $return_data = WashOrderService::signatureSubmit($user_info, $request->all());
        if ($return_data['code'] == 200) {
            DB::commit();
            // OperationLog::addLog($user_info, getRealIp($request), '订单列表', '客户签字', '客户签字成功');
            return $this->success('客户签字成功');
        } else {
            DB::rollBack();
            return response()->json($return_data);
        }
    }

    // 预约单列表
    public function busreindex(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->busreindexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'busreindex';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'business'); //微信用户信息
        request()->offsetSet('reli_client_type', 2); //买家类型1会员零售

        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->busreindex((object) $user_info, $request->all(), 10);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $search_data]);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::info($user_info, $request->all());
        $info = $return_data['data']['order_data'];
        // 查询备注信息
        $order_reamrks = DB::table('order_remarks')
            ->where('orre_ord_id', $request['ord_id'])
            ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_ord_id', 'orre_module')
            ->orderby('orre_id', 'desc')
            ->get();
        $return_data['data']['order_reamrks'] = $order_reamrks;
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        $pri_operate_method = array_column($list_button, 'pri_operate_method');
        $buttonData = [];
        $buttonData[] = 'orderExplain';
        $work_order = DB::table('work_order')
            ->where('wor_order_id',$request['ord_id'])
            ->select('wor_state','wor_id')
            ->first();
        $work_order = CommonService::dataToArray($work_order);
        if(in_array($info->ord_state, [1]) && (!$work_order || $work_order['wor_state']<=5) && in_array($info->ord_type, [0,1]) && $info->orcl_sales_adm_id == $user_info->adm_id){
            $buttonData[] = 'editOrderMember';
        }
        if(in_array($info->ord_wor_state, [1]) || ($info->ord_service_type == 2 && in_array($info->ord_wor_state, [1,2]) )){
            $buttonData[] = 'cancel';
        }
        if (in_array($info->ord_wor_state, [1]) && $info->ord_service_type == 2) {
            $buttonData[] = 'receiveOrder';
        }

        if($info->ord_state != 2 && $info->ord_source != 5 && $info->ord_wor_state != 11) {
            $buttonData[] = 'settlement';
        }
        //换货
        if(in_array($info->ord_wor_state, [7,1,2]) && !in_array($info->ord_payment_way, [10,11,12]) ){
            $buttonData[] = 'exchangeGoods';
        }
        if(!in_array('orderPhone', $pri_operate_method) && $info->ord_wor_state != 7){
            $info->orcl_phone = substr($info->orcl_phone,0,3).'****'.substr($info->orcl_phone,-4);
            $info->orcl_name = mb_substr($info->orcl_name,0,1,'utf-8').str_repeat("*",(strlen($info->orcl_name)/3-1));
        }
        if ($info->ord_wor_state != 11 && $info->ord_source != 5) {
            $buttonData[] = 'uploadOrdPic';
        }
        //--------------全部退货不显示退货按钮，不是全部，显示--start----------
        $goods_data = $return_data['data']['goods_data'];
        if($goods_data){
            foreach ($goods_data as $good_key => $good_value){
                //订单商品是否已经全部退货
               $all_order_return[$good_value->orgo_ord_id] = false;//默认不可以退货
                 if($good_value->orgo_goo_type == 1){//商品类型 1商品2服务3套餐商品4会员卡5充值卡
                    $all_return_goods[$good_value->orgo_ord_id][$good_value->orgo_goo_id] = $good_value->orgo_goo_quantitys - $good_value->orgo_goo_return_quantity;//订单商品数量 - 退货数量
                }
            }
        }
        if(isset($all_return_goods)){
            foreach ($all_return_goods as $re_key => $re_value) {
                foreach ($re_value as $r_key => $r_value){
                    if($r_value > 0){
                        $all_order_return[$re_key] = true;//还有商品，可以退货
                    }
                }
            }
        }
        //--------------全部退货不显示退货按钮，不是全部，显示-end-----------
        $tuihuo = false;
        //已结算或者已经发货
        $wor_number = DB::table('work_order')
            ->where('wor_order_id', $info->ord_id)
            ->value('wor_number');
        $dispatch_data = 1;//类型：1未出库2已出库
        if($wor_number){
            $dispatch_data = DB::table('dispatch_bill')
                ->where('dego_cid', $user_info->adm_cid)
                ->where('dego_superior_shop_id', $user_info->adm_shop_id)
                ->where('dego_type', '<>', 3)
                ->where('dego_original_number', $wor_number)
                ->value('dego_type');
        }else{
            $dispatch_data = DB::table('dispatch_bill')
                ->where('dego_cid', $user_info->adm_cid)
                ->where('dego_superior_shop_id', $user_info->adm_shop_id)
                ->where('dego_type', '<>', 3)
                ->where('dego_original_number', $info->ord_order_number)
                ->value('dego_type');
        }
        //有未处理退货不能申请
        $return_status = true;
        $refund_statuss = true;
        $is_return_good = true;//默认没有申请退货，true 展示取消按钮
        $return_good_status = DB::table('return_goods')
            ->where('retgo_order_number', $info->ord_order_number)
            ->where('retgo_status', 1)
            ->orderBy('retgo_id','desc')
            ->value('retgo_return_status');//退货进度：1未回收2部分回收3已回收4供货商回收
        if($return_good_status){
            if(in_array($return_good_status, [0,3,4])){
                $return_status = true;
            }else{
                $return_status = false;
                $is_return_good = false;//有退货未完成，false 不展示取消按钮
            }
        }
        $refund_status = DB::table('refund')
            ->where('ref_order_number', $info->ord_order_number)
            ->where('ref_cancel', 1)
            ->orderBy('ref_id','desc')
            ->value('ref_status');//状态：1待审核2通过3驳回
        if($refund_status){
            if(in_array($refund_status, [2,3])){
                $refund_statuss = true;
            }else{
                $refund_statuss = false;
                $is_return_good = false;//有退款未完成，false 不展示取消按钮
            }
        }
        if($dispatch_data == 2 && $return_status && $refund_statuss && isset($all_order_return[$info->ord_id]) && $all_order_return[$info->ord_id]){//已发货，退货退款都处理完成，就可以申请退款
            $tuihuo = true;
        }
        if(isset($wor_number) && $info->ord_wor_state >= 20){
            $tuihuo = false;
        }
        if($tuihuo && $info->ord_add_type == 1 && $info->ord_payment_way != 5){
            $buttonData[] = 'add';
        }
        $buttonData[] = 'addRemark';
        $button = CommonService::getAppletListButton($buttonData,$list_button);
        $info->button_one = $button['button_one']??[];
        $info->button_two = $button['button_two']??[];
        $info->button_three = $button['button_three']??[];
        return response()->json($return_data);
    }

    // 预约单详情
    public function busreinfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->busreinfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'reinfo';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        request()->offsetSet('rt', 'business'); //微信用户信息
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::reinfo($user_info, $request->all());
        return response()->json($return_data);
    }

    // 撤回
    public function withdraw(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->withdrawValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'withdraw';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        // 获取用户信息
        // $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        // 取消预约单
        $return_data = ReservationService::withdraw($request->all(), 4);
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        } else {
            DB::commit();
            return $this->success('撤回成功');
        }
    }

    // 新增会员
    public function addMember(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addMemberValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addMember';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = WashOrderService::addMember($user_info, $request->all());

        if ($res['code'] == 200) {
            DB::commit();
            return response()->json(["code" => 200, 'msg' => '新增会员成功', 'data' => '新增会员成功', 'return_data' => $res['return_data']]);
        } else {
            DB::rollBack();
            return response()->json($res);
        }
    }

    // 新增企业会员
    public function addBusinessAcc(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addBusinessAccValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addBusinessAcc';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = WashOrderService::addBusinessAcc($user_info, $request->all());

        if ($res['code'] == 200) {
            DB::commit();
            return response()->json(["code" => 200, 'msg' => '新增企业会员成功', 'data' => '新增企业会员成功', 'return_data' => $res['return_data']]);
        } else {
            DB::rollBack();
            return response()->json($res);
        }
    }

    // 洗车流程订单
    public function addWashCarOrder(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addWashCarOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addWashCarOrder';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('ord_service_type', 2);
        request()->offsetSet('orcl_shipment_party', 1);
        request()->offsetSet('ip', getRealIp($request));

        DB::beginTransaction();
        $request['client_ip'] = getRealIp($request);
        $request['ord_unique_string'] = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        $order_data = WashOrderService::addWashCarOrder($user_info, $request->all());
        // $order_data = WashOrderBasicService::add($user_info, $request->all());
        if ($order_data['code'] == 200) {
            DB::commit();
            return $this->success('生成订单成功');
        } else {
            DB::rollBack();
            return response()->json($order_data);
            return $this->error('生成订单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 识别会员卡二维码
    public function scan(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->scanValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'scan';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $res = WashOrderService::scan($user_info, $request->all());
        return response()->json($res);
    }

    // 查询可用会员卡
    public function getmyVip(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getmyVipValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getmyVip';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $res = WashOrderService::getmyVip($user_info, $request->all());
        return response()->json($res);
    }

    // 洗车-领取订单
    public function receiveOrder(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->receiveOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'receiveOrder';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = WashOrderService::receiveOrder($user_info, $request->all());
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    // 订单数据统计
    public function orderCount(Request $request)
    {
        // // 验证参数
        // $error_message = $this->dataService->mainValidator->orderCountValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        // }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'orderCount';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $res = WashOrderService::orderCount($user_info, $request->all());
        if (isset($request['add_num']) && $request['add_num'] == 1) {
            $find_most = DB::table('moudle_statistics')
                ->where('most_shop_id', $user_info->adm_shop_id)
                ->where('most_adm_id', $user_info->adm_id)
                ->where('most_moudle_id', 5)
                ->first();
            $update_data['most_nums'] = $find_most->most_nums + 1;
            $update_data['most_update_time'] = date('Y-m-d H:i:s');
            if ($update_data['most_nums'] >= 3) {
                $update_data['most_remind'] = 2;
            }
            $update_res = DB::table('moudle_statistics')
                ->where('most_id', $find_most->most_id)
                ->update($update_data);
        }
        return response()->json($res);
    }

    // 查询订单信息-开单使用
    public function getOrder(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getOrder';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $res = WashOrderService::getOrder($user_info, $request->all());
        return response()->json($res);
    }

    // 上传订单凭证
    public function uploadOrdPic(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->uploadOrdPicValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getOrder';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = WashOrderService::uploadOrdPic($user_info, $request->all());
        $find_order = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_order_number')
            ->first();
        $log_data = [
            'oplo_module'=>'订单列表',
            'oplo_action'=>'上传凭证',
            'oplo_content'=>'上传凭证',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>$find_order->ord_order_number,
            'work_number'=>'',
            'data_source'=>2,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 订单结算
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-14
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function settlement(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->appletSettlementValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'settlement';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $res = WashOrderService::settlement($user_info, $request->all());
        $find_order = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_order_number')
            ->first();
        $log_data = [
            'oplo_module'=>'订单结算',
            'oplo_action'=>'结算',
            'oplo_content'=>'技师结算',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>$find_order->ord_order_number,
            'work_number'=>'',
            'data_source'=>2,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 获取结算方式
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-18
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getPaymentWay(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        $return_data = WashOrderService::getPaymentWayName(false);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    /**
     * 换货
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|mixed
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public function exchangeGoods(Request $request) {
        $error_message = $this->dataService->mainValidator->exchangeGoods($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $user_info = LoginUserService::getUser();
        $returnData = $this->dataService->exchangeGoods($request->all());
        if($returnData['code'] == 200) {
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '换货', '换货' . $request['ord_order_number'] . '成功');
        }
        return response()->json($returnData);
    }

    /**
     * 获取退款方式
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     *
     * @author huangyongqi
     *
     * @since 2023-10-25
     */
    public function getRefundWay()
    {
        $returnData = $this->dataService->getRefundWay();
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $returnData]);
    }

    /**
     * 换货获取付款方式
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     *
     * @author huangyongqi
     *
     * @since 2023-10-25
     */
    public function getPayWay()
    {
        $returnData = $this->dataService->getPayWay();
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $returnData]);
    }


    /**
     * 新增商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-02-21
     * @param  Request          $request [description]
     */
    public function addGoods(Request $request) {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addGoods';
        logFileRecord($log_record, 'wash/WashOrder', 2);

        // 商品属性
        if (!empty($request['info_name'])) {
            // 处理商品属性数组数据
            foreach ($request['info_name'] as $key => $value) {
                if (empty($value) || empty($request['info_content'][$key])) {
                    return response()->json(['code' => 500, 'msg' => '信息项存在空项', 'data' => '信息项存在空项']);
                }
                $goo_attribute[$key]['key'] = $value; //名称
                $goo_attribute[$key]['value'] = $request['info_content'][$key]; //内容
            }
            $goo_add_data['goo_attribute'] = json_encode($goo_attribute);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 1. 判断商品名称是否存在
        $find_goo = DB::table('goods')
            ->where('goo_delete', 1)
            ->where(function ($query) use ($user_info) {
                $query->where('goo_shop_id', $user_info->adm_shop_id);
            })
            ->where('goo_name', $request['goo_name'])
            ->select('goo_id')
            ->first();
        if ($find_goo) {
            return response()->json(['code' => 500, 'msg' => '商品名称已存在', 'data' => '商品名称已存在']);
        }

        // 判断检索编码是否存在
        if (!empty($request['goo_goods_encode'])) {
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_goods_encode', $request['goo_goods_encode'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return response()->json(['code' => 500, 'msg' => '检索编码已存在', 'data' => '检索编码已存在']);
            }
        }

        // 判断商品编号是否存在
        if (!empty($request['goo_goods_code'])) {
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_goods_code', $request['goo_goods_code'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return response()->json(['code' => 500, 'msg' => '商品编号已存在', 'data' => '商品编号已存在']);
            }
        }

        DB::beginTransaction();
        // 2 新增一个商品数据
        $goo_add_data['goo_cid'] = $user_info->adm_cid;
        $goo_add_data['goo_shop_id'] = $user_info->adm_shop_id;
        $goo_add_data['goo_superior_shop_id'] = $user_info->shop_superior_id;
        $goo_add_data['goo_name'] = $request['goo_name'];   //商品名称
        $goo_add_data['goo_type'] = $request['goo_type'];   //1正常商品2赠品商品3活动商品4旧货商品5无库存商品
        $goo_add_data['goo_goods_code'] = $request['goo_goods_code'] ? $request['goo_goods_code'] : '';   //商品编号
        $goo_add_data['goo_goods_encode'] = $request['goo_goods_encode'] ? $request['goo_goods_encode'] : '';   //检索编码
        $goo_add_data['goo_cate_id'] = $request['goo_cate_id']; //所属品类id
        $goo_add_data['goo_cate_name'] = $request['goo_cate_name']; //品类名称
        $goo_add_data['goo_price'] = $request['goo_price'] * 100;   //商品零售价格
        $goo_add_data['goo_wholesale_price'] = $request['goo_wholesale_price'] * 100;   //批发价
        $goo_add_data['goo_purchase_price'] = $request['goo_purchase_price'] * 100; //采购价
        $goo_add_data['goo_assign_state'] = $request->input('goo_assign_state', 1); //商品派单状态：1不允许派单2允许派单
        $goo_add_data['goo_system_code'] = str_pad($user_info->adm_cid, '4', '0', STR_PAD_RIGHT) . str_pad($user_info->adm_shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
        $goo_add_data['goo_unta_id'] = $request['goo_unta_id']; //商品单位id
        if ($request['goo_unta_id'] == 1) {
            if (empty($request['goo_unit_conversion'])) {
                return response()->json(['code' => 500, 'msg' => '请输入每卷长度', 'data' => '请输入每卷长度']);
            }
            $goo_add_data['goo_unit_conversion'] = isset($request['goo_unit_conversion']) ? $request['goo_unit_conversion'] : ''; //商品单位换算每卷多少米
        }
        $goo_add_data['goo_unit'] = $request['goo_unit']; //商品单位名称
        $goo_add_data['goo_commodity_propert'] = $request['goo_commodity_propert']; //商品属性：1成品2原材料
        // 判断是否选择商品品牌
        if ($request['goo_bra_id']) {
            $goo_add_data['goo_bra_id'] = $request['goo_bra_id'];
            $goo_add_data['goo_bra_name'] = $request['goo_bra_name'];
        }
        // 判断是否选择品牌系列
        if ($request['goo_brse_id']) {
            $goo_add_data['goo_brse_id'] = $request['goo_brse_id'];
        }
        if ($request['goo_pic']) {
            $goo_add_data['goo_pic'] = $request['goo_pic'];
        } else {
            $goo_add_data['goo_pic'] = config('apisystem.server_name_https').'/storage/image/default_goo_img.png';
        }
        // 新增单位字数限制
        if ($request['goo_unit']) {
            if (strlen($request['goo_unit']) > 40) {
                return response()->json(['code' => 500, 'msg' => '单位最多20个字符', 'data' => '单位最多20个字符']);
            }
            $goo_add_data['goo_unit'] = $request['goo_unit'];
        }
        if ($request['goo_unta_id'] == 1) {
            $goo_level = 1;
        } elseif ($request['goo_unta_id'] == 4) {
            $goo_level = 2;
        } else {
            $goo_level = 3;
        }
        $goo_add_data['goo_level'] = $goo_level; //商品单位id
        // 新增商品
        $goo_id =  DB::table('goods')->insertGetId($goo_add_data);

        // 3. 判断是否有商品别名
        if ($request['goaf_another_name']) {
            $goaf_add_data = [
                'goaf_goo_id' => $goo_id,
                'goaf_shop_id' => $user_info->adm_shop_id,
                'goaf_another_name' => $request['goaf_another_name'],
                'goaf_update_time' => date('Y-m-d H:i:s'),
            ];
            // 新增商品别名
            $goaf_res =  DB::table('goods_affiliate')->insert($goaf_add_data);
        } else {
            $goaf_res = true;
        }

        // 4.商品所属品类数量更改
        $find_caco_id = DB::table('category_correlation')
            ->where('caco_cate_id', $request['goo_cate_id'])
            ->where('caco_shop_id', $user_info->adm_shop_id)
            ->value('caco_id');
        if ($find_caco_id) {
            $res_cate = DB::table('category_correlation')
                ->where('caco_cate_id', $request['goo_cate_id'])
                ->where('caco_shop_id', $user_info->adm_shop_id)
                ->increment('caco_goods_number', 1);
        } else {
            // 没有数据，新增数据
            $add_caco_data['caco_shop_id'] = $user_info->adm_shop_id;
            $add_caco_data['caco_cate_id'] = $request['goo_cate_id'];
            $add_caco_data['caco_goods_number'] = 1;
            $add_caco_data['caco_update_time'] = date('Y-m-d H:i:s');
            $res_cate = DB::table('category_correlation')->insert($add_caco_data);
        }

        // 5.商品所属品牌数量更改
        if ($request['goo_bra_id']) {
            // 查询关联表是否有数据
            $find_brco_id = DB::table('brand_correlation')
                ->where('brco_bra_id', $request['goo_bra_id'])
                ->where('brco_shop_id', $user_info->adm_shop_id)
                ->value('brco_id');
            if ($find_brco_id) {
                // 有数据增加数量
                $res_brand = DB::table('brand_correlation')
                    ->where('brco_bra_id', $request['goo_bra_id'])
                    ->where('brco_shop_id', $user_info->adm_shop_id)
                    ->increment('brco_goods_number', 1);
            } else {
                // 没有数据，新增数据
                $add_brco_data['brco_shop_id'] = $user_info->adm_shop_id;
                $add_brco_data['brco_bra_id'] = $request['goo_bra_id'];
                $add_brco_data['brco_goods_number'] = 1;
                $add_brco_data['brco_update_time'] = date('Y-m-d H:i:s');
                $res_brand = DB::table('brand_correlation')->insert($add_brco_data);
            }
        } else {
            $res_brand = true;
        }

        // 商品所属品牌系列数量更改
        if ($request['goo_brse_id']) {
            // 查询系列关联表是否有数据
            $find_brsc_id = DB::table('brand_serie_correlation')
                ->where('brsc_brse_id', $request['goo_brse_id'])
                ->where('brsc_shop_id', $user_info->adm_shop_id)
                ->value('brsc_id');
            if ($find_brsc_id) {
                // 有数据增加数量
                $res_brand_serie = DB::table('brand_serie_correlation')
                    ->where('brsc_brse_id', $request['goo_brse_id'])
                    ->where('brsc_shop_id', $user_info->adm_shop_id)
                    ->increment('brsc_goods_number', 1);
            } else {
                // 没有数据，新增数据
                $add_brsc_data['brsc_shop_id'] = $user_info->adm_shop_id;
                $add_brsc_data['brsc_brse_id'] = $request['goo_brse_id'];
                $add_brsc_data['brsc_goods_number'] = 1;
                $add_brsc_data['brsc_update_time'] = date('Y-m-d H:i:s');
                $res_brand_serie = DB::table('brand_serie_correlation')->insert($add_brsc_data);
            }
        } else {
            $res_brand_serie = true;
        }
        

        if ($request['goo_number'] > 0) {//库存
            $warehouse = DB::table('warehouse')
                ->where('ware_shop_id', $user_info->adm_shop_id)
                ->where('ware_default', 2)//1普通仓库2默认仓库
                ->select('ware_id', 'ware_name')
                ->first();
            if (empty($warehouse)) {
                return response()->json(['code' => 500, 'msg' => '未查询到默认仓库', 'data' => '']);
            }
            $add_wago['wago_ware_id'] = $warehouse->ware_id;
            $add_wago['wago_class'] = 1;
            $add_wago['wago_goo_id'] = $goo_id;
            $add_wago['wago_stock_number'] = 0;
            $add_wago['wago_create_time'] = date('Y-m-d H:i:s');
            $add_wago['wago_goo_price'] = $request['goo_purchase_price'];
            $add_wago['wago_goo_amount'] = 0;
            $add_wago_res = DB::table('warehouse_goods')->insertGetId($add_wago);
            $add_wafg['wafg_create_time'] = date('Y-m-d H:i:s');
            $add_wafg['wafg_stock_number'] = 0;
            $add_wafg['wafg_goo_id'] = $goo_id;
            $add_wafg['wafg_class'] = 1;
            $add_wafg['wafg_ware_id'] = $warehouse->ware_id;
            $add_wafg['wafg_wago_id'] = $add_wago_res;
            $add_wafg['wafg_wafr_id'] = DB::table('warehouse_freight')
                    ->where('wafr_ware_id', $warehouse->ware_id)
                    ->value('wafr_id');
            $add_wafg_res = DB::table('warehouse_freight_goods')->insertGetId($add_wafg);

            $post['ware_id'] = $warehouse->ware_id;
            $post['stoc_waon_class'] = 1;
            $post['stoc_manner'] = 1;
            $post['stoc_make_time'] = date('Y-m-d H:i:s');
            $goods_data[0]['goo_id'] = $goo_id;
            $goods_data[0]['stocktake_number'] = $request['goo_number'];
            $goods_data[0]['priority_stocktake_number'] = 0;
            $stoc = new WashStockakeController;
            $stoc_return = $stoc->saveSubmitData($post, $goods_data, $user_info, 2);
            if ($stoc_return['code'] != 200) {
                DB::rollBack();
                return response()->json($stoc_return);
            }
            $post_data['stoc_id'] = $stoc_return['return_data']['stoc_id'];
            $stoc_res = $stoc->pass($user_info, $post_data);
            if ($stoc_res['code'] != 200) {
                DB::rollBack();
                return response()->json($stoc_res);
            }
        }
        if ($request['goo_unta_id'] == 1) {//卷
            $post['goo_add_data'] = $goo_add_data;
            $Goodslist = new GoodsListController();
            $add_res = $Goodslist->addAffiliatedGood($user_info, $post,$goo_id,$request['goaf_another_name']);
        }

        if ($goo_id && $goaf_res && $res_cate && $res_brand && $res_brand_serie) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '服务列表', '技师端新增', '技师端新增' .$request['goo_name']. '成功');
            $data['goo_id'] = $goo_id;
            $return_data = DB::table('goods')
                ->where('goo_id', $goo_id)
                ->first();
            return response()->json(['code' => 200, 'msg' => '新增商品：成功', 'data' => $data, 'return_data'=>$return_data]);
        } else {
            DB::rollBack();
            return response()->json(['code' => 500, 'msg' => '新增商品：失败', 'data' => '新增商品：失败']);
        }
    }

    /**
     * 新增品牌
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-03
     * @param  Request          $request [description]
     */
    public function addBrandlist(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addBrandlist';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        // 验证数据
        $verify_data = new VerifyBrandListController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            $error_message = $error_message->all();
            return response()->json(['code'=>500, 'msg'=>$error_message[0], 'data'=>'']);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $shop_id = $user_info->adm_shop_id;

        // 1、判断品牌名称是否存在
        $find_sepr = DB::table('brand')
            ->where('bra_delete', 1)
            ->where('bra_cid', $user_info->adm_cid)
            ->where('bra_shop_id', $shop_id)
            ->where('bra_name', $request['bra_name'])
            ->select('bra_id')
            ->first();
        if ($find_sepr) {
            return response()->json(['code'=>500, 'msg'=>'品牌已存在', 'data'=>'品牌已存在']);
        }

        // // 2、判断品牌序号是否存在
        // $find_bra = DB::table('brand as bra')
        //     ->leftjoin('brand_correlation as brco', 'brco.brco_bra_id', '=', 'bra.bra_id')
        //     ->where(function ($query) use ($user_info) {
        //         $query->where('bra_shop_id', $user_info->adm_shop_id);
        //     })
        //     ->where('bra_sequence', '<>', 0)
        //     ->where('bra_sequence', $request['bra_sequence'])
        //     ->where('bra_delete', 1)
        //     ->select('bra_id')
        //     ->first();
        // if ($find_bra) {
        //     return response()->json(['code'=>500, 'msg'=>'品牌序号已存在', 'data'=>'品牌序号已存在']);
        // }

        // 2 新增一个品牌数据
        $bra_add_data['bra_cid'] = $user_info->adm_cid;
        $bra_add_data['bra_shop_id'] = $user_info->adm_shop_id;
        $bra_add_data['bra_superior_shop_id'] = $user_info->shop_superior_id;
        $bra_add_data['bra_name'] = $request['bra_name'];
        // $bra_add_data['bra_sequence'] = $request['bra_sequence'];

        DB::beginTransaction();

        // 新增品牌
        $bra_res =  DB::table('brand')->insertGetId($bra_add_data);
        $data['bra_id'] = $bra_res;
        $brco['brco_shop_id'] = $user_info->adm_shop_id;
        $brco['brco_bra_id'] = $bra_res;
        $brco['brco_sequence'] = '';
        $brco_res = DB::table('brand_correlation')->insert($brco);

        if ($bra_res /*&& $brco_res*/) {
            $return_data['bra_id'] = $bra_res;
            $return_data['bra_name'] = $request['bra_name'];
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '新增品牌', '技师端新增' .$request['bra_name']. '成功');
            return response()->json(['code'=>200, 'msg'=>'新增品牌：成功', 'data'=>$return_data]);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'新增品牌：失败', 'data'=>'']);
        }
    }

    /**
     * 新增品类
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-03
     * @param  Request          $request [description]
     */
    public function addCate(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addBrandlist';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        // 验证数据
        $verify_data = new VerifyCategoryListController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            $error_message = $error_message->all();
            return response()->json(['code'=>500, 'msg'=>$error_message[0], 'data'=>'']);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $shop_id = $user_info->adm_shop_id;

        // 1. 判断品类名称是否存在
        $find_sepr = DB::table('category')
            ->where('cate_delete', 1)
            ->where(function ($query) use ($user_info) {
                $query->where('cate_shop_id', $user_info->adm_shop_id);
            })
            ->where('cate_name', $request['cate_name'])
            ->select('cate_id')
            ->first();
        if ($find_sepr) {
            return response()->json(["code"=>500, 'msg'=>'品类已存在', 'data'=>'品类已存在']);
        }

        // 2 新增一个品类数据
        $cate_add_data['cate_cid'] = $user_info->adm_cid;
        $cate_add_data['cate_shop_id'] = $user_info->adm_shop_id;
        $cate_add_data['cate_superior_shop_id'] = $user_info->shop_superior_id;
        $cate_add_data['cate_name'] = $request['cate_name'];
        $cate_add_data['cate_parent_id'] = $request['cate_parent_id'];

        // 判断隶属上级
        if ($request['cate_parent_id']) {
            // 查找隶属品类是第几级
            $cate_rank = DB::table('category')
                ->where('cate_id', $request['cate_parent_id'])
                ->select('cate_rank')
                ->first();

            if ($cate_rank->cate_rank >= 3) {
                return response()->json(["code"=>500, 'msg'=>'所属品类已超过三级', 'data'=>'所属品类已超过三级']);
            }
            $cate_add_data['cate_rank'] = $cate_rank->cate_rank + 1;
        } else {
            $cate_add_data['cate_rank'] = 1;
        }

        // 新增品类
        $cate_res =  DB::table('category')->insertGetid($cate_add_data);
        $data['cate_id'] = $cate_res;
        $caco['caco_shop_id'] = $user_info->adm_shop_id;
        $caco['caco_cate_id'] = $cate_res;
        $caco_res = DB::table('category_correlation')->insert($caco);

        if ($cate_res && $caco_res) {
            $return_data['cate_id'] = $cate_res;
            $return_data['cate_name'] = $request['cate_name'];
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '新增品类：', '技师端新增' .$request['cate_name']. '成功');
            return response()->json(["code"=>200, 'msg'=>'新增品类：成功', 'data'=>$return_data]);
        } else {
            return response()->json(["code"=>500, 'msg'=>'新增品类：失败', 'data'=>'']);
        }
    }

    /**
     * 新增品牌系列
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-03
     * @param  Request          $request [description]
     */
    public function addBre(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addBre';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        // 验证数据
        $verify_data = new VerifyBrandSerieController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            $error_message = $error_message->all();
            return response()->json(['code'=>500, 'msg'=>$error_message[0], 'data'=>'']);
        }

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $shop_id = $user_info->adm_shop_id;

        // 1. 判断品牌系列名称是否存在
        $find_sepr = DB::table('brand_serie')
            ->where('brse_delete', 1)
            ->where(function ($query) use ($user_info) {
                $query->where('brse_shop_id', $user_info->adm_shop_id);
            })
            ->where('brse_bra_id', $request['bra_id'])
            ->where('brse_name', $request['brse_name'])
            ->select('brse_id')
            ->first();
        if ($find_sepr) {
            return response()->json(['code'=>500, 'msg'=>'当前品牌下的系列名称已存在', 'data'=>'当前品牌下的系列名称已存在']);
        }

        $find_bra = DB::table('brand_serie')
            ->where('brse_delete', 1)
            ->where(function ($query) use ($user_info) {
                $query->where('brse_shop_id', $user_info->adm_shop_id);
            })
            ->where('brse_sequence', '<>', 0)
            ->where('brse_sequence', $request['brse_sequence'])
            ->select('brse_id')
            ->first();
        if ($find_bra) {
            return response()->json(['code'=>500, 'msg'=>'品牌系列序号已存在', 'data'=>'品牌系列序号已存在']);
        }

        // 2 新增一个品牌系列数据
        $brse_add_data = [
            'brse_cid' => $user_info->adm_cid,
            'brse_shop_id' => $user_info->adm_shop_id,
            'brse_superior_shop_id' => $user_info->shop_superior_id,
            'brse_bra_id' => $request['bra_id'],
            'brse_name' => $request['brse_name'],
            'brse_cate_id' => $request['cate_id'], //一级品类id
            'brse_second_cate_id' => $request['cate_two_id'] ? $request['cate_two_id'] : '0', //二级品类id
        ];

        // 新增品牌系列
        $brse_res =  DB::table('brand_serie')->insertGetid($brse_add_data);
        $data['brse_id'] = $brse_res;
        $brsc['brsc_sequence'] = $request['brsc_sequence'] ?? '';
        $brsc['brsc_update_time'] = date('Y-m-d H:i:s');
        $brsc['brsc_shop_id'] = $user_info->adm_shop_id;
        $brsc['brsc_brse_id'] = $brse_res;

        $brsc_res = DB::table('brand_serie_correlation')->insert($brsc);
        if ($brse_res && $brsc_res) {
            $return_data['brse_id'] = $brse_res;
            $return_data['brse_name'] = $request['brse_name'];
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '新增品牌系列：', '技师端新增' .$request['brse_name']. '成功');
            return response()->json(["code"=>200, 'msg'=>'新增品牌系列：成功', 'data'=>$return_data]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'新增品牌系列：失败', 'data'=>'']);
        }
    }

    // 获取单位名称数据
    public function selectUnit(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $search_data = $request->all();

        $list_data  =  DB::table('unit_table')
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['unta_name'])) { //单位名称
                    $query->where('unta_name', 'like', '%' . $search_data['unta_name'] . '%');
                }
            })
            ->orderBy('unta_id', 'asc')
            ->select('unta_id', 'unta_name')
            ->paginate($this->show_count);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $list_items = $list_data->items();
        $data_info['data'] = $list_items; //返回数据
        return response()->json(['code' => 200, 'msg' => 'success', 'data_info' => $data_info]);
    }

    /**
     * 新增商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-07
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getWareHouses(Request $request) {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $list_data = DB::table('warehouse')
            ->where('ware_shop_id', $user_info->adm_shop_id)
            ->where('ware_default', 2)//1普通仓库2默认仓库
            ->select('ware_id', 'ware_name')
            ->first();
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $list_data]);
    }

    /**
     * 转库存
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-06-25
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function unitConversion(Request $request) {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {//转库存查询信息
            $find_wago = DB::table('warehouse_goods')
                ->leftJoin('goods', 'goo_id', '=', 'wago_goo_id')
                ->where('wago_id', $request['wago_id'])
                ->select('wago_id', 'goo_id', 'goo_unta_id', 'goo_unit','goo_unit_conversion','wago_stock_number', 'goo_level', 'wago_ware_id', 'goo_fid')
                ->first();
            $main_goods = [];
            $byGoods = [];
            $find_byGoods = [];
            if ($find_wago) {
                if ($find_wago->goo_level == 1) {//主商品
                    $main_goods = $find_wago;
                    $byGoods = DB::table('goods')
                        ->where('goo_fid', $main_goods->goo_id)
                        ->where('goo_level', 2)
                        ->select('goo_id', 'goo_unta_id', 'goo_unit','goo_unit_conversion')
                        ->first();
                    if ($byGoods) {
                        $find_byGoods = DB::table('warehouse_goods')
                            ->leftJoin('goods', 'goo_id', '=', 'wago_goo_id')
                            ->where('wago_ware_id', $main_goods->wago_ware_id)
                            ->where('wago_goo_id', $byGoods->goo_id)
                            ->select('wago_id', 'goo_id', 'goo_unta_id', 'goo_unit','goo_unit_conversion','wago_stock_number')
                            ->first();
                        if (!$find_byGoods) {
                            $find_byGoods = $byGoods;
                            $find_byGoods->wago_stock_number = 0;
                        }
                        $find_byGoods = !empty($find_byGoods) ? $find_byGoods : $byGoods;
                    }
                } elseif($find_wago->goo_level == 2) {
                    $find_byGoods = $find_wago;
                    $main_goods_data = DB::table('goods')
                        ->where('goo_id', $find_byGoods->goo_fid)
                        ->where('goo_level', 1)
                        ->select('goo_id', 'goo_unta_id', 'goo_unit','goo_unit_conversion')
                        ->first();
                    if ($main_goods_data) {
                        $main_goods = DB::table('warehouse_goods')
                            ->leftJoin('goods', 'goo_id', '=', 'wago_goo_id')
                            ->where('wago_ware_id', $find_wago->wago_ware_id)
                            ->where('wago_goo_id', $main_goods_data->goo_id)
                            ->select('wago_id', 'goo_id', 'goo_unta_id', 'goo_unit','goo_unit_conversion','wago_stock_number')
                            ->first();
                        if (!$main_goods) {
                            $main_goods = $main_goods_data;
                            $main_goods->wago_stock_number = 0;
                        }
                        $main_goods = !empty($main_goods) ? $main_goods : $main_goods_data;
                    }
                }
            }
            $return_data['main_goods'] = !empty($main_goods)  ? $main_goods:'';//主商品
            $return_data['find_byGoods'] = !empty($find_byGoods)  ? $find_byGoods:'';//副商品
            return response()->json(['code'=>200,'msg'=>'success','data'=>$return_data]);
        } else {
            DB::beginTransaction();
            $res = WashMyWarehouseService::unitConversion($user_info, $request->all());
            if ($res['code'] == 200) {
                DB::commit();
                OperationLog::addLog($user_info, getRealIp($request), '仓库商品列表', '转库存', '转库存成功');
            } else {
                DB::rollBack();
            }
            return response()->json($res);
        }
    }

    /**
     * 根据卷的商品id转换成米的
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-06-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function searchColGoods(Request $request) {
        $find_goods = DB::table('goods')
            ->where('goo_id', $request['goo_id'])
            ->first();
        $return_goods = [];
        if ($find_goods->goo_level == 1) {
            $return_goods = DB::table('goods')
                ->where('goo_fid', $find_goods->goo_id)
                ->where('goo_level', 2)
                ->first();
        } elseif ($find_goods->goo_level == 2) {
            $return_goods = DB::table('goods')
                ->where('goo_id', $find_goods->goo_fid)
                ->where('goo_level', 1)
                ->first();
        }
        if ($return_goods) {
            $return_goods->goo_price = $return_goods->goo_wholesale_price;
            $return_goods->goo_brse_name = DB::table('brand_serie')
                ->where('brse_id', $return_goods->goo_brse_id)
                ->value('brse_name');
        }
        if (!empty($return_goods)) {
            if ($request['ware_id']) {
                // 仓库商品表数据
                $stock_data = DB::table('warehouse as a')
                    ->leftJoin('warehouse_goods as b', 'b.wago_ware_id', '=', 'a.ware_id')
                    ->where('ware_state', 1) //  状态1启用2停用3撤仓
                    ->where('wago_class', 1)
                    ->where('ware_id', $request['ware_id'])
                    ->where('wago_goo_id', $return_goods->goo_id)
                    ->select('wago_id', 'wago_goo_id', 'ware_id', 'ware_name', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity')
                    ->orderBy('wago_stock_number', 'desc')
                    ->get()->toArray();
                $return_goods->stock_data = $stock_data;
            } else {
                $return_goods->stock_data = [];
            }
        }
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $return_goods]);
    }

    /**
     * 添加备注
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-04
     * @param  Request          $request [description]
     */
    public function addRemark(Request $request) {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashOrderService::remarkSearch($user_info, $request->all());
        $orre_res = orderRemark($user_info, $request['ord_id'], $return_data['wor_id'], $request['remark'], '订单列表');
        if ($orre_res) {
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '备注', '订单 ' . $return_data['ord_order_number'] . ' 添加备注 :' . $request['remark']);
            return $this->success('备注成功');
        } else {
            return $this->error('备注失败', ErrorInc::MYSQL_FAILED);
        }
    }

    /**
     * 获取会员及会员卡
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-25
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getMemberAndMyVip(Request $request)
    {
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getMemberAndMyVip';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $res = WashOrderService::getMemberAndMyVip($user_info, $request->all());
        return response()->json($res);
    }

    /**
     * 获取套餐
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-10-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function package(Request $request) {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $search_data = GoodsService::package($user_info,$request->all());

        return response()->json($search_data);
    }

    /**
     * 获取套餐详情
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-10-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function packageInfo(Request $request) {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $search_data = GoodsService::info($user_info,$request->all());

        return response()->json(['code'=>200, 'msg'=>'success','data'=>$search_data]);
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 安装明细
     * @param string ord_id 订单数据id
     * @param string ord_order_number 订单单号
     * @param string ord_explain 施工说明
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2025/2/13 16:50
     * |---------------------------------------------------------------------------------
    */
    public function orderExplain ( Request $request ){
        if (!$request->filled('ord_id') || !$request->filled('ord_explain')) {
            return response()->json(['code'=>201, 'msg'=>'参数错误','data'=>'']);
        }
        $input = $request->all();
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $rea = DB::table('order')->where('ord_id',$input['ord_id'])->update(['ord_explain'=>$input['ord_explain'],'ord_update_time'=>date("Y-m-d H:i:s")]);
        $update_plan = DB::table('work_plan')->where('wopl_ord_id', $input['ord_id'])->update(['wopl_explain'=>$input['ord_explain'],'wopl_update_time'=>date("Y-m-d H:i:s")]);
        $update_work = DB::table('work_order')->where('wor_order_id', $input['ord_id'])->update(['wor_explain'=>$input['ord_explain'],'wor_update_time'=>date("Y-m-d H:i:s")]);
        if($rea){
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '编辑施工说明', '订单 ' . $input['ord_order_number'] . ' 编辑说明 :' . $request['ord_explain']);
            return response()->json(['code'=>200, 'msg'=>'操作成功','data'=>'']);
        }else{
            return response()->json(['code'=>202, 'msg'=>'操作失败','data'=>'']);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取来源类型
     * @param
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2025/3/7 11:11
     * |---------------------------------------------------------------------------------
    */
    public function getSourceState ( Request $request ){
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $input = $request->all();
        if(!$request->filled('mbs_stats') || !in_array($input['mbs_stats'], ['sourceSet'])){
            return response()->json(['code' => ErrorInc::INVALID_PARAM, 'msg' =>'属性错误', 'data' => '']);
        }
        if(!$request->filled('type') || !in_array($input['type'], [1,2])){
            return response()->json(['code' => ErrorInc::INVALID_PARAM, 'msg' =>'请求类型错误', 'data' => '']);
        }else{
            if(!$request->filled('mbs_type') || !in_array($input['mbs_type'], [0,1,2])){
                return response()->json(['code' => ErrorInc::INVALID_PARAM, 'msg' =>'数据类型错误', 'data' => '']);
            }else {
                $return = MemberService::setMemberData($input, $user_info, $request->ip());
                return response()->json(['code' => $return['code'], 'msg' =>$return['msg'], 'data' => $return['data']]);
            }
        }
    }
}