<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use App\Http\Controllers\Api\Verify\ProductManage\VerifyServiceProjectController;
use App\Http\Models\Api\Common;
use App\Models\OperationLog;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use App\Services\Business\WashOrderService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use Illuminate\Support\Facades\DB;
use App\Services\CommonService;
class ServiceProjectController extends Controller
{
    public $dataService = null;
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataService = $service = new WashOrderService();
        $this->bootWithService($service);
    }

    /**|---------------------------------------------------------------------------------
     * @name 服务项目列表
     * @param string sepr_name 服务名称
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2024/12/27 13:48
     * |---------------------------------------------------------------------------------
    */
    public function index(Request $request)
    {
        $page_size = $request->input('show_count', 10);
        $search_data = $request->all();
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        $list_data = DB::table('service_project')
            ->where('sepr_cid', $user_info->adm_cid)
            ->where('sepr_shop_id', $shop_id)
            ->where('sepr_delete', 1)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['sepr_name'])) {
                    $query->where('sepr_name', 'like', '%'.$search_data['sepr_name'].'%' );
                }
            })
            ->select('sepr_id', 'sepr_name', 'sepr_order_money', 'sepr_img', 'sepr_work_type')
            ->orderBy('sepr_sort', 'desc')
            ->paginate($page_size);
        $list_items = $list_data->items();
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $page_size;       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据
        if($list_items) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        }else{
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
    /**
     * 获取配置图片
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-01-18
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getConimg(Request $request) {
        $data_com = DB::table('image_config')
            ->where('imco_type', 2)
            ->get()->toArray();
        $goods_data = DB::table('image_config')
            ->where('imco_type', 1)
            ->get()->toArray();
        $data['data_one'] = $goods_data;
        $data['data_two'] = $data_com;
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 洗美-搜索服务项目
    public function searchWashService(Request $request)
    {
        if (!isset($request['pri_id'])) {
            request()->offsetSet('pri_id', 9);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取当前操作账号信息
        $user_info = LoginUserService::getUser();

        if (empty($fields)) {
            $fields = ['sepr_id', 'sepr_name', 'sepr_order_money', 'sepr_img', 'sepr_work_type']; //默认查询字段
        }
        $post['string'] = 'sepr_';
        $post['user_info'] = $user_info;
        $type = 3;
        $where_data = whereFunction($post,$type);
        if($request['pri_id']==96){
            $page_size = $request->input('show_count', 10);
            $list_data = DB::table('service_project as a')
                ->whereIn($where_data['string'], $where_data['shop_id'])
                ->where('sepr_state', 1) //状态1启用2停用
                ->where('sepr_delete', 1) //是否删除：1正常2已删除
                ->where(function ($query) use ($request) { //服务项目名称
                    if (!empty($request['keywords'])) {
                        $query->where('sepr_name', 'like', '%' . $request['keywords'] . '%');
                    }
                })
                ->select($fields)
                ->orderBy('sepr_sort', 'desc')
                ->paginate($page_size);
                $list_items = $list_data->items();
                $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
                $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
                $data_info['total'] = $list_data->total();               //总数据个数
                $data_info['current_number'] = $page_size;       //一页显示多少个
                $data_info['data'] = $list_items;
                $list_data = $data_info;
        }else {
            $list_data = DB::table('service_project as a')
                ->whereIn($where_data['string'], $where_data['shop_id'])
                ->where('sepr_state', 1) //状态1启用2停用
                ->where('sepr_delete', 1) //是否删除：1正常2已删除
                ->where(function ($query) use ($request) { //服务项目名称
                    if (!empty($request['keywords'])) {
                        $query->where('sepr_name', 'like', '%' . $request['keywords'] . '%');
                    }
                })
                ->where(function ($query) use ($request) { //服务项目id
                    if (!empty($request['sepr_id'])) {
                        $query->where('sepr_id', $request['sepr_id']);
                    }
                })
                ->select($fields)
                ->orderBy('sepr_sort', 'desc')
                ->get()->toArray();
        }
        $list_button = getAppletListButton($request['api_token'], $request['pri_id']);
        if (!empty($list_button)) {
            $pri_operate_method = array_column($list_button, 'pri_operate_method');
            foreach ($list_button as $key => $value) {
                if ($value['pri_operate_method'] == 'addProject' && $value['have_pri'] == 1) {
                    $addProject = true;
                    break;
                } else {
                    $addProject = false;
                }
            }
            foreach ($list_button as $key => $value) {
                if ($value['pri_operate_method'] == 'editProject' && $value['have_pri'] == 1) {
                    $editProject = true;
                    break;
                } else {
                    $editProject = false;
                }
            }
        } else {
            $addProject = false;
            $editProject = false;
        }
        if (($request['pri_id']!=96 && $list_data) || ($request['pri_id']==96 && $list_data['data'])) {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $list_data, 'addProject'=>$addProject, 'editProject'=>$editProject]);
        } else {
            return response()->json(['code' => 200, 'msg' => '暂无数据', 'data' => [], 'addProject'=>$addProject, 'editProject'=>$editProject]);
        }
    }
    /**
     * 新增服务项目
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-01-18
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function addProject(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'addProject';
        logFileRecord($log_record, 'wash/WashOrder', 2);
        // 验证数据
        $verify_data = new VerifyServiceProjectController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>$error_message, 'data'=>'']);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;

        // 1. 判断服务项目名称是否存在
        $find_sepr = DB::table('service_project')
            ->where('sepr_delete', 1)
            ->where('sepr_cid', $user_info->adm_cid)
            ->where('sepr_shop_id', $shop_id)
            ->where('sepr_name', $request['sepr_name'])
            ->select('sepr_id')
            ->first();
        if ($find_sepr) {
            return response()->json(["code"=>500,'msg'=>'服务项目已存在', 'data'=>'服务项目已存在']);
        }
        if (!empty($request['sepr_code'])) {
            // 1. 判断服务项目名称是否存在
            $find_sepr = DB::table('service_project')
                ->where('sepr_delete', 1)
                ->where('sepr_cid', $user_info->adm_cid)
                ->where('sepr_shop_id', $shop_id)
                ->where('sepr_code', $request['sepr_code'])
                ->select('sepr_id')
                ->first();
            if ($find_sepr) {
                return response()->json(["code"=>500,'msg'=>'服务项目编码已存在', 'data'=>'服务项目编码已存在']);
            }
        }
        // 2 新增一个服务项目数据
        $sepr_add_data = [
            'sepr_cid'=>$user_info->adm_cid,
            'sepr_shop_id'=>$user_info->adm_shop_id,
            'sepr_superior_shop_id'=>$user_info->shop_superior_id,
            'sepr_name'=>$request['sepr_name'],
            'sepr_code'=>$request['sepr_code'],
            'sepr_money'=>$request['sepr_money'] * 100,
            'sepr_order_money'=>$request['sepr_order_money'] * 100,
            'sepr_order_type'=>1,
            'sepr_sort'=>$request->input('sepr_sort', 0),
            'sepr_show_location'=>$request->input('sepr_show_location', 0),//显示位置
            'sepr_work_type'=>$request['sepr_work_type'],//流程分类1有工单2不生成工单
        ];
        $sepr_add_data['sepr_check_car'] = 1;//是否验车1是2否
        // $sepr_add_data['sepr_pic_conf'] = $request['sepr_pic_conf'];//上传材料设置
        //sepr_pic_conf:[{"id":1,"show_word":"汽车名牌","must_state":1},{"id":2,"show_word":"车膜标签","must_state":1},{"id":3,"show_word":"膜桶标签","must_state":2},{"id":4,"show_word":"全车照片","must_state":1},{"id":5,"show_word":"全车视频","must_state":1}]

        if (isset($request['sepr_img']) && !empty($request['sepr_img'])) {
            // 判断是否有新图片上传
            if (strpos($request['sepr_img'], 'data:image') === 0) {
                // 调用全局函数 上传图片
                $image_path = uploadBase64ImgFolder($shop_id, $value, 2);
                $sepr_add_data['sepr_img'] = $image_path; //新上传的图片路径
            } else {
                $sepr_add_data['sepr_img'] = $request['sepr_img'];
            }
        }
        if (!empty($request['sepr_remark'])) {
            $sepr_add_data['sepr_remark'] = $request['sepr_remark']; //备注
        } else {
            $sepr_add_data['sepr_remark'] = '';
        }

        // 新增服务项目
        $sepr_res =  DB::table('service_project')->insertGetid($sepr_add_data);
        if (!empty($request['sepr_data_one'])) {
            foreach ($request['sepr_data_one'] as $key => $value) {
                $add_sepr_img[$key]['seim_imco_id'] = $value;
                $add_sepr_img[$key]['seim_sepr_id'] = $sepr_res;
                $add_sepr_img[$key]['seim_create_time'] = date('Y-m-d H:i:s');
                $add_sepr_img[$key]['seim_create_id'] = $user_info->adm_id;
            }
            $add_seim_res = DB::table('sepr_img')->insert($add_sepr_img);
        }
        if (!empty($request['sepr_data_two'])) {
            foreach ($request['sepr_data_two'] as $key => $value) {
                $add_sepr_img[$key]['seim_imco_id'] = $value;
                $add_sepr_img[$key]['seim_sepr_id'] = $sepr_res;
                $add_sepr_img[$key]['seim_create_time'] = date('Y-m-d H:i:s');
                $add_sepr_img[$key]['seim_create_id'] = $user_info->adm_id;
            }
            $add_seim_res = DB::table('sepr_img')->insert($add_sepr_img);
        }
        $return_data = DB::table('service_project')
            ->where('sepr_id', $sepr_res)
            ->first();
        if ($sepr_res) {
            OperationLog::addLog($user_info, getRealIp($request), '服务列表', '技师端新增', '技师端新增' .$request['sepr_name']. '成功');
            return response()->json(["code"=>200,'msg'=>'新增服务项目：成功','data'=>'新增服务项目：成功','return_data'=>$return_data]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'新增服务项目：失败']);
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取服务信息
     * @param string order_number 订单单号
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/12/23 17:44
     * |---------------------------------------------------------------------------------
     */
    public function getServiceData ( Request $request ){
        if(isset($request['sepr_id']) && !empty($request['sepr_id'])){
            $serciceid[] = $request['sepr_id'];
        }else {
            if (!isset($request['order_number']) || empty($request['order_number'])) {
                return response()->json(["code" => 500, 'msg' => '请输入单号', 'data' => '']);
            }
            $serciceid = DB::table("order_goods")->where("orgo_order_number", $request['order_number'])->where('orgo_goo_type', 2)->where('orgo_state', '!=', 2)->pluck('orgo_goo_id');
            $serciceid = CommonService::dataToArray($serciceid);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        if(!empty($serciceid)){
            CommonService::startmysql();
            $list = DB::table('service_project')
                ->whereIn('sepr_id',$serciceid)
                ->where('sepr_shop_id', $shop_id)
                ->select('sepr_id', 'sepr_name', 'sepr_img', 'sepr_order_money', 'sepr_check_car', 'sepr_money', 'sepr_show_location', 'sepr_remark', 'sepr_work_type', 'sepr_sort', 'sepr_code')
                ->get();
            $list = CommonService::dataToArray($list);
            if($list){
                $seim_data = DB::table('sepr_img')
                    ->whereIn('seim_sepr_id', $serciceid)
                    ->select('seim_imco_id','seim_sepr_id')
                    ->get();
                $seim_data = CommonService::dataToArray($seim_data);
                if($seim_data){
                    $seim_data = CommonService::jointArrayKey($seim_data, 'seim_sepr_id',2);
                }
                $data_one = DB::table('image_config')
                    ->where('imco_type', 1)
                    ->select('imco_id', 'imco_name')
                    ->get();
                $data_one = CommonService::dataToArray($data_one);
                $data_two = DB::table('image_config')
                    ->where('imco_type', 2)
                    ->select('imco_id', 'imco_name')
                    ->get();
                $data_two = CommonService::dataToArray($data_two);
                foreach($list as $k => $v){
                    if(isset($seim_data[$v['sepr_id']])){
                        $seim_imco_id = array_column($seim_data[$v['sepr_id']], 'seim_imco_id');
                        $data_ones = [];
                        foreach($data_one as $ks => $vs){
                            if (in_array($vs['imco_id'], $seim_imco_id)) {
                                $vs['select'] = 1;
                            }else{
                                $vs['select'] = 2;
                            }
                            $data_ones[$ks] = $vs;
                        }
                        $data_twos = [];
                        foreach($data_two as $ka => $va){
                            if (in_array($va['imco_id'], $seim_imco_id)) {
                                $va['select'] = 1;
                            }else{
                                $va['select'] = 2;
                            }
                            $data_twos[$ka] = $va;
                        }
                        $list[$k]['data_one'] = $data_ones;
                        $list[$k]['data_two'] = $data_twos;
                    }else{
                        foreach($data_one as $ks => $vs){
                            $data_one[$ks]['select'] = 2;
                        }
                        foreach($data_two as $ka => $va){
                            $data_two[$ka]['select'] = 2;
                        }
                        $list[$k]['data_one'] = $data_one;
                        $list[$k]['data_two'] = $data_two;
                    }
                }
                return response()->json(["code"=>200,'msg'=>'Success','data'=>$list]);
            }else{
                return response()->json(["code"=>500,'msg'=>'服务数据异常NoProject','data'=>CommonService::showmysql()]);
            }
        }else{
            return response()->json(["code"=>500,'msg'=>'服务数据异常','data'=>'']);
        }

    }

    /**|---------------------------------------------------------------------------------
     * @name 编辑服务项目
     * @param string sepr_id 数据id
     * @param string sepr_name 服务项目名称
     * @param string sepr_order_money 订单金额
     * @param string sepr_img 图片
     * @param string sepr_check_car 是否验车1是2否
     * @param string sepr_show_location 显示位置1洗美2合作商3洗美和合作商4无
     * @param string sepr_work_type 流程分类1生成工单2不生成工单
     * @param string sepr_sort 排序
     * @param string sepr_remark 备注
     * @param string source_page 来源页面
     * @param string order_number 订单单号
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2024/12/24 11:11
     * |---------------------------------------------------------------------------------
     */
    public function editServiceProject ( Request $request ){
        if(!isset($request['source_page']) || !in_array($request['source_page'], ['vehicleInspection','submitBuild','generateWorkOrder','orderList','workOrderDetail','serviceList'])){
            return response()->json(["code"=>500,'msg'=>'请求页面异常','data'=>'']);
        }
        $serviceData = $request['serviceData'];
        $serviceData = CommonService::dataToArray($serviceData);
        if(!isset($serviceData[0]) || empty($serviceData[0])){
            return response()->json(["code"=>500,'msg'=>'请填写需要编辑的数据','data'=>'']);
        }
        // 验证数据
        $verify_data = new VerifyServiceProjectController;
        $error_message = $verify_data->editValidatorWeChat($serviceData[0]);
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>$error_message, 'data'=>'']);
        }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        $data['sepr_check_car'] = 2;
        $data['sepr_work_type'] = 2;
        $sepr_data_two = [];
        $sepr_data_one = [];
        DB::beginTransaction();
        foreach($serviceData as $k => $v){
            $find_sepr = DB::table('service_project')
                ->where('sepr_id', '<>', $v['sepr_id'])
                ->where('sepr_delete', 1)
                ->where('sepr_cid', $user_info->adm_cid)
                ->where('sepr_shop_id', $shop_id)
                ->where('sepr_name', $v['sepr_name'])
                ->select('sepr_id')
                ->first();
            if ($find_sepr) {
                DB::rollBack();
                return response()->json(["code"=>500,'msg'=>'服务项目'.$v['sepr_name'].'已存在','data'=>'']);
            }
            if (!empty($v['sepr_code'])) {
                // 1. 判断服务项目名称是否存在
                $find_sepr = DB::table('service_project')
                    ->where('sepr_id', '<>', $v['sepr_id'])
                    ->where('sepr_delete', 1)
                    ->where('sepr_cid', $user_info->adm_cid)
                    ->where('sepr_shop_id', $shop_id)
                    ->where('sepr_code', $v['sepr_code'])
                    ->select('sepr_id')
                    ->first();
                if ($find_sepr) {
                    return response()->json(["code"=>500,'msg'=>'服务项目编号'.$v['sepr_code'].'已存在','data'=>'']);
                }
            }
            // 2 编辑服务项目数据
            $sepr_edit_data = [
                'sepr_name'=>$v['sepr_name'],
                'sepr_code'=>$v['sepr_code'],
                'sepr_money'=>$v['sepr_money'] * 100,
                'sepr_order_money'=>$v['sepr_order_money'] * 100,
                'sepr_order_type'=>1,
                'sepr_sort'=>$v['sepr_sort']??0,
                'sepr_show_location'=>$v['sepr_show_location']??0,//显示位置
                'sepr_work_type'=>$v['sepr_work_type'],//流程分类1有工单2不生成工单
                'sepr_update_time'=>date('Y-m-d H:i:s'),
            ];
            if($v['sepr_check_car']==1){
                $data['sepr_check_car'] = 1;
            }
            if($v['sepr_work_type']==1){
                $data['sepr_work_type'] = 1;
            }
            $sepr_edit_data['sepr_check_car'] = $v['sepr_check_car'];//是否验车1是2否
            if (isset($v['sepr_img'])) {
                if (empty($v['sepr_img'])) {
                    $sepr_edit_data['sepr_img'] = ''; //新上传的图片路径
                } else {
                    $sepr_edit_data['sepr_img'] = $v['sepr_img'];
                }
            }
            if (!empty($v['sepr_remark'])) {
                $sepr_edit_data['sepr_remark'] = $v['sepr_remark']; //备注
            } else {
                $sepr_edit_data['sepr_remark'] = '';
            }
            // 编辑服务项目
            $sepr_res =  DB::table('service_project')
                ->where('sepr_id', $v['sepr_id'])
                ->where('sepr_shop_id', $shop_id)
                ->update($sepr_edit_data);
            $delete = DB::table('sepr_img')
                ->where('seim_sepr_id', $v['sepr_id'])
                ->delete();
            if (!empty($v['sepr_data_one'])) {
                foreach ($v['sepr_data_one'] as $key => $value) {
                    $sepr_data_one[] = $value;
                    $add_sepr_img[$key]['seim_imco_id'] = $value;
                    $add_sepr_img[$key]['seim_sepr_id'] = $v['sepr_id'];
                    $add_sepr_img[$key]['seim_create_time'] = date('Y-m-d H:i:s');
                    $add_sepr_img[$key]['seim_create_id'] = $user_info->adm_id;
                }
                $add_seim_res = DB::table('sepr_img')->insert($add_sepr_img);
            }
            if (!empty($v['sepr_data_two'])) {
                foreach ($v['sepr_data_two'] as $key => $value) {
                    $sepr_data_two[] = $value;
                    $add_sepr_imgs[$key]['seim_imco_id'] = $value;
                    $add_sepr_imgs[$key]['seim_sepr_id'] = $v['sepr_id'];
                    $add_sepr_imgs[$key]['seim_create_time'] = date('Y-m-d H:i:s');
                    $add_sepr_imgs[$key]['seim_create_id'] = $user_info->adm_id;
                }
                $add_seim_res = DB::table('sepr_img')->insert($add_sepr_imgs);
            }
            if ($sepr_res) {
                Common::addLog($user_info, getRealIp($request), '服务项目','编辑','编辑服务项目：'.$request['sepr_name'].'成功');
            }else{
                DB::rollBack();
                return response()->json(["code"=>500,'msg'=>'编辑服务项目：失败','data'=>'']);
            }
        }
        switch ( $request['source_page'] ){
            case 'vehicleInspection':
                $return['url'] = 'pages/workOrder/vehicleInspection';
                break;
            case 'submitBuild':
                $return['url'] = 'pages/workOrder/submitBuild';
                break;
            case 'generateWorkOrder':
                $return['url'] = 'pages/order/generateWorkOrder';
                break;
            case 'orderList':
                $return['url'] = 'pages/order/orderList';
                break;
            case 'serviceList':
                $return['url'] = 'pages/my/serviceList';
                break;
            default:
                $return['url'] = 'pages/workOrder/workOrderList';
                break;
        }
        $return['ord_id'] = '';
        $return['wor_id'] = '';
        $return['order_number'] = '';
        if(isset($request['order_number']) && !empty($request['order_number'])){
            $return['ord_id'] = DB::table('order')->where('ord_order_number',$request['order_number'])->value('ord_id');
            if(!isset($request['wor_id']) || empty($request['wor_id'])) {
                $return['wor_id'] = DB::table('work_order')->where('wor_order_number', $request['order_number'])->value('wor_id');
            }else{
                $return['wor_id'] = $request['wor_id'];
            }
            $return['order_number'] = $request['order_number'];
            $data_one = DB::table('image_config')
                ->where('imco_type', 1)
                ->pluck('imco_id');
            $data_one = CommonService::dataToArray($data_one);
            if(!empty($sepr_data_one)) {
                foreach($data_one as $k => $v){
                    if (in_array($v, $sepr_data_one)) {
                        DB::table('wash_validate_car')
                            ->where('vaca_ord_id',$return['ord_id'])
                            ->where('vaca_type',1)
                            ->where('vaca_data_id',$v)
                            ->update(['vaca_must'=>1]);
                    }else{
                        DB::table('wash_validate_car')
                            ->where('vaca_ord_id',$return['ord_id'])
                            ->where('vaca_type',1)
                            ->where('vaca_data_id',$v)
                            ->update(['vaca_must'=>2]);
                    }
                }
            }else{
                DB::table('wash_validate_car')
                    ->where('vaca_ord_id',$return['ord_id'])
                    ->where('vaca_type',1)
                    ->whereIn('vaca_data_id',$data_one)
                    ->update(['vaca_must'=>2]);
            }
            if(!empty($return['ord_id']) && !empty($return['wor_id'])){
                $data_two = DB::table('image_config')
                    ->where('imco_type', 2)
                    ->select('imco_id', 'imco_name')
                    ->get();
                $data_two = CommonService::dataToArray($data_two);
                $completion_info = DB::table('completion_info')->where("coin_ord_id",$return['ord_id'])->select('coin_data','coin_data_id','coin_id')->get();
                $completion_info = CommonService::dataToArray($completion_info);
                if($completion_info){
                    $completion_info = CommonService::jointArrayKey($completion_info, 'coin_data_id');
                }
                if(empty($sepr_data_two)){
                    $deletid = [];
                    foreach($data_two as $k => $v){
                        if(isset($completion_info[$v['imco_id']]) && $completion_info[$v['imco_id']]['coin_data']==''){
                            $deletid[] = $completion_info[$v['imco_id']]['coin_id'];
                        }
                    }
                    if(!empty($deletid)) {
                        DB::table('completion_info')->where("coin_ord_id", $return['ord_id'])->whereIn('coin_id', $deletid)->delete();
                    }
                }else{
                    $deletid = [];
                    $addData = [];
                    $bum = 0;
                    if(!empty($return['wor_id'])){
                        $wor_service_adm_id = DB::table('work_order')->where('wor_id', $return['wor_id'])->value('wor_service_adm_id');
                    }
                    foreach($data_two as $k => $v){
                        if (in_array($v['imco_id'], $sepr_data_two)) {
                            if(!isset($completion_info[$v['imco_id']])){
                                $addData[$bum]['coin_shop_id'] = $shop_id;
                                if(!empty($return['wor_id'])){
                                    $addData[$bum]['coin_wor_id'] = $return['wor_id'];
                                    $addData[$bum]['coin_adm_id'] = $wor_service_adm_id;
                                }
                                $addData[$bum]['coin_type'] = 3;
                                $addData[$bum]['coin_create_id'] = $user_info->adm_id;
                                $addData[$bum]['coin_create_time'] = date("Y-m-d H:i:s");
                                $addData[$bum]['coin_data_id'] = $v['imco_id'];
                                $addData[$bum]['coin_name'] = $v['imco_name'];
                                $addData[$bum]['coin_must'] = 1;
                                $addData[$bum]['coin_ord_id'] = $return['ord_id'];
                                $bum++;
                            }
                        }else{
                            if(isset($completion_info[$v['imco_id']]) && $completion_info[$v['imco_id']]['coin_data']==''){
                                $deletid[] = $completion_info[$v['imco_id']]['coin_id'];
                            }
                        }
                    }
                    if(!empty($deletid)) {
                        DB::table('completion_info')->where("coin_ord_id", $return['ord_id'])->whereIn('coin_id', $deletid)->delete();
                    }
                    if(!empty($addData)) {
                        DB::table('completion_info')->insert($addData);
                    }
                    $return['addData'] = $addData;
                }
            }
        }
        DB::commit();
        return response()->json(["code"=>200,'msg'=>'操作成功,设置将在新添加的订单中开始生效','data'=>$return]);
    }

    public function getClass(Request $request) {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        $data = DB::table('sepr_class')
            ->where('shop_id', $shop_id)
            ->get();
        return response()->json(['code' => 200, 'msg' => 'success', 'data' =>$data]);
    }
}