<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\WeChatApplet\Technician\AdminMessageService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

class AdminMessageController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new AdminMessageService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        // $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        // }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $search_data = $this->dataService->searchPage($user_info, $request->all(), 10);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    public function busindex(Request $request)
    {
        // 验证参数
        // $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        // }
        request()->offsetSet('rt', 'business');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $search_data = $this->dataService->busmsgindex($user_info, $request->all(), 10);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 已读消息
    public function readbusmsg(Request $request)
    {
        // 验证参数
        // $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        // }
        request()->offsetSet('rt', 'business');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $return_data = $this->dataService->readbusmsg($user_info, $request);
        return response()->json($return_data);
    }

    // 已读消息
    public function read(Request $request)
    {
        // 验证参数
        // $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        // }
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $return_data = $this->dataService->read($user_info, $request);
        return response()->json($return_data);
    }

    // 未读消息总数
    public function unreadTotal(Request $request)
    {
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $search_data = $this->dataService->unreadTotal($user_info);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 未读消息总数
    public function busunreadTotal(Request $request)
    {
        request()->offsetSet('rt', 'business');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $search_data = $this->dataService->busunreadTotal($user_info);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }
}
