<?php
namespace App\Http\Controllers\WeChatApplet\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

// 个人中心
class PersonalController extends Controller
{
    // 获取页面信息
    public function personal(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::wechatGetUserInfo($request['api_token']);

        $date = date('Y') . '-' . date('m');

        // 查询账号信息
        $find_admin = DB::table('admin as adm')
            ->leftjoin('admin_shop_role as asr', 'asr.adm_id', '=', 'adm.adm_id')
            ->leftjoin('role', 'role.rol_id', '=', 'adm.adm_role_applet')
            ->where('asr.adm_id', $user_info->adm_id)
            ->where('asr.shop_id', $user_info->adm_shop_id)
            ->select('adm.adm_id', 'adm.adm_name', 'adm.adm_account', 'adm.adm_phone', 'asr.shop_cid as adm_cid', 'asr.shop_id as adm_shop_id', 'asr.adm_state', 'rol_state', 'rol_privilege', 'asr.superior_shop_id as adm_superior_shop_id')
            ->first();
        if (empty($find_admin)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前门店账号不存在！']);
        }
        
        // 查询账号设置表的经纬度
        $find_admin_set = DB::table('admin_set')
            ->where('adms_adm_id', $find_admin->adm_id)
            ->where('adms_shop_id', $find_admin->adm_shop_id)
            ->select('adms_province', 'adms_city', 'adms_county', 'adms_address', 'adms_longitude', 'adms_latitude')
            ->first();

        // 查询门店信息
        $find_shop = DB::table('shop')
            ->where('shop_id', $find_admin->adm_shop_id)
            ->select('shop_state', 'shop_superior_id', 'shop_store_name', 'shop_type', 'shop_longitude', 'shop_latitude', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'shop_versions')
            ->first();
        if ($find_shop->shop_state != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前账号所属门店已被停用']);
        }
        if (!empty($find_admin_set)) {
            if ($find_admin_set->adms_longitude != '0' && $find_shop->shop_longitude != '0') {
                $find_shop->shop_longitude = $find_admin_set->adms_longitude;
                $find_shop->shop_latitude = $find_admin_set->adms_latitude;
            }
            if (empty($find_shop->shop_province)) {
                $find_shop->shop_province = $find_admin_set->adms_province;
                $find_shop->shop_city = $find_admin_set->adms_city;
                $find_shop->shop_county = $find_admin_set->adms_county;
            }
        }

        // 获取用户对应角色权限
        $role_auth = $this->getRolePrivilege($find_admin);

        $find_ord_data = DB::table('order as ord')
            ->leftjoin('order_goods as orgo', 'orgo.orgo_ord_id', '=', 'ord.ord_id')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_create_id', $user_info->adm_id)
            ->where('ord_collection_bill', 1)
            ->whereNotIn('orgo_state', [2, 3])
            ->where('ord_delete', 1)
            ->where('ord_create_time', 'like', '%' . $date . '%')
            ->selectRaw('count(ord_id) as num, sum(orgo_goo_quantity * orgo_goo_price) as allprice, sum(orgo_goo_quantity) as allnum, ord_service_type, orgo_state, sum(orgo_goo_quantity * orgo_goo_cost) as allcost, ord_order_number')
            ->groupBy('ord_service_type', 'orgo_state')
            ->get()->toArray();
        $find_ord_data = json_decode(json_encode($find_ord_data), true);
        // 统计订单的服务项目金额
        $find_orcl_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_collection_bill', 1)
            ->where('ord_create_id', $user_info->adm_id)
            ->where('ord_delete', 1)
            ->where('ord_create_time', 'like', '%' . $date . '%')
            ->selectRaw('count(ord_id) as num, orcl_rescue_service_price as service_price, ord_order_number')
            ->get()->toArray();
        $find_orcl_data = json_decode(json_encode($find_orcl_data), true);
        $allshow = [];
        $allprice = 0;//销售合计
        $all_service_price = 0;//服务项目金额合计
        $allnum = 0;//数量合计
        $order_num = 0;//订单量
        foreach ($find_ord_data as $key => $value) {
            if ($value['ord_service_type'] == '4' || $value['orgo_state'] == '4') {
                $allprice -= $value['allprice'];
                $allnum -= $value['allnum'];
            } else {
                $allprice += $value['allprice'];
                $allnum += $value['allnum'];
            }
        }
        foreach ($find_orcl_data as $key => $value) {
            $all_service_price += $value['service_price'];
            $order_num = $value['num'];
        }
        $allshow['profits'] = $allprice;//销售合计
        $allshow['all_service_price'] = $all_service_price;//服务金额合计
        $allshow['allnum'] = $allnum;//数量合计
        $allshow['order_num'] = $order_num;//订单量
        
        // 返回数据
        $return_data = [
            'adm_id' => $find_admin->adm_id,
            'adm_name' => $find_admin->adm_name,
            'adm_phone' => $find_admin->adm_phone,
            'shop_id' => $find_admin->adm_shop_id,
            'shop_store_name' => $find_shop->shop_store_name,
            'shop_type' => $find_shop->shop_type,
            'shop_province' => $find_shop->shop_province,
            'shop_city' => $find_shop->shop_city,
            'shop_county' => $find_shop->shop_county,
            'shop_longitude' => $find_shop->shop_longitude,
            'shop_latitude' => $find_shop->shop_latitude,
            'shop_versions' => $find_shop->shop_versions,
            'role_auth' => $role_auth['role_auth'],
        ];
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data, 'allshow'=>$allshow]);
    }

    /**
     * [getRolePrivilege 获取角色权限]
     * @param  [type] $find_admin [用户信息]
     * @return [type]                [description]
     */
    protected function getRolePrivilege($find_admin)
    {
        $pri_id = explode(',', $find_admin->rol_privilege);
        // 查询权限id对应的权限数据
        $privileges = DB::table('privileges_applet')
            ->whereIn('pri_id', $pri_id)
            ->where('pri_show', 1)
            ->get()->toArray();
        $privileges = json_decode(json_encode($privileges), true);
        $privileges = array_values($privileges);
        foreach ($privileges as $key => $value) {
            // 权限路由
            $privileges_info['routes_auth'][] = 'App\Http\Controllers\\'.$value['pri_controller'].'Controller'.'@'.$value['pri_operate_method'].',';
        }

        // 角色权限
        $privileges_info['role_auth'] = $privileges;
        return $privileges_info;
    }
}
