<?php

namespace App\Http\Controllers\WeChatApplet\AppletSettleIn;
use App\Http\Controllers\Api\AccountManage\BillContrastController;
use App\Http\Models\Api\Common;
use App\Services\CommonService;
use App\Services\SettleIn\SettleInService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use \Illuminate\Support\Facades\Validator;
use DB;

class SettleInController extends Controller
{
    /**
     * 注册验证店铺名称和手机号
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-08-13
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function zhuceYz(Request $request) {
        if (isset($request['phone']) && !empty($request['phone'])) {
            $find_shop = DB::table('shop as a')
                ->where('shop_phone', $request['phone'])
                ->first();
            if ($find_shop) {
                return response()->json(['data'=>'','code'=>501, 'msg'=>'手机号已存在']);
            }
        }
        if (isset($request['shop_name']) && !empty($request['shop_name'])) {
            $shop_exist = DB::table('shop')->where('shop_store_name',$request['shop_name'])->value('shop_id');
            if($shop_exist){
                return response()->json(['data'=>'','code'=>501, 'msg'=>'该门店已存在']);
            }
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'']);
    }

    //申请入驻添加和修改
    public function add(Request $request)
    {
        $input = $request->all();
        DB::beginTransaction();
        $res = SettleInService::settleUp($input);
        if (isset($request['is_zhuce']) && $request['is_zhuce'] == 1) {//申请注册的直接创建账号,不用审核
            if ($res['code'] == 200) {
                $post_data['id'] = $res['data'];
                $post_data['type'] = 2;
                $post_data['status'] = 4;
                $post_data['password'] = $input['password'];
                $edit_res = SettleInService::editSchedule($post_data);
                if ($edit_res) {
                    DB::commit();
                } else {
                    DB::rollBack();
                }
                return $edit_res;
            }
        }
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return $res;
    }

    /**
     * @name 完善信息
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2023/5/23
     * @Time: 10:44
     */
    public function edit(Request $request){
        $input = $request->all();
        $id = $input['id'];
        //修改
        $data = SettleInService::updateSettleData($input,$id);
        return $data;
        /*$message = [
            'weixin.required'=> '微信不能为空',
            'appointment_phone.required'=> '预约电话不能为空',
            'appointment_phone.unique'=> '预约电话已存在',
            'appointment_phone.regex'=> '预约电话号码不正确',
            'address.required'=> '地址不能为空',
            'bussiness_time.required'=> '营业时间不能为空',
        ];
        $rules = [
            'appointment_phone' =>'required|unique:settle_in,appointment_phone',
            'appointment_phone' =>['regex:/^[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}$/'],
            'address'=>'required',
            'bussiness_time'=>'required',
        ];
        $Validator = Validator::make($request->all(),$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>500, 'msg'=>$Validator->errors()->first()]);exit;
        }
      //  request()->offsetSet('rt', 'wechatWash');//微信用户信息

        return SettleInService::add($input);*/
    }

    /*
     * @name 修改状态
     * @param array
     * @retrun array
     * @author Ma 2023/7/11 11:54
     *
    */
    public function upStatus(Request $request){
        $input = $request->all();
        if(isset($input['shop_id'])){
            $shop = DB::table('shop')->where('shop_id',$input['shop_id'])->first();
            if(empty($shop)){
                return response()->json(['code'=> 500, 'msg'=>'数据异常请联系技术人员', 'data'=>'']);
            }
            $shop = CommonService::dataToArray($shop);
            if($input['type'] == 1){//获取
                //状态 1待审核 2无需审核 3已联系 4已通过 5已驳回
                $res = DB::table('settle_in')->where('shop_id',$input['shop_id'])->first();
                if(empty($res)){
                    $res = DB::table('settle_in')->where('phone',$shop['shop_phone'])->where('shop_id',0)->first();
                    if($res){
                        DB::table('settle_in')->where('id',$res->id)->update(['shop_id'=>$input['shop_id']]);//无需审核和驳回可以再次申请
                    }
                }
                if($res){
                    if($res->status == 1 || $res->status == 3){//提价完成，并且是待审核或者驳回状态
                        return response()->json(['code'=> 200, 'msg'=>'审核中', 'data'=>$res->status]);
                    }
                    if($res->status==6){
                        return response()->json(['code'=> 200, 'msg'=>'', 'data'=>2]);
                    }
                    return response()->json(['code'=> 200, 'msg'=>'', 'data'=>$res->status]);
                }else{
                    return response()->json(['code'=> 500, 'msg'=>'暂无数据', 'data'=>'']);
                }
            }else{
                $res = DB::table('settle_in')->where('shop_id',$input['shop_id'])->whereIn('status',[1,3])->where('submit_end',2)->first();//待审核和已联系不可以申请
                if($res){
                    return response()->json(['code'=> 200, 'msg'=>'审核中', 'data'=>$res->status]);
                }else{
                    $find_data = DB::table('settle_in')
                        ->where('shop_id',$input['shop_id'])
                        ->first();
                    $post_data['id'] = $find_data->id;
                    $res = DB::table('settle_in')->where('shop_id',$input['shop_id'])->whereIn('status',[2,5])->update(['status'=>1,'submit_end'=>2]);//无需审核和驳回可以再次申请
                    $post_data['type'] = 2;
                    $post_data['status'] = 4;
                    $edit_res = SettleInService::editSchedule($post_data);
                    return $edit_res;
                }
            }
        }
        return response()->json(['code'=> 500, 'msg'=>'暂无数据', 'data'=>'']);
    }

    /**
     * @name 详情
     * @param Request $request id 数据ＩＤ
     * @return mixed
     * @author du
     * @date 2023/5/18
     * @Time: 14:15
     */
    public function info(Request $request)
    {
        $input = $request->all();
        return SettleInService::getInfo($input);
    }

    /**
     * @name 获取最后一条进度信息
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/5/23
     * @Time: 11:50
     */
    public function getScheduleinfoById(Request $request){
        $input = $request->all();
        return SettleInService::getScheduleinfo($input);
    }

    // 列表每页显示数据个数
    protected $show_count = 10;


    /**
     * @name 技师列表
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/5/19
     * @Time: 16:39
     */
    public function index(Request $request)
    {
        $input = $request->all();
        return SettleInService::listPerson($input, $this->show_count);
    }

    /**
     * @name 添加技师
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|int
     * @author du
     * @date 2023/5/19
     * @Time: 17:33
     */
    public function addPerson(Request $request){
        $input = $request->all();
        $message = [
            'adm_name.required'=> '姓名不能为空',
            'adm_phone.required'=> '电话不能为空',
//            'adm_phone.unique'=> '电话已存在',
            'adm_phone.regex'=> '电话号码不正确',
            'phone'=> '入驻商电话不能为空',
           /* 'adm_password.required'=> '密码不能为空',
           // 'adm_password.confirmed' => '两次输入的密码不一致',
            'adm_password.max'=> '登录密码长度不能超过10个字符',
            'adm_password.min'=> '登录密码长度不得小于6个字符',*/
        ];
        $rules = [
            'adm_name' =>'required',
            'adm_phone' =>'required',
            'adm_phone' =>['regex:/^[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}$/'],
//            'adm_phone' =>'unique:admin',
            'phone' =>'required',
            //'adm_password' => 'required|string|min:6|max:10',//
        ];
        $Validator = Validator::make($request->all(),$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>$Validator->errors()->first()]);exit;
        }
        $input['type']= 3;
        return SettleInService::addShopPerson($input);
    }

    /**
     * @name　编辑技师
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|int
     * @author du
     * @date 2023/5/19
     * @Time: 18:00
     */
    public function editPerson(Request $request){
        $input = $request->all();
        $message = [
            'adm_name.required'=> '姓名不能为空',
            'adm_phone.required'=> '电话不能为空',
           // 'adm_phone.unique'=> '电话已存在',
            'adm_phone.regex'=> '电话号码不正确',
            'adm_id' => 'ID不能为空',
            'adm_state' => '状态不能为空'

        ];
        $rules = [
            'adm_name' =>'required',
            'adm_phone' =>'required',
            'adm_phone' =>['regex:/^[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}$/'],
            'adm_id' => 'required',
            'adm_state' => 'required',
        ];
        $Validator = Validator::make($request->all(),$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>$Validator->errors()->first()]);exit;
        }
        $input['type']= 2;
        return SettleInService::addShopPerson($input);
    }

    /**
     * @name 重置密码
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|int
     * @author du
     * @date 2023/5/22
     * @Time: 8:34
     */
    public function resetPassword(Request $request){
        $input = $request->all();
        $message = [
            'adm_id' => 'ID不能为空',
        ];
        $rules = [
            'adm_id' => 'required',
        ];
        $Validator = Validator::make($request->all(),$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>$Validator->errors()->first()]);exit;
        }
        $input['type']= 1;
        return SettleInService::addShopPerson($input);
    }

    /**
     * @name 修改密码
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|int
     * @author du
     * @date 2023/5/22
     * @Time: 15:57
     */
    public function editPassword(Request $request){
        $input = $request->all();
        $message = [
            'adm_password_y.required'=> '原密码不能为空',
            'adm_password.required'=> '新密码不能为空',
            'adm_password.confirmed' => '两次输入的密码不一致',
            'adm_password.max'=> '登录密码长度不能超过15个字符',
            'adm_password.min'=> '登录密码长度不得小于6个字符',
        ];
        $rules = [
            'adm_password_y' =>'required',
            'adm_password' =>'required',
            'adm_password' => 'required|string|confirmed|min:6|max:15',//密码为6-10位字符串，验证密码重复confirmed必须要有字段password_confirmation 进行验证
        ];
        $Validator = Validator::make($request->all(),$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>$Validator->errors()->first()]);exit;
        }
        $input['type']= 4;
        return SettleInService::addShopPerson($input);
    }

    /**
     * @name 未出账单列表
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/5/24
     * @Time: 11:22
     */
    public function listOrder(Request $request){
        $input = $request->all();
        return SettleInService::getSettlmOrder($input, $this->show_count);
    }

    /**
     * @name 确认账单
     * @param Request $request
     * @param sdob_id 账单ＩＤ　type　２
     * @author du
     * @date 2023/5/25
     * @Time: 11:04
     */
    public function confirmOrder(Request $request){
        $input = $request->all();
        $input['ip'] = $request->ip();
        $message = [
            'sdob_id.required'=> '账单ＩＤ必传',
        ];
        $rules = [
            'sdob_id' =>'required',
        ];
        $Validator = Validator::make($request->all(),$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>$Validator->errors()->first()]);exit;
        }

        return SettleInService::confirm($input);

    }

    /**
     * @name 已出账单
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/5/24
     * @Time: 11:36
     */
    public function listSdOrderBill(Request $request){
        $input = $request->all();
        return SettleInService::getSdOrderBill($input, $this->show_count);
    }


    /**
     * @name 账单详情
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/7
     * @Time: 18:01
     */
    public function billDetail(Request $request){
        if(!$request->filled('id')){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>'账单ID必传']);exit;
        }
        $input = $request->all();
        return SettleInService::billDetail($input, $this->show_count);
    }


    /**
     * @name 上传发票
     * @param Request $request
     * @return int
     * @author du
     * @date 2023/5/24
     * @Time: 15:07
     */
    public function uploadInv(Request $request){
        $input = $request->all();
        $input['ip'] = $request->ip();
        $message = [
            'inv_num.required'=> '发票号不能为空',
        ];
        $rules = [
            'inv_num' =>'required',
        ];
        $Validator = Validator::make($request->all(),$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>$Validator->errors()->first()]);exit;
        }
        return SettleInService::uploadInv($input);
    }

    /**
     * @name 获取发票类型
     * @return string[]
     * @author du
     * @date 2023/5/30
     * @Time: 9:30
     */
    public function getInvType(){
        $ret = SettleInService::getInvType(false);
        return response()->json(['code'=> 200,'msg'=>'获取成功','data'=>$ret]);
    }

    /**
     * @name 获取服务范围
     * @author du
     * @date 2023/6/5
     * @Time: 13:58
     */
    public function getServiceScope(Request $request){
        $input = $request->all();
        $ret = SettleInService::getTypeName($input['type']);
        return response()->json(['code'=> 200,'msg'=>'获取成功','data'=>$ret]);
    }

    /**
     * @name 获取车间类型
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/6
     * @Time: 9:59
     */
    public function getSettleWorkshop(){
        $ret = SettleInService::getSettleWorkshop(false);
        return response()->json(['code'=> 200,'msg'=>'获取成功','data'=>$ret]);
    }

    /**
     * @name 获取是否能洗车
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/6
     * @Time: 10:00
     */
    public function getSettleWashCar(){
        $ret = SettleInService::getSettleWashCar(false);
        return response()->json(['code'=> 200,'msg'=>'获取成功','data'=>$ret]);
    }

    /**
     * @name 获取付款方式
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/6
     * @Time: 10:07
     */
    public function getPayType(){
        $ret = SettleInService::getPayType(false);
        return response()->json(['code'=> 200,'msg'=>'获取成功','data'=>$ret]);
    }

    /**
     * @name 获取品牌
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/8
     * @Time: 17:31
     */
    public function getBrands(){
        $ret = SettleInService::getAdBrandsName(false);
        return response()->json(['code'=> 200,'msg'=>'获取成功','data'=>$ret]);
    }

    /**
     * @name 获取一条发票信息
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/8
     * @Time: 11:56
     */
    public function getInvImg(Request $request){
        $input = $request->all();
        if(!$request->filled('wat_num')){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>'账单号必传']);exit;
        }
        return SettleInService::getInvImg($input);
    }

    /**
     * @name 是否存在此定单
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/8
     * @Time: 15:36
     */
    public function isExsitOrderNum(Request $request){
        $input = $request->all();
        if(!$request->filled('ord_other_system_number')){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>'智配单号必传']);exit;
        }
        return SettleInService::isExsitOrderNum($input);

    }

    /**
     * @name 接单
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/9
     * @Time: 8:53
     */
    public function receivingOrder(Request $request){
        $input = $request->all();
        $input['ip'] = $request->ip();
        if(!$request->filled('ord_id')){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>'单号ID必传']);exit;
        }
        return SettleInService::orderReceiving($input);
    }

    /**
     * @name 拒单
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/12
     * @Time: 15:44
     */
    public function refuseOrder(Request $request){
        $input = $request->all();
        $input['ip'] = $request->ip();
        if(!$request->filled('ord_id')){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>'单号ID必传']);exit;
        }
        return SettleInService::orderRefuse($input);
    }

    /**
     * @name 获取拒单标签
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/12
     * @Time: 15:45
     */
    public function getRefuseLable(){
        return SettleInService::refuseLabel();
    }

    /*
     * @name 根据经纬度获取省市区
     * @param string 经纬度
     * @retrun array
     * @author Ma 2023/7/18 14:41
     *
    */
    public function getAddress(Request $request){
        $input = $request->all();
        $data = CommonService::getDress($input['location']);
        if($data['code'] == 1){
            $data = $data['data'];
            $ret['province'] = $data['address_component']['province'];
            $ret['city'] = $data['address_component']['city'];
            $ret['county'] = $data['address_component']['district'];
            return response()->json(['code'=> 200,'msg'=>'获取成功','data'=>$ret]);
        }
        return response()->json(['code'=> 500,'msg'=>'获取失败','data'=>'']);
    }

}

