<?php
namespace App\Http\Controllers\SettleIn;
use App\Services\SettleIn\SettleInService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use \Illuminate\Support\Facades\Validator;


class SettleInController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    
    /**
     * @name 列表
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2023/5/18
     * @Time: 10:30
     */
    public function index(Request $request)
    {
        $input = $request->all();
        return SettleInService::getList($input, $request['show_count']);
    }


    /**
     * @name 跟进状态
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2023/5/18
     * @Time: 14:12
     */
    public function editStatus(Request $request)
    {
        $input = $request->all();
        $input['ip'] = $request->ip();
      //  request()->offsetSet('rt', 'wechatWash');//微信用户信息
        return SettleInService::editSchedule($input);
    }

    /**
     * @name 审核
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2023/5/18
     * @Time: 14:15
     */
    public function info(Request $request)
    {
        $input = $request->all();
        return SettleInService::getInfo($input);
    }

    /**
     * @name 详情
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2023/6/9
     * @Time: 16:00
     */
    public function exmInfo(Request $request)
    {
        $input = $request->all();
        return SettleInService::getInfo($input);
    }

    /**
     * @name 创建账号
     * @param Request $request (shop_store_name:门店名称;shop_name']; //联系人;shop_phone']; //联系人电话;shop_province']; //省;shop_city']; //市;shop_county']; //县;shop_address']; //详细地址;shop_password 密码；)
     * @author du
     * @date 2023/5/18
     * @Time: 14:39
     */
    public function creatAccout(Request $request){
        $input = $request->all();
        $message = [
            'id' => '入驻信息ID',
            'shop_store_name.required'=> '门店不能为空',
            'shop_store_name.unique'=> '门店名已存在',
            'shop_phone.required'=> '电话不能为空',
            'shop_phone.unique'=> '电话已存在',
            'shop_phone.regex'=> '电话号码不正确',
            'shop_name.required'=> '姓名不能为空',
            'shop_address.required'=> '地址不能为空',
            'goods_ids.required'=> '服务项目不能为空',
            'shop_password' => '密码不能为空',
            'shop_password.max'=> '登录密码长度不能超过15个字符',
            'shop_password.min'=> '登录密码长度不得小于6个字符',
        ];
        $rules = [
            'id' => 'required',
            'shop_name' =>'required|unique:shop,shop_store_name',
            'shop_phone' =>'required|unique:admin,shop_phone',
            'shop_phone' =>['regex:/^[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}$/'],
            'shop_address'=>'required',
            'goods_ids'=>'required',
            //'shop_password'=>'required',
            'shop_password' => 'required|string|min:6|max:15',
        ];

        $Validator = Validator::make($request->all(),$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>$Validator->errors()->first()]);exit;
        }
        return SettleInService::createAccount($input);
    }

    /**
     * @name 获取状态
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2023/6/6
     * @Time: 10:34
     */
    public function getStaues(){
        $ret = SettleInService::getSettleStatus(false);
        return response()->json(['code'=> 200,'msg'=>'获取成功','data'=>$ret]);
    }
    
    /*
     * @name 智配审核后同步美装系统
     * @param $request
     * @retrun array 
     * @author Ma 2023/7/6 11:45
     * 
    */
    public function synchronousData(Request $request){
        $input = $request->all();
        return SettleInService::synchronousData($input);
    }
}

