<?php

namespace App\Http\Controllers\Mounting\Verify\BasicManage;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

// 验车管理验证器
class VerifyValidateCarController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vacm_unusual_name.required' => '请输入:异常名称',
            'vacm_unusual_name.max' => '议程名称长度超过最大限制',
            'vacm_type.required' => '请选择模块',
            'vacm_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vacm_unusual_name' => 'required|max:20',
            'vacm_remark' => 'sometime|max:255',
            'vacm_type' => [
                'required',
                Rule::in([1,2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vacm_id.required' => '参数错误',
            'vacm_id.integer' => '参数错误',
            'vacm_unusual_name.required' => '请输入:异常名称',
            'vacm_unusual_name.max' => '议程名称长度超过最大限制',
            'vacm_type.required' => '请选择模块',
            'vacm_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vacm_id' => 'required|integer',
            'vacm_unusual_name' => 'required|max:20',
            'vacm_remark' => 'sometime|max:255',
            'vacm_type' => [
                'required',
                Rule::in([1,2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vacm_id.required' => '参数错误',
            'vacm_id.array' => '参数错误',
            'vacm_type.required' => '请选择模块',
            'vacm_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vacm_id' => 'required|array',
            'vacm_type' => [
                'required',
                Rule::in([1, 2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索验车管理数据
    public function searchValidateCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择门店',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
            'vacm_type.required' => '请选择模块',
            'vacm_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'vacm_type' => [
                'required',
                Rule::in([1, 2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
