<?php
/*
|--------------------------------------------------------------------------
| 技师职称管理控制器
|--------------------------------------------------------------------------
|
|  @Date: 2021/8/18
|  @Time: 14:11
|  @version 1.0
|  @copyright BlueCity
*/
namespace App\Http\Controllers\Mounting;

use App\Services\LoginUserService;
use App\Services\TechnicalTitleService;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Traits\ResourceControllerMethod;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use Illuminate\Http\Request;

class TechnicalTitleController extends Controller
{
    public $dataService = null;  // ResourceControllerMethod 必备参数
//    public $dataFields = ['grpr_name', 'grpr_remark', 'grpr_state', 'grpr_delete'];  // 保存和修改时的 fields 参数
    protected $validateRules = [
        'rules' => [
            'grpr_name' => 'required'
        ],
        'messages' => [

        ],
        'attributes' => [
            'grpr_name' => '职位名称',
            'grpr_remark' => '备注',
        ]
    ];

    public function __construct()
    {
        $service = new TechnicalTitleService();
        $this->bootWithService($service);
    }

    use ResourceControllerMethod;

    /**
     * @api {get} /api/mounting/technicalTitle 技师职称列表
     * @apiGroup technical
     * @apiName 技师管理
     * @apiVersion 1.0.0
     *
     * @apiDescription 技师职称管理列表
     *
     * @apiParam {String} keywords      关键字
     * @apiParam {String} page          页码
     * @apiParam {String} page_size     页容量
     *
     * @apiSuccess {Number} error       状态码，0：请求成功
     * @apiSuccess {String} msg         提示信息
     * @apiSuccess {Object} data        返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常","data":[]}
     *
     */

    public function _beforeStore($request) {
        $exist = TechnicalTitleService::nameExists($request->get('grpr_name'));
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }

        return false;
    }

    public function _setStore($data) {
        $userInfor = LoginUserService::getUser();
        $data['grpr_shop_id'] = $userInfor['adm_shop_id'];
        $data['grpr_superior_shop_id'] = $userInfor['shop_superior_id'];
        $data['grpr_cid'] = $userInfor['adm_cid'];
        $data['grpr_state'] = 1;
        $data['grpr_delete'] = 1;

        return $data;
    }

    public function _beforeUpdate($request, $id) {
        $exist = TechnicalTitleService::nameExists($request->get('grpr_name'), $id);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }

        return false;
    }

    public function setEnable(int $ID, Request $request) {
        $entity = TechnicalTitleService::getByID($ID);
        if (empty($entity)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        }
        $state = $request->get('enable');
        if ($state != 1 && $state != 2) {
            return $this->error('状态码错误', ErrorInc::INVALID_PARAM);
        }
        $res = TechnicalTitleService::setEnable($ID, $state);
        if ($res) {
            $this->success('更新成功');
        }
        return $this->error('更新失败', ErrorInc::MYSQL_FAILED);
    }

}
