<?php

namespace App\Http\Controllers\Mounting\Shop;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Shop\VipCardService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use \PhpOffice\PhpSpreadsheet\IOFactory;

// 会员卡管理
class VipCardController extends Controller
{
    public function __construct()
    {
        $this->dataService = $service = new VipCardService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        if (!isset($request['show_count'])) {
            $request['show_count'] = 10;
        }

        // 查询字段
        $field_columns = ['vica_id', 'vica_name', 'vica_sepr_id', 'vica_sepr_name', 'vica_num', 'vica_price', 'vica_effective_date', 'vica_instructions', 'vica_create_time', 'vica_create_adm_id', 'vica_update_time', 'vica_update_adm_id', 'vica_state', 'vica_long_term'];
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($user_info, $request->all(), $request['show_count'], $field_columns);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button]);
        }
    }

    // 我的会员卡管理列表
    public function vipCardIndex(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->vipCardIndexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 查询字段
        $field_columns = ['myvi_id', 'myvi_adm_id', 'myvi_num', 'myvi_create_adm_id', 'myvi_create_time', 'myvi_surplus_times', 'myvi_all_times', 'myvi_effective_date', 'myvi_state', 'myvi_carnum', 'myvi_name', 'myvi_sepr_id', 'myvi_sepr_name', 'myvi_end_time', 'myvi_long_term'];
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $search_data = $this->dataService->vipCardIndex($user_info, $request->all(), 50, $field_columns);
        if ($search_data['code'] == 500) {
            DB::rollBack();
            return response()->json($search_data);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], 66);
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button]);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $exist = VipCardService::nameExists($user_info, $request->all(), 0);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }
        if ($request['vica_shop_price'] <= $request['vica_price']) {
            return $this->error('门店价要大于零售价', ErrorInc::INVALID_PARAM);
        }
        $res = VipCardService::add($user_info, $request->all());
        if ($res['code'] == 200) {
            OperationLog::addLog($user_info, getRealIp($request), '会员卡', '新增', '新增'.$request['bucl_name'].'成功');
            return $this->success('新增成功');
        } else {
            return response()->json($res);
            // return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 新增会员卡
    public function addvipcard(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addvipcardValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = VipCardService::addvipcard($user_info, $request->all());
        if ($res['code'] == 200) {
            OperationLog::addLog($user_info, getRealIp($request), '会员列表', '新增会员卡', '新增成功');
            DB::commit();
            return $this->success('新增成功');
        } else {
            DB::rollBack();
            return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 会员卡明细
    public function detailIndex(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->detailIndexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 查询字段
        $field_columns = ['vcre_id', 'vcre_myvi_id', 'vcre_user_id', 'vcre_ord_num', 'vcre_ord_id', 'vcre_create_time', 'vcre_car_adm_name', 'vcre_car_adm_phone', 'vcre_myvi_num', 'myvi_name', 'vcre_log', 'vcre_num_change', 'orcl_car_num','vcrd_num', 'myvid_data_name','myvid_surplus_times', 'myvid_data_id','myvid_type', 'vcrd_description'];
        $res = VipCardService::detailIndex($user_info, $request->all(), 10, $field_columns);
        if (empty($res)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            // 获取当前列表下的按钮
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res]);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $return_data = DB::table('vip_card')
                ->where('vica_id', $request['vica_id'])
                ->select('vica_id', 'vica_name', 'vica_sepr_id', 'vica_sepr_name', 'vica_num', 'vica_price', 'vica_effective_date', 'vica_instructions', 'vica_long_term')
                ->first();
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $exist = VipCardService::nameExists($user_info, $request->all(), $request['vica_id']);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }

        $res = VipCardService::edit($user_info,$request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '会员卡', '编辑', '编辑成功');
            return $this->success('编辑成功');
        } else {
            return $this->error('编辑失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 上架
    public function start(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = VipCardService::editState($request['vica_id'], 1);
        if ($res) {
            // 获取启用的名称
            OperationLog::addLog($user_info, getRealIp($request), '会员卡', '上架', '上架成功');
            return $this->success('上架成功');
        } else {
            return $this->error('上架失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 下架
    public function stop(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = VipCardService::editState($request['vica_id'], 2);
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '会员卡', '下架', '下架成功');
            return $this->success('下架成功');
        } else {
            return $this->error('下架失败', ErrorInc::MYSQL_FAILED);
        }
    }
}