<?php

namespace App\Http\Controllers\Mounting\Shop;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Shop\ShopService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use \PhpOffice\PhpSpreadsheet\IOFactory;
use Illuminate\Support\Facades\Crypt;
use App\Services\CommonService;
use App\Services\Business\WashOrderService;

// 新增门店
class ShopController extends Controller
{
    public function __construct()
    {
        $this->dataService = $service = new ShopService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $url = config('apisystem.gyl_server_name') . '/index.php/api/m1/Product/list';
        // $request['page'] = 2;
        // $param['ip'] = getRealIp($request);
        // $param['time'] = date('Y-m-d H:i:s'); //
        // $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
        $doPost_res = Common::doPost($request, $url, 2);
        $doPost_res = json_decode($doPost_res);
        // 获取当前列表下的按钮
        if ($doPost_res->code != 200) {
            return response()->json(['code'=>200, 'msg'=>'未找到数据', 'data'=>[]]);
        } else {
            return response()->json($doPost_res);
        }
    }

    // 获取产品信息
    public function getProduct(Request $request)
    {
        $url = config('apisystem.gyl_server_name') . '/index.php/getProduct';
        $param['type'] = $request['type'];
        $param['ip'] = getRealIp($request);
        $param['time'] = date('Y-m-d H:i:s'); //收货时间
        $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
        $doPost_res = Common::doPost($param, $url, 2);
        $doPost_res = json_decode($doPost_res);
        if ($doPost_res->code != 200) {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
        }
        // 接收数据流
        $request= file_get_contents("php://input");
        //解析
        Common::write_log($request);
        $request = json_decode($request, true);
        if (empty($request['brand_name']) || empty($request['pg_series']) || empty($request['good_name']) || empty($request['pg_id']) || empty($request['type'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }
        $token = md5(md5($request['time'].'c883e5e641818d993a2d8d966ca450bf'));
        if ($request['token'] != $token) {
            return response()->json(['code'=>203, 'msg'=>'token校验失败']);
        }
        DB::beginTransaction();

        if ($request['type'] == 3) {
             // 直接删除数据
            $rego_id = DB::table('relationship_goods')
                ->where('rego_sd_goo_id', $request['pg_id'])
                ->delete();
            $regd_id = true;
        }else{
            // type类型：1添加2编辑3删除
            $id = DB::table('relationship_goods')
                ->where('rego_sd_goo_id',$request['pg_id'])
                ->value('rego_sd_goo_id');
            if (empty($id)) {
                $rego_add_data['rego_cid'] = 1;//公司id
                $rego_add_data['rego_sd_goo_id'] = $request['pg_id'];//速电商品id
                $rego_add_data['rego_goo_name'] = $request['good_name'];//速电商品名称
                $rego_add_data['rego_goo_encode'] = $request['product_version'];//速电商品编号
                $rego_add_data['rego_cate_name'] = $request['pg_series'];//品类
                $rego_add_data['rego_bra_name'] = $request['brand_name'];//品牌
                $rego_id = DB::table('relationship_goods')->insertGetid($rego_add_data);
                $regd_add_data['regd_rego_id'] = $rego_id;
                $regd_add_data['regd_update_time'] = date('Y-m-d H:i:s');
                $regd_id = DB::table('replenishment_goods_details')->insert($regd_add_data);
            } else {
                $rego_edit_data['rego_goo_name'] = $request['good_name'];//商品名称
                $rego_edit_data['rego_goo_encode'] = $request['product_version'];//商品编号
                $rego_edit_data['rego_cate_name'] = $request['pg_series'];//品类
                $rego_edit_data['rego_bra_name'] = $request['brand_name'];//品牌
                $rego_id = DB::table('relationship_goods')
                    ->where('rego_sd_goo_id', $request['pg_id'])
                    ->update($rego_edit_data);
                $regd_id = true;
            }
        }
        if ($rego_id && $regd_id) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'回传成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>201, 'msg'=>'回传失败']);
        }
    }

    // 新增门店
    public function addShop(Request $request)
    {
        $get_ip = getRealIp($request); //获取ip
        // 接收数据流
        $request = file_get_contents("php://input");
        // // 解析
        Common::write_log($request, 1, 'addShop');
        $request = json_decode($request, true);

        // 验证参数
        $error_message = $this->dataService->mainValidator->addShopValidator($request);
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        DB::beginTransaction();
        $res = ShopService::addShop($request);
        if ($res['code'] == 200) {
            DB::commit();
            return $this->success('新增成功');
        } else {
            DB::rollBack();
            return response()->json($res);
        }
    }

    // 验证手机号
    public function verifyPhone(Request $request)
    {
        $get_ip = getRealIp($request); //获取ip
        // 接收数据流
        $request = file_get_contents("php://input");
        if (empty($request)) {
            return $this->error('请输入手机号', ErrorInc::INVALID_PARAM);
        }
        // // 解析
        Common::write_log($request, 1, 'verifyPhone');
        $request = json_decode($request, true);

        // 验证参数
        $error_message = $this->dataService->mainValidator->verifyPhoneValidator($request);
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // $exist = ShopService::shopNameExists($request, 0);
        // if ($exist) {
        //     return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        // }
        if (!isset($request['shop_id'])) {
            $request['shop_id'] = 0;
        }
        DB::beginTransaction();
        $res = ShopService::verifyPhone($request,$request['shop_id']);
        if (!$res) {
            return $this->success('手机号可用');
        } else {
            return $this->error('手机号已存在', ErrorInc::INVALID_PARAM);
        }
    }

    // 编辑门店
    public function editShop(Request $request)
    {
        $get_ip = getRealIp($request); //获取ip
        // 接收数据流
        $request = file_get_contents("php://input");
        // // 解析
        Common::write_log($request, 2, 'editShop');
        $request = json_decode($request, true);

        // 验证参数
        $error_message = $this->dataService->mainValidator->editShopValidator($request);
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        DB::beginTransaction();
        $res = ShopService::editShop($request);
        if ($res['code'] == 200) {
            DB::commit();
            return $this->success('新增成功');
        } else {
            DB::rollBack();
            return response()->json($res);
        }
    }

    /**
     * 分店列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function bindIndex(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->bindIndexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::bindIndex($user_info,$request,$request['show_count']);
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        //获取top按钮
        $sea_button_data = 'addBindShop,bindShop,buyShop';
        $sea_button_data = CommonService::getTopButton('',$sea_button_data,$list_button);
        // 获取当前列表下的按钮
        if (empty($res)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res, 'searech_button'=>$sea_button_data]);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            foreach ($res['list'] as $key => $value) {
                if ($list_button) {
                    foreach ($list_button as $key_b => $value_b) {
                        if ($value_b['pri_operate_method'] == 'editBindShop') {//编辑
                            $res['list'][$key]->list_button_one[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'stopBindshop' && $value->bish_state == 1) {//停用
                            $res['list'][$key]->list_button_two[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'startBindshop' && $value->bish_state == 2) {//启用
                            $res['list'][$key]->list_button_two[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'shopAdmin') {//员工管理
                            $res['list'][$key]->list_button_two[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'editShopRole') {//店铺权限
                            $res['list'][$key]->list_button_two[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'addmsg') {//短信充值
                            $res['list'][$key]->list_button_two[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'subtraction') {//短信扣除
                            $res['list'][$key]->list_button_two[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'addspace') {//空间充值
                            $res['list'][$key]->list_button_two[] = $value_b;
                        }
                        if ($value_b['pri_operate_method'] == 'changeSpace') {//划拨空间
                            $res['list'][$key]->list_button_two[] = $value_b;
                        }
                    }
                }
            }
            
            // 获取当前列表下的按钮
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res, 'searech_button'=>$sea_button_data]);
        }
    }

    /**
     * 绑定门店-新增分店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function addBindShop(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addShopValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $request['shop_superior_id'] = $user_info->adm_shop_id;
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->select('shop_free_shop', 'shop_toll_shop')
            ->first();
        $shop_num = $find_shop->shop_free_shop + $find_shop->shop_toll_shop;
        $find_bind_shop = DB::table('bind_shop')
            ->where('bish_fshop_id', $user_info->adm_shop_id)
            ->where('bish_state', 1)
            ->count();
        if ($shop_num <= $find_bind_shop) {
            return response()->json(["code" => 500, 'msg' => '分店数量已超出，请先前往购买或注销其他分店', 'data' => '']);
        }
        $res = ShopService::addShop($user_info,$request->all());
        if ($res['code'] == 200) {
            $find_shop = DB::table('shop')
                ->where('shop_id', $res['data'])
                ->first();
            $post_data['shop_code'] = $find_shop->shop_code;
            if (!isset($request['bish_shop_type']) || empty($request['bish_shop_type'])) {
                return response()->json(['code'=>500, 'msg'=>'请选择门店类型', 'data'=>'']);
            }
            $post_data['bish_shop_type'] = $request['bish_shop_type'];
            $result = ShopService::bindShop($user_info,$post_data);
            $find_shop_up = DB::table('shop')
                ->where('shop_id', $user_info->adm_shop_id)
                ->first();
            $update_data['shop_versions'] = $find_shop_up->shop_versions;
            $update_data['shop_opening_type'] = $find_shop_up->shop_opening_type;
            $update_data['shop_on_trial_start_time'] = $find_shop_up->shop_on_trial_start_time;
            $update_data['shop_on_trial_end_time'] = $find_shop_up->shop_on_trial_end_time;
            $update_data['shop_opening_start_time'] = $find_shop_up->shop_opening_start_time;
            $update_data['shop_opening_end_time'] = $find_shop_up->shop_opening_end_time;
            if ($res['data']) {
                $find_shop_up = DB::table('shop')
                    ->where('shop_id', $res['data'])
                    ->update($update_data);
            }
            if ($result['code'] == 200) {
                Common::addLog($user_info, getRealIp($request), '分店管理', '新增分店', '新增成功');
                DB::commit();
                return response()->json($result);
            }
        } else {
            DB::rollBack();
            return response()->json($res);
        }
    }

    public function addOrder(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $add_order_res = ShopService::addOrder($user_info, $request);
        if ($add_order_res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($add_order_res);
        
        $url = config('apisystem.gyl_server_name') . '/index.php/getProduct';
        $param['type'] = $request['type'];
        $param['ip'] = getRealIp($request);
        $param['time'] = date('Y-m-d H:i:s'); //收货时间
        $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
        $doPost_res = Common::doPost($param, $url, 2);
        $doPost_res = json_decode($doPost_res);
    }

    // 新增分类
    public function addClassification(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addClassificationValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $exist = ShopService::nameExists($user_info, $request->all(), 0);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }
        DB::beginTransaction();
        $res = ShopService::addClassification($user_info, $request->all());
        if ($res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '新增分类', '新增成功');
            return $this->success('新增成功');
        } else {
            DB::rollBack();
            return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 编辑分类
    public function editClassification(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editClassificationValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $exist = ShopService::nameExists($user_info, $request->all(), $request['gocl_id']);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }
        DB::beginTransaction();
        $res = ShopService::editClassification($user_info, $request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '编辑分类', '编辑成功');
            DB::commit();
            return $this->success('编辑成功');
        } else {
            DB::rollBack();
            return $this->error('编辑失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 会员卡明细
    public function claIndex(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->detailIndexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 查询字段
        $field_columns = ['vcre_id', 'vcre_myvi_id', 'vcre_user_id', 'vcre_ord_num', 'vcre_ord_id', 'vcre_create_time', 'vcre_car_adm_name', 'vcre_car_adm_phone', 'vcre_myvi_num', 'myvi_name', 'vcre_log', 'vcre_num_change', 'orcl_car_num'];
        $res = VipCardService::detailIndex($user_info, $request->all(), 10, $field_columns);
        if (empty($res)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            // 获取当前列表下的按钮
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res]);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $return_data = $this->dataService->info($user_info, $request->all());
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $exist = ShopService::goodsnameExists($user_info, $request->all(), $request['pait_id']);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }
        DB::beginTransaction();
        $res = ShopService::edit($user_info,$request->all());
        if ($res['code'] ==200) {
            // 生成操作记录
            $palo_res = paitLog($user_info, $request['pait_id'], '编辑商品', '');
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '编辑', '编辑成功');
            DB::commit();
            return $this->success('编辑成功');
        } else {
            DB::rollBack();
            return response()->json($res);
        }
    }

    // 开启
    public function claStart(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->claStartValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::editState($request['gocl_id'], 1);
        if ($res) {
            // 获取启用的名称
            OperationLog::addLog($user_info, getRealIp($request), '商品分类', '开启', '开启成功');
            DB::commit();
            return $this->success('开启成功');
        } else {
            DB::rollBack();
            return $this->error('开启失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 分类关闭
    public function claStop(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->claStartValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::editState($request['gocl_id'], 2);
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '会员卡', '关闭', '关闭成功');
            DB::commit();
            return $this->success('关闭成功');
        } else {
            DB::rollBack();
            return $this->error('关闭失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 上架
    public function start(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $pait_saleable_quantity = DB::table('package_items')
            ->where('pait_id', $request['pait_id'])
            ->value('pait_saleable_quantity');
        if ($pait_saleable_quantity <= 0) {
            return $this->error('可售数量为0，请补货后上架', ErrorInc::INVALID_PARAM);
        }
        $res = ShopService::goodseditState($request['pait_id'], 1);
        if ($res) {
            // 生成操作记录
            $palo_res = paitLog($user_info, $res, '上架商品', '');
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '上架', '上架成功');
            DB::commit();
            return $this->success('上架成功');
        } else {
            DB::rollBack();
            return $this->error('上架失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 下架商品
    public function stop(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::goodseditState($request['pait_id'], 2);
        if ($res) {
            // 生成操作记录
            $palo_res = paitLog($user_info, $res, '下架商品', '');
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '下架', '下架成功');
            DB::commit();
            return $this->success('下架成功');
        } else {
            DB::rollBack();
            return $this->error('下架失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 删除分类
    public function claDelete(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->claDeleteValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::claDelete($request['gocl_id']);
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '商品分类', '删除', '删除成功');
            DB::commit();
            return $this->success('删除成功');
        } else {
            DB::rollBack();
            return $this->error('删除失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 补货
    public function replenishment(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->replenishmentValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $res = ShopService::replenishment($user_info,$request->all());
        if ($res['code'] == 200) {
            // 生成操作记录
            $palo_res = paitLog($user_info, $request['pait_id'], '补货', '补货数量：'.$request['number'].'');
            OperationLog::addLog($user_info, getRealIp($request), '商品列表', '补货', '补货成功');
            DB::commit();
            return $this->success('补货成功');
        } else {
            DB::rollBack();
            return $this->error('补货失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 商品操作记录
    public function paitLogIndex(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $search_data = ShopService::paitLogIndex($user_info,$request->all(), 10);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 官网扫码登录 获取token生成二维码
    public function getQr(Request $request) {
        $xm_id = 'xm'.md5(time().rand(10000,99999));
        $time_rand = md5(time().rand(10000,99999));
        $data['token'] =  'XM'.$time_rand;
        // $data['token'] =  '111111111';
        $add_data['shqr_number'] = $data['token'];
        // $add_data['shqr_number'] = '111111111';
        $add_data['shqr_source'] = 1;
        $add_data['shqr_create_time'] = date('Y-m-d H:i:s');
        $add_res = DB::table('shop_qr')->insertGetId($add_data);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 修改状态
    public function setQrState(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->setQrStateValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $find_qrstate = DB::table('shop_qr')
            ->where('shqr_number', $request['shqr_number'])
            ->exists();
        if (!$find_qrstate) {
            return response()->json(['code'=>200, 'msg'=>'未查询到此二维码', 'data'=>'']);
        }
        // 根据openid查询用户id
        $find_admin = DB::table('admin')
            ->where("adm_bjfw_openid", $request['openid'])
            ->select('adm_id')
            ->first();
        if(isset($find_admin->adm_id)){
            $update_data['shqr_scan_adm_id'] = $find_admin->adm_id;
        }
        $update_data['shqr_state'] = $request['shqr_state'];
        $update_data['shqr_update_time'] = date('Y-m-d H:i:s');
        $update_data_res = DB::table('shop_qr')->where('shqr_number', $request['shqr_number'])->update($update_data);
        if ($update_data_res) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'']);
        }
    }

    // 官网扫码状态查询
    // 二维码状态1未扫码2已扫码3取消失效4授权成功5过期失效
    public function getQrState(Request $request) {
        $find_qrstate = DB::table('shop_qr')
            ->where('shqr_number', $request['shqr_number'])
            ->first();
        if ($find_qrstate) {
            $shqr_create_time = strtotime($find_qrstate->shqr_create_time);
            if (time() - $shqr_create_time > 60000) {
                $update_qrstate = DB::table('shop_qr')
                    ->where('shqr_number', $request['shqr_number'])
                    ->update(['shqr_state'=>5,'shqr_update_time'=>date('Y-m-d H:i:s')]);
                $find_qrstate->shqr_state = 5;
                return response()->json(['code'=>500, 'msg'=>'二维码已过期1', 'data'=>'','state'=>$find_qrstate->shqr_state]);
            }
            if ($find_qrstate->shqr_state == 1) {//
                return response()->json(['code'=>200, 'msg'=>'用户未扫码', 'data'=>'','state'=>$find_qrstate->shqr_state]);
            } elseif ($find_qrstate->shqr_state == 2) {
                return response()->json(['code'=>500, 'msg'=>'二维码已扫码', 'data'=>'','state'=>$find_qrstate->shqr_state]);
            } elseif ($find_qrstate->shqr_state == 3) {
                return response()->json(['code'=>500, 'msg'=>'二维码已取消失效', 'data'=>'','state'=>$find_qrstate->shqr_state]);
            } elseif ($find_qrstate->shqr_state == 4) {
                $lote_res = DB::table('login_temporary as l')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'l.adm_id')
                    ->leftJoin('shop as s', 's.shop_id', '=', 'l.adm_shop_id')
                    ->where('last_login', '>=', time()-2*60*60)
                    ->where('a.adm_id', $find_qrstate->shqr_scan_adm_id)
                    ->select('api_token', 'a.adm_name', 'a.adm_phone', 'l.adm_shop_id', 'shop_store_name', 'shop_type', 'shop_province', 'shop_province', 'shop_city', 'shop_county', 'shop_longitude', 'shop_latitude', 's.shop_versions', 'a.adm_id')
                    ->first();
                if (empty($lote_res)) {
                    return response()->json(['code'=>500, 'msg'=>'登录过期', 'data'=>'','state'=>$find_qrstate->shqr_state]);
                }
                if (empty($lote_res->adm_shop_id)) {
                    $default_url = 'editShop';
                } else {
                    $default_url = 'index';
                }
                // 返回数据
                $return_data = [
                    'api_token' => Crypt::encrypt($lote_res->api_token), //生成前台token
                    'default_url' => $default_url, //默认跳转页面
                    'adm_id' => $lote_res->adm_id,
                    'adm_name' => $lote_res->adm_name,
                    'adm_phone' => $lote_res->adm_phone,
                    'shop_id' => $lote_res->adm_shop_id,
                    'shop_store_name' => $lote_res->shop_store_name,
                    'shop_type' => $lote_res->shop_type,
                    'shop_province' => $lote_res->shop_province,
                    'shop_city' => $lote_res->shop_city,
                    'shop_county' => $lote_res->shop_county,
                    'shop_longitude' => $lote_res->shop_longitude,
                    'shop_latitude' => $lote_res->shop_latitude,
                    'shop_versions' => $lote_res->shop_versions,
                ];
                return response()->json(['code'=>200, 'msg'=>'授权成功', 'data'=>$return_data,'state'=>$find_qrstate->shqr_state]);
            } elseif ($find_qrstate->shqr_state == 5) {
                return response()->json(['code'=>500, 'msg'=>'二维码已过期失效', 'data'=>'','state'=>$find_qrstate->shqr_state]);
            } elseif ($find_qrstate->shqr_state == 6) {
                $lote_res = DB::table('login_temporary as l')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'l.adm_id')
                    ->leftJoin('shop as s', 's.shop_id', '=', 'l.adm_shop_id')
                    ->where('last_login', '>=', time()-2*60*60)
                    ->where('a.adm_id', $find_qrstate->shqr_scan_adm_id)
                    ->select('api_token', 'a.adm_name', 'a.adm_phone', 'l.adm_shop_id', 'shop_store_name', 'shop_type', 'shop_province', 'shop_province', 'shop_city', 'shop_county', 'shop_longitude', 'shop_latitude', 's.shop_versions', 'a.adm_id')
                    ->first();
                if (empty($lote_res)) {
                    return response()->json(['code'=>500, 'msg'=>'登录过期', 'data'=>'','state'=>$find_qrstate->shqr_state]);
                }
                if (empty($lote_res->adm_shop_id)) {
                    $default_url = 'editShop';
                } else {
                    $default_url = 'index';
                }
                // 返回数据
                $return_data = [
                    'api_token' => Crypt::encrypt($lote_res->api_token), //生成前台token
                    'default_url' => $default_url, //默认跳转页面
                    'adm_id' => $lote_res->adm_id,
                    'adm_name' => $lote_res->adm_name,
                    'adm_phone' => $lote_res->adm_phone,
                    'shop_id' => $lote_res->adm_shop_id,
                    'shop_store_name' => $lote_res->shop_store_name,
                    'shop_type' => $lote_res->shop_type,
                    'shop_province' => $lote_res->shop_province,
                    'shop_city' => $lote_res->shop_city,
                    'shop_county' => $lote_res->shop_county,
                    'shop_longitude' => $lote_res->shop_longitude,
                    'shop_latitude' => $lote_res->shop_latitude,
                    'shop_versions' => $lote_res->shop_versions,
                ];
                return response()->json(['code'=>200, 'msg'=>'授权成功', 'data'=>$return_data,'state'=>$find_qrstate->shqr_state]);
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'查无数据', 'data'=>'']);
        }
    }

    // 完善店铺信息
    public function createShop(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->createShopValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::createShop($user_info,$request);
        if ($res['code'] == 200) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'新增成功', 'data'=>$res['data']]);
            //return $this->success('新增成功');
        } else {
            DB::rollBack();
            return response()->json($res);
        }
    }

    // 店铺版本查询
    public function shopVersions(Request $request) {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $find_shop_data = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        $find_shop_order = DB::table('shop_order')
            ->where('shor_shop_id', $user_info->adm_shop_id)
            ->where('type', 1)
            ->where('shor_pay_state', 2)
            ->first();
        $is_buy = $find_shop_data->shop_buy;//是否购买过版本1是2否
        if ($find_shop_data->shop_create_type == 1) {//官网新增门店
            $find_shve = DB::table('shop_versions')
                ->orderBy('shve_sort', 'asc')
                ->get()->toArray();
            if ($find_shve) {
                foreach ($find_shve as $key => $value) {
                    $find_shve[$key]->shve_data = DB::table('shop_versions_info')
                        ->where('shvi_shve_id', $value->shve_id)
                        ->get()->toArray();
                    $find_shve[$key]->shve_price = DB::table('shop_price')
                        ->where('shpr_shop_id', 0)
                        ->where('shpr_shve_id', $value->shve_id)
                        ->where('shpr_month', 1)
                        ->where('shpr_order_type', 1)
                        ->get()->toArray();
                    $find_shve[$key]->year_price = DB::table('shop_price')
                        ->where('shpr_shop_id', 0)
                        ->where('shpr_shve_id', $value->shve_id)
                        ->where('shpr_order_type', 4)
                        ->get()->toArray();
                }
                
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_shve, 'is_buy'=>$is_buy]);
            } else {
                return response()->json(['code'=>500, 'msg'=>'查无数据', 'data'=>'']);
            }
        } else {//注册 或 邀请新增
            $find_settle = DB::table('settle_in')
                ->where('shop_id', $user_info->adm_shop_id)
                ->first();
            $find_fshop_id = DB::table('shop')
                ->where('shop_code', $find_settle->inv_shop_code)
                ->first();
            $find_shve = DB::table('shop_versions')
                ->orderBy('shve_sort', 'asc')
                ->get()->toArray();
            if ($find_shve) {
                if ($find_fshop_id) {
                    foreach ($find_shve as $key => $value) {
                        $find_shve[$key]->shve_data = DB::table('shop_versions_info')
                            ->where('shvi_shve_id', $value->shve_id)
                            ->get()->toArray();
                        $shve_price = DB::table('shop_price')
                            ->where('shpr_shop_id', $find_fshop_id->shop_id)
                            ->where('shpr_shve_id', $value->shve_id)
                            ->where('shpr_month', 1)
                            ->where('shpr_order_type', 1)
                            ->get()->toArray();
                        if (empty($shve_price)) {
                            $shve_price = DB::table('shop_price')
                                ->where('shpr_shop_id', 0)
                                ->where('shpr_shve_id', $value->shve_id)
                                ->where('shpr_month', 1)
                                ->where('shpr_order_type', 1)
                                ->get()->toArray();
                        }
                        $find_shve[$key]->shve_price = $shve_price;
                        $year_price = DB::table('shop_price')
                            ->where('shpr_shop_id', $find_fshop_id->shop_id)
                            ->where('shpr_shve_id', $value->shve_id)
                            ->where('shpr_order_type', 4)
                            ->get()->toArray();
                        if (empty($year_price)) {
                            $year_price = DB::table('shop_price')
                                ->where('shpr_shop_id', 0)
                                ->where('shpr_shve_id', $value->shve_id)
                                ->where('shpr_order_type', 4)
                                ->get()->toArray();
                        }
                        $find_shve[$key]->year_price = $year_price;
                    }
                } else {
                    foreach ($find_shve as $key => $value) {
                        $find_shve[$key]->shve_data = DB::table('shop_versions_info')
                            ->where('shvi_shve_id', $value->shve_id)
                            ->get()->toArray();
                        $find_shve[$key]->shve_price = DB::table('shop_price')
                            ->where('shpr_shop_id', 0)
                            ->where('shpr_shve_id', $value->shve_id)
                            ->where('shpr_month', 1)
                            ->where('shpr_order_type', 1)
                            ->get()->toArray();
                        $find_shve[$key]->year_price = DB::table('shop_price')
                            ->where('shpr_shop_id', 0)
                            ->where('shpr_shve_id', $value->shve_id)
                            ->where('shpr_order_type', 4)
                            ->get()->toArray();
                    }
                }
                $dis_data['shic_discount_price'] = 0;
                $dis_data['inv_code'] = 0;
                if ($find_settle->inv_code && $is_buy == 2) {
                    $find_shic_data = DB::table('shop_invitate_code_config')
                        ->where('shic_code', $find_settle->inv_code)
                        ->first();
                    if ($find_shic_data) {
                        $dis_data['shic_discount_price'] = $find_shic_data->shic_discount_price;
                        $dis_data['inv_code'] = $find_settle->inv_code;
                    }
                }
                
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_shve, 'is_buy'=>$is_buy, 'shic_discount_price'=>$dis_data]);
            } else {
                return response()->json(['code'=>500, 'msg'=>'查无数据', 'data'=>'']);
            }
        }
    }

    // 购买版本时长
    public function addShopOrder(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addShopOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::addShopOrder($user_info,$request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 短信充值
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-10
     * @param  Request          $request [description]
     */
    public function addSmsOrder(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addSmsOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::addSmsOrder($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '短信充值', '短信充值', '短信充值成功');
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }


    /**
     * 购买分店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-28
     * @param  Request          $request [description]
     */
    public function buyShop(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->buyShopValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if ($request['add_type'] == 1) {
            $find_data = DB::table('shop')
                ->where('shop_id', $user_info->adm_shop_id)
                ->first();
            $find_bind_shop = DB::table('bind_shop')
                ->where('bish_fshop_id', $user_info->adm_shop_id)
                ->where('bish_state', 1)
                ->count();
            $data['shop_free_shop'] = $find_data->shop_free_shop;
            $data['shop_toll_shop'] = $find_data->shop_toll_shop;
            $data['used_shop_num'] = $find_bind_shop;
            $data['price'] = config('apimesssage.bind_price')*100;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }
        DB::beginTransaction();
        $res = ShopService::buyShop($user_info,$request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }


    // 使用银行账户支付
    public function payShopOrder(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->payShopOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::payShopOrder($user_info,$request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    // 购买记录
    public function shopOrder(Request $request) {
        $search_data = $request->all();
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $list_data = DB::table('shop_order as so')
            ->leftJoin('shop_price', 'shpr_id', '=', 'shor_shpr_id')
            ->where('shor_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_state'])) {//订单状态：1未付款2处理中3已完成4已取消
                    $query->where('shor_state', $search_data['shor_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_type'])) {//订单类型1普通订单2升级订单3短信充值
                    $query->where('shor_type', $search_data['shor_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('shor_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('shor_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('shor_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('shor_id' ,'shor_create_time', 'shor_number', 'shor_create_name', 'shor_goo_name', 'shor_goo_price', 'shor_state', 'shpr_id', 'shpr_month', 'shpr_duration', 'shor_pay_state', 'shor_order_amount', 'shor_pay_amount', 'shor_pay_check', 'shor_shop_end_time', 'type', 'shor_paid_money', 'shor_goo_num', 'shor_pay_way')
            ->orderBy('shor_id', 'desc')
            ->paginate($request['show_count']);
        $list_items = $list_data->items();
        if (!empty($list_items)) {
            foreach ($list_items as $key => $value) {
                $list_items[$key]->shor_end_time = date("Y-m-d H:i:s",strtotime("+ 2 hour",strtotime($value->shor_create_time)));
                $typeName = ShopService::getOrderType(true);//获取支付方式名称
                $list_items[$key]->shor_order_type_name = WashOrderService::getTypeData($value->type, $typeName);
                if ((time() < (strtotime($value->shor_create_time) + 60*60*2)) && $value->shor_pay_state == 1 && $value->shor_state != 4){
                    $list_items[$key]->can_pay = 1;
                } else {
                    $list_items[$key]->can_pay = 2;
                }
                if ($value->shor_pay_state == 1 && $value->shor_state != 4){//付款状态1未付款2已付款
                    $list_items[$key]->can_cancel = 1;
                } else {
                    $list_items[$key]->can_cancel = 2;
                }
            }
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $request['show_count'];       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据

        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
    }

    /**
     * 获取订单类型
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-11
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getOrderType(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::getOrderType(false);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 获取升级需要支付的费用
    public function getNeedPay(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getNeedPayValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $res = ShopService::getNeedPay($user_info,$request);
        return response()->json($res);
    }

    public function getservice(Request $request) {
        $res = ShopService::getService();
        return response()->json($res);
    }

    //获取订单状态
    public function getOrderState(Request $request){
        // 验证参数
        $error_message = $this->dataService->mainValidator->getOrderStateValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 根据订单id查询订单支付状态
        $find_order = DB::table('shop_order')
            ->where("shor_number", $request['shor_number'])
            ->select('shor_number', 'shor_state', 'shor_pay_state', 'shor_pay_time', 'shor_pay_way')
            ->first();
        if (empty($find_order)) {
            return ['code'=>500, 'msg'=>'没有该订单', 'data'=>'没有该订单'];
        }
        // 返回数据
        $return_data = [
            'shor_number' => $find_order->shor_number, //订单号
            'shor_state' => $find_order->shor_state, //订单状态：1未付款2处理中3已完成4已取消
            'shor_pay_state' => $find_order->shor_pay_state, //付款状态1未付款2已付款
            'shor_pay_time' => $find_order->shor_pay_time,//付款时间
            'shor_pay_way' => $find_order->shor_pay_way,//支付方式1微信2支付宝3转账汇款
        ];
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    //获取优惠券
    public function getCoupon(Request $request){
          // 获取用户信息
        $user_info = LoginUserService::getUser($request['api_token']);
        if (empty($user_info->adm_id)) {
            $adm_id = $request['adm_id'];
            $adm_shop_id = $request['adm_shop_id'];
        } else {
            $adm_id = $user_info->adm_id;
            $adm_shop_id = $user_info->adm_shop_id;
        }
        // 根据订单id查询订单支付状态
        $find_order = DB::table('admin_coupon')
            ->where("adco_adm_id", $adm_id)
            ->select('adco_cou_id', 'adco_id', 'adco_price', 'adco_name')
            ->orderBy('adco_price', 'desc')
            ->first();
        if (empty($find_order)) {
            return response()->json(['code'=>4000, 'msg'=>'无可用优惠券', 'data'=>'']);
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_order]);
    }

    // 审核门店列表
    public function checkShopOrder(Request $request) {
        $search_data = $request->all();
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $list_data = DB::table('shop_order as so')
            ->leftJoin('shop_price', 'shpr_id', '=', 'shor_goo_id')
            // ->where('shor_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_state'])) {//订单状态：1未付款2处理中3已完成4已取消
                    $query->where('shor_state', $search_data['shor_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_pay_check'])) {//付款是否审核1通过2否3驳回
                    $query->where('shor_pay_check', $search_data['shor_pay_check']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_pay_way'])) {//支付方式1微信2支付宝3转账汇款
                    $query->where('shor_pay_way', $search_data['shor_pay_way']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('shor_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('shor_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('shor_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('shor_create_time', 'shor_number', 'shor_create_name', 'shor_goo_name', 'shor_goo_price', 'shor_state', 'shpr_id', 'shpr_month', 'shpr_duration', 'shor_pay_state', 'shor_order_amount', 'shor_pay_amount', 'shor_pay_check', 'shor_id', 'shor_pay_way')
            ->orderBy('shor_id', 'desc')
            ->paginate($request['show_count']);
        $list_items = $list_data->items();
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if (!empty($list_items)) {
            foreach ($list_items as $key => $value) {
                $buttonData = [];
                if(in_array($value->shor_pay_check, [2])){
                    $buttonData[] = 'checkShop';
                }
                $button = CommonService::getListButton($buttonData,$list_button);
                $list_items[$key]->button_one = $button['button_one']??[];
                $list_items[$key]->button_two = $button['button_two']??[];
                $list_items[$key]->button_three = $button['button_three']??[];

                $list_items[$key]->shor_end_time = date("Y-m-d H:i:s",strtotime("+".$value->shpr_month."months",strtotime($value->shor_create_time)));
            }
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $request['show_count'];       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
    }

    //审核门店
    public function checkShop(Request $request){
        // 验证参数
        $error_message = $this->dataService->mainValidator->checkShopValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $find_shor = DB::table('shop_order')
            ->leftJoin('shop', 'shop_id', '=', 'shor_shop_id')
            ->where('shor_id', $request['shor_id'])
            ->first();
        if (empty($find_shor)) {
            return response()->json(['code'=>500, 'msg'=>'查无此单', 'data'=>'']);
        }
        if ($find_shor->shor_pay_check == 1) {
            return response()->json(['code'=>500, 'msg'=>'此订单已审核', 'data'=>'']);
        }
        DB::beginTransaction();
        if ($request['checked'] == 1) {//是否通过1是2否
            $shop_update['shop_state'] = 1;
            $shop_update['shop_shve_id'] = $find_shor->shor_goo_id;
            $shop_update['shop_shpr_id'] = $find_shor->shor_shpr_id;
            $shop_update['shop_opening_type'] = 1;
            if (empty($find_shor->shop_opening_start_time)) {
                $shop_update['shop_opening_start_time'] = date('Y-m-d H:i:s');
            }
            $find_shop_versions = DB::table('shop_price')
                ->where('shpr_id', $find_shor->shor_shpr_id)
                ->first();
            if ($find_shor->type == 1) {
                if (empty($find_shor->shop_opening_end_time)) {
                    $shop_update['shop_opening_end_time'] = date('Y-m-d H:i:s', strtotime($find_shor->shop_opening_end_time.'+'.$find_shop_versions->shpr_month.'month'));
                }
            }
            $update_res = DB::table('shop')
                ->where('shop_id', $find_shor->shor_shop_id)
                ->update($shop_update);
            $update_order = DB::table('shop_order')
                ->where('shor_number', $find_shor->shor_number)
                ->update(['shor_pay_check'=>1, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
                //shor_pay_check1通过2待审核3驳回
        } else {
            $update_order = DB::table('shop_order')
                ->where('shor_number', $postObj->out_trade_no)
                ->update(['shor_pay_check'=>3,'shor_pay_state'=>2, 'shor_pay_time'=>date('Y-m-d H:i:s')]);
            $update_res = true;
        }
        if ($update_res && $update_order) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'审核成功', 'data'=>'']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'审核失败', 'data'=>'']);
        }
    }

    //获取发放的优惠券
    public function getGrant(Request $request){
        $get_ip = getRealIp($request); //获取ip
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 1, 'getCoupon');
        $request = json_decode($request, true);
        $find_admin = DB::table('admin_shop_role')
            ->where('phone', $request['phone'])
            ->first();
        if (empty($find_admin)) {
            return ['code'=>4000, 'msg'=>'当前门店未查询到此用户', 'data'=>''];
        }
        $add_data['adco_adm_id'] = $find_admin->adm_id;
        $add_data['adco_cou_id'] = $request['cou_id'];
        $add_data['adco_price'] = $request['cou_discount'];//优惠券金额
        $add_data['adco_name'] = $request['cou_name'];//优惠券名称
        $add_data['adco_create_time'] = date('Y-m-d H:i:s');//创建时间
        $add_data['adco_end_time'] = date('Y-m-d H:i:s', time()+$request['cou_time_long']*24*60*60);//失效时间
        $add_res = DB::table('admin_coupon')->insertGetId($add_data);
        if (!$add_res) {
            return ['code'=>500, 'msg'=>'发放失败', 'data'=>''];
        }
        return ['code'=>200, 'msg'=>'发放成功', 'data'=>$add_res];
    }

    /**
     * 短信套餐
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-10
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function msgPackage(Request $request) {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 验证参数
        $error_message = $this->dataService->mainValidator->msgPackageValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $res = ShopService::msgPackage($user_info,$request);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res]);
    }

    /**
     * 获取支付方式
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-11
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getPaymentWay(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::getPaymentWayName(false);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    /**
     * 消费记录
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-11
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function record(Request $request) {
        $search_data = $request->all();
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $list_data = DB::table('shop_order as so')
            // ->leftJoin('shop_price', 'shpr_id', '=', 'shor_goo_id')
            ->where('shor_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_type'])) {//交易类型
                    $query->where('shor_type', $search_data['shor_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_state'])) {//交易状态
                    $query->where('shor_state', $search_data['shor_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_pay_way'])) {//支付方式
                    $query->where('shor_pay_way', $search_data['shor_pay_way']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['shor_other_num'])) {//三方交易号
                    $query->where('shor_other_num', $search_data['shor_other_num']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('shor_pay_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('shor_pay_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('shor_pay_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('shor_id','shor_create_time', 'shor_number', 'shor_create_name', 'shor_goo_name', 'shor_goo_price', 'shor_state', 'shor_pay_state', 'shor_order_amount', 'shor_pay_amount', 'shor_pay_check', 'shor_pay_way', 'shor_other_num', 'shor_remark', 'shor_pay_time', 'shor_type', 'shor_paid_money')
            ->orderBy('shor_id', 'desc')
            ->paginate($request['show_count']);
        $list_items = $list_data->items();
        if (!empty($list_items)) {
            // 获取当前列表下的按钮
            $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);
            $typeName = ShopService::getPaymentWayName(true);//获取支付方式名称
            foreach ($list_items as $key => $value) {
                $buttonData = [];
                $list_items[$key]->shor_pay_way_name = WashOrderService::getTypeData($value->shor_pay_way, $typeName);
                if ((time() < (strtotime($value->shor_create_time) + 60*60*2)) && $value->shor_pay_state == 1 && $value->shor_state != 4) {
                    $buttonData[] = 'pay';
                }
                if ($value->shor_pay_state == 1 && $value->shor_state != 4){//付款状态1未付款2已付款
                    $buttonData[] = 'cancel';
                }
                $list_items[$key]->shor_paid_money = $value->shor_paid_money/100;
                $button = CommonService::getListButton($buttonData,$list_button);
                $list_items[$key]->button_one = $button['button_one']??[];
                $list_items[$key]->button_two = $button['button_two']??[];
                $list_items[$key]->button_three = $button['button_three']??[];
            }
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $request['show_count'];       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
    }

    /**
     * 短信类型
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-11
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getSmsType(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::getSmsType(false);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    /**
     * 短信记录
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-11
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function smsLog(Request $request) {
        $search_data = $request->all();
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $list_data = DB::table('sms_log as s')
            ->where('smlo_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['smlo_type'])) {//类型
                    $query->where('smlo_type', $search_data['smlo_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['smlo_state'])) {//状态
                    $query->where('smlo_state', $search_data['smlo_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['smlo_mem_phone'])) {//手机号
                    $query->where('smlo_mem_phone', $search_data['smlo_mem_phone']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['smlo_msg_type'])) {//短信类型
                    $query->where('smlo_msg_type', $search_data['smlo_msg_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('smlo_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('smlo_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('smlo_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->whereRaw("((`smlo_state` = 2 and `smlo_msg_type` <> 1) or `smlo_state` = 1)")
            ->select('smlo_id', 'smlo_mem_type', 'smlo_mem_id', 'smlo_mem_name', 'smlo_mem_phone', 'smlo_type', 'smlo_create_time', 'smlo_state', 'smlo_num', 'smlo_content', 'smlo_msg_type')
            ->orderBy('smlo_id', 'desc')
            ->paginate($request['show_count']);
        $list_items = $list_data->items();
        if (!empty($list_items)) {
            // 获取当前列表下的按钮
            $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);
            $typeName = ShopService::getSmsType(true);//获取支付方式名称
            foreach ($list_items as $key => $value) {
                $list_items[$key]->smlo_msg_type_name = WashOrderService::getTypeData($value->smlo_msg_type, $typeName);
                $buttonData = [];
                if ($value->smlo_state == 2 && $value->smlo_msg_type != 1) {
                    $buttonData[] = 'resend';
                }
                $button = CommonService::getListButton($buttonData,$list_button);
                $list_items[$key]->button_one = $button['button_one']??[];
                $list_items[$key]->button_two = $button['button_two']??[];
                $list_items[$key]->button_three = $button['button_three']??[];
            }
        }
        $find_shop = DB::table('shop')
            ->leftJoin('admin', 'shop_msg_adm_id', '=', 'adm_id')
            ->where('shop_id', $user_info->adm_shop_id)
            ->select('shop_id', 'shop_message_num', 'shop_msg_remind', 'adm_name', 'shop_msg_adm_id')
            ->first();
        $success_num = DB::table('sms_log')
            ->where('smlo_shop_id', $user_info->adm_shop_id)
            ->where('smlo_type', 2)
            ->where('smlo_state', 1)
            ->sum('smlo_num');
        $new_top_button = getListButton($search_data['api_token'], $search_data['pri_id']);
        $buttonData_top[] = 'recharge';
        $buttonData_top[] = 'msgSet';
        $buttonData_top[] = 'msgConfig';
        $button_one = [];
        foreach ($new_top_button as $key => $value) {
            if (in_array($value['pri_operate_method'],$buttonData_top)) {
                $button_one[] = $value;
            }
        }
        $button_top = CommonService::getListButton($buttonData_top,$new_top_button);
        // $top_button['button_one'] = $button_one;
        // $top_button['button_two'] = $button_top['button_two']??[];
        // $top_button['button_three'] = $button_top['button_three']??[];
        $top_button = $button_one;
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $request['show_count'];       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据
        $data_info['shop_data']['success_num'] = $success_num;                //返回已使用短信条数
        $data_info['shop_data']['shop_message_num'] = $find_shop->shop_message_num;                //返回短信条数
        $data_info['shop_data']['shop_msg_remind'] = $find_shop->shop_msg_remind;                //预警设置
        $data_info['shop_data']['adm_name'] = $find_shop->adm_name;                //提醒人
        $data_info['shop_data']['shop_msg_adm_id'] = $find_shop->shop_msg_adm_id;                //提醒人id
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'top_button'=>$top_button]);
    }

    /**
     * 重发短信
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function resend(Request $request) {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::resend($user_info,$request);
        return response()->json($return_data);
    }

    /**
     * 设置短信预警
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-17
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function msgSet(Request $request) {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 验证参数
        $error_message = $this->dataService->mainValidator->msgSetValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $return_data = ShopService::msgSet($user_info,$request);
        return response()->json($return_data);
    }

    /**
     * 添加banner
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-23
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function addBanner(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addBannerValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::addBanner($user_info,$request);
        return response()->json($return_data);
    }

    /**
     * 添加banner
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-23
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function banner(Request $request) {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $return_data = ShopService::banner($user_info,$request);
        return response()->json($return_data);
    }

    /**
     * 删除banner
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-23
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function delBanner(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->delBannerValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $return_data = ShopService::delBanner($user_info,$request);
        return response()->json($return_data);
    }

    /**
     * 发送短信设置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-24
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function msgConfig(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->msgConfigValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $return_data = ShopService::msgConfig($user_info,$request);
        return response()->json($return_data);
    }

    /**
     * 获取短信配置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-11
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getMsgCon(Request $request)
    {
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = ShopService::getMsgCon(false);
        $find_shop_msg = DB::table('msg_config')
            ->where('msco_shop_id', $user_info->adm_shop_id)
            ->first();
        $msco_send_detail = [];
        if ($find_shop_msg) {
            $msco_send_detail = explode(',',$find_shop_msg->msco_send_detail);
            $data['msco_is_send'] = $find_shop_msg->msco_is_send;
        } else {
            $data['msco_is_send'] = 2;
        }
        foreach ($return_data as $key => $value) {
            if (in_array($value['type'],$msco_send_detail)) {
                $return_data[$key]['selected'] = 1;
            } else {
                $return_data[$key]['selected'] = 2;
            }
        }
        $data['config'] = $return_data;
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    /**
     * 绑定门店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function bindShop(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->bindShopValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::bindShop($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '分店管理', '绑定分店', '绑定成功');
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 停用
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-06
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function bindState(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->bindStateValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::bindState($user_info,$request);
        if ($res['code'] == 200) {
            $state = ($request['bish_state'] == 1) ? '启用':'停用';
            Common::addLog($user_info, getRealIp($request), '分店管理', $state.'分店', $state.'成功');
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 分店员工管理
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-11
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function shopAdmin(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->shopAdminValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::shopAdmin($user_info,$request);

        if ($res['code'] == 200) {
            // 获取当前列表下的按钮
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 给分店新增员工
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-11
     * @param  Request          $request [description]
     */
    public function addShopAdm(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addShopAdmValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        DB::beginTransaction();
        $user_info = LoginUserService::getUser();
        $find_data = DB::table('bind_shop')
            ->where('bish_id', $request['bish_id'])
            ->where('bish_fshop_id', $user_info->adm_shop_id)
            ->first();
        if (empty($find_data)) {
            return ['code'=>500, 'msg'=>'未发现此分店', 'data'=>''];
        }
        $request['shop_id'] = $find_data->bish_lshop_id;
        //判断当前门店下的手机号是否存在
        $adminShopRole = DB::table('admin_shop_role')
            ->where('phone', $request['adm_phone'])
            ->where('shop_id', $request['shop_id'])
            ->first();
        if (!empty($adminShopRole)) {
            if($adminShopRole->create_source ==2){
                $insertAdminShopRoleDataRes = DB::table('admin_shop_role')->where('id', $adminShopRole->id)->update(['create_source'=>1,'role_id'=>$request['adm_role']]);
                if ($insertAdminShopRoleDataRes) {
                    DB::commit();
                    Common::addLog($user_info, getRealIp($request), '员工列表', '新增', '新增员工：' . $request['adm_name'] . '('.$user_info->adm_shop_id.')' . '成功');
                    return response()->json(['code' => 200, 'msg' => 'success', 'data' => '新增员工成功']);
                } else {
                    DB::rollBack();
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => '新增员工失败']);
                }
            }else {
                return response()->json(['code' => 500, 'msg' => '员工账号已存在', 'data' => '当前门店下手机号已存在']);
            }
        }

        $res = ShopService::addShopAdm($user_info,$request);
        if ($res['code'] == 200) {
            DB::commit();
            Common::addLog($user_info, getRealIp($request), '分店员工列表', '新增', '新增分店员工：' . $request['adm_name'] . '成功');
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }


    /**
     * 分店权限
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-11
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function editShopRole(Request $request) {
        if ($request['type'] == 1) {
            // 获取角色权限
            $find_role = DB::table('role')
                ->where('rol_shop_id', $request['shop_id'])
                ->where('rol_type', 1)
                ->select('rol_type', 'rol_privilege', 'rol_name', 'rol_description', 'rol_category', 'rol_privilege_multiple', 'rol_id')
                ->first();
            $rol_privilege_multiple = json_decode($find_role->rol_privilege_multiple, true);

            // pc端角色
            $role_info = DB::table('login_temporary')
                ->where('api_token', '=', $request['api_token'])
                ->select('adm_id', 'role_auth')
                ->first();
            $role_auth = json_decode($role_info->role_auth, true);
            // 分类
            $role_auth = DB::table('privileges')
                ->where('pri_shop_version', 'like', '%'.'4'.'%')
                ->get()->toArray();
            $role_auth = json_decode(json_encode($role_auth,true), true);
            $privileges_info = $this->roleCategory($role_auth);
            foreach ($role_auth as $key => $value) {
                if ($value['pri_type'] == 3) {
                    $rol_subordinate[] = $value['pri_id'];
                }
            }
            $data['pc']['rol_subordinate'] = $rol_subordinate;
            $data['pc']['privileges_info'] = $privileges_info;
            // pc端所有权限id
            $rol_privilege = explode(',', $rol_privilege_multiple['pc']);
            $data['rol_name'] = $find_role->rol_name;
            $data['rol_description'] = $find_role->rol_description;
            $data['pc']['rol_privilege'] = array_values($rol_privilege);
            // 微信小程序角色
            $rol_privilege = explode(',', $rol_privilege_multiple['applet']);
            $data['applet']['rol_privilege'] = array_values($rol_privilege);
            $privileges_info = DB::table('privileges_technician_applet')->where('pri_show', 1)->get();
            $rol_subordinate = [];
            foreach ($privileges_info as $key => $value) {
                $find_son = DB::table('privileges_technician_applet')->where('pri_fid', $value->pri_id)->get()->toArray();
                if ($value->pri_type == 3 || empty($find_son)) {
                    $rol_subordinate[] = $value->pri_id;
                }
            }
            $role_auth = json_decode(json_encode($privileges_info, true), true);
            // 分类
            $privileges_info = $this->roleCategory($role_auth);
            $data['applet']['rol_subordinate'] = $rol_subordinate;
            $data['applet']['privileges_info'] = $privileges_info;

            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->editShopRoleValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = Common::getUserInfo($request['api_token']);
        $find_shop = DB::table('bind_shop')
            ->where('bish_fshop_id', $user_info->adm_shop_id)
            ->where('bish_lshop_id', $request['shop_id'])
            ->first();
        if (empty($find_shop)) {
            return ['code'=>500, 'msg'=>'未查询到分店信息', 'data'=>[]];
        }
        DB::beginTransaction();
        $res = ShopService::editShopRole($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '分店员工列表', '修改权限', '修改权限成功');
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }


    /**
     * 空间购买
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-12
     * @param  Request          $request [description]
     */
    public function addSpaceOrder(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addSpaceOrderValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::addSpaceOrder($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '空间购买', '空间购买', '空间购买成功');
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 获取空间套餐页面信息
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getSpaceInfo(Request $request) {
        // // 验证参数
        // $error_message = $this->dataService->mainValidator->addSpaceOrderValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error($error_message, ErrorInc::INVALID_PARAM);
        // }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if (isset($request['shop_id'])) {
            $shop_id = $request['shop_id'];
        } else {
            $shop_id = $user_info->adm_shop_id;
        }
        DB::beginTransaction();
        $find_shop = DB::table('shop')
            ->where('shop_id', $shop_id)
            ->first();
        if ($find_shop->shop_shve_id == 1) {
            $data['shop_versions'] = '基础版';
        } elseif ($find_shop->shop_shve_id == 2) {
            $data['shop_versions'] = '企业版';
        } elseif ($find_shop->shop_shve_id == 3) {
            $data['shop_versions'] = '连锁版';
        } elseif ($find_shop->shop_shve_id == 0) {
            $data['shop_versions'] = '试用版';
        }
        $data['surplus_days'] = round((strtotime($find_shop->shop_opening_end_time) - time())/(24*60*60));
        $data['shop_space'] = $find_shop->shop_free_space + $find_shop->shop_toll_space;
        $data['shop_use_space'] = shopFoldSize($find_shop->shop_id);
        $data['shop_space_price'] = 20;
        $data['space_config'] = DB::table('space_config')->get();
        $data['space_text'] = '说明:
什么是存储空间?
通常指的是用于保存数据和文件的地方。它可以是指物理空间，如仓库内的保管空间，包括物理空间、潜在可利用空间、作
业空间和无用空间。在计算机领域，存储空间也可以指设备上的内部存储器和外部存储器，如硬盘驱动器或闪存，用于长期
保存数据，并且在设备关闭时仍然可用。此外，存储空间还可以是一个计算机术语，指数据存储所需要的介质。在云计算环
境中，存储空间可能指将本地物理存储设备集中合并为存储池并划分为虚拟驱动器的一项功能。在数据管理中，存储空间也
可以指用户用于存储对象(如文件、图片、视频、文档等)的容器，所有的对象都必须隶属于某个存储空间。
存储空间如何计算?
存储空间的计算主要取决于存储设备的类型和使用的单位。常见的存储单位包括字节(Byte)、千字节(KB)、兆字节(MB)、千
兆字节(GB)、太字节(TB)等。
存储空间的计算公式为存储容量=存储单元个数*存储字长。其中，存储单元个数取决于存储设备的物理尺寸，如内存条的
插槽数量;存储字长取决于存储设备的位宽，如内存条的数据线数量。例如，一个1GB的内存条，其存储容量为1024MB，
这是基于1GB等于1024MB的换算
空间购买是否受身份限制?
答:任何身份(超级会员/会员/普通用户)均可购买容量套餐，购买后容量套餐立即生效。
空间购买的有效期如何计算?
答:当您成功购买容量套餐后，扩展容量立即生效，容量套餐的有效期为一年，有效期按照自然年进行计算。
当购买一个容量套餐时，如:
您于2016年2月29日购买一年的空间内存，则可使用至2017年2月28日23:59:59;
当购买多个空间内存时，空间内存进行叠加，如:
您于2016年2月29日购买200G的空间内存，2016年3月5日再购买300G的空间内存，在2016年3月5日到2017年2月28日期
间，您可使用的空间内存总和为500G。在2017年3月1日到2017年3月5日期间，您可使用的空间内存为未到期的300G;';
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    /**
     * 获取空间续费费用
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-14
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getSpaPrice(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getSpaPriceValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = ShopService::getSpaPrice($user_info, $request);
        return response()->json($res);
    }

    /**
     * 取消订购
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-14
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function cancel(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->cancelValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = ShopService::cancel($user_info, $request);
        return response()->json($res);
    }

    /**
     * 编辑分店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-18
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function editBindShop(Request $request) {
        $error_message = $this->dataService->mainValidator->editBindShopValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::editBindShop($user_info, $request);
        if ($res['code'] == 500) {
            DB::rollBack();
        }
        $find_data = DB::table('bind_shop')
            ->where('bish_id',$request['bish_id'])
            ->first();
        $post['shop_store_name'] = $request['bish_shop_store_name'];
        $post['shop_province'] = $request['shop_province'];
        $post['shop_city'] = $request['shop_city'];
        $post['shop_county'] = $request['shop_county'];
        $post['shop_address'] = $request['bish_adress'];
        $post['shop_id'] = $find_data->bish_lshop_id;
        $res_shop = ShopService::editShop($post);
        if ($res_shop['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '分店管理', '编辑分店', '编辑成功');
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    // 角色权限数据分类
    public function roleCategory($arr)
    {
        $one_list = [];//一级栏目
        $two_list = [];//二级列表
        $fid_list = [];//二级列表的父级id
        foreach ($arr as $key => $value) {
            if ($value['pri_fid'] == 0) {
                $one_list[$value['pri_sord']] = $value;
                $fid_list[$value['pri_sord']] = $value['pri_id'];
            }
            if ($value['pri_type'] == 3) {
                // 二级列表下的按钮
                $two_list[$value['pri_fid']][] = $value;
            }
            // 工作总台的权限，在列表页面显示
            if ($value['pri_id'] == 102) {
                $arr[$key]['pri_show'] = 1;
            }
        }

        // 对一级栏目按照 pri_sord 字段数据排序
        ksort($fid_list);
        ksort($one_list);
        // 对数组的键值重新排序
        $new_fid_list = array_values($fid_list);
        $new_one_list = array_values($one_list);
        foreach ($arr as $key => $value) {
            // 把二级列表数据放到一级栏目下
            if (in_array($value['pri_fid'], $new_fid_list)) {
                $one_key = array_search($value['pri_fid'], $new_fid_list);
                // 判断是否有二级列表
                $list_button = $value;
                if (!empty($two_list[$value['pri_id']])) {
                    $list_button['subcat'] = $two_list[$value['pri_id']];
                }
                $new_one_list[$one_key]['subcat'][] = $list_button;
                unset($button);
                unset($list_button);
            }
        }
        return $new_one_list;
    }

    /**
     * 获取分店角色
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getShopRole(Request $request) {
        $error_message = $this->dataService->mainValidator->getShopRoleValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = ShopService::getShopRole($user_info,$request);
        return response()->json($res);
    }

    /**
     * 分店员工在职离职
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-20
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function editShopAdm(Request $request) {
        $error_message = $this->dataService->mainValidator->editShopAdmValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();

        $res = ShopService::editShopAdm($user_info,$request);
        $find_adm = DB::table('admin')
            ->where('adm_id', $request['adm_id'])
            ->first();
        if ($request['adm_state'] == 1) {
            $adm_state = '在职';
        } elseif ($request['adm_state'] == 2) {
            $adm_state = '离职';
        }
        Common::addLog($user_info, getRealIp($request), '分店管理', $adm_state.$find_adm->adm_name, $adm_state.'成功');
        return response()->json($res);
    }

    /**
     * 给分店划拨短信
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-22
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function addMsg(Request $request) {
        $error_message = $this->dataService->mainValidator->addMsgValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();

        $res = ShopService::addMsg($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '分店管理', '短信充值', '短信充值成功');
        }
        return response()->json($res);
    }

    /**
     * 获取门店短信数量
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-22
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getMsgnum(Request $request) {
        if (empty($request['shop_id'])) {
            return response()->json(['code'=>500, 'msg'=>'请选择门店', 'data'=>'']);
        }
        $find_message = DB::table('shop')
            ->where('shop_id', $request['shop_id'])
            ->value('shop_message_num');
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_message]);
    }

    

    /**
     * [getShopState description]
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-26
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getShopState(Request $request) {

    }

    /**
     * 意见反馈
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-01
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function feedBack(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->feedBackValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $res = ShopService::feedBack($user_info,$request, $request['show_count']);
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        // //获取top按钮
        // $sea_button_data = 'addBindShop,bindShop,buyShop';
        // $sea_button_data = CommonService::getTopButton('',$sea_button_data,$list_button);
        // 获取当前列表下的按钮
        if (empty($res)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res]);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            foreach ($res['list'] as $key => $value) {
                $res['list'][$key]->list_button_one = [];
                if ($list_button) {
                    foreach ($list_button as $key_b => $value_b) {
                        if ($value_b['pri_operate_method'] == 'audit' && $value->fee_state == 1) {//确认处理
                            $res['list'][$key]->list_button_one[] = $value_b;
                        }
                    }
                }
            }
            // 获取当前列表下的按钮
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res]);
        }
    }

    /**
     * 意见反馈
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-01
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function confirm(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->confirmValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = ShopService::confirm($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '意见反馈', '确认处理', '确认处理成功');
            return response()->json(['code'=>200, 'msg'=>'处理成功', 'data'=>'']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'处理失败', 'data'=>'']);
        }
    }

    /**
     * 给分店划拨空间
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-22
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function changeSpace(Request $request) {
        $error_message = $this->dataService->mainValidator->changeSpaceValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();

        $res = ShopService::changeSpace($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '分店管理', '短信充值', '短信充值成功');
        }
        return response()->json($res);
    }

    /**
     * 视频列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-10
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function video(Request $request) {
        $error_message = $this->dataService->mainValidator->videoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();

        $res = ShopService::video($user_info,$request,$request['show_count']);
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        //获取top按钮
        $sea_button_data = 'addVideo';
        $sea_button_data = CommonService::getTopButton('',$sea_button_data,$list_button);
        // 获取当前列表下的按钮
        if (empty($res)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res, 'searech_button'=>$sea_button_data]);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            foreach ($res['list'] as $key => $value) {
                $res['list'][$key]->list_button_one = [];
                if ($list_button) {
                    foreach ($list_button as $key_b => $value_b) {
                        if ($value_b['pri_operate_method'] == 'editVideo') {//编辑
                            $res['list'][$key]->list_button_one[] = $value_b;
                        }
                    }
                }
            }
            
            // 获取当前列表下的按钮
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res, 'searech_button'=>$sea_button_data]);
        }
    }

    /**
     * 新增视频
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-10
     * @param  Request          $request [description]
     */
    public function addVideo(Request $request) {
        $error_message = $this->dataService->mainValidator->addVideoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        
        $res = ShopService::addVideo($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '培训教学', '新增视频', '新增视频成功');
        }
        return response()->json($res);
    }

    /**
     * 编辑视频
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-10
     * @param  Request          $request [description]
     */
    public function editVideo(Request $request) {
        $error_message = $this->dataService->mainValidator->editVideoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        
        $res = ShopService::editVideo($user_info,$request);
        if ($res['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '培训教学', '编辑视频', '编辑视频成功');
        }
        return response()->json($res);
    }

    /**
     * 查询是否维护地址
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-23
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getAddress(Request $request) {
        $user_info = LoginUserService::getUser();
        
        $res = ShopService::getAddress($user_info,$request);
        
        return response()->json($res);
    }

    /**
     * 修改地址
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-23
     * @param  Request          $request [description]
     */
    public function addAddress(Request $request) {
        $error_message = $this->dataService->mainValidator->addAddressVideoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        
        $res = ShopService::addAddress($user_info,$request);
        return response()->json($res);
    }

    /**
     * 获取升级金额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-11-14
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getUpShopPrice(Request $request) {
        $user_info = LoginUserService::getUser();
        
        $res = ShopService::getUpShopPrice($user_info,$request);
        return response()->json($res);
    }

    /**
     * 新增邀请码
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-11-14
     * @param  Request          $request [description]
     */
    public function addInvCode(Request $request) {
        $user_info = LoginUserService::getUser();
        $res = ShopService::addInvCode($user_info,$request);
        return response()->json($res);
    }

    /**
     * 邀请码列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-10
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function invCodeIndex(Request $request) {
        
        $user_info = LoginUserService::getUser();

        $res = ShopService::invCodeIndex($user_info,$request,$request['show_count']);
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        //获取top按钮
        $sea_button_data = 'addInvCode';
        $sea_button_data = CommonService::getTopButton('',$sea_button_data,$list_button);
        // 获取当前列表下的按钮
        if (empty($res)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res, 'searech_button'=>$sea_button_data]);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            foreach ($res['list'] as $key => $value) {
                if ($value->shic_code_type == 1) {//邀请码类型1全类型可用2版本可用
                    $res['list'][$key]->shic_code_type_name = '全类型可用';
                } else {
                    $res['list'][$key]->shic_code_type_name = '版本可用';
                }
                if ($value->shic_invitation_time_type == 1) {//邀请码类型1全类型可用2版本可用
                    $res['list'][$key]->shic_invitation_time_type = '天';
                } elseif($value->shic_invitation_time_type == 2) {
                    $res['list'][$key]->shic_invitation_time_type = '周';
                } elseif($value->shic_invitation_time_type == 3) {
                    $res['list'][$key]->shic_invitation_time_type = '月';
                } elseif($value->shic_invitation_time_type == 4) {
                    $res['list'][$key]->shic_invitation_time_type = '年';
                }
                $res['list'][$key]->list_button_one = [];
                if ($list_button) {
                    foreach ($list_button as $key_b => $value_b) {
                        if ($value_b['pri_operate_method'] == 'editVideo') {//编辑
                            $res['list'][$key]->list_button_one[] = $value_b;
                        }
                    }
                }
            }
            
            // 获取当前列表下的按钮
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$res, 'searech_button'=>$sea_button_data]);
        }
    }

    /**
     * 获取邀请码优惠金额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-11-15
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getCodePrice(Request $request) {
        $user_info = LoginUserService::getUser();
        
        $res = ShopService::getCodePrice($user_info,$request);
        return response()->json($res);
    }
}