<?php

namespace App\Http\Controllers\Mounting\Point;

use App\Services\CommonService;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Services\Point\PointService;
use DB;

// 积分管理
class PointController extends Controller
{
    public function __construct()
    {
        $this->dataService = $service = new PointService();
        $this->bootWithService($service);
    }

    /**
     * 积分设置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function pointConfig(Request $request) {
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $find_data = DB::table('point_config')
                ->where('poco_shop_id', $user_info->adm_shop_id)
                ->select('poco_id', 'poco_point_switch', 'poco_firstord_point', 'poco_firstord_times', 'poco_name_point', 'poco_phone_point', 'poco_birth_point')
                ->first();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
        }
        $res = $this->dataService::pointConfig($user_info, $request);
        if ($res) {
            $log_data = [
                'oplo_module'=>'积分设置',
                'oplo_action'=>'积分设置',
                'oplo_content'=>'积分设置成功',
                'oplo_ip'=>getRealIp($request),
                'order_number'=>'',
                'work_number'=>'',
                'data_source'=>1,//操作来源  1 PC  2 小程序
            ];
            $log = addNewLog($user_info, $log_data);
            return $this->success('修改成功');
        } else {
            return $this->error('修改失败');
        }
    }

    /**
     * 积分设置-新增 增送积分的商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function addPointGoods(Request $request) {
        $request['pogo_goo_point'] = intval($request['pogo_goo_point']);
        // 验证参数
        $error_message = $this->dataService->mainValidator->addPointGoodsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::addPointGoods($user_info, $request);
        $log_data = [
            'oplo_module'=>'积分设置',
            'oplo_action'=>'新增 增送积分的商品',
            'oplo_content'=>'新增 增送积分的商品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 积分设置-编辑增送积分的商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function editPointGoods(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editPointGoodsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::editPointGoods($user_info, $request);
        $log_data = [
            'oplo_module'=>'积分设置',
            'oplo_action'=>'编辑积分商品',
            'oplo_content'=>'积分积分商品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 积分设置-增送积分的商品开启关闭
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function editState(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editStateValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::editState($user_info, $request);
        if ($request['pogo_enable'] == 1) {
            $state = '开启';
        } else {
            $state = '关闭';
        }
        $log_data = [
            'oplo_module'=>'积分设置',
            'oplo_action'=>$state.'积分商品',
            'oplo_content'=>$state.'积分商品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 积分设置-增送积分的商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function pointGoods(Request $request) {
        $user_info = LoginUserService::getUser();
        if (empty($request['show_count'])) {
            $request['show_count'] = 10;
        }
        $res = $this->dataService::pointGoods($user_info, $request, $request['show_count']);
        if (isset($res['list'])) {
            return response()->json(['code'=>200, 'msg'=>'success','data'=>$res]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'暂无数据','data'=>$res]);
        }
    }

    /**
     * 积分设置-获取商品类型
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getType(Request $request) {
        $goo_type = $this->dataService::getType(false);
        return response()->json(['code'=>200, 'msg'=>'success','data'=>$goo_type]);
    }

    /**
     * 积分设置-获取商品列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getGoods(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getGoodsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        if (empty($request['show_count'])) {
            $request['show_count'] = 30;
        }
        $res = $this->dataService::getGoods($user_info, $request, $request['show_count']);
        if ($res) {
            return response()->json(['code'=>200, 'msg'=>'success','data'=>$res]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'暂无数据','data'=>$res]);
        }
    }

    /**
     * 积分设置-签到管理
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function signinConfig(Request $request) {
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $find_data = DB::table('sign_config')
                ->where('sico_shop_id', $user_info->adm_shop_id)
                ->select('sico_id', 'sico_state', 'sico_type', 'sico_day_type', 'sico_day_num')
                ->first();
            $find_data = CommonService::dataToArray($find_data);
            $day_data = DB::table('sign_day_config')
                ->where('sidco_scid', $find_data['sico_id'])
                ->where('sidco_type', '<=' ,$find_data['sico_day_num'])
                ->select('sidco_type', 'sidco_points')
                ->get();
            $day_data = CommonService::dataToArray($day_data);
            $find_data['day_data'] = $this->dataService::getSigninType($find_data['sico_day_type'], $day_data);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
        }
        $res = $this->dataService::signinConfig($user_info, $request);
        $log_data = [
            'oplo_module'=>'签到设置',
            'oplo_action'=>'签到设置',
            'oplo_content'=>'签到设置',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        if ($res) {
            return $this->success('修改成功');
        } else {
            return $this->error('修改失败');
        }
    }

    /**
     * 新增签到礼品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  Request          $request [description]
     */
    public function addSignGoods(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addSignGoodsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::addSignGoods($user_info, $request);
        $log_data = [
            'oplo_module'=>'签到设置',
            'oplo_action'=>'新增签到礼品'.$request['sigo_goo_name'],
            'oplo_content'=>'新增签到礼品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 编辑签到礼品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  Request          $request [description]
     */
    public function editSignGoods(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editSignGoodsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::editSignGoods($user_info, $request);
        $log_data = [
            'oplo_module'=>'签到设置',
            'oplo_action'=>'编辑签到礼品',
            'oplo_content'=>'编辑签到礼品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 开启关闭签到礼品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  Request          $request [description]
     */
    public function signState(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->signStateValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::signState($user_info, $request);
        if ($request['sigo_state'] == 1) {
            $state = '开启';
        } else {
            $state = '关闭';
        }
        $log_data = [
            'oplo_module'=>'签到设置',
            'oplo_action'=>$state.'签到礼品',
            'oplo_content'=>$state.'签到礼品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 签到设置-礼品状态
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getSignState(Request $request) {
        $goo_type = $this->dataService::getSignState(false);
        return response()->json(['code'=>200, 'msg'=>'success','data'=>$goo_type]);
    }

    /**
     * 签到设置-礼品方式
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getSignWay(Request $request) {
        $goo_type = $this->dataService::getSignWay(false);
        return response()->json(['code'=>200, 'msg'=>'success','data'=>$goo_type]);
    }

    /**
     * 签到设置-礼品次数
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getSignNum(Request $request) {
        $goo_type = $this->dataService::getSignNum(false);
        return response()->json(['code'=>200, 'msg'=>'success','data'=>$goo_type]);
    }

    /**
     * 签到礼品列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function signGoods(Request $request) {
        $user_info = LoginUserService::getUser();
        if (empty($request['show_count'])) {
            $request['show_count'] = 10;
        }
        $res = $this->dataService::signGoods($user_info, $request, $request['show_count']);
        if (isset($res['list'])) {
            return response()->json(['code'=>200, 'msg'=>'success','data'=>$res]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'暂无数据','data'=>$res]);
        }
    }

    /**
     * 积分设置-分享设置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function shareConfig(Request $request) {
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $find_data = DB::table('share_config')
                ->where('shco_shop_id', $user_info->adm_shop_id)
                ->select('shco_id', 'shco_first_point', 'shco_proportion', 'shco_divide_point', 'shco_divide_proportion')
                ->first();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
        }
        $res = $this->dataService::shareConfig($user_info, $request);
        $log_data = [
            'oplo_module'=>'分享设置',
            'oplo_action'=>'分享设置',
            'oplo_content'=>'分享设置',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        if ($res) {
            return $this->success('修改成功');
        } else {
            return $this->error('修改失败');
        }
    }

    /**
     * 积分设置-新增积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function addPointGift(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addPointGiftValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::addPointGift($user_info, $request);
        $log_data = [
            'oplo_module'=>'积分设置',
            'oplo_action'=>'新增积分商品',
            'oplo_content'=>'新增积分商品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 积分商品类型
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getPointGift(Request $request) {
        $goo_type = $this->dataService::getPointGift(false);
        return response()->json(['code'=>200, 'msg'=>'success','data'=>$goo_type]);
    }

    /**
     * 积分商品属性
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getProperties(Request $request) {
        $goo_type = $this->dataService::getProperties(false);
        return response()->json(['code'=>200, 'msg'=>'success','data'=>$goo_type]);
    }

    /**
     * 积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function index(Request $request) {
        $user_info = LoginUserService::getUser();
        if (empty($request['show_count'])) {
            $request['show_count'] = 10;
        }
        $res = $this->dataService::index($user_info, $request, $request['show_count']);
        if (isset($res['list'])) {
            return response()->json(['code'=>200, 'msg'=>'success','data'=>$res]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'暂无数据','data'=>$res]);
        }
    }

    /**
     * 积分设置-编辑积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function editPointGift(Request $request) {
        if ($request['type'] == 1) {
            $find_data = DB::table('point_gift_goods')
                ->where('pogg_id', $request['pogg_id'])
                ->first();
            return response()->json(['code'=>200, 'msg'=>'success','data'=>$find_data]);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->editPointGiftValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::editPointGift($user_info, $request);
        $log_data = [
            'oplo_module'=>'积分设置',
            'oplo_action'=>'新增积分商品',
            'oplo_content'=>'新增积分商品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }

    /**
     * 积分商城-积分商品开启关闭
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function poggState(Request $request) {
        // 验证参数
        $error_message = $this->dataService->mainValidator->poggStateValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $user_info = LoginUserService::getUser();
        $res = $this->dataService::poggState($user_info, $request);
        if ($request['pogg_state'] == 1) {
            $state = '开启';
        } else {
            $state = '关闭';
        }
        $log_data = [
            'oplo_module'=>'积分商城',
            'oplo_action'=>$state.'积分商品',
            'oplo_content'=>$state.'积分商品',
            'oplo_ip'=>getRealIp($request),
            'order_number'=>'',
            'work_number'=>'',
            'data_source'=>1,//操作来源  1 PC  2 小程序
        ];
        $log = addNewLog($user_info, $log_data);
        return response()->json($res);
    }
}