<?php

namespace App\Http\Controllers\Mounting\Operation;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use App\Services\Operation\StoreListService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;

// 门店列表
class StoreListController extends Controller
{
    public function __construct()
    {
        $this->dataService = $service = new StoreListService();
        $this->bootWithService($service);
    }
    public $shop_cid = 1;


    // 新增
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $request['shop_cid'] = $this->shop_cid;
        $res = StoreListService::add($user_info, $request->all());
        return $res;
    }
}
