<?php

namespace App\Http\Controllers\Mounting\Operation;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Operation\BusinessService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use \PhpOffice\PhpSpreadsheet\IOFactory;
use App\Services\Business\WashOrderService;

// 企业管理
class BusinessController extends Controller
{
    public function __construct()
    {
        $this->dataService = $service = new BusinessService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 查询字段
        $field_columns = ['bucl_id', 'bucl_name', 'bucl_address', 'bucl_user_phone', 'bucl_user_name', 'bucl_create_id', 'bucl_create_time', 'bucl_update_id', 'bucl_update_time', 'bucl_state', 'bucl_province', 'bucl_city', 'bucl_county', 'bucl_arrears', 'bucl_rec_banlance', 'bucl_gift_banlance'];
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($user_info, $request->all(), 10, $field_columns);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            foreach ($search_data['data'] as $key => $value) {
                $search_data['data'][$key]->banlance = $value->bucl_rec_banlance + $value->bucl_gift_banlance;
            }
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button]);
        }
    }

    // 账号管理列表
    public function accIndex(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->accIndexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 查询字段
        $field_columns = ['buac_id', 'buac_name', 'buac_phone', 'buac_create_time', 'buac_create_adm_id', 'buac_sex'];
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->accIndex($user_info, $request->all(), 10, $field_columns);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            // 获取当前列表下的按钮
            $list_button = getListButton($request['api_token'], $request['pri_id']);
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button]);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $exist = BusinessService::nameExists($user_info, $request->all(), 0);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }
        DB::beginTransaction();
        $res = BusinessService::add($user_info, $request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '企业客户', '新增', '新增'.$request['bucl_name'].'成功');
            DB::commit();
            return $this->success('新增成功');
        } else {
            DB::rollBack();
            return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 新增账号
    public function addAccount(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addAccountValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        $exist = BusinessService::phoneExists($user_info, $request->all(), 0);
        if ($exist == 1) {
            return $this->error('该手机号已绑定在合作单位内', ErrorInc::DATA_EXIST);
        } elseif ($exist == 2) {
            return $this->error('该手机号已绑定其他汽车美装，暂不能绑定', ErrorInc::DATA_EXIST);
        }
        $res = BusinessService::addAccount($user_info, $request->all());
        if ($res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '企业客户', '新增账号', '新增'.$request['buac_name'].'成功');
            $data['buac_id'] = $res;
            return $this->success('新增成功',$data);
        } else {
            DB::rollBack();
            return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

     // 删除企业
    public function busdelete(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->deleteValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $res = BusinessService::busdelete($request['bucl_id']);
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '企业客户', '删除', '删除成功');
            return $this->success('删除成功');
        } else {
            return $this->error('删除失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 删除账号
    public function accdelete(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->accdeleteValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        
        $res = BusinessService::accdelete($request['buac_id']);
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '企业客户', '删除账号', '删除成功');
            return $this->success('删除成功');
        } else {
            return $this->error('删除失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $return_data = DB::table('business_client')
                ->where('bucl_id', $request['bucl_id'])
                ->select('bucl_id', 'bucl_name', 'bucl_user_name', 'bucl_user_phone', 'bucl_user_name', 'bucl_province', 'bucl_city', 'bucl_county', 'bucl_state', 'bucl_address')
                ->first();
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->editValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $exist = BusinessService::nameExists($user_info, $request->all(), $request['bucl_id']);
        if ($exist) {
            return $this->error('同名内容已经存在', ErrorInc::DATA_EXIST);
        }

        $res = BusinessService::edit($user_info,$request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '企业客户', '编辑', '编辑成功');
            return $this->success('编辑成功');
        } else {
            return $this->error('编辑失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 启用
    public function start(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = BusinessService::editState($request['bucl_id'], 1);
        if ($res) {
            // 获取启用的名称
            OperationLog::addLog($user_info, getRealIp($request), '企业客户', '启用', '启用成功');
            return $this->success('启用成功');
        } else {
            return $this->error('启用失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 停用
    public function stop(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->startValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = BusinessService::editState($request['bucl_id'], 2);
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '企业客户', '停用', '停用成功');
            return $this->success('停用成功');
        } else {
            return $this->error('停用失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 类型提示信息
    private function typeHint($type)
    {
        if ($type == 1) {
            $hint = '绩效管理-按施工部位';
        } elseif ($type == 2) {
            $hint = '绩效管理-按整车';
        } else {
            $hint = '绩效管理-其他';
        }
        return $hint;  
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getGradeProfessional(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getGradeProfessionalValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        $user_info = LoginUserService::getUser();
        if (in_array($request['type'], [1])) {
            // 职称管理列表
            $search_data = $this->dataServiceGrade->searchPage($user_info, $request->all(), 10);
        } else {
            // 级别管理列表
            $search_data = $this->contentService->searchPage($user_info, $request->all(), 10);
        }

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 导入-下载模板
    public function downTemplate(Request $request)
    {
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/Template/Business.xlsx']);
    }

    // 批量新增导入
    public function lead(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->leadValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！');
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $file = $request->file('file');

        // $res = $this->verifyLead($request);
        if ($file->isValid()) {
            // 获取表格的大小，限制上传表格的大小5M
            $file_size = $_FILES['file']['size'];
            if ($file_size > 5 * 1024 * 1024) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'文件大小不能超过5M']);
            }

            // 限制上传表格类型
            $ext = $file->getClientOriginalExtension(); //文件拓展名
            if ($ext != 'xlsx') {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仅允许上传以xlsx结尾的后缀文件']);
            }

            // 有Xls和Xlsx格式两种
            $objReader = IOFactory::createReader('Xlsx');
            $filename = $_FILES['file']['tmp_name'];
            $objPHPExcel = $objReader->load($filename);  //$filename可以是上传的表格，或者是指定的表格
            $sheet = $objPHPExcel->getSheet(0);   //excel中的第一张sheet
            $highestRow = $sheet->getHighestRow();       // 取得总行数
            if ($highestRow < 2) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'未获取到会员数据']);
            }
            if ($highestRow > 2503) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'一次最多导入1500条数据']);
            }

            // 循环读取excel表格，整合成数组,如果是不指定key的二维,就用$data[i][j]表示。
            $usersExits = [];
            DB::beginTransaction();
            $hint = '';
            for ($j = 2; $j <= $highestRow; $j++) {
                $bucl_data['bucl_cid'] = $user_info->adm_cid; //所属企业id
                $bucl_data['bucl_shop_id'] = $user_info->adm_shop_id; //所属门店id
                // 企业名称
                $bucl_data['bucl_name'] = trim($objPHPExcel->getActiveSheet()->getCell("A" . $j)->getValue());
                if (empty($bucl_data['bucl_name'])) {
                    $hint .= '企业名称必填，';
                }
                if (strlen($bucl_data['bucl_name']) > 240) {
                    $hint .= '企业名称最多80个字，';
                }
                
                
                $buac_data['buac_phone'] = trim($objPHPExcel->getActiveSheet()->getCell("I" . $j)->getValue());
                if (empty($buac_data['buac_phone'])) {
                    $hint .= '账号电话必填，';
                }
                $find_bucl = DB::table('business_client')
                    ->where('bucl_name', $bucl_data['bucl_name'])
                    ->value('bucl_id');
                $find_buac = DB::table('business_account')
                    ->where('buac_phone', $buac_data['buac_phone'])
                    ->value('buac_id');
                // 联系人
                $bucl_data['bucl_user_name'] = trim($objPHPExcel->getActiveSheet()->getCell("B" . $j)->getValue());
                if (empty($bucl_data['bucl_user_name'])) {
                    $hint .= '联系人必填，';
                }
                $bucl_data['bucl_user_phone'] = trim($objPHPExcel->getActiveSheet()->getCell("C" . $j)->getValue());
                if (empty($bucl_data['bucl_user_phone'])) {
                    $hint .= '联系电话必填，';
                }
                $bucl_data['bucl_province'] = trim($objPHPExcel->getActiveSheet()->getCell("D" . $j)->getValue());
                if (empty($bucl_data['bucl_province'])) {
                    $hint .= '地址省必填，';
                }
                $bucl_data['bucl_city'] = trim($objPHPExcel->getActiveSheet()->getCell("E" . $j)->getValue());
                if (empty($bucl_data['bucl_city'])) {
                    $hint .= '地址市必填，';
                }
                $bucl_data['bucl_county'] = trim($objPHPExcel->getActiveSheet()->getCell("F" . $j)->getValue());
                if (empty($bucl_data['bucl_county'])) {
                    //$hint .= '地址县必填，';//20231201 修改地址县可以不填
                }
                $bucl_data['bucl_address'] = trim($objPHPExcel->getActiveSheet()->getCell("G" . $j)->getValue());
                if (empty($bucl_data['bucl_address'])) {
                    $hint .= '详细地址必填，';
                }
                $bucl_data['bucl_update_time'] = date('Y-m-d H:i:s');
                $bucl_data['bucl_update_id'] = $user_info->adm_id;
                $buac_data['buac_name'] = trim($objPHPExcel->getActiveSheet()->getCell("H" . $j)->getValue());
                if (empty($buac_data['buac_name'])) {
                    $hint .= '账号必填，';
                }
                if ($find_bucl) {
                    $bucl_id = $find_bucl;
                    $update_data_res = DB::table('business_client')
                        ->where('bucl_id', $bucl_id)
                        ->update($bucl_data);
                } else {
                    $bucl_data['bucl_create_id'] = $user_info->adm_id; //创建人
                    $bucl_data['bucl_create_time'] = date('Y-m-d H:i:s'); //创建时间
                    $bucl_id = DB::table('business_client')->insertGetId($bucl_data);
                    if (!$bucl_id) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'上传失败03']);
                    }
                }
                unset($bucl_data);
                if (!empty($hint)) {
                    return response()->json(['code'=>500, 'msg'=>$hint, 'data'=>$hint]);
                }
                $buac_data['buac_bucl_id'] = $bucl_id;
                $buac_data['buac_shop_id'] =  $user_info->adm_shop_id; //所属门店id
                $buac_data['buac_cid'] =  $user_info->adm_cid; //所属公司id
                if ($find_buac) {
                    $buac_id = $find_buac;
                    $update_buac_res = DB::table('business_account')
                        ->where('buac_id', $buac_id)
                        ->update($buac_data);
                } else {
                    $buac_data['buac_create_adm_id'] = $user_info->adm_id;
                    $buac_data['buac_create_time'] = date('Y-m-d H:i:s');
                    $buac_data['buac_password'] =  md5(111111 . 'faster123456');
                    $buac_id = DB::table('business_account')->insertGetId($buac_data);
                    if (!$bucl_id) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'上传失败03']);
                    }
                }
                unset($buac_data);
            }
            OperationLog::addLog($user_info, getRealIp($request), '企业客户', '导入', '导入成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'上传成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'上传有误,请重新上传']);
        }   
    }

    // 批量新增验证
    public function verifyLead($request)
    {
        $file = $request->file('file');

        if ($file->isValid()) {
            // 获取表格的大小，限制上传表格的大小5M
            $file_size = $_FILES['file']['size'];
            if ($file_size > 5 * 1024 * 1024) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'文件大小不能超过5M']);
            }

            // 限制上传表格类型
            $ext = $file->getClientOriginalExtension(); //文件拓展名
            if ($ext != 'xlsx') {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仅允许上传以xlsx结尾的后缀文件']);
            }

            // 有Xls和Xlsx格式两种
            $objReader = IOFactory::createReader('Xlsx');
            $filename = $_FILES['file']['tmp_name'];
            $objPHPExcel = $objReader->load($filename);  //$filename可以是上传的表格，或者是指定的表格
            $sheet = $objPHPExcel->getSheet(0);   //excel中的第一张sheet
            $highestRow = $sheet->getHighestRow();       // 取得总行数
            if ($highestRow < 3) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'未获取到企业会员数据']);
            }
            if ($highestRow > 2503) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'一次最多导入2500条数据']);
            }

            // 循环读取excel表格，整合成数组,如果是不指定key的二维,就用$data[i][j]表示。
            $hint = '';
            for ($j = 3; $j <= $highestRow; $j++) {
                // 企业名称
                $bucl_data['bucl_name'] = trim($objPHPExcel->getActiveSheet()->getCell("A" . $j)->getValue());
                if (empty($bucl_data['bucl_name'])) {
                    $hint .= '企业名称必填，';
                }
                if (strlen($bucl_data['bucl_name']) > 240) {
                    $hint .= '企业名称最多80个字，';
                }
                // 联系人
                $bucl_data['bucl_user_name'] = trim($objPHPExcel->getActiveSheet()->getCell("B" . $j)->getValue());
                if (empty($bucl_data['bucl_user_name'])) {
                    $hint .= '联系人必填，';
                }
                $bucl_data['bucl_user_phone'] = trim($objPHPExcel->getActiveSheet()->getCell("C" . $j)->getValue());
                if (empty($bucl_data['bucl_user_phone'])) {
                    $hint .= '联系电话必填，';
                }
                $bucl_data['bucl_province'] = trim($objPHPExcel->getActiveSheet()->getCell("D" . $j)->getValue());
                if (empty($bucl_data['bucl_province'])) {
                    $hint .= '地址省必填，';
                }
                $bucl_data['bucl_city'] = trim($objPHPExcel->getActiveSheet()->getCell("E" . $j)->getValue());
                if (empty($bucl_data['bucl_city'])) {
                    $hint .= '地址市必填，';
                }
                $bucl_data['bucl_county'] = trim($objPHPExcel->getActiveSheet()->getCell("F" . $j)->getValue());
                if (empty($bucl_data['bucl_county'])) {
                    $hint .= '地址县必填，';
                }
                $bucl_data['bucl_address'] = trim($objPHPExcel->getActiveSheet()->getCell("G" . $j)->getValue());
                if (empty($bucl_data['bucl_address'])) {
                    $hint .= '详细地址必填，';
                }
                $buac_data['buac_name'] = trim($objPHPExcel->getActiveSheet()->getCell("H" . $j)->getValue());
                if (empty($buac_data['buac_name'])) {
                    $hint .= '账号必填，';
                }
                $buac_data['buac_phone'] = trim($objPHPExcel->getActiveSheet()->getCell("I" . $j)->getValue());
                if (empty($buac_data['buac_phone'])) {
                    $hint .= '详细地址必填，';
                }
            }
            return $hint;
        } else {
            return '上传有误,请重新上传';
        }
    }

    /**
     * 企业会员充值
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-01-04
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function busRecharge(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $request['ord_source'] = 1;
        DB::beginTransaction();
        $result = WashOrderService::busRecharge($user_info, $request);
        if ($result['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($result);
    }

    /**
     * 企业客户充值退款
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-01-05
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function busRefund(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $request['ord_source'] = 1;
        DB::beginTransaction();
        $result = WashOrderService::busRefund($user_info, $request);
        if ($result['code'] == 200) {
            $order_ret = DB::table('order as a')
                ->leftJoin('order_client as b', 'a.ord_id', '=', 'b.orcl_ord_id')
                ->where('ord_id', $result['data']['recpay_original_id'])
                ->select('ord_order_number','orcl_name','ord_actual_price','ord_type','ord_client_id')
                ->first();
            $receivable['recpay_cid'] = $user_info->adm_cid;
            $receivable['recpay_shop_id'] = $user_info->adm_shop_id;
            $receivable['recpay_shop_superior_id'] = $user_info->adm_shop_id;
            $receivable['recpay_type'] = '2'; //类型：1.销售订单
            $receivable['recpay_original_id'] = $result['data']['recpay_original_id']; //与类型所对应的id
            $receivable['recpay_original_number'] = $order_ret->ord_order_number; //与类型所对应的单号
            $receivable['recpay_client_type'] = $order_ret->ord_type; //客户类型：1.会员零售 2.来往单位 3.加盟店 4会员零售(工单代收）
            $receivable['recpay_client_id'] = $request['bucl_id']; //会员id/来往单位id
            $receivable['recpay_client_name'] = $result['data']['bucl_name']; //来往单位名称
            $receivable['recpay_receivable_price'] = 0; //应收金额
            $receivable['recpay_arrears_price'] = 0; //欠收金额
            $receivable['recpay_actual_price'] = '0'; //实收金额
            $receivable['recpay_cost_price'] = '0'; //成本价
            $receivable['recpay_receivable_pay'] = 0; //应付金额
            $receivable['recpay_actual_pay'] = 0; //实付金额
            $receivable['recpay_state'] = '1'; //状态：1未确认2已确认
            $receivable['recpay_order_state'] = '1'; //订单状态：1正常2退款3取消
            $receivable['recpay_plus_minus'] = '2'; //盈利正负：1正值2负值
            $receivable['recpay_profit'] = abs($order_ret->ord_actual_price); //盈利金额
            DB::table('receivable_pay')->insertGetId($receivable);
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($result);
    }

    /**
     * 获取企业会员余额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-01-05
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function busBanlance(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        if (empty($request['bucl_id']) && empty($request['keywords'])) {
            return response()->json(['code' => 500, 'msg' => '请选择会员', 'data' =>[]]);
        }
        $result = WashOrderService::busBanlance($user_info, $request);
        if ($result) {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $result]);
        } else {
            return response()->json(['code' => 200, 'msg' => '暂无此会员', 'data' =>'']);
        }
    }
}