<?php

namespace App\Http\Controllers\Mounting\Finance;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Finance\WashViolationService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;
use App\Services\CommonService;

// 罚单管理
class WashViolationController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new WashViolationService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->index($user_info, $request->all(), $request['show_count']);
        if(isset($request['is_excel']) && $request['is_excel']==2){
            return $search_data;
        }
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        //获取top按钮
        $sea_button_data = 'add';
        $sea_button = CommonService::getTopButton('export',$sea_button_data,$list_button);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data, 'list_button'=>$list_button,'sea_button'=>$sea_button]);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $res = WashViolationService::add($user_info, $request->all());
        if ($res) {
            OperationLog::addLog($user_info, getRealIp($request), '罚单管理', '新增', '新增成功');
            DB::commit();
            return $this->success('新增成功');
        } else {
            DB::rollBack();
            return $this->error('新增失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 驳回
    public function reject(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = WashViolationService::reject($request->all());
        if ($res) {
            // 获取启用的名称
            OperationLog::addLog($user_info, getRealIp($request), '罚单管理', '驳回', '驳回成功');
            return $this->success('驳回成功');
        } else {
            return $this->error('驳回失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 恢复
    public function restore(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();

        $res = WashViolationService::restore($request['viti_id']);
        if ($res) {
            // 获取启用的名称
            OperationLog::addLog($user_info, getRealIp($request), '罚单管理', '恢复', '恢复成功');
            return $this->success('恢复成功');
        } else {
            return $this->error('恢复失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashViolationService::info($user_info, $request->all());
        return response()->json($return_data);
    }

    public function test(Request $request) {
        DB::beginTransaction();
        
        $phone = '1836540308';
        sleep($request['time']);
        $last_id = DB::table('account')
            ->where('phone', $phone)
            ->value('account_id');
        if ($last_id) {
            return response()->json(['code'=>500,'msg'=>'error']);
        }
        $first = DB::table('account')
            ->insert(['login_name'=>rand(100000,999999),'phone'=>$phone]);
        if ($first) {
            DB::commit();
            return response()->json(['code'=>200,'msg'=>'success','last_id'=>$last_id]);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500,'msg'=>'error']);
        }
    }
}
