<?php

namespace App\Http\Controllers\Mounting\BasicManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Mounting\Verify\BasicManage\VerifyValidateCarController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

// 验车管理
class ValidateCarController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyValidateCarController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $search_data = $request->all();
        $list_data = DB::table('wash_validate_car_manage')
            ->where('vacm_cid', $user_info->adm_cid)
            ->where('vacm_shop_id', $user_info->adm_shop_id)
            ->where('vacm_type', $request['vacm_type'])
            ->where('vacm_delete', 1)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['vacm_unusual_name'])) {
                    $query->where('vacm_unusual_name', 'like', '%'.$search_data['vacm_unusual_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['vacm_state'])) {
                    $query->where('vacm_state', $search_data['vacm_state']);
                }
            })
            ->select('vacm_id', 'vacm_unusual_name', 'vacm_remark', 'vacm_state', 'vacm_create_time')
            ->orderBy('vacm_id', 'desc')
            ->paginate($this->show_count);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        }else{
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyValidateCarController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
    	$hint = '';
    	if ($request['vacm_type'] == 1) {
    		$hint = '车内异常管理';
    	} else {
    		$hint = '外观异常管理';
    	}

        // 1. 判断异常名称是否存在
        $find_vacm = DB::table('wash_validate_car_manage')
            ->where('vacm_delete', 1)
            ->where('vacm_cid', $user_info->adm_cid)
            ->where('vacm_shop_id', $user_info->adm_shop_id)
            ->where('vacm_type', $request['vacm_type'])
            ->where('vacm_unusual_name', $request['vacm_unusual_name'])
            ->select('vacm_id')
            ->first();
        if ($find_vacm) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>$request['vacm_unusual_name'].'已存在']);
        }

        // 2 新增一个异常数据
        $vacm_add_data = [
            'vacm_cid'=>$user_info->adm_cid,
            'vacm_shop_id'=>$user_info->adm_shop_id,
            'vacm_superior_shop_id'=>$shop_id,
            'vacm_type'=>$request['vacm_type'],
            'vacm_unusual_name'=>$request['vacm_unusual_name'],
            'vacm_remark'=>$request->input('vacm_remark', ''),
        ];

        // 新增异常数据
        $vacm_res =  DB::table('wash_validate_car_manage')->insert($vacm_add_data);

        if ($vacm_res) {
            Common::addLog($user_info, getRealIp($request), '验车管理', '新增', '新增'.$hint.':'.$request['vacm_unusual_name'].'成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'新增'.$hint.'：成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'新增'.$hint.'：失败']);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyValidateCarController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
    	$hint = '';
    	if ($request['vacm_type'] == 1) {
    		$hint = '车内异常管理';
    	} else {
    		$hint = '外观异常管理';
    	}

        // 1. 判断异常名称是否存在
        $find_vacm = DB::table('wash_validate_car_manage')
            ->where('vacm_id', '<>', $request['vacm_id'])
            ->where('vacm_delete', 1)
            ->where('vacm_cid', $user_info->adm_cid)
            ->where('vacm_superior_shop_id', $shop_id)
            ->where('vacm_type', $request['vacm_type'])
            ->where('vacm_unusual_name', $request['vacm_unusual_name'])
            ->select('vacm_id')
            ->first();
        if ($find_vacm) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>$request['vacm_unusual_name'].'已存在']);
        }

        // 2 编辑异常数据数据
        $vacm_edit_data = [
            'vacm_cid'=>$user_info->adm_cid,
            'vacm_shop_id'=>$user_info->adm_shop_id,
            'vacm_superior_shop_id'=>$shop_id,
            'vacm_type'=>$request['vacm_type'],
            'vacm_unusual_name'=>$request['vacm_unusual_name'],
            'vacm_remark'=>$request->input('vacm_remark', ''),
            'vacm_update_time'=>date('Y-m-d H:i:s'),
        ];
        // 编辑异常数据
        $vacm_res =  DB::table('wash_validate_car_manage')
                    ->where('vacm_id', $request['vacm_id'])
                    ->update($vacm_edit_data);

        if ($vacm_res) {
            Common::addLog($user_info, getRealIp($request), '验车管理', '编辑', '编辑'.$hint.'：'.$request['vacm_unusual_name'].'成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑'.$hint.'：成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑'.$hint.'：失败']);
        }
    }

    // 启用
    public function start(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyValidateCarController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询信息
        $find_vacm = DB::table('wash_validate_car_manage')
                    ->whereIn('vacm_id',$request['vacm_id'])
                    ->select('vacm_unusual_name')
                    ->get();
        foreach ($find_vacm as $key => $value) {
            $vacm_unusual_name[] = $value->vacm_unusual_name;
        }

        // 启用
        $update_data['vacm_state'] = 1;//状态1启用2停用
        $update_data['vacm_update_time'] = date('Y-m-d H:i:s');
        $vacm_res = DB::table('wash_validate_car_manage')
                    ->whereIn('vacm_id', $request['vacm_id'])
                    ->update($update_data);
        if($vacm_res) {
	    	if ($request['vacm_type'] == 1) {
	    		$hint = '车内异常管理';
	    	} else {
	    		$hint = '外观异常管理';
	    	}
            Common::addLog($user_info, getRealIp($request), '验车管理', '启用', $hint.'：（'.implode(',', $vacm_unusual_name).'）启用成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'启用成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'启用失败']);
        }
    }

    // 停用
    public function stop(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyValidateCarController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询信息
        $find_vacm = DB::table('wash_validate_car_manage')
                    ->whereIn('vacm_id',$request['vacm_id'])
                    ->select('vacm_unusual_name')
                    ->get();
        foreach ($find_vacm as $key => $value) {
            $vacm_unusual_name[] = $value->vacm_unusual_name;
        }

        // 启用
        $update_data['vacm_state'] = 2;//状态1启用2停用
        $update_data['vacm_update_time'] = date('Y-m-d H:i:s');
        $vacm_res = DB::table('wash_validate_car_manage')
                    ->whereIn('vacm_id', $request['vacm_id'])
                    ->update($update_data);

        if($vacm_res) {
        	if ($request['vacm_type'] == 1) {
	    		$hint = '车内异常管理';
	    	} else {
	    		$hint = '外观异常管理';
	    	}
            Common::addLog($user_info, getRealIp($request), '验车管理', '停用', $hint.'：（'.implode(',', $vacm_unusual_name).'）停用成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'停用成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'停用失败']);
        }
    }

    // 删除
    public function delete(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyValidateCarController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询信息
        $find_vacm = DB::table('wash_validate_car_manage')
                    ->whereIn('vacm_id',$request['vacm_id'])
                    ->select('vacm_unusual_name')
                    ->get();
        foreach ($find_vacm as $key => $value) {
            $vacm_unusual_name[] = $value->vacm_unusual_name;
        }

        // 删除
        $update_data['vacm_delete'] = 2;//是否删除：1正常2已删除
        $update_data['vacm_update_time'] = date('Y-m-d H:i:s');
        $vacm_res = DB::table('wash_validate_car_manage')
                    ->whereIn('vacm_id', $request['vacm_id'])
                    ->update($update_data);

        if($vacm_res) {
        	if ($request['vacm_type'] == 1) {
	    		$hint = '车内异常管理';
	    	} else {
	    		$hint = '外观异常管理';
	    	}
            Common::addLog($user_info, getRealIp($request), '验车管理', '删除', $hint.'：（'.implode(',', $vacm_unusual_name).'）删除成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }

    // 搜索验车管理数据
    public function searchValidateCar(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyValidateCarController;
        $error_message = $verify_data->searchValidateCarValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        $list_data = DB::table('wash_validate_car_manage')
            ->where('vacm_shop_id', $request['shop_id'])
            ->where('vacm_type', $request['vacm_type'])
            ->where('vacm_delete', 1)
            ->where('vacm_state', 1)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['vacm_unusual_name'])) {
                    $query->where('vacm_unusual_name', 'like', '%'.$search_data['vacm_unusual_name'].'%' );
                }
            })
            ->select('vacm_id', 'vacm_unusual_name')
            ->orderBy('vacm_id', 'asc')
            ->paginate($this->show_count);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        if($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        }else{
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
}
