<?php
/*
|--------------------------------------------------------------------------
| 技师绩效办法接口
|--------------------------------------------------------------------------
|
|  @Date: 2021/8/18
|  @Time: 14:10
|  @version 1.0
|  @copyright BlueCity
*/
namespace App\Http\Controllers\Common;

use App\Services\MeritPayOptionsService;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;

class MeritPayController extends Controller
{
    /**
     * @api {get} /api/Common/meritPay/options 技师绩效列表
     * @apiGroup MeritPay
     * @apiName 技师绩效管理
     * @apiVersion 1.0.0
     *
     * @apiDescription 技师绩效管理列表
     *
     * @apiParam {String} keywords      关键字
     * @apiParam {String} page          页码
     * @apiParam {String} page_size     页容量
     *
     * @apiSuccess {Number} error       状态码，0：请求成功
     * @apiSuccess {String} msg         提示信息
     * @apiSuccess {Object} data        返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常","data":[]}
     *
     */
    public function options(Request $request)
    {
        $keywords = $request->get('keywords');
        $shopID = $request->get('shop_id');
        $type = $request->get('m_type');
        $options = [];
        if (1 == $type) {
            $options = MeritPayOptionsService::getPartsMerits($keywords, $shopID);
        } elseif (2 == $type) {
            $options = MeritPayOptionsService::getTecMerits($keywords, $shopID);
        } elseif (3 == $type) {
            $options = MeritPayOptionsService::getOtherMerits($keywords, $shopID);
        }

        return $this->success('获取成功', $options);
    }

    /**
     * @api {get} /api/Common/meritPay/options 技师绩效列表
     * @apiGroup MeritPay
     * @apiName 技师绩效管理
     * @apiVersion 1.0.0
     *
     * @apiDescription 技师绩效管理列表
     *
     * @apiParam {String} keywords      关键字
     * @apiParam {String} page          页码
     * @apiParam {String} page_size     页容量
     *
     * @apiSuccess {Number} error       状态码，0：请求成功
     * @apiSuccess {String} msg         提示信息
     * @apiSuccess {Object} data        返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常","data":[]}
     *
     */
    public function titles(Request $request)
    {
        $keywords = $request->get('keywords');
        $shopID = $request->get('shop_id');
        $type = $request->get('m_type');
        $options = [];
        if (1 == $type) {
            $options = MeritPayOptionsService::getPartsMerits($keywords, $shopID);
        } elseif (2 == $type) {
            $options = MeritPayOptionsService::getTecMerits($keywords, $shopID);
        } elseif (3 == $type) {
            $options = MeritPayOptionsService::getOtherMerits($keywords, $shopID);
        }

        return $this->success('获取成功', $options);
    }


}
