<?php
/*
|--------------------------------------------------------------------------
| 汽车相关公用接口控制器
|--------------------------------------------------------------------------
|
|  @Date: 2021/8/25
|  @Time: 23:33
|  @version 1.0
|  @copyright BlueCity
*/

namespace App\Http\Controllers\Common;

use App\Services\AutoPartsService;
use App\Services\LoginUserService;
use App\Services\TechnicalTitleService;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\TechnicalLevelService;
use BlueCity\Core\Inc\ErrorInc;

class AutoController extends Controller
{
    //

    /**
     * @api {post} /api/Common/auto/parts 全部部位
     * @apiGroup common_auto
     * @apiName 汽车查询
     * @apiVersion 1.0.0
     *
     * @apiDescription 获取全部部位列表
     *
     * @apiParam {String} $keywords   部位关键字
     *
     * @apiSuccess {Number} error    状态码，0：请求成功
     * @apiSuccess {String} msg   提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常"}
     *
     */
    public function parts(Request $request) {
        $keywords = $request->get('keywords');
        $type = $request->get('type');
        if ($type == 1) {
            $data = AutoPartsService::searchType();
            return $this->success('获取成功', $data);
        }
        if ($type == 2) {
            $data = AutoPartsService::searchByType($keywords);
            return $this->success('获取成功', $data);
        }
        if (!empty($keywords)) {
            $data = AutoPartsService::searchTitle($keywords);
            $data = json_decode(json_encode($data,true), true);
        } else {
            $data = AutoPartsService::getAll();
        }
        return $this->success('获取成功', $data);
    }
    /**
     * @api {post} /api/Common/auto/brands 车品牌
     * @apiGroup common_auto
     * @apiName 汽车查询
     * @apiVersion 1.0.0
     *
     * @apiDescription 获取全部车品牌列表
     *
     * @apiParam {String} $keywords   车品牌关键字
     *
     * @apiSuccess {Number} error    状态码，0：请求成功
     * @apiSuccess {String} msg   提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":0,"message":"","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":5001,"message":"接口异常"}
     *
     */
    public function brands(Request $request) {
        $keywords = $request->get('keywords');
        if ($keywords != '') {

        }
    }
}
