<?php

namespace App\Http\Controllers\Api\Workbench;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\Workbench\VerifyLocationController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class LocationController extends Controller
{
	// 搜索技师定位数据
    public function searchLocation(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyLocationController;
        $error_message = $verify_data->searchLocationValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        if ($request['shop_id']) {
            $shop_id = $request['shop_id'];
        }else{
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            $shop_id = $user_info->adm_shop_id;
        }
        $search_data = $request->all();
        // 查询门店下技师的当前的定位信息
        $list_data = DB::table('lat as l')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'l.lat_aid')
                    ->where('lat_shop_id',$shop_id)
                    ->where('lat_work_state',2)
                    // ->where('lat_time','>=',date('Y-m-d H:i:s', strtotime( '-2 Minute')))
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['search_data'])) {
                            $query->where('adm_name', 'like', $search_data['search_data'].'%' )
                                  ->orwhere('adm_phone', 'like', $search_data['search_data'].'%' );
                        }
                    })
                    ->get(['lat_id','lat_lat','lat_lon','lat_aid','lat_ord_state','lat_ord_id','lat_time','adm_name','adm_phone','lat_work_state']);
        $now_time = date('Y-m-d H:i:s');
        if (!empty($list_data)) {
            foreach ($list_data as $key => $value) {
                $list_data[$key]->now_time = $now_time;
            }
        }
        return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$list_data, 'now_time'=>$now_time]);
    }

    // 搜索移动仓数据
    public function searchMobileSilo(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyLocationController;
        $error_message = $verify_data->searchMobileSiloValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 查询技师所在的仓库信息
       $ware_data = DB::table('warehouse as a')
                ->leftJoin('admin as c', 'c.adm_id', '=', 'a.ware_leader_id')
                ->where('ware_leader_id', $request['adm_id'])
                ->where('ware_type', 2)
                ->select('ware_id', 'ware_name', 'adm_name', 'adm_phone')
                ->first();
        if (empty($ware_data)) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'当前技师暂未绑定移动仓']);
        }
        
        // 查询仓库的商品信息
        $goods_data = DB::table('warehouse_goods as a')
                ->leftJoin('goods as c', 'c.goo_id', '=', 'a.wago_goo_id')
                ->where('wago_ware_id', $ware_data->ware_id)
                ->get(['goo_name', 'goo_goods_encode', 'wago_stock_number']);
        $data['ware_data'] = $ware_data;
        $data['goods_data'] = $goods_data;
        return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$data]);
    }
}
