<?php
namespace App\Http\Controllers\Api\WarehouseManage;

use App\Services\Business\DeliveryService;
use App\Services\CommonService;
use Illuminate\Http\Request;
use App\Http\Models\Api\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\WarehouseManage\VerifyDispatchController;
use App\Http\Models\Api\Export;
use App\Http\Models\Services\Prints;
use App\Http\Models\Services\Dispatch;
use App\Http\Models\Api\ReceivableBill;
use App\Http\Models\Api\WorkOrder;
use App\Services\Business\WashOrderService;
use App\Services\Business\WashDispatchService;
use App\Services\Business\WashOrderBasicService;

// 仓储系统 -- 发货单
class DispatchController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyDispatchController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;

        $search_data = $request->all();
        $page_size = $request->input('show_count', 10);
        $list_data = DB::table('dispatch_bill as dibi')
            ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'dibi.dego_wor_id')
            ->where('dego_cid', $user_info->adm_cid)
            ->where('dego_shop_id', $shop_id)
            ->where('dego_type', '<>', 3)
            ->where(function ($query) use ($search_data) { //类型：1未出库2已出库
                if (!empty($search_data['dego_type'])) {
                    $query->where('dego_type', $search_data['dego_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('dego_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('dego_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('dego_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //门店id
                if (!empty($search_data['dego_service_shop_id'])) {
                    $query->where('dego_service_shop_id', $search_data['dego_service_shop_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //供货仓库
                if (!empty($search_data['dego_out_ware_id'])) {
                    $query->where('dego_out_ware_id', $search_data['dego_out_ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单号
                if (!empty($search_data['dego_original_number'])) {
                    $query->where('wor_order_number', 'like', '%' . $search_data['dego_original_number'] . '%')
                        ->where('dego_order_type', 2)
                        ->orwhere('dego_original_number', 'like', '%' . $search_data['dego_original_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //发货单号
                if (!empty($search_data['dego_number'])) {
                    $query->where('dego_number', 'like', '%' . $search_data['dego_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //领货人
                if (!empty($search_data['dego_service_adm_id'])) {
                    $query->where('dego_service_adm_id', $search_data['dego_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //客户id
                if (!empty($search_data['dego_client_id'])) {
                    $query->where('dego_client_id', $search_data['dego_client_id']);
                }
            })
            ->select('dego_id', 'wor_order_number', 'dego_create_time', 'dego_number', 'dego_original_number', 'dego_count', 'dego_service_shop_id', 'dego_out_ware_id', 'dego_service_adm_id', 'dego_type', 'dego_wor_id', 'dego_order_type')
            ->orderBy('dego_id', 'desc')
            ->paginate($page_size);

        $list_items = $list_data->items();
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_items) {
            $order_id = [];
            $wor_id = [];
            $after_id = [];
            $shop_id = array_unique(array_column($list_items, 'dego_service_shop_id')); //服务门店id
            $ware_id = array_unique(array_column($list_items, 'dego_out_ware_id')); //出库仓库id
            $adm_id = array_unique(array_column($list_items, 'dego_service_adm_id')); //服务技师id
            $dego_client_id = array_unique(array_column($list_items, 'dego_client_id')); //选择的客户id,会员id/单位id
            foreach ($list_items as $key => $value) {
                // 订单发货
                if ($value->dego_order_type == 1) {
                    $order_id[] = $value->dego_wor_id;
                    $dego_service_adm_id = DB::table('order')
                        ->leftjoin('order_client', 'orcl_ord_id', '=', 'ord_id')
                        ->where('ord_order_number', $value->dego_original_number)
                        ->value('orcl_sales_adm_id');
                    $adm_id[] = $dego_service_adm_id;
                    $list_items[$key]->dego_service_adm_id = $dego_service_adm_id;
                }
                // 工单发货
                if ($value->dego_order_type == 2) {
                    $wor_id[] = $value->dego_wor_id;
                }
                // 售后单发货
                if ($value->dego_order_type == '3') {
                    $after_id[] = $value->dego_wor_id;
                }
                $goo_data = DB::table('dispatch_goods as dg')
                    ->leftjoin('goods as g', 'g.goo_id', '=', 'dg.digo_goo_id')
                    ->where('digo_dego_id', $value->dego_id)
                    ->select('goo_name', 'digo_goo_unit', 'digo_goo_unta_id', 'goo_unit_conversion', 'digo_goo_quantity')
                    ->get()->toArray();
                if ($goo_data) {
                    $list_items[$key]->goo_data = $goo_data;
                }
            }

            // 查找门店id对应的门店名称
            $shop_id = array_unique($shop_id);
            $find_shop = DB::table('shop')
                ->whereIn('shop_id', $shop_id)
                ->select('shop_id', 'shop_store_name')
                ->get()->toArray();
            // 查找仓库id对应的仓库名称 / 负责人
            $ware_id = array_unique($ware_id);
            $ware_type = [];
            $find_ware = DB::table('warehouse as w')
                ->whereIn('ware_id', $ware_id)
                ->select('ware_id', 'ware_name', 'ware_type', 'ware_leader_id')
                ->get()->toArray();
            foreach ($find_ware as $key => $value) {
                $adm_id = explode(',',$value->ware_leader_id);
                $adm_name = DB::table('admin')
                    ->whereIn('adm_id', $adm_id)
                    ->select('adm_name')
                    ->get()->toArray();
                $adm_name = array_column($adm_name, 'adm_name');
                $adm_name =  implode(',', $adm_name);
                $find_ware[$key]->adm_name = $adm_name;
                $ware_type[$value->ware_id]['type'] = $value->ware_type;
            }

            // 查询客户单位
            $channel = DB::table('channel_unit')
                ->whereIn('chun_id', $dego_client_id)
                ->where('chun_shop_id', $shop_id)
                ->where('chun_state', '1')
                ->pluck('chun_id', 'chun_unit_name')
                ->toArray();
            // 查找工单客户信息
            $work_client = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->whereIn('wocl_wor_id', $wor_id)
                ->select('wocl_wor_id', 'wocl_channel_unit', 'wocl_name', 'wor_type', 'wor_service_state', 'wocl_standby_battery_type', 'wor_order_number', 'wocl_client_id')
                ->get()->toArray();
            foreach ($work_client as $key => $value) {
                // 客户单位名称
                if (isset($channel[$value->wocl_client_id])) {
                    $work_client[$key]->wocl_channel_unit = $channel[$value->wocl_client_id];
                } else {
                    $work_client[$key]->wocl_channel_unit = $value->wocl_channel_unit ? $value->wocl_channel_unit : $value->wocl_name;
                }
                if ($value->wor_type == 3) {
                    $work_client[$key]->wocl_channel_unit = config('apisystem.sd_chan_info')['name'];
                }
                $work_client_service[$value->wocl_wor_id]['wor_service_state'] = $value->wor_service_state;
            }
            // 查找订单客户信息
            $order_client = DB::table('order as ord')
                ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                ->whereIn('orcl_ord_id', $order_id)
                ->get(['orcl_ord_id', 'orcl_channel_unit', 'orcl_name', 'ord_type', 'orcl_standby_battery_type', 'ord_order_number', 'orcl_client_id']);
            foreach ($order_client as $key => $value) {
                // 客户单位名称
                if (isset($channel[$value->orcl_client_id])) {
                    $order_client[$key]->orcl_channel_unit = $channel[$value->orcl_client_id];
                } else {
                    $order_client[$key]->orcl_channel_unit = $value->orcl_channel_unit ? $value->orcl_channel_unit : $value->orcl_name;
                }
                if ($value->ord_type == 3) {
                    $order_client[$key]->orcl_channel_unit = config('apisystem.sd_chan_info')['name'];
                }
            }
            // 查找售后单客户信息
            $after_client = DB::table('wash_after_sale_list as afsl')
                ->leftjoin('wash_after_sale_client as afsc', 'afsc.afsc_afsl_id', '=', 'afsl.afsl_id')
                ->whereIn('afsl_id', $after_id)
                ->get(['afsl_id', 'afsc_channel_unit', 'afsc_name', 'afsl_type']);

            // 查找技师id对应的领货人姓名
            $adm_id = array_unique($adm_id);
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->get(['adm_id', 'adm_name']);
            // 查询当前账号所拥有的仓库权限
            $find_admin_set = DB::table('admin_set')
                ->where('adms_adm_id', $user_info->adm_id)
                ->where('adms_shop_id', $user_info->adm_shop_id)
                // ->value('adms_ware_id');
                ->value('adms_myware_id');
            foreach ($list_items as $key_bu => $value_bu) {
                $buttonData = [];
                //dego_type:1未出库2已出库3作废4锁定 dego_order_type 类型：1.订单发货 2.工单发货3售后单发货
                if($value_bu->dego_type == 1 && (($value_bu->dego_order_type == 2 && isset($work_client_service[$value_bu->dego_wor_id]['wor_service_state']) && $work_client_service[$value_bu->dego_wor_id]['wor_service_state'] > 1) || $value_bu->dego_order_type == 1 || $value_bu->dego_order_type == 4) && isset($ware_type[$value_bu->dego_out_ware_id]['type']) && $ware_type[$value_bu->dego_out_ware_id]['type'] != 3){
                    $buttonData[] = 'shipments';//立即发货
                }
                if ($value_bu->dego_type == 1 && $value_bu->dego_order_type == 3) {
                    $buttonData[] = 'shipments';//立即发货
                }
                $buttonData[] = 'info';//查看详情
                $buttonData[] = 'print';//打印订单
                $buttonData[] = 'getorderpic';//查看凭证
                $buttonData[] = 'deliveryList';//快递信息
                $button = CommonService::getListButton($buttonData,$list_button);
                $list_items[$key_bu]->button_one = $button['button_one']??[];
                $list_items[$key_bu]->button_two = $button['button_two']??[];
                $list_items[$key_bu]->button_three = $button['button_three']??[];
            }
        } else {
            $find_shop = [];
            $find_ware = [];
            $find_admin = [];
            $order_client = [];
            $work_client = [];
            $after_client = [];
            $find_admin_set = '';
        }

        $state_count = DB::table('dispatch_bill')
            ->where('dego_cid', $user_info->adm_cid)
            ->where('dego_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw('count(*) as count, dego_type'))
            ->groupBy('dego_type')
            ->get();

        // 查询门店打印模板
        $shpt_id = DB::table('shop_print_template')
            ->where('shpt_shop_id', $user_info->adm_shop_id)
            ->where('shpt_print_type', 1)
            ->where('shpt_delete', 1)
            ->value('shpt_id');
        if (empty($shpt_id)) {
            $shpt_id = 0;
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        $data_info['state_count'] = $state_count;
        $data_info['find_shop'] = $find_shop;          //返回门店名称
        $data_info['find_ware'] = $find_ware;          //返回仓库名称
        $data_info['find_admin'] = $find_admin;        //返回领货人姓名
        $data_info['order_client'] = $order_client;    //订单客户名称
        $data_info['work_client'] = $work_client;      //工单客户名称
        $data_info['after_client'] = $after_client;      //售后单客户名称
        $data_info['find_admin_set'] = $find_admin_set;      //当前账号所拥有的仓库权限
        $data_info['shpt_id'] = $shpt_id;      //当前门店的打印模板id


        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // // 发货
    // // 订单生成的发货单,状态改为已出库,扣固定仓库存,订单状态改为已完成
    // // 工单生成的发货单,状态改为已出库,扣固定仓库存,加移动仓库存
    // public function shipments(Request $request)
    // {   
    //     // 验证数据
    //     $verify_data = new VerifyDispatchController;
    //     $error_message = $verify_data->shipmentsValidator($request->all());
    //     if ($error_message) {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
    //     }

    //     // 验证已经发货的不能再次发货
    //     $dis_data = DB::table('dispatch_bill')
    //         ->where('dego_id', $request['dego_id'])
    //         ->select('dego_type', 'dego_cid', 'dego_shop_id', 'dego_out_ware_id', 'dego_service_adm_id', 'dego_number', 'dego_order_type', 'dego_wor_id', 'dego_original_number', 'dego_service_shop_id', 'dego_count', 'dego_create_adm_id', 'dego_id', 'dego_client_type', 'dego_client_id', 'dego_remark')
    //         ->first();
    //     if (empty($dis_data)) {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前发货单不存在！']);
    //     }
    //     if ($dis_data->dego_type == 2) {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前发货单已发货！']);
    //     }
    //     if ($dis_data->dego_type == 3) {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前发货单已作废！']);
    //     }
    //     if ($dis_data->dego_type == 4) {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前发货单已锁定，无法发货！']);
    //     }

    //     $service_ware_id = 0; //领货人技师库id
    //     // dego_order_type类型：1.订单发货 2.工单发货3售后单发货
    //     if ($dis_data->dego_order_type == 1) {
    //         // 订单发货，如果是订单类型为发货单的判断此订单是否审核
    //         $ord_wor_state = DB::table('order')
    //             ->where('ord_id', $dis_data->dego_wor_id)
    //             ->where('ord_order_number', $dis_data->dego_original_number)
    //             ->value('ord_wor_state');
    //         if ($ord_wor_state == 12) {
    //             return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'此客户单位超出可欠金额、天数,请到订单列表进行审核！']);
    //         }

    //         $find_ord_id = $dis_data->dego_wor_id; //订单id
    //         $find_order_number = $dis_data->dego_original_number; //订单编号
    //     } elseif ($dis_data->dego_order_type == 2) {
    //         // 工单发货验证技师是否绑定了技师库
    //         $service_ware_id = DB::table('warehouse')
    //             ->where('ware_type', 2) //类型：1固定仓2技师库
    //             ->where('ware_leader_id', $dis_data->dego_service_adm_id)
    //             ->value('ware_id');
    //         if (empty($service_ware_id)) {
    //             return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师未绑定技师库,请先绑定技师库']);
    //         }
    //         // 查询当前工单技师的服务状态
    //         $wor_service_state = DB::table('work_order')
    //             ->where('wor_id', $dis_data->dego_wor_id)
    //             ->value('wor_service_state');
    //         // 如果技师尚未接单，不允许发货
    //         // 服务状态：1待接单2已接单3预约4出发5抵达6完成待审核7完成已驳回8完成通过9终止10锁定11速电撤销回收
    //         if ($wor_service_state < 2) {
    //             return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师尚未接单！']);
    //         }

    //         $find_order_data = DB::table('work_order as wor')
    //             ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
    //             ->where('wor_id', $dis_data->dego_wor_id)
    //             ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number')
    //             ->first();
    //         $find_ord_id = $find_order_data->wor_order_id; //订单id
    //         $find_order_number = $find_order_data->wor_order_number; //订单编号
    //     } elseif ($dis_data->dego_order_type == 3) {
    //         // 售后单发货验证
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'售后单发货功能暂未开通！']);
    //     } elseif ($dis_data->dego_order_type == 4) {
    //         $find_ord_id = $dis_data->dego_wor_id; //订单id
    //         $find_order_number = $dis_data->dego_original_number; //订单编号
    //     } else {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'发货失败！']);
    //     }

    //     // 获取当前操作账号信息
    //     $user_info = Common::getUserInfo($request['api_token']);

    //     if ($request['type'] == '1') { //获取页面数据
    //         $digo_data = DB::table('dispatch_goods as digo')
    //             ->leftjoin('goods as goo', 'goo.goo_id', '=', 'digo.digo_goo_id')
    //             ->where('digo_dego_id', $request['dego_id'])
    //             ->where('digo_state', '!=', '2')
    //             ->select('digo_id', 'digo_wago_class', 'digo_goo_id', 'digo_goo_type', 'digo_goo_name', 'digo_goo_goods_encode', 'digo_goo_price', 'digo_goo_quantity', 'digo_is_recycle', 'digo_goo_inventory', 'digo_state', 'digo_tem_goo_name', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'digo_wago_id', 'digo_orgo_id', 'digo_goo_unit', 'digo_goo_unta_id', 'goo_unit_conversion')
    //             ->get()->toArray();
    //         // 查询系列数据
    //         $goo_brse_id = array_column($digo_data, 'goo_brse_id');
    //         $brse_data = DB::table('brand_serie')
    //             ->whereIn('brse_id', $goo_brse_id)
    //             ->pluck('brse_name', 'brse_id')
    //             ->toArray();
    //         // 查询仓位商品锁定表
    //         $find_wfgl_data = DB::table('warehouse_freight_goods_lock as w')
    //             ->leftJoin('warehouse_freight as wf', 'w.wfgl_wafr_id', '=', 'wf.wafr_id')
    //             ->where('wfgl_shop_id', $user_info->adm_shop_id)
    //             ->where('wfgl_type', 1)
    //             ->where('wfgl_state', 1)
    //             ->where('wfgl_original_id', $find_ord_id)
    //             ->where('wfgl_original_number', $find_order_number)
    //             ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type', 'wafr_name', 'wfgl_waon_class')
    //             ->get()->toArray();
    //         $find_wfgl_data = json_decode(json_encode($find_wfgl_data, true), true);
    //         $new_wfgl_sate = false; //是否重新组仓位数据
    //         if (empty($find_wfgl_data)) {
    //             //没有查询到仓位锁定库存，需要重新组数据
    //             $new_wfgl_sate = true;
    //         }
    //         $new_wfgl_data = []; //新的仓位数据
    //         $surplus_wfgl_data = $find_wfgl_data; //剩余仓位数据
    //         foreach ($digo_data as $key => $value) {
    //             // 查询仓库商品表中有可发货商品的数据
    //             $option_ware[] = DB::table('warehouse_goods as wago')
    //                 ->leftjoin('warehouse as w', 'wago.wago_ware_id', '=', 'w.ware_id')
    //                 ->where('wago_ware_id', $dis_data->dego_out_ware_id)
    //                 ->where('wago_id', $value->digo_wago_id)
    //                 ->where('wago_class', $value->digo_wago_class)
    //                 ->where('wago_goo_id', $value->digo_goo_id)
    //                 ->select('ware_id as wafr_id', 'ware_name as wafr_name', 'wago_stock_amount as wafg_stock_number', 'wago_lock_amount as wafg_lock_quantity', 'wago_priority_lock_amount as wafg_priority_lock_quantity', 'wago_priority_stock_amount as wafg_priority_stock_number')
    //                 ->first();

    //             // 查询仓位商品表中有发货商品的数据
    //             $digo_data[$key]->option_freight = DB::table('warehouse_freight_goods as wafg')
    //                 ->leftjoin('warehouse_freight as wafr', 'wafg.wafg_wafr_id', '=', 'wafr.wafr_id')
    //                 ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
    //                 ->where('wafg_wago_id', $value->digo_wago_id)
    //                 ->where('wafg_class', $value->digo_wago_class)
    //                 ->where('wafg_goo_id', $value->digo_goo_id)
    //                 ->where(function ($query) use ($value) {
    //                     if ($value->digo_goo_inventory == 1) {
    //                         $query->where('wafg_stock_number', '>', 0)->Orwhere('wafg_lock_quantity', '>', 0);
    //                     } else {
    //                         $query->where('wafg_priority_stock_number', '>', 0)->Orwhere('wafg_priority_lock_quantity', '>', 0);
    //                     }
    //                 })
    //                 ->select('wafr_id', 'wafr_name', 'wafr_rank', 'wafg_stock_number', 'wafg_priority_stock_number', 'wafg_lock_quantity', 'wafg_priority_lock_quantity')
    //                 ->get()->toArray();
    //             if (!empty($option_ware[0])) {
    //                 if ($value->digo_goo_inventory == 1 && ($option_ware[0]->wafg_stock_number > 0 || $option_ware[0]->wafg_lock_quantity > 0)) {
    //                     $option_ware[0]->wafr_id = 0;
    //                     $option_ware[0]->wafr_name = '仓库';
    //                     $option_ware[0]->wafg_stock_number = $option_ware[0]->wafg_stock_number;
    //                     $option_ware[0]->wafg_lock_quantity = $option_ware[0]->wafg_lock_quantity;
    //                     $option_ware[0]->wafg_priority_stock_number = $option_ware[0]->wafg_priority_stock_number;
    //                     $option_ware[0]->wafg_priority_lock_quantity = $option_ware[0]->wafg_priority_lock_quantity;
    //                     $digo_data[$key]->option_freight = array_merge($option_ware, $digo_data[$key]->option_freight);
    //                     $option_ware[0]->wafr_id = 0;
    //                 }
    //                 if ($value->digo_goo_inventory == 2 && ($option_ware[0]->wafg_priority_stock_number > 0 || $option_ware[0]->wafg_priority_lock_quantity > 0)) {
    //                     $option_ware[0]->wafr_id = 0;
    //                     $option_ware[0]->wafr_name = '仓库';
    //                     $option_ware[0]->wafg_stock_number = $option_ware[0]->wafg_stock_number;
    //                     $option_ware[0]->wafg_lock_quantity = $option_ware[0]->wafg_lock_quantity;
    //                     $option_ware[0]->wafg_priority_stock_number = $option_ware[0]->wafg_priority_stock_number;
    //                     $option_ware[0]->wafg_priority_lock_quantity = $option_ware[0]->wafg_priority_lock_quantity;
    //                     $digo_data[$key]->option_freight = array_merge($option_ware, $digo_data[$key]->option_freight);
    //                     $option_ware[0]->wafr_id = 0;
    //                 }
    //             }
    //             unset($option_ware);
    //             if ($new_wfgl_sate) {
    //                 // 重新调整数组
    //                 $temp_wfgl_data['wfgl_id'] = 0; //仓位商品锁定主键id
    //                 $temp_wfgl_data['wafr_name'] = '仓库'; //仓位商品锁定主键id
    //                 $temp_wfgl_data['wfgl_ware_id'] = $dis_data->dego_out_ware_id; //仓库id
    //                 $temp_wfgl_data['wfgl_wago_id'] = $value->digo_wago_id; //仓库商品主键id
    //                 $temp_wfgl_data['wfgl_wafr_id'] = 0; //仓位id
    //                 $temp_wfgl_data['wfgl_wafg_id'] = 0; //仓位商品主键id
    //                 $temp_wfgl_data['wfgl_lock_quantity'] = $value->digo_goo_quantity; //商品锁定数量
    //                 $temp_wfgl_data['wfgl_lock_type'] = $value->digo_goo_inventory; //商品锁定类型：1良品2优先
    //                 $new_wfgl_data[] = $temp_wfgl_data;
    //                 unset($temp_wfgl_data);
    //             }
    //             if ($new_wfgl_sate) { //没有仓位锁定商品
    //                 $digo_data[$key]->wfgl_data = $new_wfgl_data;
    //                 unset($new_wfgl_data);
    //             } else { //有锁定商品的
    //                 $num = 0;
    //                 $digo_goo_quantity = $value->digo_goo_quantity; //发货数量
    //                 foreach ($find_wfgl_data as $wfgl_key => $wfgl_value) { //从仓位商品表中扣除发货数量
    //                     if ($wfgl_value['wfgl_wago_id'] == $value->digo_wago_id && $value->digo_goo_inventory == $wfgl_value['wfgl_lock_type'] && $value->digo_wago_class == $wfgl_value['wfgl_waon_class']) { //判断仓库类别和发货类型和仓库商品id
    //                         if ($wfgl_value['wfgl_lock_quantity'] != 0) { //此仓位还有锁定数量，可以从这个仓位出库
    //                             $digo_goo_quantity = $digo_goo_quantity - $wfgl_value['wfgl_lock_quantity']; //出库商品-仓位中锁定的数量
    //                             $wafr_data[$num]['wafr_name'] = $wfgl_value['wafr_name'] ? $wfgl_value['wafr_name'] : '仓库'; //仓位锁定表中锁定仓库商品没有仓位名称显示仓库
    //                             $wafr_data[$num]['wfgl_id'] = $wfgl_value['wfgl_id'];
    //                             $wafr_data[$num]['wfgl_wago_id'] = $wfgl_value['wfgl_wago_id'];
    //                             $wafr_data[$num]['wfgl_wafr_id'] = $wfgl_value['wfgl_wafr_id'];
    //                             $wafr_data[$num]['wfgl_wafg_id'] = $wfgl_value['wfgl_wafg_id'];
    //                             $wafr_data[$num]['wfgl_lock_type'] = $wfgl_value['wfgl_lock_type'];
    //                             if ($digo_goo_quantity <= 0) { //出库商品-仓位中锁定的数量小于0，仓位锁定出库后还有剩余，出完了，跳出
    //                                 $find_wfgl_data[$wfgl_key]['wfgl_lock_quantity'] = abs($digo_goo_quantity);
    //                                 $wafr_data[$num]['wfgl_lock_quantity'] = $digo_goo_quantity + $wfgl_value['wfgl_lock_quantity'];
    //                                 break;
    //                             } else { //出库商品-仓位中锁定的数量大于0，没出完，从下一个仓位扣除
    //                                 $find_wfgl_data[$wfgl_key]['wfgl_lock_quantity'] = 0;
    //                                 $wafr_data[$num]['wfgl_lock_quantity'] = $wfgl_value['wfgl_lock_quantity'];
    //                             }
    //                             $num++;
    //                         }
    //                     }
    //                 }

    //                 if ($digo_goo_quantity > 0) { //仓位出库后还有需要出库的库存，从仓库出库
    //                     $wafr_data[$num]['wafr_name'] = '仓库';
    //                     $wafr_data[$num]['wfgl_lock_quantity'] = $digo_goo_quantity;
    //                     $wafr_data[$num]['wfgl_id'] = $digo_goo_quantity;
    //                     $wafr_data[$num]['wfgl_ware_id'] = $dis_data->dego_out_ware_id; //仓库id
    //                     $wafr_data[$num]['wfgl_wago_id'] = $value->digo_wago_id; //仓库商品主键id
    //                     $wafr_data[$num]['wfgl_wafr_id'] = 0;
    //                     $wafr_data[$num]['wfgl_wafg_id'] = 0; //仓位商品主键id
    //                     $wafr_data[$num]['wfgl_lock_type'] = $value->digo_goo_inventory; //商品锁定类型：1良品2优先
    //                 }
    //                 $digo_data[$key]->wfgl_data = $wafr_data;
    //                 unset($digo_goo_quantity);
    //                 unset($wafr_data);
    //             }
    //             // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
    //             if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
    //                 if (!empty($value->goo_brse_id)) {
    //                     if ($value->goo_class == 2) {
    //                         $digo_data[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
    //                         unset($digo_data[$key]->goo_brse_id);
    //                     } else {
    //                         if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
    //                             $digo_data[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
    //                             unset($digo_data[$key]->goo_brse_id);
    //                         }
    //                     }
    //                 }
    //             }
    //             // 显示品牌名称
    //             if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
    //                 if ($value->goo_class == 2) {
    //                     $digo_data[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
    //                 } else {
    //                     if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
    //                         $digo_data[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
    //                     }
    //                 }
    //             }
    //             unset($digo_data[$key]->goo_class);
    //         }
    //         // 查询服务门店名称
    //         $dis_data->dego_service_shop_name = DB::table('shop')
    //             ->where('shop_id', $dis_data->dego_service_shop_id)
    //             ->value('shop_store_name');
    //         // 查询仓库名称
    //         $dis_data->ware_name = DB::table('warehouse')
    //             ->where('ware_id', $dis_data->dego_out_ware_id)
    //             ->value('ware_name');
    //         // 查询领货人名称
    //         $dis_data->adm_name = DB::table('admin')
    //             ->where('adm_id', $dis_data->dego_create_adm_id)
    //             ->value('adm_name');
    //         // 订单发货
    //         if ($dis_data->dego_order_type == 1) {
    //             // 查找订单客户信息
    //             $order_client = DB::table('order as ord')
    //                 ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
    //                 ->where('orcl_ord_id', $dis_data->dego_wor_id)
    //                 ->select('orcl_ord_id', 'orcl_channel_unit', 'ord_type', 'orcl_standby_battery_type', 'orcl_client_id')
    //                 ->first();
    //             $order_client->orcl_channel_unit = DB::table('channel_unit')
    //                 ->where('chun_id', $order_client->orcl_client_id)
    //                 ->value('chun_unit_name');
    //             unset($order_client->orcl_client_id);
    //         } else {
    //             $order_client = [];
    //         }

    //         // 工单发货
    //         if ($dis_data->dego_order_type == 2) {
    //             // 查找工单客户信息
    //             $work_client = DB::table('work_order as wor')
    //                 ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
    //                 ->where('wocl_wor_id', $dis_data->dego_wor_id)
    //                 ->select('wocl_wor_id', 'wocl_channel_unit', 'wocl_name', 'wor_type', 'wocl_standby_battery_type', 'wocl_client_id')
    //                 ->first();
    //             $work_client->wocl_channel_unit = DB::table('channel_unit')
    //                 ->where('chun_id', $work_client->wocl_client_id)
    //                 ->value('chun_unit_name');
    //             unset($work_client->wocl_client_id);
    //         } else {
    //             $work_client = [];
    //         }


    //         $data['dis_data'] = $dis_data;
    //         $data['order_client'] = $order_client;
    //         $data['work_client'] = $work_client;
    //         $data['dispatch_goods'] = $digo_data;
    //         return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    //     }

    //     $request_goods_data = json_decode($request['goodsDataList'], true); //前端提交的出库商品数据
    //     if (empty($request_goods_data)) {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择出库商品']);
    //     }

    //     // 判断出库仓库类型，pc端不能发移动仓库的商品，只能发固定仓的，有权限的商品
    //     // ware_type类型：1固定仓2技师库3移动仓
    //     $dego_out_ware_type = DB::table('warehouse')
    //         ->where('ware_id', $dis_data->dego_out_ware_id)
    //         ->value('ware_type');
    //     if ($dego_out_ware_type != 1) {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前供货仓库不是固定仓库，没有发货权限！']);
    //     }

    //     // 查询当前账号所拥有的仓库权限
    //     $find_admin_set = DB::table('admin_set')
    //         ->where('adms_adm_id', $user_info->adm_id)
    //         // ->value('adms_ware_id');
    //         ->value('adms_myware_id');
    //     $find_admin_set = explode(',', trim($find_admin_set, ','));
    //     if (!in_array($dis_data->dego_out_ware_id, $find_admin_set)) {
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有当前仓库的发货权限！']);
    //     }

    //     DB::beginTransaction();

    //     // 更改仓库、仓位发货数量
    //     $shipments_retrun = Dispatch::shipments(
    //         $user_info, //用户信息
    //         $request->all(), //用户信息
    //         $request_goods_data, //提交的商品数据
    //         $dis_data, //查询的发货单信息
    //         $dego_out_ware_type, //发货仓库类型
    //         $find_ord_id, //订单id
    //         $find_order_number, //订单单号
    //         $service_ware_id //服务技师库id
    //     );
    //     if ($shipments_retrun['code'] == 500) {
    //         DB::rollBack();
    //         return response()->json($shipments_retrun);
    //     }

    //     // 发货单商品添加物料图片
    //     if (!empty($request['imgs64'])) {
    //         $upload_file = json_decode(json_encode($request['imgs64']), true);
    //         foreach ($upload_file as $key => $value) {
    //             if (!empty($value)) {
    //                 // 判断是否有新图片上传
    //                 if (strpos($value, 'data:image') === 0) {
    //                     // 调用全局函数 上传图片
    //                     $image_path = uploadBase64ImgFolder($user_info->adm_shop_id, $value, 2);
    //                 }
    //             }
    //             $new_data[] = $image_path;
    //             unset($image_path);
    //         }
    //         $new_upload_data = json_encode($new_data);
    //     } else {
    //         $new_upload_data = '';
    //     }

    //     // 发货单商品添加物料图片
    //     // foreach ($request_goods_data as $key => $value) {
    //     //     $image_path = '';
    //     //     if (!empty($value['digo_goo_material_pic'])) {
    //     //         if (strpos($value['digo_goo_material_pic'], 'data:image') === 0) {
    //     //             // 调用全局函数 上传图片
    //     //             $image_path = uploadBase64ImgFolder($user_info->adm_shop_id, $value['digo_goo_material_pic'], 2);
    //     //         }
    //     //     }
    //     //     $update_digo_data['digo_goo_material_pic'] = !empty($image_path) ? $image_path : '';
    //     //     $update_digo_data['digo_update_time'] = date('Y-m-d H:i:s');
    //     //     $update_digo_res = DB::table('dispatch_goods')->where('digo_id', $value['digo_id'])->update($update_digo_data);
    //     //     if (!$update_digo_res) {
    //     //         return response()->json(['code'=>500,'msg'=>'error','data'=>'发货失败，图片上传失败']);
    //     //     }
    //     // }
    //     // 修改发货单表的状态
    //     $update_data['dego_type'] = 2; //类型：1未出库2已出库
    //     $update_data['dego_pic'] = !empty($new_upload_data) ? $new_upload_data : ''; //发货图片
    //     $update_data['dego_remark'] = !empty($request['dego_remark']) ? $request['dego_remark'] : ''; //发货备注
    //     $update_data['dego_update_time'] = date('Y-m-d H:i:s'); //更新时间
    //     $dispatch_res = DB::table('dispatch_bill')
    //         ->where('dego_id', $request['dego_id'])
    //         ->update($update_data);

    //     // 更新订单商品表的商品成本，根据订单id,查询商品
    //     $find_orgo_data = DB::table('order_goods')
    //         ->where('orgo_ord_id', $find_ord_id)
    //         ->where('orgo_state', '!=', 2)
    //         ->select('orgo_id', 'orgo_state', 'orgo_ord_id', 'orgo_ware_id', 'orgo_waon_class', 'orgo_goo_id', 'orgo_goo_price', 'orgo_goo_quantity')
    //         ->get()->toArray();
    //     $cost_price = 0; //总成本金额
    //     $recycle_amount = 0; //回收商品总成本
    //     $now_date = date('Y-m-d H:i:s'); //当前时间
    //     $voucher_state = false;
    //     foreach ($find_orgo_data as $kkkk => $vvvv) {
    //         if ($vvvv->orgo_waon_class == 1 || ($vvvv->orgo_waon_class == 3 && $vvvv->orgo_goo_price != 0)) { //货物仓
    //             $voucher_state = true;
    //             // 获取当前月份商品成本价
    //             if (in_array($vvvv->orgo_state, [1, 5, 8])) {
    //                 $find_ense_end_price = DB::table('enters_sells_saves')
    //                     ->where('ense_goo_id', $vvvv->orgo_goo_id)
    //                     ->where('ense_goo_warehouse', $vvvv->orgo_ware_id)
    //                     ->where('ense_goo_waretype', $vvvv->orgo_waon_class)
    //                     ->where('ense_order_number', $find_order_number)
    //                     ->orderBy('ense_id', 'desc')
    //                     ->value('ense_end_price');
    //                 $find_ense_end_price = sprintf('%.2f', $find_ense_end_price);
    //             } else {
    //                 $find_ense_end_price = 0;
    //             }
    //             $cost_price += $find_ense_end_price * $vvvv->orgo_goo_quantity; //总成本金额
    
    //             if ($vvvv->orgo_state == 3) {
    //                 $recycle_amount += $vvvv->orgo_goo_price * $vvvv->orgo_goo_quantity; //回收商品成本金额
    //             }
    //             // 修改订单商品成本
    //             $orgo_edit_data['orgo_goo_cost'] = $find_ense_end_price * 100;
    //             $orgo_edit_data['orgo_update_time'] = $now_date;
    //             // 修改订单表的更新时间
    //             $orgo_edit_res = DB::table('order_goods')
    //                 ->where('orgo_id', $vvvv->orgo_id)
    //                 ->where('orgo_ord_id', $find_ord_id)
    //                 ->where('orgo_order_number', $find_order_number)
    //                 ->update($orgo_edit_data);
    //             unset($orgo_edit_data);
    //         }
    //     }
    //     if ($dis_data->dego_order_type == 1) {
    //         // 订单发货单 将订单状态改为完成
    //         $update_date['ord_wor_state'] = 4;
    //         $update_date['ord_update_time'] = date('Y-m-d H:i:s');
    //         $update_state = DB::table('order')
    //             ->where('ord_id', $dis_data->dego_wor_id)
    //             ->update($update_date);

    //         $order_client = DB::table('order_client')
    //             ->where('orcl_ord_id', $dis_data->dego_wor_id)
    //             ->first(['orcl_channel_unit', 'orcl_client_id', 'orcl_acc_subject_id', 'orcl_collect_state', 'orcl_name']);
    //         $ord_data = DB::table('order')
    //             ->where('ord_id', $dis_data->dego_wor_id)
    //             ->first(['ord_type', 'ord_actual_price', 'ord_remark', 'ord_order_number', 'ord_create_time', 'ord_service_type']);
    //         $ord_plus_minus = 1;
    //         if ($ord_data->ord_actual_price < 0) {
    //             $ord_plus_minus = 2;
    //         }
    //         // 生成订单应收账单
    //         $ord_bill = ReceivableBill::create(
    //             $user_info, //用户信息
    //             3, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
    //             0, //应收账款id
    //             $dis_data->dego_wor_id, //原始id(订单id)
    //             $dis_data->dego_original_number, //应收账款单号/原始号(订单编号)
    //             $ord_data->ord_type, //客户类型：1.门店零售 2.来往单位
    //             $order_client->orcl_client_id, //会员id/来往单位id
    //             $order_client->orcl_channel_unit, //来往单位名称
    //             abs($ord_data->ord_actual_price), //结算金额
    //             date('Y-m-d H:i:s'), //结款时间
    //             $order_client->orcl_acc_subject_id, //会计科目id
    //             abs($ord_data->ord_actual_price), //实际金额
    //             0, //抹零金额
    //             1,  //状态：1.未核销 2.已核销
    //             1,  //应收账单id是否是自己 1.不是 2.是
    //             $ord_data->ord_remark,  //备注
    //             0, //已收金额
    //             '', //截止时间
    //             $ord_plus_minus, //金额正负1正2负值
    //             1, //显示类型：1订单收款 10订单退款
    //             2, //是否合并代收：1是2否
    //             $ord_data->ord_create_time,
    //             $order_client->orcl_collect_state //技师是否收钱：0未选择1是2否
    //         );
    //         if (!$ord_bill || !$update_state) {
    //             return ['code'=>500, 'msg'=>'error', 'data'=>'发货失败！03'];
    //         }

    //         if ($voucher_state == true) {
    //             // 判断门店是否使用用友u8财务系统
    //             if (config('apiu8cloud.CODE_STARTS') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop'))) {
    //                 // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
    //                 $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
    //                 // 生成凭证单据
    //                 if ($ord_data->ord_type == '1') {
    //                     $order_client->orcl_channel_unit = $order_client->orcl_name;
    //                 } elseif ($ord_data->ord_type == '2') {
    //                     $order_client->orcl_channel_unit = $order_client->orcl_channel_unit;
    //                 } elseif ($ord_data->ord_type == '3') {
    //                     $order_client->orcl_channel_unit = $order_client->orcl_channel_unit;
    //                 }
    //                 $vore_data = WorkOrder::voucherReceipts($user_info, $shop_id, 1, 0, '', $dis_data->dego_wor_id, $ord_data->ord_order_number, $ord_data->ord_actual_price, $recycle_amount, 0, $cost_price, $ord_data->ord_service_type, $ord_data->ord_type, $order_client->orcl_client_id, $order_client->orcl_channel_unit);
    //                 if (!$vore_data) {
    //                     return ['code'=>500, 'msg'=>'error', 'data'=>'凭证单生成失败'];
    //                 }
    //             }
    //         }
    //     }

    //     if ($dis_data->dego_order_type == 4) {
    //         // 易损件订单发货单 将订单状态改为完成
    //         $update_order_data['ord_wor_state'] = 18; // 易损件订单完成状态
    //         $update_order_data['ord_update_time'] = date('Y-m-d H:i:s');
    //         $update_order_state = DB::table('order')
    //             ->where('ord_id', $dis_data->dego_wor_id)
    //             ->update($update_order_data);
    //     }

    //     // 仓库商品锁定表
    //     $wagl_id = DB::table('warehouse_goods_lock')
    //         ->where('wagl_original_correlation_id', $request['dego_id'])
    //         ->where('wagl_correlation_type', 2)
    //         ->value('wagl_id');
    //     if (!empty($wagl_id)) {
    //         $wagl_res = DB::table('warehouse_goods_lock')
    //             ->where('wagl_original_correlation_id', $request['dego_id'])
    //             ->where('wagl_correlation_type', 2)
    //             ->update(['wagl_update_time' => date('Y-m-d H:i:s'), 'wagl_state' => 2]);
    //     } else {
    //         $wagl_res =  true;
    //     }
    //     $wfgl_id = DB::table('warehouse_freight_goods_lock')
    //         ->where('wfgl_shop_id', $user_info->adm_shop_id)
    //         ->where('wfgl_original_id', $find_ord_id)
    //         ->where('wfgl_original_number', $find_order_number)
    //         ->where('wfgl_type', 1)
    //         ->value('wfgl_id');
    //     if (!empty($wfgl_id)) {
    //         $wfgl_res = DB::table('warehouse_freight_goods_lock')
    //             ->where('wfgl_shop_id', $user_info->adm_shop_id)
    //             ->where('wfgl_original_id', $find_ord_id)
    //             ->where('wfgl_original_number', $find_order_number)
    //             ->where('wfgl_type', 1)
    //             ->update(['wfgl_update_time' => date('Y-m-d H:i:s'), 'wfgl_state' => 2]);
    //     } else {
    //         $wfgl_res = true;
    //     }
    //     if ($dispatch_res && $wagl_res && $wfgl_res) {
    //         Common::addLog($user_info, getRealIp($request), '发货单', '发货', '发货单：' . $dis_data->dego_number . ' 发货成功');
    //         DB::commit();
    //         return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'发货成功']);
    //     } else {
    //         DB::rollBack();
    //         return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'发货失败']);
    //     }
    // }

    // 发货
    // 工单生成的发货单,状态改为已出库,扣固定仓库存
    public function shipments(Request $request)
    {   
        // 验证数据
        $verify_data = new VerifyDispatchController;
        $error_message = $verify_data->shipmentsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 验证已经发货的不能再次发货
        $dis_data = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->select('dego_type', 'dego_cid', 'dego_shop_id', 'dego_out_ware_id', 'dego_service_adm_id', 'dego_number', 'dego_order_type', 'dego_wor_id', 'dego_original_number', 'dego_service_shop_id', 'dego_count', 'dego_create_adm_id', 'dego_id', 'dego_client_type', 'dego_client_id', 'dego_remark')
            ->first();
        if (empty($dis_data)) {
            return response()->json(['code'=>500, 'msg'=>'当前发货单不存在！', 'data'=>'当前发货单不存在！']);
        }
        if ($dis_data->dego_type == 2) {
            return response()->json(['code'=>500, 'msg'=>'当前发货单已发货！', 'data'=>'当前发货单已发货！']);
        }
        if ($dis_data->dego_type == 3) {
            return response()->json(['code'=>500, 'msg'=>'当前发货单已作废！', 'data'=>'当前发货单已作废！']);
        }
        if ($dis_data->dego_type == 4) {
            return response()->json(['code'=>500, 'msg'=>'当前发货单已锁定，无法发货！', 'data'=>'当前发货单已锁定，无法发货！']);
        }

        $service_ware_id = 0; //领货人技师库id
        // dego_order_type类型：1.订单发货 2.工单发货3售后单发货
        if ($dis_data->dego_order_type == 1) {
            // 订单发货，如果是订单类型为发货单的判断此订单是否审核
            $ord_wor_state = DB::table('order')
                ->where('ord_id', $dis_data->dego_wor_id)
                ->where('ord_order_number', $dis_data->dego_original_number)
                ->select('ord_wor_state','ord_address')
                ->first();
            if ($ord_wor_state->ord_wor_state == 12) {
                return response()->json(['code'=>500, 'msg'=>'此客户单位超出可欠金额、天数,请到订单列表进行审核！', 'data'=>'此客户单位超出可欠金额、天数,请到订单列表进行审核！']);
            }

            $find_ord_id = $dis_data->dego_wor_id; //订单id
            $find_order_number = $dis_data->dego_original_number; //订单编号
            $dis_data->dego_service_shop_name = $ord_wor_state->ord_address;
        } elseif ($dis_data->dego_order_type == 2) {
            // 查询当前工单技师的服务状态
            $wor_service_state = DB::table('work_order')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->value('wor_service_state');
            // 如果技师尚未接单，不允许发货
            // 服务状态：1待接单2已接单3预约4出发5抵达6完成待审核7完成已驳回8完成通过9终止10锁定11速电撤销回收
            if ($wor_service_state < 2) {
                return response()->json(['code'=>500, 'msg'=>'当前技师尚未接单！', 'data'=>'当前技师尚未接单！']);
            }

            $find_order_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number','wor_address')
                ->first();
            $find_ord_id = $find_order_data->wor_order_id; //订单id
            $find_order_number = $find_order_data->wor_order_number; //订单编号
            $dis_data->dego_service_shop_name = $find_order_data->wor_address;
        }  elseif ($dis_data->dego_order_type == 3) {//售后单
            $find_order_data = DB::table('wash_after_sale_list as afsl')
                ->leftjoin('wash_after_sale_client as afsc', 'afsc.afsc_afsl_id', '=', 'afsl.afsl_id')
                ->where('afsl_id', $dis_data->dego_wor_id)
                ->first();
            $find_ord_id = $find_order_data->afsl_id; //售后单id
            $find_order_number = $find_order_data->afsl_after_number; //订单编号
            $dis_data->dego_service_shop_name = $find_order_data->afsl_address;
        } else {
            return response()->json(['code'=>500, 'msg'=>'发货失败！', 'data'=>'发货失败！']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        if ($request['type'] == '1') { //获取页面数据
            $digo_data = DB::table('dispatch_goods as digo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'digo.digo_goo_id')
                ->where('digo_dego_id', $request['dego_id'])
                ->where('digo_state', '!=', '2')
                ->select('digo_id', 'digo_wago_class', 'digo_goo_id', 'digo_goo_type', 'digo_goo_name', 'digo_goo_goods_encode', 'digo_goo_quantity', 'digo_is_recycle', 'digo_goo_inventory', 'digo_state', 'digo_tem_goo_name', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'digo_wago_id', 'digo_orgo_id', 'digo_goo_unit', 'digo_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();
            // 查询系列数据
            $goo_brse_id = array_column($digo_data, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            foreach ($digo_data as $key => $value) {
                // 查询仓位商品表中有发货商品的数据
                $digo_data[$key]->option_freight = DB::table('warehouse_freight_goods as wafg')
                    ->leftjoin('warehouse_freight as wafr', 'wafg.wafg_wafr_id', '=', 'wafr.wafr_id')
                    ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                    ->where('wafg_wago_id', $value->digo_wago_id)
                    ->where('wafg_class', $value->digo_wago_class)
                    ->where('wafg_goo_id', $value->digo_goo_id)
                    ->where(function ($query) use ($value) {
                        if ($value->digo_goo_inventory == 1) {
                            $query->where('wafg_stock_number', '>', 0);
                        } else {
                            $query->where('wafg_priority_stock_number', '>', 0);
                        }
                    })
                    ->select('wafr_id', 'wafr_name', 'wafr_rank', 'wafg_stock_number', 'wafg_priority_stock_number')
                    ->get()->toArray();

                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $digo_data[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
                            unset($digo_data[$key]->goo_brse_id);
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $digo_data[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
                                unset($digo_data[$key]->goo_brse_id);
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $digo_data[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $digo_data[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
                        }
                    }
                }
                unset($digo_data[$key]->goo_class);
            }
            // 查询服务门店名称
            if(!isset($dis_data->dego_service_shop_name)){
                $dis_data->dego_service_shop_name = DB::table('shop')
                    ->where('shop_id', $dis_data->dego_service_shop_id)
                    ->value('shop_store_name');
            }
            // 查询仓库名称
            $dis_data->ware_name = DB::table('warehouse')
                ->where('ware_id', $dis_data->dego_out_ware_id)
                ->value('ware_name');
            // 查询领货人名称
            $dis_data->adm_name = DB::table('admin')
                ->where('adm_id', $dis_data->dego_create_adm_id)
                ->value('adm_name');
            // 订单发货
            if ($dis_data->dego_order_type == 1) {
                // 查找订单客户信息
                $order_client = DB::table('order as ord')
                    ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                    ->where('orcl_ord_id', $dis_data->dego_wor_id)
                    ->select('orcl_ord_id', 'orcl_channel_unit', 'ord_type', 'orcl_standby_battery_type', 'orcl_client_id', 'orcl_name', 'ord_client_id', 'orcl_carowner_phone', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address')
                    ->first();
                $ord_id = $order_client->orcl_ord_id;
                // $order_client->orcl_channel_unit = DB::table('channel_unit')
                //     ->where('chun_id', $order_client->orcl_client_id)
                //     ->value('chun_unit_name');
                if ($order_client->ord_type == 1) {//0散户1会员2企业会员
                    $order_client->orcl_channel_unit = $order_client->orcl_name;
                }
                if ($order_client->ord_type == 2) {
                    $order_client->orcl_channel_unit = DB::table('business_account')
                        ->leftjoin('business_client', 'bucl_id', '=', 'buac_bucl_id')
                        ->where('buac_id', $order_client->ord_client_id)
                        ->value('bucl_name');
                }
                if ($order_client->ord_type == 0) {
                    $order_client->orcl_channel_unit = '散户';
                }
                unset($order_client->orcl_client_id);
            } else {
                $order_client = [];
            }

            // 工单发货
            if ($dis_data->dego_order_type == 2) {
                // 查找工单客户信息
                $work_client = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->where('wocl_wor_id', $dis_data->dego_wor_id)
                    ->select('wocl_wor_id', 'wocl_channel_unit', 'wocl_name', 'wor_type', 'wocl_standby_battery_type', 'wocl_client_id', 'wocl_bus_name', 'wocl_bus_id', 'wor_order_id','wocl_province','wocl_city','wocl_county','wocl_address','wocl_carowner_phone')
                    ->first();
                if ($work_client->wor_type == 2) {
                    $work_client->wocl_channel_unit = $work_client->wocl_bus_name;
                } else {
                    $work_client->wocl_channel_unit = '';
                }
                $ord_id = $work_client->wor_order_id;
            } else {
                $work_client = [];
            }

            // 售后单发货
            if ($dis_data->dego_order_type == 3) {
                // 查找订单客户信息
                $after_sale_client = DB::table('wash_after_sale_list as wasl')
                    ->leftjoin('wash_after_sale_client as wasc', 'wasc.afsc_afsl_id', '=', 'wasl.afsl_id')
                    // ->leftjoin('order', 'ord_id', '=', 'afsl_ord_id')
                    ->where('afsl_id', $dis_data->dego_wor_id)
                    ->first();
                $afsl_id = $after_sale_client->afsl_id;
                $ord_id = $after_sale_client->afsl_ord_id;
            } else {
                $ord_id = 0;
                $after_sale_client = [];
            }


            $data['dis_data'] = $dis_data;
            $data['order_client'] = $order_client;
            $data['work_client'] = $work_client;
            $data['after_sale_client'] = $after_sale_client;
            $data['dispatch_goods'] = $digo_data;
            $ord_Explainpic = [];
            $Explainpic = WashOrderService::getExplainpic($user_info, $ord_id);
            if (!empty($Explainpic['data'])) {
                $ord_Explainpic = $Explainpic['data'];
            }
            $data['ord_explain_pic'] = $ord_Explainpic;
            //快递信息
            $data['delivedry'] = DeliveryService::deliveryList($user_info,$request)['data'];
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        $request_goods_data = json_decode($request['goodsDataList'], true); //前端提交的出库商品数据
        if (empty($request_goods_data)) {
            return response()->json(['code'=>500, 'msg'=>'请选择出库商品', 'data'=>'请选择出库商品']);
        }

        // 判断出库仓库类型，pc端不能发移动仓库的商品，只能发固定仓的，有权限的商品
        // ware_type类型：1固定仓2技师库3移动仓
        $dego_out_ware_type = DB::table('warehouse')
            ->where('ware_id', $dis_data->dego_out_ware_id)
            ->value('ware_type');
        if ($dego_out_ware_type != 1) {
            return response()->json(['code'=>500, 'msg'=>'当前供货仓库不是固定仓库，没有发货权限！', 'data'=>'当前供货仓库不是固定仓库，没有发货权限！']);
        }

        // 查询当前账号所拥有的仓库权限
        $find_admin_set = DB::table('admin_set')
            ->where('adms_adm_id', $user_info->adm_id)
            ->where('adms_shop_id', $user_info->adm_shop_id)
            ->value('adms_myware_id');
        $find_admin_set = explode(',', trim($find_admin_set, ','));
        if (!in_array($dis_data->dego_out_ware_id, $find_admin_set)) {
            return response()->json(['code'=>500, 'msg'=>'没有当前仓库的发货权限！', 'data'=>'没有当前仓库的发货权限！']);
        }

        DB::beginTransaction();
        // 修改发货单表的状态
        $update_data['dego_type'] = 2; //类型：1未出库2已出库
        $update_data['dego_pic'] = !empty($new_upload_data) ? $new_upload_data : ''; //发货图片
        $update_data['dego_remark'] = !empty($request['dego_remark']) ? $request['dego_remark'] : ''; //发货备注
        $update_data['dego_update_time'] = date('Y-m-d H:i:s'); //更新时间
        $dispatch_res = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->update($update_data);
        // 更改仓库、仓位发货数量
        $shipments_retrun = Dispatch::shipments(
            $user_info, //用户信息
            $request->all(), //用户信息
            $request_goods_data, //提交的商品数据
            $dis_data, //查询的发货单信息
            $dego_out_ware_type, //发货仓库类型
            $find_ord_id, //订单id
            $find_order_number, //订单单号
            $service_ware_id //
        );
        if ($shipments_retrun['code'] == 500) {
            DB::rollBack();
            return response()->json($shipments_retrun);
        }
        

        // 发货单商品添加物料图片
        if (!empty($request['imgs64'])) {
            $upload_file = json_decode(json_encode($request['imgs64']), true);
            foreach ($upload_file as $key => $value) {
                if (!empty($value)) {
                    // 判断是否有新图片上传
                    if (strpos($value, 'data:image') === 0) {
                        // 调用全局函数 上传图片
                        $image_path = config('apisystem.server_name_https') .'/' .uploadBase64ImgFolder($user_info->adm_shop_id, $value, 2);
                    } else {
                        $image_path = $value;
                    }
                } else {
                    $image_path = '';
                }
                $new_data[] = $image_path;
                unset($image_path);
            }
            $new_upload_data = json_encode($new_data);
        } else {
            $new_upload_data = '';
        }


        //修改仓库商品的金额
        $amount_ret = $this->updateWagoAmountDispatch($request['dego_id']);
        if($amount_ret['code'] != 200){
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'调拨单入库失败011']);
        }
        //快递信息
        DeliveryService::addDelivery($user_info,$request->all());
        if ($dispatch_res) {
            Common::addLog($user_info, getRealIp($request), '发货单', '发货', '发货单：' . $dis_data->dego_number . ' 发货成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'发货成功', 'data'=>'发货成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'发货失败', 'data'=>'发货失败']);
        }
    }

    /* 商品库存有变化的时候，修改仓库商品得总价 20230518
     * $id 发货单id
     */
    public function updateWagoAmountDispatch($id)
    {
        //发货单信息
        $dispatch_res = DB::table('dispatch_goods')
            ->where('digo_dego_id', $id)
            ->select('digo_goo_id', 'digo_wago_id')
            ->get()->toArray();
        if(empty($dispatch_res)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'发货单不存在'];
        }
        $ware_goo_id = array_unique(array_column($dispatch_res,'digo_wago_id'));//盘点仓库商品id
        // 查询仓库商品信息
        $find_tror = DB::table('warehouse_goods')
            ->whereIn('wago_id', $ware_goo_id)
            ->select('wago_id', 'wago_goo_price', 'wago_goo_amount', 'wago_stock_number', 'wago_lock_quantity', 'wago_ware_id', 'wago_goo_id')
            ->get()->toArray();
        if(empty($find_tror)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'仓库商品不存在'];
        }
        $ware_ids = array_column($find_tror,'wago_ware_id');//仓库id
        foreach ($find_tror as $k => $v){
            $trod_data = [];
            //仓库商品得总价 = 商品单价 * （商品库存 + 商品锁定数量）
            $amount = $v->wago_goo_price * ($v->wago_stock_number + $v->wago_lock_quantity);
            $trod_data['wago_goo_amount'] = $amount;
            $trod_data['wago_update_time'] =  date('Y-m-d H:i:s'); //更新时间
            //修改仓库商品的总价
            $ware_goo_ret = DB::table('warehouse_goods')
                ->where('wago_ware_id', $v->wago_ware_id)
                ->where('wago_goo_id', $v->wago_goo_id)
                ->where('wago_class', 1)
                ->update($trod_data);
        }
        //查找仓库所有商品总价
        $find_tror_all = DB::table('warehouse_goods')
            ->whereIn('wago_ware_id', $ware_ids)
            ->select('wago_id', 'wago_goo_amount', 'wago_ware_id')
            ->get()->toArray();
        if(empty($find_tror_all)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'仓库不存在'];
        }
        $ware_all_data = [];
        foreach ($find_tror_all as $a_k => $a_v){
            if(isset($ware_all_data[$a_v->wago_ware_id])){
                $ware_all_data[$a_v->wago_ware_id] += $a_v->wago_goo_amount;
            }else{
                $ware_all_data[$a_v->wago_ware_id] = $a_v->wago_goo_amount;
            }
        }
        if(empty($ware_all_data)){
            return ['code'=>500, 'msg'=>'success', 'data'=>'仓库不存在'];
        }
        foreach ($ware_all_data as $k => $v){
            //修改仓库商品的总金额
            $ware_ret = DB::table('warehouse')
                ->where('ware_id', $k)
                ->where('ware_type', 1)
                ->update(['ware_goo_amount'=>$v]);
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>'修改总价成功'];
    }

    // 搜索勾选过的服务门店
    public function searchShop(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 获取到服务门店信息
        $search_data = $request->all();

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $list_data = DB::table('shop')
            ->where('shop_superior_id', $shop_id)
            ->where('shop_cid', $user_info->adm_cid)
            ->where('shop_state', 1)
            ->where('shop_type', '<>', 3)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('shop_store_name', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->select('shop_id', 'shop_store_name')
            ->orderBy('shop_id', 'desc')
            ->get();
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 新发货单语音提示
    public function voicePrompt(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $res = DB::table('dispatch_bill')
            ->where([
                'dego_cid' => $user_info->adm_cid,
                'dego_shop_id' => $user_info->adm_shop_id,
                'dego_type' => 1
            ])
            ->get(['dego_id']);
        if (empty($res)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'暂无发货单']);
        }
        $data = [];
        foreach ($res as $key => $value) {
            $data[] = $value->dego_id;
        }
        //发货单路径
        $url = 'storage/voice/dispatchBill.mp3';
        // $url = $_SERVER['SERVER_NAME'].'/storage/voice/dispatchBill.mp3';
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 发货单详情
    public function info(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyDispatchController;
        $error_message = $verify_data->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $select_field = "dego_order_type, dego_wor_id, dego_count, dego_out_ware_id, dego_type, dego_pic, dego_remark, dego_order_type";
        $dispatch_info = new Dispatch();
        $return_data = $dispatch_info->info($user_info, $request->all(), $select_field);
        return response()->json($return_data);
    }

    // 导出
    public function export(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $data = DB::table('dispatch_bill as dibi')
            ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'dibi.dego_wor_id')
            ->leftjoin('dispatch_goods as digo', 'digo.digo_dego_id', '=', 'dibi.dego_id')
            ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'dibi.dego_out_ware_id')
            ->where('dego_cid', $user_info->adm_cid)
            ->where('dego_superior_shop_id', $shop_id)
            ->where('dego_type', '<>', 3)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dego_type'])) {
                    $query->where('dego_type', $search_data['dego_type']);
                }
            }) //类型：1未出库2已出库
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('dego_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('dego_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('dego_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dego_service_shop_id'])) {
                    $query->where('dego_service_shop_id', $search_data['dego_service_shop_id']);
                }
            }) //门店id
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dego_out_ware_id'])) {
                    $query->where('dego_out_ware_id', $search_data['dego_out_ware_id']);
                }
            }) //供货仓库
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dego_original_number'])) {
                    $query->where('wor_order_number', 'like', '%' . $search_data['dego_original_number'] . '%')
                        ->where('dego_order_type', 2)
                        ->orwhere('dego_original_number', 'like', '%' . $search_data['dego_original_number'] . '%');
                }
            }) //订单号
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dego_number'])) {
                    $query->where('dego_number', 'like', '%' . $search_data['dego_number'] . '%');
                }
            }) //发货单号
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dego_service_adm_id'])) {
                    $query->where('dego_service_adm_id', $search_data['dego_service_adm_id']);
                }
            }) //领货人
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dego_client_id'])) {
                    $query->where('dego_client_id', $search_data['dego_client_id']);
                }
            }) //客户id
            ->select('dego_id', 'dego_number', 'wor_order_number', 'dego_original_number', 'digo_goo_name', 'digo_goo_goods_encode', 'digo_goo_quantity', 'dego_client_type', 'dego_client_id', 'dego_count', 'dego_create_time', 'dego_service_shop_id', 'ware_name', 'ware_leader_id', 'dego_service_adm_id', 'dego_type', 'dego_order_type', 'dego_wor_id')
            ->orderBy('dego_id', 'desc')
            ->get()->toArray();

        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            $adm_id = array_unique(array_column($data, 'dego_service_adm_id')); //服务技师id
            $ware_leader_id = array_unique(array_column($data, 'ware_leader_id')); //仓库负责人id
            // 查找技师id对应的账号姓名
            $find_adm_data = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id');
            $shop_id = array_unique(array_column($data, 'dego_service_shop_id')); //服务门店id
            // 查找门店id对应的账号姓名
            $shop = DB::table('shop')
                ->whereIn('shop_id', $shop_id)
                ->pluck('shop_store_name', 'shop_id');
            $find_ware = DB::table('admin')
                ->whereIn('adm_id', $ware_leader_id)
                ->pluck('adm_name', 'adm_id');
            foreach ($data as $key => $value) {
                // 订单发货
                if ($value['dego_order_type'] == 1) {
                    $order_id[] = $value['dego_wor_id'];
                }
                // 工单发货
                if ($value['dego_order_type'] == 2) {
                    $wor_id[] = $value['dego_wor_id'];
                }
                // 售后单发货
                if ($value['dego_order_type'] == '3') {
                    $after_id[] = $value['dego_wor_id'];
                }
                $order_type[] = $value['dego_order_type'];
            }
            foreach ($order_type as $key => $value) {
                if ($value == 1) {
                    if ($order_id) {
                        // 查找订单客户信息
                        $order_client = DB::table('order as ord')
                            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                            ->whereIn('orcl_ord_id', $order_id)
                            ->select('orcl_channel_unit', 'orcl_name', 'ord_type', 'ord_client_id')
                            ->get();
                        $order_client = json_decode(json_encode($order_client), true);
                        foreach ($order_client as $k => $v) {
                            if ($v['ord_type'] == 1) {
                                $channel_name[$v['ord_client_id']] = $v['orcl_name'];
                            } elseif ($v['ord_type'] == 2) {
                                $channel_name[$v['ord_client_id']] = $v['orcl_channel_unit'];
                            } elseif ($v['ord_type'] == 3) {
                                $channel_name[$v['ord_client_id']] = $v['orcl_channel_unit'];
                            }
                        }
                    }
                } elseif ($value == 2) {
                    if ($wor_id) {
                        // 查找工单客户信息
                        $work_client = DB::table('work_order as wor')
                            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                            ->whereIn('wocl_wor_id', $wor_id)
                            ->select('wocl_channel_unit', 'wocl_name', 'wor_type', 'wocl_client_id')
                            ->get();
                        $work_client = json_decode(json_encode($work_client), true);
                        foreach ($work_client as $k => $v) {
                            if ($v['wor_type'] == 1) {
                                $channel_name[$v['wocl_client_id']] = $v['wocl_name'];
                            } elseif ($v['wor_type'] == 2) {
                                $channel_name[$v['wocl_client_id']] = $v['wocl_channel_unit'];
                            } elseif ($v['wor_type'] == 3) {
                                $channel_name[$v['wocl_client_id']] = $v['wocl_channel_unit'];
                            }
                        }
                    }
                }
            }
            foreach ($data as $key => $value) {
                // 状态
                if ($value['dego_type'] == '1') {
                    $data[$key]['dego_type'] = '未发货';
                } elseif ($value['dego_type'] == '2') {
                    $data[$key]['dego_type'] = '已发货';
                } elseif ($value['dego_type'] == '3') {
                    $data[$key]['dego_type'] = '作废';
                } elseif ($value['dego_type'] == '4') {
                    $data[$key]['dego_type'] = '锁定';
                }
                if ($value['dego_client_type'] == 1) { //买家类型:2.客户单位
                    if (isset($channel_name[$value['dego_client_id']])) {
                        $data[$key]["dego_client_id"] = $channel_name[$value['dego_client_id']];
                    } else {
                        $data[$key]["dego_client_id"] = '';
                    }
                } else {
                    if (isset($channel_name[$value['dego_client_id']])) {
                        $data[$key]["dego_client_id"] = $channel_name[$value['dego_client_id']];
                    } else {
                        $data[$key]["dego_client_id"] = '';
                    }
                }
                // 服务技师id
                if (isset($find_adm_data[$value['dego_service_adm_id']])) {
                    $data[$key]['dego_service_adm_id'] = $find_adm_data[$value['dego_service_adm_id']];
                } else {
                    $data[$key]['dego_service_adm_id'] = '';
                }
                // 服务门店id
                $data[$key]['dego_service_shop_id'] = $shop[$value['dego_service_shop_id']];
                // 仓库负责人
                // if (isset($find_ware[$value['ware_leader_id']])) {
                //     $data[$key]['ware_leader_id'] = $find_ware[$value['ware_leader_id']];
                // } else {
                //     $data[$key]['ware_leader_id'] = '';
                // }
                $adm_id = explode(',',$value['ware_leader_id']);
                $adm_name = DB::table('admin')
                    ->whereIn('adm_id', $adm_id)
                    ->select('adm_name')
                    ->get()->toArray();
                $adm_name = array_column($adm_name, 'adm_name');
                $adm_name =  implode(',', $adm_name);
                $data[$key]->ware_leader_id = $adm_name;
                // 单号
                if ($value['dego_order_type'] == 1) {
                    $data[$key]['wor_order_number'] = $value['dego_original_number'];
                }
                //商品编号
                $data[$key]['digo_goo_goods_encode'] = empty("\t" . $value['digo_goo_goods_encode']) ? '' : "\t" . $value['digo_goo_goods_encode'];
                $data[$key]['digo_goo_name'] = empty($value['digo_goo_name']) ? '' : $value['digo_goo_name'];
                unset($data[$key]['dego_id']);
                unset($data[$key]['dego_client_type']);
                unset($data[$key]['dego_order_type']);
                unset($data[$key]['dego_wor_id']);
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = '发货单' . time() . rand(1000, 9999) . '.xls';
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '发货单列表';
        $where['field_name'] = ['发货单号', '订单单号', '工单单号', '商品名称', '商品编号', '商品数量', '客户单位', '商品总数量', '派单时间', '服务门店', '仓库名称', '仓库负责人', '领货人', '状态'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 打印
    public function print(Request $request)
    {
        $request['shpt_print_type'] = 1;
        // 验证数据
        $verify_data = new VerifyDispatchController;
        $error_message = $verify_data->printValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $print = Prints::print($user_info, $request);
        if ($print['code'] == 200) {
            Common::addLog($user_info, getRealIp($request), '发货单', '打印', '发货单：' . $print['data_info'][0]['dego_number'] . ' 打印成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$print['data'], 'data_info'=>$print['data_info']]);
        } else {
            return response()->json($print);
        }
    }

    // 查看凭证
    public function getorderpic(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyDispatchController;
        $error_message = $verify_data->getorderpicValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message, 'data'=>'']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $find_data = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->select('dego_order_type', 'dego_original_number', 'dego_wor_id')
            ->first();
        $ord_id = 0;
        if (!empty($find_data)) {
            if ($find_data->dego_order_type == 1) {//类型：1.订单发货 2.工单发货3售后单发货
                $ord_id = $find_data->dego_wor_id;
            }
            if ($find_data->dego_order_type == 2) {//类型：1.订单发货 2.工单发货3售后单发货
                $ord_id = DB::table('work_order')
                    ->where('wor_id', $find_data->dego_wor_id)
                    ->value('wor_order_id');
            }
        }
        
        $return_data = WashOrderService::getorderpic($user_info, $ord_id);
        return response()->json($return_data);
    }

    /**
     * 获取仓库
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-08
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getWareHouses(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyDispatchController;
        $error_message = $verify_data->getWareHousesValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message, 'data'=>'']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $return_data = WashDispatchService::getWareHouses($user_info, $request);
        return response()->json($return_data);
    }

    /**
     * 更换仓库
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-08
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function changeWare(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyDispatchController;
        $error_message = $verify_data->changeWareValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message, 'data'=>'']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $return_data = WashDispatchService::changeWare($user_info, $request);
        return response()->json($return_data);
    }
}
