<?php
namespace App\Http\Controllers\Api\Verify\recycleManage;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyRecyclingController extends Controller
{
    // 搜索验证器
    public function searchAllValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'mem_name.max' => '搜索数据超过最大限制',
            // 'ord_order_number.required_if' => '参数错误',
            // 'ord_order_number.min' => '请输入订单编号',
            'wor_number.max' => '搜索数据超过最大限制',
            'adm_name.max' => '搜索数据超过最大限制',
            'chty_name.max' => '搜索数据超过最大限制',
            'chty_id.min' => '参数错误',
            'chty_id.required_if' => '参数错误',
            'chty_id.integer' => '参数类型错误',
            'chun_unit_name.max' => '搜索数据超过最大限制',
            'ware_name.max' => '搜索数据超过最大限制',
            'adm_name.max' => '搜索数据超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                    'required',
                    Rule::in(['1', '2', '3', '4', '5', '6', '7', '8']),
                ],
            'mem_name' => 'max:20',
            // 'ord_order_number' => 'required_if:type,2',
            'wor_number' => 'max:20',
            'adm_name' => 'max:50',
            'chty_name' => 'max:10',
            'chty_id' => 'required_if:type,6|integer|min:1',
            'chun_unit_name' => 'max:20',
            'ware_name' => 'max:20',
            'adm_name' => 'max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    // 详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数错误',
            'jur_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_type.required' => '参数错误',
            'jur_type.in' => '参数类型错误',
            'mem_id.required' => '参数错误',
            'mem_id.integer' => '参数类型错误',
            'mem_id.min' => '参数错误',
            'jur_ware_id.required' => '参数错误',
            'jur_ware_id.integer' => '参数类型错误',
            'jur_ware_id.min' => '参数错误',
            'jur_remark.max' => '备注长度超过最大限制',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数类型不正确',
            'goo_name.required' => '参数错误',
            'goo_name.array' => '参数类型不正确',
            'goo_goods_encode.required' => '参数错误',
            'goo_goods_encode.array' => '参数类型不正确',
            'goo_amount.required' => '参数错误',
            'goo_amount.array' => '参数类型不正确',
            'jur_waon_class.required' => '参数错误',
            'jur_waon_class.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_type' => [
                    'required',
                    Rule::in(['1', '2', '3']),
                ], //买家类型 1.门店零售 2.来往单位 4.加盟店
            'mem_id' => 'required|integer|min:1', //来往单位id/客户id/加盟店
            'jur_ware_id' => 'required|integer|min:1', //仓库id
            'jur_remark' => 'sometimes|max:255', //备注
            'goo_id' => 'required|array', //商品id
            'goo_name' => 'required|array', //商品名称
            'goo_goods_encode' => 'required|array', //商品编号
            'goo_amount' => 'required|array', //商品数量
            'jur_waon_class' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ], //买家类型 1货物仓2非货物仓3旧货仓4临时仓

        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 确认回收验证器
    public function affirmValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数类型错误',
            'type.required' => '请输入商品类型',
            'type.in' => '商品类型参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ], //商品类型
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 显示审核验证器
    public function showAuditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数类型错误',
            'type.required' => '请输入商品类型',
            'type.in' => '商品类型参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ], //商品类型
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核验证器
    public function auditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_recycle_amount.required' => '参数错误',
            'goo_recycle_amount.array' => '参数错误',
            'jugo_goo_id.required' => '参数错误',
            'jugo_goo_id.array' => '参数类型错误',
            'jur_ware_id.required' => '参数类型错误',
            'jur_ware_id.integer' => '参数类型错误',
            'jur_ware_id.min' => '参数类型错误',
            'jur_waon_class.required' => '参数类型错误',
            'jur_waon_class.in' => '参数类型错误',
            'jur_number.required' => '参数类型错误',
            'acti_id.required' => '参数类型错误',
            'acti_id.integer' => '参数类型错误',
            'acti_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_recycle_amount.required|array' => '参数错误',
            'jugo_goo_id.required|array' => '参数错误',
            'jur_ware_id.required|integer|min:1' => '参数错误',
            'jur_waon_class' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ], //商品类型
            'jur_number.required' => '参数错误',
            'acti_id.required|integer|min:1' => '参数错误',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 商品搜索验证器
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_type.required' => '请输入商品类型',
            'goo_type.in' => '商品类型参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_type' => [
                    'required',
                    Rule::in(['1', '2', '3', '4']),
                ], //商品类型
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数错误',
            'jur_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'goodsDataList.required_if' => '参数错误',
            'goodsDataList.json' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'goodsDataList' => 'required_if:type,2|json',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 回收获取数据验证器
    public function recycleShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数错误',
            'jur_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 回收验证器
    public function recycleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_source.required' => '参数错误',
            'jur_source.in' => '参数类型错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误',
            'jur_amount.required' => '参数错误',
            'jur_amount.numeric' => '参数类型错误',
            'jur_amount.min' => '总数量至少为1',
            'jur_price.required' => '请输入:金额',
            'jur_price.numeric' => '参数类型错误',
            'jur_price.min' => '请输入正数',
            'jur_ware_id.required' => '参数错误',
            'jur_ware_id.integer' => '参数类型错误',
            'jur_ware_id.min' => '参数错误',
            'jur_waon_class.required' => '参数错误',
            'jur_waon_class.integer' => '参数类型错误',
            'jur_waon_class.min' => '参数错误',
            'jur_remark.max' => '备注长度超过最大限制',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数类型不正确',
            'goo_name.required' => '参数错误',
            'goo_name.array' => '参数类型不正确',
            'goo_goods_encode.required' => '参数错误',
            'goo_goods_encode.array' => '参数类型不正确',
            'goo_recycle_amount.required' => '参数错误',
            'goo_recycle_amount.array' => '参数类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_source' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //旧货来源1.旧货收购 2.订单回收
            'wor_id' => 'integer|min:1', //工单id
            'jur_amount' => 'required|numeric|min:1', //回收总数量
            // 'jur_price' => 'required|numeric|min:0', //回收总金额
            'jur_ware_id' => 'required|integer|min:1', //仓库id
            'jur_waon_class' => 'required|integer|min:1', //仓库类别
            'jur_remark' => 'sometimes|max:255', //备注
            'goo_id' => 'required|array', //商品id
            'goo_name' => 'required|array', //商品名称
            'goo_goods_encode' => 'required|array', //商品编号
            'goo_recycle_amount' => 'required|array', //退货数量

        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 回收验证器
    public function recyclesValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_source.required' => '参数错误',
            'jur_source.in' => '参数类型错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误',
            'jur_amount.required' => '参数错误',
            'jur_amount.numeric' => '参数类型错误',
            'jur_amount.min' => '总数量至少为1',
            'jur_price.required' => '请输入:金额',
            'jur_price.numeric' => '参数类型错误',
            'jur_price.min' => '请输入正数',
            'jur_ware_id.required' => '参数错误',
            'jur_ware_id.integer' => '参数类型错误',
            'jur_ware_id.min' => '参数错误',
            'jur_waon_class.required' => '参数错误',
            'jur_waon_class.integer' => '参数类型错误',
            'jur_waon_class.min' => '参数错误',
            'jur_remark.max' => '备注长度超过最大限制',
            'goo_data.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_source' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //旧货来源1.旧货收购 2.订单回收
            'wor_id' => 'integer|min:1', //工单id
            'jur_amount' => 'required|numeric|min:1', //回收总数量
            // 'jur_price' => 'required|numeric|min:0', //回收总金额
            'jur_ware_id' => 'required|integer|min:1', //仓库id
            'jur_waon_class' => 'required|integer|min:1', //仓库类别
            'jur_remark' => 'sometimes|max:255', //备注
            'goo_data' => 'required', //商品id
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数错误',
            'jur_id.min' => '参数错误',
            'jur_number.required' => '参数错误',
            'jur_number.max' => '参数类型错误',
            'jur_remark.required' => '参数错误',
            'jur_remark.max' => '备注长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer|min:1',
            'jur_number' => 'required|max:20',
            'jur_remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除验证器
    public function delValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数错误',
            'jur_id.min' => '参数错误',
            'jur_number.required' => '参数错误',
            'jur_number.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer|min:1',
            'jur_number' => 'required|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 不回收验证器
    public function noRecycleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数错误',
            'jur_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 打印验证器
    public function printNumberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '参数错误',
            'jur_id.min' => '参数错误',
            // 'prca_com_name.required' => '请输入公司名称',
            'prca_com_name.max' => '公司名称超过长度限制',
            // 'prca_serve_provider.required' => '请输入服务提供商',
            'prca_serve_provider.max' => '服务提供商超过长度限制',
            // 'prca_serve_order.required' => '请输入打印单的类型',
            'prca_serve_order.max' => '打印单的类型超过长度限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer|min:1',
            'prca_com_name' => 'sometimes|max:30', //公司名称
            'prca_serve_provider' => 'sometimes|max:30', //服务提供商
            'prca_serve_order' => 'sometimes|max:10', //打印单的类型
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
