<?php

namespace App\Http\Controllers\Api\Verify\WarehouseManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

// 我的仓库-仓位
class VerifyWarehouseFreightController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '权限id数据类型不正确',
            'pri_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '请选择仓库',
            'ware_id.integer' => '仓库id数据类型不正确',
            'ware_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取仓位库存数量
    public function getFreightStockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wafr_id.required' => '请选择仓库',
            'wafr_id.integer' => '仓库id数据类型不正确',
            'wafr_id.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wafr_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '请选择仓库',
            'ware_id.integer' => '仓库id数据类型不正确',
            'ware_id.min' => '数据类型不正确',
            'wafr_data.required' => '请输入仓位数据',
            'wafr_data.json' => '数据类型不正确',
            'wafr_delete_data.required' => '请输入删除仓位数据',
            'wafr_delete_data.json' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'wafr_data' => 'required|json',
            'wafr_delete_data' => 'required|json',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 商品转仓位验证器
    public function transitionValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wafr_id.required' => '请选择仓位',
            'wafr_id.integer' => '仓位id数据类型不正确',
            'wafr_id.min' => '数据类型不正确',
            'ware_id.required' => '请选择仓库',
            'ware_id.integer' => '仓库id数据类型不正确',
            'ware_id.min' => '数据类型不正确',
            'wago_id.required' => '请选择仓库商品',
            'wago_id.integer' => '仓库商品id数据类型不正确',
            'wago_id.min' => '数据类型不正确',
            'wago_goo_id.required' => '请选择商品',
            'wago_goo_id.integer' => '商品id数据类型不正确',
            'wago_goo_id.min' => '数据类型不正确',
            'goo_count.required' => '请选择商品转换数量',
            'goo_count.integer' => '商品转换数量数据类型不正确',
            'goo_count.min' => '数据类型不正确',
            'type.required' => '请选择商品转换类型',
            'type.in' => '商品转换类型数据类型不正确',
            'wago_class.required' => '请选择仓库类别',
            'wago_class.integer' => '仓库类别数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wafr_id' => 'required|integer|min:1',
            'ware_id' => 'required|integer|min:1',
            'wago_id' => 'required|integer|min:1',
            'wago_goo_id' => 'required|integer|min:1',
            'goo_count' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
            'wago_class' => [
                'required',
                Rule::in(['1', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 查看仓位商品
    public function freightGoodsListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '参数错误',
            'ware_id.min' => '参数错误',
            'waon_class.required' => '请选择仓库类别',
            'waon_class.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'waon_class' => [
                'required',
                Rule::in(config('apisystem.WAREHOUSE_CLASS')),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 仓位商品转仓库验证器
    public function transitionWarehouseValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wafg_id.required' => '请选择仓位商品',
            'wafg_id.integer' => '仓位商品id数据类型不正确',
            'wafg_id.min' => '数据类型不正确',
            'wago_id.required' => '请选择仓库商品',
            'wago_id.integer' => '仓库商品id数据类型不正确',
            'wago_id.min' => '数据类型不正确',
            'goo_count.required' => '请选择商品转换数量',
            'goo_count.integer' => '商品转换数量数据类型不正确',
            'goo_count.min' => '数据类型不正确',
            'type.required' => '请选择商品转换类型',
            'type.in' => '商品转换类型数据类型不正确',
            'wago_class.required' => '请选择仓库类别',
            'wago_class.integer' => '仓库类别数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wafg_id' => 'required|integer|min:1',
            'wago_id' => 'required|integer|min:1',
            'goo_count' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
            'wago_class' => [
                'required',
                Rule::in(['1', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 仓位商品转仓库验证器
    public function transitionOtherFreightValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wafg_data.required' => '请选择商品转换类型',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wafg_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 库存转换-提交验证器
    public function transitionsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '参数类型错误',
            'ware_id.min' => '参数错误',
            'wafg_id.required' => '参数错误',
            'wafg_id.integer' => '参数类型错误',
            'wafg_id.min' => '参数类型错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'goo_count.required' => '请输入数量',
            'goo_count.integer' => '参数类型错误',
            'goo_count.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'wafg_id' => 'required|integer|min:1',
            'goo_count' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2','3','4']),
            ],//转换类型1良品转优先2优先转良品3待检测转优品4待检测转良品
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
