<?php

namespace App\Http\Controllers\Api\Verify\WarehouseManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyStocktakeController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索商品验证器
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '请选择仓库',
            'ware_id.integer' => '仓库id数据类型不正确',
            'ware_id.min' => '仓库id参数错误',
            'goo_bra_id.required' => '参数错误',
            'goo_bra_id.integer' => '数据类型不正确',
            'goo_bra_id.min' => '参数错误',
            'goo_cate_id.required' => '参数错误',
            'goo_cate_id.integer' => '数据类型不正确',
            'goo_cate_id.min' => '参数错误',
            'goo_type.required' => '请选择商品类型',
            'goo_type.min' => '商品类型参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'sometimes|required|integer|min:1',
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_cate_id' => 'sometimes|required|integer|min:0',
            // 'goo_type' => [
            //         'required',
            //         Rule::in(['1', '2', '3', '4']),
            //     ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取商品库存数量
    public function goodsStockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'goo_id.required' => '请选择商品',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
            'waon_class.required' => '请选择仓库类别',
            'waon_class.integer' => '数据类型不正确',
            'waon_class.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'goo_id' => 'required|integer|min:1',
            'waon_class' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 保存验证器
    public function saveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '请选择盘点仓库',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'wafr_id.sometimes' => '请选择盘点仓位',
            'wafr_id.integer' => '数据类型不正确',
            'wafr_id.min' => '参数错误',
            'stoc_waon_class.required' => '请选择仓库类别',
            'stoc_waon_class.in' => '参数错误',
            'stoc_manner.required' => '请选择盘库方式',
            'stoc_manner.in' => '参数错误',
            'stoc_make_time.required' => '请输入盘库时间',
            'goods_data.required' => '参数错误',
            'goods_data.json' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            // 'wafr_id' => 'sometimes|integer|min:1',
            'stoc_waon_class' => [
                'required',
                Rule::in(['1', '3', '4']),
            ],
            'stoc_manner' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'stoc_make_time' => 'required',
            'goods_data' => 'required|json',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'stoc_id.required' => '参数错误',
            'stoc_id.integer' => '参数错误',
            'stoc_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'stoc_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2', '3']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 提交验证器
    public function submitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'stoc_id.required' => '参数错误',
            'stoc_id.integer' => '参数类型错误',
            'stoc_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'stoc_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 通盘获取所有商品
    public function warehouseAllGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '请输入仓库id',
            'ware_id.integer' => '参数类型错误',
            'ware_id.min' => '参数错误',
            'stoc_waon_class.required' => '请输入仓库类别',
            'stoc_waon_class.in' => '仓库类别参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'stoc_waon_class' => [
                    'required',
                    Rule::in(config('apisystem.WAREHOUSE_CLASS')),
                ],//仓库类别：1货物仓2非货物仓3旧货仓4临时仓
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 打印验证器
    public function printValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'stoc_id.required' => '参数错误',
            'stoc_id.integer' => '参数类型错误',
            'stoc_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'stoc_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
