<?php

namespace App\Http\Controllers\Api\Verify\WarehouseManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifySellController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 保存验证器
    public function saveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '数据类型不正确',
            'chun_id.min' => '参数错误',
            'chun_unit_name.required' => '请选择客户单位',
            'chun_unit_name.max' => '客户单位长度超过最大限制',
            'chun_name.required' => '请输入客户姓名',
            'chun_name.max' => '客户姓名长度超过最大限制',
            // 'chun_phone.required' => '请输入手机号',
            // 'chun_phone.regex' => '手机号格式不正确',
            'chun_province.required' => '请输入省',
            'chun_province.max' => '省长度超过最大限制',
            'chun_city.required' => '请输入市',
            'chun_city.max' => '市长度超过最大限制',
            'chun_county.required' => '请输入县',
            'chun_county.max' => '县长度超过最大限制',
            'chun_address.required' => '请输入地址',
            'chun_address.max' => '地址长度超过最大限制',
            'sell_payment_way.required' => '请选择结算方式',
            'sell_payment_way.in' => '参数错误',
            'sell_actual_price.required' => '请输入结算金额',
            'sell_actual_price.numeric' => '金额格式错误',
            'sell_actual_price.min' => '参数错误',
            'sell_ware_id.required' => '请选择仓库',
            'sell_ware_id.integer' => '参数类型错误',
            'sell_ware_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'sell_number.required' => '参数错误',
            'sell_number.array' => '数据类型不正确',
            'sell_price.required' => '参数错误',
            'sell_price.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|integer|min:1',
            'chun_unit_name' => 'required|max:20',
            'chun_name' => 'required|max:20',
            // 'chun_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'chun_province' => 'required|max:50',
            'chun_city' => 'required|max:50',
            'chun_county' => 'required|max:50',
            'chun_address' => 'required|max:255',
            'sell_payment_way' => [
                    'required',
                    Rule::in(['1', '2', '3', '4']),
                ],
            'sell_actual_price' => 'required|numeric|min:0',
            'sell_ware_id' => 'required|integer|min:1',

            'goo_id' => 'required|array',
            'sell_number' => 'required|array',
            'sell_price' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数错误',
            'sell_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数类型错误',
            'sell_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核验证器
    public function auditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数类型错误',
            'sell_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 提交出库验证器
    public function submitStorageValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数类型错误',
            'sell_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',

            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'sell_actual_count.required' => '参数错误',
            'sell_actual_count.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
            'goo_id' => 'sometimes|required|array',
            'sell_actual_count' => 'sometimes|required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 部分出库验证器
    public function partStorageValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数类型错误',
            'sell_id.min' => '参数错误',
            'goo_id.required' => '请输入商品id',
            'goo_id.array' => '数据类型不正确',
            'sell_actual_count.required' => '请输入商品出库数量',
            'sell_actual_count.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|integer|min:1',
            'goo_id' => 'required|array',
            'sell_actual_count' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 扫码记录验证器
    public function scanRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数类型错误',
            'sell_id.min' => '参数错误',
            'scan_code.required' => '参数错误',
            // 'scan_code.numeric' => '参数类型错误',
            'scan_code.min' => '参数错误',
            'scan_type.required' => '参数类型错误',
            'scan_type.in' => '参数错误',
            'type.required' => '参数类型错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|integer|min:1',
            // 'scan_code' => 'required|numeric|min:1',
            'scan_code' => 'required|min:1',
            'scan_type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除扫码记录验证器
    public function deleteRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数类型错误',
            'sell_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数类型错误',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|integer|min:1',
            'goo_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 商品搜索记录
    public function searchRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数类型错误',
            'sell_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'sell_actual_count.required' => '参数错误',
            'sell_actual_count.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|integer|min:1',
            'goo_id' => 'required|array',
            'sell_actual_count' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 出库仓库商品搜索
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.integer' => '参数类型错误',
            'sell_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 生成账单验证器
    public function createBillValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_id.required' => '参数错误',
            'sell_id.array' => '参数错误',
            'start_time.required' => '参数错误',
            'start_time.date' => '参数错误',
            'end_time.required' => '参数错误',
            'end_time.date' => '参数错误',
            'sell_actual_price.required' => '参数错误',
            'sell_actual_price.numeric' => '参数错误',
            'sell_actual_price.min' => '参数错误',
            'sebi_total_price.required' => '参数错误',
            'sebi_total_price.numeric' => '参数错误',
            'sebi_total_price.min' => '参数错误',
            'sell_type.required' => '参数错误',
            'sell_type.in' => '参数错误',
            'sell_client_id.required' => '请选择客户单位/会员',
            'sell_client_id.integer' => '参数错误',
            'sell_client_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_id' => 'required|array',
            'start_time' => 'required|date',
            'end_time' => 'required|date',
            'sell_actual_price' => 'required|numeric|min:0',
            'sebi_total_price' => 'required|numeric|min:0',
            'sell_type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
            'sell_client_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 销售结算
    public function sellSettlementValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sell_number.required' => '参数错误',
            'type.required' => '参数错误',
            'type.integer' => '参数类型错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sell_number' => 'required',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
