<?php

namespace App\Http\Controllers\Api\Verify\WarehouseManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyProcurementController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 保存验证器
    public function saveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '数据类型不正确',
            'chun_id.min' => '参数错误',
            'chun_unit_name.required' => '请选择客户单位',
            'chun_unit_name.max' => '客户单位长度超过最大限制',
			'chun_name.required' => '请输入客户姓名',
            'chun_name.max' => '客户姓名长度超过最大限制',
            'chun_phone.required' => '请输入手机号',
            'chun_phone.regex' => '手机号格式不正确',

            'chun_province.required' => '请输入省',
            'chun_province.max' => '县长度超过最大限制',
            'chun_city.required' => '请输入市',
            'chun_city.max' => '县长度超过最大限制',
            'chun_county.required' => '请输入县',
            'chun_county.max' => '县长度超过最大限制',
            'chun_address.required' => '请输入地址',
            'chun_address.max' => '地址长度超过最大限制',
			'proc_payment_way.required' => '请选择结算方式',
            'proc_payment_way.in' => '参数错误',
            'proc_ware_id.required' => '请选择仓库',
            'proc_ware_id.integer' => '参数类型错误',
            'proc_ware_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'purchase_number.required' => '参数错误',
            'purchase_number.array' => '数据类型不正确',
            'purchase_price.required' => '参数错误',
            'purchase_price.array' => '数据类型不正确',
            'proc_acpa_id.required_if' => '请选择预付款',
            'proc_acpa_id.integer' => '参数错误',
            'proc_acpa_id.min' => '参数错误',
            'proc_acti_id.required_if' => '请选择会计科目',
            'proc_acti_id.integer' => '参数错误',
            'proc_acti_id.min' => '参数错误',
            'proc_waon_class.required' => '请输入仓库类别',
            'proc_waon_class.in' => '参数错误',
            'goo_type.required' => '请选择商品类型',
            'goo_type.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chun_id' => 'required|integer|min:1',
            'chun_unit_name' => 'required|max:20',
            'chun_name' => 'required|max:20',
            'chun_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'chun_province' => 'required|max:50',
            'chun_city' => 'required|max:50',
            'chun_county' => 'required|max:50',
            'chun_address' => 'required|max:255',
            'proc_payment_way' => [
                    'required',
                    Rule::in(['1', '2', '5']),
                ],
            'proc_waon_class' => [
			        'required',
			        Rule::in(config('apisystem.WAREHOUSE_CLASS')),
			    ],
            'proc_ware_id' => 'required|integer|min:1',
            'goo_id' => 'required|array',
            'goo_type' => 'required|array',
            'purchase_number' => 'required|array',
            'purchase_price' => 'required|array',
            'proc_acpa_id' => 'required_if:proc_payment_way,5|integer|min:1', //预付款id
            'proc_acti_id' => 'required_if:proc_payment_way,2|integer|min:1', //会计科目
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'proc_id.required' => '参数错误',
            'proc_id.integer' => '参数错误',
            'proc_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'proc_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'proc_id.required' => '参数错误',
            'proc_id.integer' => '参数类型错误',
            'proc_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'proc_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 提交入库验证器
    public function submitStorageValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'proc_id.required' => '参数错误',
            'proc_id.integer' => '参数类型错误',
            'proc_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',

            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'proc_actual_count.required' => '参数错误',
            'proc_actual_count.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'proc_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
            'goo_id' => 'sometimes|required|array',
            'proc_actual_count' => 'sometimes|required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 部分入库验证器
    public function partStorageValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'proc_id.required' => '参数错误',
            'proc_id.integer' => '参数类型错误',
            'proc_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'proc_actual_count.required' => '参数错误',
            'proc_actual_count.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'proc_id' => 'required|integer|min:1',
            'goo_id' => 'required|array',
            'proc_actual_count' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 扫码记录验证器
    public function scanRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'proc_id.required' => '参数错误',
            'proc_id.integer' => '参数类型错误',
            'proc_id.min' => '参数错误',
            'scan_code.required' => '参数错误',
            'scan_code.numeric' => '参数类型错误',
            'scan_code.min' => '参数错误',
            'scan_type.required' => '参数类型错误',
            'scan_type.in' => '参数错误',
            'type.required' => '参数类型错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'proc_id' => 'required|integer|min:1',
            'scan_code' => 'required|numeric|min:1',
            'scan_type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除扫码记录验证器
    public function deleteRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'proc_id.required' => '参数错误',
            'proc_id.integer' => '参数类型错误',
            'proc_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数类型错误',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'proc_id' => 'required|integer|min:1',
            'goo_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 商品搜索记录
    public function searchRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'proc_id.required' => '参数错误',
            'proc_id.integer' => '参数类型错误',
            'proc_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'proc_actual_count.required' => '参数错误',
            'proc_actual_count.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'proc_id' => 'required|integer|min:1',
            'goo_id' => 'required|array',
            'proc_actual_count' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 生成账单验证器
    public function createBillValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'proc_id.required' => '参数错误',
            'proc_id.array' => '参数错误',
            'start_time.required' => '参数错误',
            'start_time.date' => '参数错误',
            'end_time.required' => '参数错误',
            'end_time.date' => '参数错误',
            'proc_actual_price.required' => '参数错误',
            'proc_actual_price.numeric' => '参数错误',
            'proc_actual_price.min' => '参数错误',
            'prbi_total_price.required' => '参数错误',
            'prbi_total_price.numeric' => '参数错误',
            'prbi_total_price.min' => '参数错误',
            'prbi_type.required' => '参数错误',
            'prbi_type.in' => '参数错误',
            'prbi_client_id.required' => '请选择客户单位/会员',
            'prbi_client_id.integer' => '参数错误',
            'prbi_client_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'proc_id' => 'required|array',
            'start_time' => 'required|date',
            'end_time' => 'required|date',
            'proc_actual_price' => 'required|numeric|min:0',
            'prbi_total_price' => 'required|numeric|min:0',
            'prbi_type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
            'prbi_client_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
