<?php

namespace App\Http\Controllers\Api\Verify\WarehouseManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyDeliveryController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 列表验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'deli_name.required' => 'deli_name必填',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'deli_name' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function delValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adex_id.required' => '参数错误',
            'adex_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adex_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'deli_id.required' => '参数错误',
            'deli_id.integer' => '数据类型不正确',
            'deli_name.required' => 'deli_is_show必填',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'deli_id' => 'required|integer',
            'deli_name' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editStatusValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'deli_id.required' => '参数错误',
            'deli_id.integer' => '数据类型不正确',
            'deli_is_show.required' => 'deli_is_show必填',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'deli_id' => 'required|integer',
            'deli_is_show' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function addDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'delil_id.required' => '参数错误',
            'delil_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'delil_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function deliveryListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
