<?php

namespace App\Http\Controllers\Api\Verify;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;

class VerifyMobileLoginController extends Controller
{
	// 登录验证器
	public function loginValidator($data)
	{
	    // 自定义错误消息
        $messages = [
            'username.required' => '请输入手机号',
            'username.regex' => '手机号格式不正确',
            'password.required' => '请输入密码',//为给定属性指定自定义消息
            'password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'username' => ['required','regex:/^1[3456789]\d{9}$/'],
            'password' => ['required','regex:/^[\w\_]{6,15}$/u'],
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            $errors =  $validator->errors()->toArray();
            $errors =  array_shift($errors);
            return $errors[0];
        }
	}
}
