<?php

namespace App\Http\Controllers\Api\Verify\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;

class VerifyVirtualStoresController extends Controller
{
	// 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

	// 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 'vish_store_name.required' => '请输入:虚拟加盟店名称',
            // 'vish_store_name.max' => '虚拟加盟店名称长度超过最大限制',
            'vish_name.required' => '请输入:联系人姓名',
            'vish_name.max' => '联系人姓名长度超过最大限制',
            'vish_phone.required' => '请输入:联系人电话',
            'vish_phone.regex' => '手机号格式不正确',
            // 'adm_account.required' => '请输入:用户名',
            // 'adm_account.min' => '用户名长度最少为15位',
            // 'adm_account.max' => '用户名长度超过最大限制',
            // 'vish_province.required' => '请输入地址',
            // 'vish_province.max' => '地址长度超过最大限制',
            // 'vish_city.required' => '请输入地址',
            // 'vish_city.max' => '地址长度超过最大限制',
            // 'vish_county.required' => '请输入地址',
            // 'vish_county.max' => '地址长度超过最大限制',
            // 'vish_address.required' => '请输入地址',
            // 'vish_address.max' => '地址长度超过最大限制',
            // 'adm_password.required' => '请输入密码',//为给定属性指定自定义消息
            // 'adm_password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
            'chun_id.required' => '参数错误',//为给定属性指定自定义消息
            'chun_id.integer' => '参数错误',//为给定属性指定自定义消息
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            // 'vish_store_name' => 'required|max:50',
            'vish_name' => 'required|max:50',
            // 'adm_account' => 'required|min:15|max:20',
            'vish_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            // 'vish_province' => 'required|max:50',
            // 'vish_city' => 'required|max:50',
            // 'vish_county' => 'required|max:50',
            // 'vish_address' => 'required|max:200',
            // 'adm_password' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'chun_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 'vish_store_name.required' => '请输入:加盟店名称',
            // 'vish_store_name.max' => '加盟店名称长度超过最大限制',
            'vish_name.required' => '请输入:联系人姓名',
            'vish_name.max' => '联系人姓名长度超过最大限制',
            'vish_phone.required' => '请输入:联系人电话',
            'vish_phone.regex' => '手机号格式不正确',
            // 'vish_province.required' => '请输入地址',
            // 'vish_province.max' => '地址长度超过最大限制',
            // 'vish_city.required' => '请输入地址',
            // 'vish_city.max' => '地址长度超过最大限制',
            // 'vish_county.required' => '请输入地址',
            // 'vish_county.max' => '地址长度超过最大限制',
            // 'vish_address.required' => '请输入地址',
            // 'vish_address.max' => '地址长度超过最大限制',
            'adm_password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
            'vish_id.required' => '参数错误',
            'vish_id.integer' => '参数错误',
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            // 'vish_store_name' => 'required|max:50',
            'vish_name' => 'required|max:50',
            'vish_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            // 'vish_province' => 'required|max:50',
            // 'vish_city' => 'required|max:50',
            // 'vish_county' => 'required|max:50',
            // 'vish_address' => 'required|max:200',
            'adm_password' => ['sometimes','regex:/^[\w\_]{6,15}$/u'],
            'vish_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 营业验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vish_id.required' => '参数错误',
            'vish_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vish_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 检索技师
    public function searchingAccountValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'phone.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'phone' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    public function addAccountValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_name.required' => '请输入:联系人姓名',
            'adm_name.max' => '联系人姓名长度超过最大限制',
            'adm_phone.required' => '请输入:联系人电话',
            'adm_phone.regex' => '手机号格式不正确',
            // 'adm_password.required' => '请输入密码',//为给定属性指定自定义消息
            // 'adm_password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
            'vish_id.required' => '参数错误',//为给定属性指定自定义消息
            'vish_id.integer' => '参数错误',//为给定属性指定自定义消息
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            'adm_name' => 'required|max:50',
            'adm_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            // 'adm_password' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'vish_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑
    public function editAccountValidator($data)
    {
        // 自定义错误消息
        $messages = [ 
            'adm_name.required' => '请输入:联系人姓名',
            'adm_name.max' => '联系人姓名长度超过最大限制',
            'adm_phone.required' => '请输入:联系人电话',
            'adm_phone.regex' => '手机号格式不正确',
            // 'adm_password.required' => '请输入密码',//为给定属性指定自定义消息
            // 'adm_password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
            'vish_id.required' => '参数错误',//为给定属性指定自定义消息
            'vish_id.integer' => '参数错误',//为给定属性指定自定义消息
            'viad_id.integer' => '参数错误',//为给定属性指定自定义消息
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            'adm_name' => 'required|max:50',
            'adm_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            // 'adm_password' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'vish_id' => 'required|integer',
            'viad_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
