<?php

namespace App\Http\Controllers\Api\Verify\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;

class VerifyStoreListController extends Controller
{
	// 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

	// 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_store_name.required' => '请输入:门店名称',
            'shop_store_name.max' => '门店名称长度超过最大限制',
            'shop_name.required' => '请输入:联系人姓名',
            'shop_name.max' => '联系人姓名长度超过最大限制',
            'shop_phone.required' => '请输入:联系人电话',
            'shop_phone.regex' => '手机号格式不正确',
            'adm_account.required' => '请输入:用户名',
            'adm_account.min' => '用户名长度最少为15位',
            'adm_account.max' => '用户名长度超过最大限制',
            'shop_province.required' => '请输入地址',
            'shop_province.max' => '地址长度超过最大限制',
            'shop_city.required' => '请输入地址',
            'shop_city.max' => '地址长度超过最大限制',
            'shop_county.required' => '请输入地址',
            'shop_county.max' => '地址长度超过最大限制',
            'shop_address.required' => '请输入地址',
            'shop_address.max' => '地址长度超过最大限制',
            'adm_password.required' => '请输入密码',//为给定属性指定自定义消息
            'adm_password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            'shop_store_name' => 'required|max:50',
            'shop_name' => 'required|max:50',
            'adm_account' => 'required|min:15|max:20',
            'shop_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'shop_province' => 'required|max:50',
            'shop_city' => 'required|max:50',
            'shop_county' => 'required|max:50',
            'shop_address' => 'required|max:200',
            'adm_password' => ['required','regex:/^[\w\_]{6,15}$/u'],
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_store_name.required' => '请输入:门店名称',
            'shop_store_name.max' => '门店名称长度超过最大限制',
            'shop_name.required' => '请输入:联系人姓名',
            'shop_name.max' => '联系人姓名长度超过最大限制',
            'shop_phone.required' => '请输入:联系人电话',
            'shop_phone.regex' => '手机号格式不正确',
            'shop_province.required' => '请输入地址',
            'shop_province.max' => '地址长度超过最大限制',
            'shop_city.required' => '请输入地址',
            'shop_city.max' => '地址长度超过最大限制',
            'shop_county.required' => '请输入地址',
            'shop_county.max' => '地址长度超过最大限制',
            'shop_address.required' => '请输入地址',
            'shop_address.max' => '地址长度超过最大限制',
            'adm_password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
            'shop_id.required' => '参数错误',
            'shop_id.integer' => '参数错误',
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            'shop_store_name' => 'required|max:50',
            'shop_name' => 'required|max:50',
            'shop_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'shop_province' => 'required|max:50',
            'shop_city' => 'required|max:50',
            'shop_county' => 'required|max:50',
            'shop_address' => 'required|max:200',
            'adm_password' => ['sometimes','regex:/^[\w\_]{6,15}$/u'],
            'shop_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 营业验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '参数错误',
            'shop_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 人员分配-搜索员工验证器
    public function searchPeopleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '参数错误',
            'shop_id.integer' => '参数错误',
            'shop_id.min' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',//门店id
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 人员分配-提交验证器
    public function peopleSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'left_shop_id.required' => '参数错误',
            'left_shop_id.integer' => '参数错误',
            'left_shop_id.min' => '参数错误',
            'right_shop_id.required' => '参数错误',
            'right_shop_id.integer' => '参数错误',
            'right_shop_id.min' => '参数错误',
            'right_shop_id.different' => '所选门店相同不允许人员分配',
            'left_adm_id.required' => '参数错误',
            'left_adm_id.array' => '参数错误',
            'right_adm_id.required' => '参数错误',
            'right_adm_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'left_shop_id' => 'required|integer|min:1', //左侧的数据
            'right_shop_id' => 'required|integer|min:1|different:left_shop_id', //右侧的数据
            'left_adm_id' => 'sometimes|required|array', //左侧的数据
            'right_adm_id' => 'sometimes|required|array', //右侧的数据
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
