<?php

namespace App\Http\Controllers\Api\Verify\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyRoleSetController extends Controller
{
	// 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

	// 新增页面查看验证器
    public function addShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
        	    'type' => [
			        'required',
			        Rule::in(['1', '2']),
			    ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增提交验证器
    public function additionSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rol_name.required' => '请输入角色名称',
            'rol_name.max' => '长度超过最大限制',
            'rol_description.max' => '长度超过最大限制',
            'pc_privilege.required' => '请选择权限',
            'applet_privilege.required' => '请选择权限',
        ];

        $data = array_filter($data);
        // 数据验证
        $validator = Validator::make($data, [
			'rol_name' => 'required|max:8',
            'rol_description' => 'sometimes|max:255',
            'pc_privilege' => 'sometimes|required',
            'applet_privilege' => 'sometimes|required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增提交验证器
    public function addSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rol_name.required' => '请输入角色名称',
            'rol_name.max' => '长度超过最大限制',
            'rol_privilege.required' => '请选择权限',
            'rol_description.max' => '长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
			'rol_name' => 'required|max:8',
            'rol_description' => 'sometimes|max:255',
            'rol_privilege' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑页面查看验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'rol_id.required' => '参数错误',
            'rol_id.integer' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
        	    'type' => [
			        'required',
			        Rule::in(['1', '2']),
			    ],
				'rol_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rol_id.required' => '参数错误',
            'rol_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rol_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
