<?php

namespace App\Http\Controllers\Api\Verify\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyEmployeeListController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_name.required' => '请输入:员工姓名',
            'adm_name.max' => '员工姓名长度超过最大限制',
            'adm_phone.required' => '请输入:联系人电话',
            'adm_phone.regex' => '手机号格式不正确',
            'adm_account.required' => '请输入:用户名',
            'adm_account.min' => '用户名长度最少为15位',
            'adm_account.max' => '用户名长度超过最大限制',
            // 'adm_password.required' => '请输入密码',//为给定属性指定自定义消息
            // 'adm_password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
            'adm_role.required' => '请选择角色',
            'adm_role.integer' => '参数类型错误',
            'adm_role.min' => '参数错误',
            // 'adm_leave.0' => '参数错误',
            // 'adm_leave.1' => '参数错误',
            // 'adm_leave.array' => '参数错误',
            'adm_leave.integer' => '参数错误',
            'adm_leave.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_account' => 'required|min:15|max:20',
            // 'adm_password' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'adm_name' => 'required|max:50',
            'adm_phone' => ['required', 'regex:/^1[3456789]\d{9}$/'],
            'adm_role' => 'required|integer|min:0',
            // 'adm_leave.0' => [
            //         'sometimes',
            //         Rule::in(['3','4']),
            //     ], //3.技师 4.业务员
            // 'adm_leave.1' => [
            //         'sometimes',
            //         Rule::in(['3','4']),
            //     ], //3.技师 4.业务员
            // 'adm_leave' =>'array'
            // 'adm_leave' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 获取数据职级验证器
    public function addGrleShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'adm_id.required' => '请输入:员工姓名',
            'adm_id.integer' => '参数错误',
            'adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ], //1.获取数据 2.提交数据
            'adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->all();
        }
    }

    // 新增职级验证器
    public function addGrleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'adm_id.required' => '请输入:员工姓名',
            'adm_id.integer' => '参数错误',
            'adm_id.min' => '参数错误',
            'adm_grle_id.required' => '请输入:职位级别',
            'adm_grle_id.integer' => '参数错误',
            'adm_grle_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ], //1.获取数据 2.提交数据
            'adm_id' => 'required|integer|min:1',
            'adm_grle_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }


    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '参数错误',
            'adm_id.integer' => '参数错误',
            'adm_id.min' => '参数错误',
            'adm_name.required' => '请输入:员工姓名',
            'adm_name.max' => '员工姓名长度超过最大限制',
            'adm_phone.required' => '请输入:联系人电话',
            'adm_phone.regex' => '手机号格式不正确',
            'adm_password.required' => '请输入密码', //为给定属性指定自定义消息
            'adm_password.regex' => '密码由6-15位数字或字母,或下划线组成！', //为给定属性指定自定义消息
            'adm_role.required' => '请选择角色',
            'adm_role.integer' => '参数类型错误',
            'adm_role.min' => '参数错误',
            // 'adm_leave.0' => '参数错误',
            // 'adm_leave.1' => '参数错误',
            // 'adm_leave.array' => '参数错误',
            'adm_leave.integer' => '参数错误',
            'adm_leave.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:1',
            'adm_password' => ['sometimes', 'required', 'regex:/^[\w\_]{6,15}$/u'],
            'adm_name' => 'required|max:50',
            'adm_phone' => ['required', 'regex:/^1[3456789]\d{9}$/'],
            'adm_role' => 'required|integer|min:0',
            // 'adm_leave.0' => [
            //         'sometimes',
            //         Rule::in(['3','4']),
            //     ], //3.技师 4.业务员
            // 'adm_leave.1' => [
            //         'sometimes',
            //         Rule::in(['3','4']),
            //     ], //3.技师 4.业务员
            // 'adm_leave' =>'array'

            'adm_leave' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 在职验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '参数错误',
            'adm_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 设置验证器
    public function setValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'adm_id.required' => '参数错误',
            'adm_id.integer' => '参数错误',
            'adm_id.min' => '参数错误',
            // 'warehouse.required_if' => '参数错误',
            // 'warehouse.array' => '参数类型错误',
            // 'shop.required_if' => '参数错误',
            // 'shop.array' => '参数类型错误',
            // 'mac.required_if' => '参数错误',
            // 'mac.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ], //1.获取数据 2.提交数据
            'adm_id' => 'required|integer|min:1', //员工id
            // 'warehouse' => 'required_if:type,2|array', //仓库信息
            // 'shop' => 'required_if:type,2|array', //门店信息
            // 'mac' => 'required_if:type,2|array', //mark地址
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 重置密码提交验证器
    public function resetPasswordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '参数错误',
            'adm_id.integer' => '参数错误',
            'adm_id.min' => '参数错误',
            'pwd.required' => '请输入密码',
            'pwd.regex' => '密码由6-15位数字或字母,或下划线组成！',
            'renew_pwd.required' => '请输入确认密码',
            'renew_pwd.same' => '密码与确认密码不一致',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:1', //员工id
            'pwd' => ['required', 'regex:/^[\w\_]{6,15}$/u'],
            // 'renew_pwd'=>['required',"same:pwd"], //不为空,两次密码是否相同
        ], $messages);

        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 导入提交验证器
    public function leadValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'file.required' => '请上传文件',
            'file.file' => '请上传文件',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'file' => 'required|file',
        ], $messages);

        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 解绑微信验证器
    public function unbindWxValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
