<?php
namespace App\Http\Controllers\Api\Verify\SystemPlatform;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyPlatformGoodsListsController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 同步商品验证器
    public function syncValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sygo_id.required' => '参数错误',
            'sygo_id.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sygo_id' => 'required|array'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 改绑
    public function changeBindGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sygo_id.required' => '参数错误',
            'sygo_id.int' => '数据类型不正确',
            'goo_id.required' => '数据类型不正确',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '数据类型不正确',
            'goo_name.required' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sygo_id' => 'required|int',
            'goo_id' => 'required|integer|min:1',
            'goo_name' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 改绑
    public function showChangeBindGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '数据类型不正确',
            'type.in' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                 Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}