<?php

namespace App\Http\Controllers\Api\Verify\SupplyChains;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifySupplyOrdersController extends Controller
{
    // 搜索验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'reob_state.required' => '参数错误',
            'reob_state.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'reob_state' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    
}
