<?php
namespace App\Http\Controllers\Api\Verify\SupplyChains;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifySupplyBillsController extends Controller
{
    //详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rebb_id.required' => '参数错误',
            'rebb_id.integer' => '参数错误',
            'rebb_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rebb_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rebb_id.required' => '参数错误',
            'rebb_id.integer' => '参数错误',
            'rebb_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rebb_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //核销验证器
    public function cancelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rebb_id.required' => '参数错误',
            'rebb_id.integer' => '参数错误',
            'rebb_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rebb_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //送货单列表
    public function deliveryListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rebb_id.required' => '参数错误',
            'rebb_id.integer' => '参数错误',
            'rebb_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rebb_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //收货单商品列表
    public function deliveryDetailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerb_id.required' => '参数错误',
            'rerb_id.integer' => '参数错误',
            'rerb_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerb_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //收货单列表收货方法
    public function getTakeDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerb_id.required' => '参数错误',
            'rerb_id.integer' => '参数错误',
            'rerb_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerb_id' => 'required|integer|min:1',
            'type' => [
                'required',
                 Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //收货单列表收货方法
    public function takeDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rrgb_id.required'=>'参数错误',
            'rrgb_id.array'=>'类型错误',
            'amount.required'=>'参数错误',
            'amount.array'=>'类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rrgb_id' => 'required|array',
            'amount' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //收货单列表备注添加
    public function deliveryRemarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerb_id.required' => '参数错误',
            'rerb_id.integer' => '参数错误',
            'rerb_id.min' => '参数错误',
            'rerb_remark.required' => '参数错误',
            'rerb_remark.max' => '备注长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerb_id' => 'required|integer|min:1',
            'rerb_remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //收货单列表撤销收货
    public function revocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerb_id.required' => '参数错误',
            'rerb_id.integer' => '参数错误',
            'rerb_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerb_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }  

    //扫码收货方法
    public function scanCodeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rerb_id.required' => '参数错误',
            'rerb_id.min' => '参数错误',
            'rebb_id.required' => '参数错误',
            'rebb_id.min' => '参数错误',
            'type.required' => '参数错误',
            'rerb_id.integer' => '参数错误',
            'rebb_id.integer' => '参数错误',
            'type.integer' => '参数错误',
            'code.array' => '参数错误',
            'code.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rerb_id' => 'required|integer|min:1',
            'rebb_id' => 'required|integer|min:1',
            'type' => [ //1.缓存数据 2.提交数据
                'required',
                 Rule::in(['1', '2']),
            ],
            'code' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }  
}
