<?php

namespace App\Http\Controllers\Api\Verify\SupplyChains;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifySupplementedsGoodsController extends Controller
{
    // 推送数据验证
    public function goodsSurplusValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'regb_shop_id.required' => '参数错误',
            'regb_shop_id.integer' => '参数错误',
            'regb_shop_id.min' => '参数错误',
            'regb_sd_goo_id.required' => '参数错误',
            'regb_sd_goo_id.integer' => '参数错误',
            'regb_sd_goo_id.min' => '参数错误',
            'token.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'regb_shop_id' => 'required|integer|min:1',
            'regb_sd_goo_id' => 'required|integer|min:1',
            'token' => 'required',
            'type' => [
                'required',
                 Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    
}
