<?php

namespace App\Http\Controllers\Api\Verify\SalesManagement;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifySalesStatisticsController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
            'type' => [ //1.商品销量2.品牌销量3.客户销量4.区域销量5.销售回款 6.区域回款7.客户回款8.锁单统计9.退单统计
                'required',
                 Rule::in(['1','2','3','4','5','6','7','8','9']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
