<?php

namespace App\Http\Controllers\Api\Verify\ReturnGoodsManage;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class ReturnGoodsManageController extends Controller
{
    // 添加验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'order_number.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'order_number' => 'required|max:255', //备注
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取单条信息验证器
    public function getOneValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'order_number.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'order_number' => 'required|max:255', //备注
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 打款编辑验证器
    public function payValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ref_number.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ref_number' => 'required|string',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ref_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ref_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 回收验证器
    public function recoveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'retgo_number_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'retgo_number_id' => 'required|string',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 回收验证器
    public function revokeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'retgo_id.required' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'retgo_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
