<?php
namespace App\Http\Controllers\Api\Verify\RegionManage;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyPrecinctsController extends Controller
{
    //列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '参数错误',
            'pri_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //添加验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'prec_region.required' => '参数错误',
            'prec_region.int' => '长度超过最大限制',
            'prec_province.required' => '参数错误',
            'prec_province.max' => '长度超过最大限制',
            'prec_city.required' => '参数错误',
            'prec_city.max' => '长度超过最大限制',
            'prec_county.required' => '参数错误',
            'prec_county.max' => '长度超过最大限制',
            'prec_name.required' => '参数错误',
            'prec_name.max' => '长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'prec_region' => 'required|int',
            'prec_province' => 'required|max:50',
            'prec_city' => 'required|max:50',
            'prec_county' => 'required|max:50',
            'prec_name' => 'required|max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'prec_id.required' => '参数错误',
            'prec_id.integer' => '参数错误',
            'prec_id.min' => '参数错误',
            'prec_region.required' => '参数错误',
            'prec_region.int' => '长度超过最大限制',
            'prec_province.required' => '参数错误',
            'prec_province.max' => '长度超过最大限制',
            'prec_city.required' => '参数错误',
            'prec_city.max' => '长度超过最大限制',
            'prec_county.required' => '参数错误',
            'prec_county.max' => '长度超过最大限制',
            'prec_name.required' => '参数错误',
            'prec_name.max' => '长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'prec_id' => 'required|integer|min:1',
            'prec_region' => 'required|int',
            'prec_province' => 'required|max:50',
            'prec_city' => 'required|max:50',
            'prec_county' => 'required|max:50',
            'prec_name' => 'required|max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //启用列表
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'prec_id.array' => '参数错误',
            'prec_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'prec_id' => 'array|required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //停用列表
    public function stopValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'prec_id.required' => '参数错误',
            'prec_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'prec_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
