<?php
namespace App\Http\Controllers\Api\Verify\Purchase;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyPurchaseOrderController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索商品验证器
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.integer' => '仓库id数据类型不正确',
            'ware_id.min' => '仓库id参数错误',
            'goo_bra_id.integer' => '数据类型不正确',
            'goo_bra_id.min' => '参数错误',
            'goo_cate_id.integer' => '数据类型不正确',
            'goo_cate_id.min' => '参数错误',
            'puor_supplyunit_type.required' => '参数错误',
            'puor_supplyunit_type.in' => '参数错误',

        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'sometimes|integer|min:1',
            'goo_bra_id' => 'sometimes|integer|min:0',
            'goo_cate_id' => 'sometimes|integer|min:0',
            'puor_supplyunit_type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function searchShopinfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'puor_supplyunit_type.required' => '参数错误',
            'puor_supplyunit_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'puor_supplyunit_type' => [
                'required',
                Rule::in(['2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 保存验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 基本信息
            'cg_number.required' => '参数错误',
            'cg_number.max' => '采购单号长度超过最大限制',
            'contract_number.required' => '参数错误',
            'contract_number.max' => '合同单号长度超过最大限制',
            'cg_amount.required' => '参数错误',
            'cg_amount.integer' => '数据类型不正确',
            'cg_amount.min' => '参数错误',
            'business_type.required' => '请勾选业务类型',
            'business_type.in' => '参数错误',
            'cg_wareid.required' => '请勾选采购仓库',
            'cg_wareid.integer' => '数据类型不正确',
            'cg_wareid.min' => '参数错误',
            'cg_waon_class.required' => '请勾选仓库类别',
            'cg_waon_class.in' => '参数错误',
            'cg_remark.required' => '参数错误',
            'cg_remark.max' => '备注长度超过最大限制',

            // 供货方
            'cg_supplyunit.required' => '参数错误',
            'cg_supplyunit.integer' => '数据类型不正确',
            'cg_supplyunit.min' => '参数错误',
            // 'contact_name.required' => '请输入联系人姓名',
            // 'contact_name.max' => '联系人姓名长度超过最大限制',
            // 'contact_phone.required' => '请输入手机号',
            // 'contact_phone.regex' => '手机号格式不正确',

            // 结算信息
            'cg_paymentype.required' => '请勾选仓库类别',
            'cg_paymentype.in' => '参数错误',
            'cg_delivertype.required' => '请勾选仓库类别',
            'cg_delivertype.in' => '参数错误',
            'cg_invoicetype.required' => '请勾选仓库类别',
            'cg_invoicetype.in' => '参数错误',

            // 商品信息
//            'goods.required' => '参数错误',
//            'goods.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 基本信息
            'cg_number' => 'required|max:20',
            'contract_number' => 'required|max:20',
            'cg_amount' => 'required|numeric|min:0',
            'business_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ], //业务类型1普通采购2样品采购3厂家返利
            'cg_wareid' => 'required|integer|min:1', //仓库id
            'cg_waon_class' => [
                'required',
                Rule::in(['1', '2']),
            ], //仓库类别1货物仓2非货物仓
            'cg_remark' => 'sometimes|max:255', //备注
            'cg_supplyunit' => 'required|integer|min:1', //供应商
            // 'contact_name' => 'required|max:10', //联系人
            // 'contact_phone' => ['required','regex:/^1[3456789]\d{9}$/'],//联系方式
            'cg_paymentype' => [
                'required',
                Rule::in(['1', '2', '3', '4', '5', '6', '7', '8']),
            ], //结算方式1现金2定期3款到发货4货到付款5月结15天6月结30天7月结60天8免费
            'cg_delivertype' => [
                'required',
                Rule::in(['1', '2']),
            ], //交货方式1送货上门2自提
            'cg_invoicetype' => [
                'required',
                Rule::in(['0', '1', '2']),
            ], //票据类型0不开票1普通发票2专用发票
//            'goods' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_number.required' => '参数错误',
            'cg_number.max' => '采购单号长度超过最大限制',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_number' => 'required|max:20',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 提交审核验证器
    public function submitAuditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_number.required' => '参数错误',
            'cg_number.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_number' => 'required|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 终止验证器
    public function suspendValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_number.required' => '参数错误',
            'cg_number.max' => '参数错误',
            'remarks.required' => '参数错误',
            'remarks.max' => '备注长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_number' => 'required|max:20',
            'remarks' => 'sometimes|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 财务审核验证器
    public function financialAuditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_number.required' => '参数错误',
            'cg_number.max' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_number' => 'required|max:20',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 财务审核验证器
    public function financialAuditsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'examine_type.required' => '参数错误',
            'examine_type.in' => '参数错误',
            'remarks.required' => '参数错误',
            'remarks.max' => '备注长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'examine_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'remarks' => 'sometimes|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 退货验证器
    public function returnGoodValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_id.required' => '参数错误',
            'cg_id.integer' => '参数错误',
            'cg_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 保存验证器
    public function returnGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_number.required' => '参数错误',
            'cg_number.max' => '退货单号长度超过最大限制',
            'cg_amount.required' => '参数错误',
            'cg_amount.integer' => '数据类型不正确',
            'cg_amount.min' => '参数错误',
            'goods.required' => '参数错误',
            'goods.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_number' => 'required|max:30',
            'cg_amount' => 'required|numeric|min:0',
            'goods' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_id.required' => '参数错误',
            'cg_id.integer' => '数据类型不正确',
            'cg_id.min' => '参数错误',
            'number.required' => '参数错误',
            'number.max' => '单号长度超过最大限制',
            'cg_change_amount.required' => '参数错误',
            'cg_change_amount.integer' => '数据类型不正确',
            'cg_change_amount.min' => '参数错误',
            'cg_remark.required' => '参数错误',
            'cg_remark.max' => '备注长度超过最大限制',
            'goods.required' => '参数错误',
            'goods.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_id' => 'required|integer|min:1',
            'number' => 'required|max:20',
            'cg_change_amount' => 'required|numeric|min:0',
            'cg_remark' => 'sometimes|max:255',
            'goods' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 解除封账期验证器
    public function relieveAccountValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_id.required' => '参数错误',
            'cg_id.integer' => '参数错误',
            'cg_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    public function setPurchaseOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.integer' => '参数错误',
            'type.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
