<?php

namespace App\Http\Controllers\Api\Verify\PublicsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyPublicSearchController extends Controller
{
	// 搜索历史价格验证器
    public function searchHistoricalPriceValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '请选择商品',
            'goo_id.integer' => '参数错误',
            'goo_id.min' => '参数错误',
            'client_id.required' => '请选择客户单位',
            'client_id.integer' => '参数错误',
            'client_id.min' => '参数错误',
            'ord_type.required' => '请选择买家类型',
            'ord_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|integer|min:1',
            'client_id' => 'required|integer|min:0',
            'ord_type' => [
                'required',
                Rule::in(['0', '1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
