<?php

namespace App\Http\Controllers\Api\Verify\ProductManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyGoodsListController extends Controller
{
    // 绑定上级商品验证器
    public function parentGoodsBindingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_goo_id.required' => '参数错误',
            'shop_goo_id.integer' => '数据类型不正确',
            'parent_goo_id.required' => '参数错误',
            'parent_goo_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_goo_id' => 'required|integer',
            'parent_goo_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
            'goo_type.required' => '请选择商品类型',
            'goo_type.in' => '商品类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
            'goo_type' => [
                'required',
                Rule::in(['1', '5']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function washAddValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_name.required' => '请输入:商品名称',
            'goo_name.max' => '商品名称长度超过最大限制',
            'goo_goods_encode.required' => '请输入:检索编码',
            'goo_goods_encode.max' => '检索编码长度超过最大限制',
            'goo_bra_name.required_with' => '请输入:品牌名称',
            'goo_bra_name.max' => '品牌名称长度超过最大限制',
            'goo_bra_id.required' => '请选择品牌',
            'goo_bra_id.integer' => '参数类型错误',
            'goo_bra_id.min' => '请选择正确的品牌',
            'goo_price.required' => '请输入:商品单价',
            'goo_price.numeric' => '参数类型错误',
            'goo_price.min' => '请输入正确的参数',
            'goo_guarantee.required' => '请输入:质保时长',
            'goo_guarantee.integer' => '参数类型错误',
            'goo_guarantee.min' => '请输入正确的参数',
            'goo_type.required' => '请选择商品类型',
            'goo_type.in' => '商品类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_name' => 'required|max:80',
            'goo_goods_encode' => 'sometimes|max:80',
            'goo_bra_name' => 'required_with:goo_bra_id|max:10',
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_price' => 'required|numeric|min:0',
            'goo_guarantee' => 'required|integer|min:0',
            'goo_type' => [
                'required',
                Rule::in(['1', '5']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑页面查看验证器
    public function washEditShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数错误',
            'goo_id.min' => '参数错误',
            'goo_type.required' => '参数错误',
            'goo_type.integer' => '参数错误',
            'goo_type.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'goo_id' => 'required|integer|min:1',
            'goo_type' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function washEditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数错误',
            'goo_id.min' => '参数错误',
            'goo_name.required' => '请输入:商品名称',
            'goo_name.max' => '商品名称长度超过最大限制',
            'goo_goods_encode.required' => '请输入:检索编码',
            'goo_goods_encode.max' => '检索编码长度超过最大限制',
            'goo_bra_name.required_with' => '请输入:品牌名称',
            'goo_bra_name.max' => '品牌名称长度超过最大限制',
            'goo_bra_id.required' => '请选择品牌',
            'goo_bra_id.integer' => '参数类型错误',
            'goo_bra_id.min' => '请选择正确的品牌',
            'goo_price.required' => '请输入:商品单价',
            'goo_price.numeric' => '参数类型错误',
            'goo_price.min' => '请输入正确的参数',
            'goo_guarantee.required' => '请输入:质保时长',
            'goo_guarantee.integer' => '参数类型错误',
            'goo_guarantee.min' => '请输入正确的参数',
            'goo_type.required' => '请选择商品类型',
            'goo_type.in' => '商品类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|integer|min:1',
            'goo_name' => 'required|max:80',
            'goo_goods_encode' => 'sometimes|max:80',
            'goo_bra_name' => 'required_with:goo_bra_id|max:10',
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_price' => 'required|numeric|min:0',
            'goo_guarantee' => 'required|integer|min:0',
            'goo_type' => [
                'required',
                Rule::in(['1', '5']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_name.required' => '请输入:商品名称',
            // 'goo_pic.required' => '请上传图片',
            'goo_name.max' => '商品名称长度超过最大限制',
            'goo_goods_code.required' => '请输入:商品编号',
            'goo_goods_code.max' => '商品编号长度超过最大限制',
            'goo_goods_encode.required' => '请输入:检索编码',
            'goo_goods_encode.max' => '检索编码长度超过最大限制',
            'goaf_another_name.required' => '请输入:商品别名',
            'goaf_another_name.max' => '商品别名长度超过最大限制',
            'goo_bra_name.required_with' => '请输入:品牌名称',
            'goo_bra_name.max' => '品牌名称长度超过最大限制',
            'goo_bra_id.required' => '请选择品牌',
            'goo_bra_id.integer' => '参数类型错误',
            'goo_bra_id.min' => '请选择正确的品牌',
            'goo_cate_name.required_with' => '请输入:品类名称',
            'goo_cate_name.max' => '品类名称长度超过最大限制',
            'goo_cate_id.required' => '请选择品类',
            'goo_cate_id.integer' => '参数类型错误',
            'goo_cate_id.min' => '请选择正确的品类',
            'goo_price.required' => '请输入:售价金额',
            'goo_price.numeric' => '参数类型错误',
            'goo_wholesale_price.required' => '请输入:批发价',
            'goo_wholesale_price.numeric' => '参数类型错误',
            'goo_purchase_price.required' => '请输入:采购价',
            'goo_purchase_price.numeric' => '参数类型错误',
            'goo_price.min' => '请输入正数',
            'info_name.required_with' => '请输入:属性名称',
            'info_name.array' => '参数类型错误',
            'info_content.required_with' => '请输入:属性内容',
            'info_content.array' => '参数类型错误',
            'goo_type.required' => '请选择商品类型',
            'goo_type.in' => '商品类型不正确',
            'goo_unta_id.required' => '请选择单位',
            'goo_unta_id.integer' => '参数类型错误',
            'goo_unta_id.min' => '请选择正确的单位',
            'goo_unit.required_with' => '请输入：单位名称',
            'goo_unit.max' => '单位名称长度超过最大限制',
            'goo_commodity_propert.required' => '请选择商品属性',
            'goo_commodity_propert.in' => '商品属性不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_name' => 'required|max:80',
            // 'goo_pic' => 'required',
            'goo_goods_code' => 'sometimes|max:13',
            'goo_goods_encode' => 'sometimes|max:80',
            'goaf_another_name' => 'sometimes|required|max:80',
            'goo_cate_name' => 'required_with:goo_cate_id|max:10',
            'goo_cate_id' => 'required|integer|min:1',
            'goo_bra_name' => 'required_with:goo_bra_id|max:10',
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            // 'goo_price' => 'required|numeric|min:0',
            'goo_wholesale_price' => 'required|numeric|min:0',
            'goo_purchase_price' => 'required|numeric|min:0',
            'info_name' => 'required_with:info_name,info_content|array',
            'info_content' => 'required_with:info_name,info_content|array',
            'goo_type' => [
                'required',
                Rule::in(['1', '5']),
            ],
            'goo_unta_id' => 'required|integer|min:1',
            'goo_unit' => 'required_with:goo_unta_id|max:20',
            'goo_commodity_propert' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑页面查看验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数错误',
            'goo_id.min' => '参数错误',
            'goaf_id.required_if' => '参数错误',
            'goaf_id.integer' => '参数错误',
            'goaf_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'goo_id' => 'required|integer|min:1',
            'goaf_id' => 'required_if:type,2|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索库存
    public function searchStockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 订单外派-搜索商品
    public function assignSearchValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择门店',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 导入验证器
    public function leadValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'file.required' => '请上传文件',
            'file.file' => '请上传文件1',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'file' => 'required|file',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 绑定验证器
    public function bindGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '请选择商品',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
            'bind_goo_id.required' => '请选择绑定商品',
            'bind_goo_id.integer' => '数据类型不正确',
            'bind_goo_id.min' => '参数错误',
            'shop_id.required' => '请选择绑定的上级门店',
            'shop_id.integer' => '数据类型不正确',
            'shop_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|integer|min:1',
            'bind_goo_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 列表验证器
    public function bindListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
            
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
